/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrVisitor;
import io.trino.sql.ir.Literal;
import java.util.List;
import java.util.Objects;

public final class StringLiteral
extends Literal {
    private final String value;
    private final int length;

    @JsonCreator
    public StringLiteral(String value) {
        Objects.requireNonNull(value, "value is null");
        this.value = value;
        this.length = value.codePointCount(0, value.length());
    }

    @JsonProperty
    public String getValue() {
        return this.value;
    }

    public int length() {
        return this.length;
    }

    @Override
    public <R, C> R accept(IrVisitor<R, C> visitor, C context) {
        return visitor.visitStringLiteral(this, context);
    }

    @Override
    public List<? extends Expression> getChildren() {
        return ImmutableList.of();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StringLiteral that = (StringLiteral)o;
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return "'%s'".formatted(this.value);
    }
}

