/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrVisitor;
import java.util.List;
import java.util.Objects;

public final class SubscriptExpression
extends Expression {
    private final Expression base;
    private final Expression index;

    @JsonCreator
    public SubscriptExpression(Expression base, Expression index) {
        this.base = Objects.requireNonNull(base, "base is null");
        this.index = Objects.requireNonNull(index, "index is null");
    }

    @Override
    public <R, C> R accept(IrVisitor<R, C> visitor, C context) {
        return visitor.visitSubscriptExpression(this, context);
    }

    @Override
    public List<? extends Expression> getChildren() {
        return ImmutableList.of((Object)this.base, (Object)this.index);
    }

    @JsonProperty
    public Expression getBase() {
        return this.base;
    }

    @JsonProperty
    public Expression getIndex() {
        return this.index;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubscriptExpression that = (SubscriptExpression)o;
        return Objects.equals(this.base, that.base) && Objects.equals(this.index, that.index);
    }

    public int hashCode() {
        return Objects.hash(this.base, this.index);
    }

    public String toString() {
        return "Subscript(%s, %s)".formatted(this.base, this.index);
    }
}

