/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrVisitor;
import java.util.List;
import java.util.Objects;

public final class WhenClause
extends Expression {
    private final Expression operand;
    private final Expression result;

    @JsonCreator
    public WhenClause(Expression operand, Expression result) {
        this.operand = operand;
        this.result = result;
    }

    @JsonProperty
    public Expression getOperand() {
        return this.operand;
    }

    @JsonProperty
    public Expression getResult() {
        return this.result;
    }

    @Override
    public <R, C> R accept(IrVisitor<R, C> visitor, C context) {
        return visitor.visitWhenClause(this, context);
    }

    @Override
    public List<? extends Expression> getChildren() {
        return ImmutableList.of((Object)this.operand, (Object)this.result);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WhenClause that = (WhenClause)o;
        return Objects.equals(this.operand, that.operand) && Objects.equals(this.result, that.result);
    }

    public int hashCode() {
        return Objects.hash(this.operand, this.result);
    }

    public String toString() {
        return "When(%s, %s)".formatted(this.operand, this.result);
    }
}

