/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceUtf8;
import io.airlift.slice.Slices;
import io.trino.Session;
import io.trino.SystemSessionProperties;
import io.trino.metadata.GlobalFunctionCatalog;
import io.trino.metadata.LanguageFunctionManager;
import io.trino.metadata.ResolvedFunction;
import io.trino.operator.scalar.JsonPath;
import io.trino.plugin.base.expression.ConnectorExpressions;
import io.trino.security.AllowAllAccessControl;
import io.trino.spi.connector.CatalogSchemaName;
import io.trino.spi.expression.Call;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.expression.Constant;
import io.trino.spi.expression.FieldDereference;
import io.trino.spi.expression.FunctionName;
import io.trino.spi.expression.StandardFunctions;
import io.trino.spi.expression.Variable;
import io.trino.spi.function.CatalogSchemaFunctionName;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.DynamicFilters;
import io.trino.sql.PlannerContext;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.ir.ArithmeticBinaryExpression;
import io.trino.sql.ir.ArithmeticUnaryExpression;
import io.trino.sql.ir.BetweenPredicate;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.ComparisonExpression;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.FunctionCall;
import io.trino.sql.ir.InPredicate;
import io.trino.sql.ir.IrUtils;
import io.trino.sql.ir.IrVisitor;
import io.trino.sql.ir.IsNotNullPredicate;
import io.trino.sql.ir.IsNullPredicate;
import io.trino.sql.ir.Literal;
import io.trino.sql.ir.LogicalExpression;
import io.trino.sql.ir.LongLiteral;
import io.trino.sql.ir.NodeRef;
import io.trino.sql.ir.NotExpression;
import io.trino.sql.ir.NullIfExpression;
import io.trino.sql.ir.NullLiteral;
import io.trino.sql.ir.SubscriptExpression;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.BuiltinFunctionCallBuilder;
import io.trino.sql.planner.IrExpressionInterpreter;
import io.trino.sql.planner.IrLiteralInterpreter;
import io.trino.sql.planner.IrTypeAnalyzer;
import io.trino.sql.planner.LiteralEncoder;
import io.trino.sql.planner.ResolvedFunctionCallBuilder;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.tree.QualifiedName;
import io.trino.type.JoniRegexp;
import io.trino.type.JoniRegexpType;
import io.trino.type.JsonPathType;
import io.trino.type.LikePattern;
import io.trino.type.LikePatternType;
import io.trino.type.Re2JRegexp;
import io.trino.type.Re2JRegexpType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class ConnectorExpressionTranslator {
    private ConnectorExpressionTranslator() {
    }

    public static Expression translate(Session session, ConnectorExpression expression, PlannerContext plannerContext, Map<String, Symbol> variableMappings, LiteralEncoder literalEncoder) {
        return new ConnectorToSqlExpressionTranslator(session, plannerContext, literalEncoder, variableMappings).translate(expression).orElseThrow(() -> new UnsupportedOperationException("Expression is not supported: " + expression.toString()));
    }

    public static Optional<ConnectorExpression> translate(Session session, Expression expression, TypeProvider types, PlannerContext plannerContext, IrTypeAnalyzer typeAnalyzer) {
        return (Optional)new SqlToConnectorExpressionTranslator(session, typeAnalyzer.getTypes(session, types, expression), plannerContext).process(expression);
    }

    public static ConnectorExpressionTranslation translateConjuncts(Session session, Expression expression, TypeProvider types, PlannerContext plannerContext, IrTypeAnalyzer typeAnalyzer) {
        Map<NodeRef<Expression>, Type> remainingExpressionTypes = typeAnalyzer.getTypes(session, types, expression);
        SqlToConnectorExpressionTranslator translator = new SqlToConnectorExpressionTranslator(session, remainingExpressionTypes, plannerContext);
        List<Expression> conjuncts = IrUtils.extractConjuncts(expression);
        ArrayList<Expression> remaining = new ArrayList<Expression>();
        ArrayList<ConnectorExpression> converted = new ArrayList<ConnectorExpression>(conjuncts.size());
        for (Expression conjunct : conjuncts) {
            Optional connectorExpression = (Optional)translator.process(conjunct);
            if (connectorExpression.isPresent()) {
                converted.add((ConnectorExpression)connectorExpression.get());
                continue;
            }
            remaining.add(conjunct);
        }
        return new ConnectorExpressionTranslation(ConnectorExpressions.and(converted), IrUtils.combineConjuncts(plannerContext.getMetadata(), remaining));
    }

    @VisibleForTesting
    static FunctionName functionNameForComparisonOperator(ComparisonExpression.Operator operator) {
        return switch (operator) {
            default -> throw new MatchException(null, null);
            case ComparisonExpression.Operator.EQUAL -> StandardFunctions.EQUAL_OPERATOR_FUNCTION_NAME;
            case ComparisonExpression.Operator.NOT_EQUAL -> StandardFunctions.NOT_EQUAL_OPERATOR_FUNCTION_NAME;
            case ComparisonExpression.Operator.LESS_THAN -> StandardFunctions.LESS_THAN_OPERATOR_FUNCTION_NAME;
            case ComparisonExpression.Operator.LESS_THAN_OR_EQUAL -> StandardFunctions.LESS_THAN_OR_EQUAL_OPERATOR_FUNCTION_NAME;
            case ComparisonExpression.Operator.GREATER_THAN -> StandardFunctions.GREATER_THAN_OPERATOR_FUNCTION_NAME;
            case ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL -> StandardFunctions.GREATER_THAN_OR_EQUAL_OPERATOR_FUNCTION_NAME;
            case ComparisonExpression.Operator.IS_DISTINCT_FROM -> StandardFunctions.IS_DISTINCT_FROM_OPERATOR_FUNCTION_NAME;
        };
    }

    @VisibleForTesting
    static FunctionName functionNameForArithmeticBinaryOperator(ArithmeticBinaryExpression.Operator operator) {
        return switch (operator) {
            default -> throw new MatchException(null, null);
            case ArithmeticBinaryExpression.Operator.ADD -> StandardFunctions.ADD_FUNCTION_NAME;
            case ArithmeticBinaryExpression.Operator.SUBTRACT -> StandardFunctions.SUBTRACT_FUNCTION_NAME;
            case ArithmeticBinaryExpression.Operator.MULTIPLY -> StandardFunctions.MULTIPLY_FUNCTION_NAME;
            case ArithmeticBinaryExpression.Operator.DIVIDE -> StandardFunctions.DIVIDE_FUNCTION_NAME;
            case ArithmeticBinaryExpression.Operator.MODULUS -> StandardFunctions.MODULUS_FUNCTION_NAME;
        };
    }

    private static class ConnectorToSqlExpressionTranslator {
        private final Session session;
        private final PlannerContext plannerContext;
        private final LiteralEncoder literalEncoder;
        private final Map<String, Symbol> variableMappings;

        public ConnectorToSqlExpressionTranslator(Session session, PlannerContext plannerContext, LiteralEncoder literalEncoder, Map<String, Symbol> variableMappings) {
            this.session = Objects.requireNonNull(session, "session is null");
            this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
            this.literalEncoder = Objects.requireNonNull(literalEncoder, "literalEncoder is null");
            this.variableMappings = Objects.requireNonNull(variableMappings, "variableMappings is null");
        }

        public Optional<Expression> translate(ConnectorExpression expression) {
            if (expression instanceof Variable) {
                String name = ((Variable)expression).getName();
                return Optional.of(this.variableMappings.get(name).toSymbolReference());
            }
            if (expression instanceof Constant) {
                return Optional.of(this.literalEncoder.toExpression(((Constant)expression).getValue(), expression.getType()));
            }
            if (expression instanceof FieldDereference) {
                FieldDereference dereference = (FieldDereference)expression;
                return this.translate(dereference.getTarget()).map(base -> new SubscriptExpression((Expression)base, new LongLiteral(dereference.getField() + 1)));
            }
            if (expression instanceof Call) {
                return this.translateCall((Call)expression);
            }
            return Optional.empty();
        }

        protected Optional<Expression> translateCall(Call call) {
            Optional<Enum> operator;
            if (call.getFunctionName().getCatalogSchema().isPresent()) {
                CatalogSchemaName catalogSchemaName = (CatalogSchemaName)call.getFunctionName().getCatalogSchema().get();
                Preconditions.checkArgument((!catalogSchemaName.getCatalogName().equals("system") ? 1 : 0) != 0, (Object)"System functions must not be fully qualified");
                ResolvedFunction resolved = this.plannerContext.getFunctionResolver().resolveFunction(this.session, QualifiedName.of((String)catalogSchemaName.getCatalogName(), (String[])new String[]{catalogSchemaName.getSchemaName(), call.getFunctionName().getName()}), TypeSignatureProvider.fromTypes((List)call.getArguments().stream().map(ConnectorExpression::getType).collect(ImmutableList.toImmutableList())), new AllowAllAccessControl());
                return this.translateCall(call.getFunctionName().getName(), resolved, call.getArguments());
            }
            if (StandardFunctions.AND_FUNCTION_NAME.equals((Object)call.getFunctionName())) {
                return this.translateLogicalExpression(LogicalExpression.Operator.AND, call.getArguments());
            }
            if (StandardFunctions.OR_FUNCTION_NAME.equals((Object)call.getFunctionName())) {
                return this.translateLogicalExpression(LogicalExpression.Operator.OR, call.getArguments());
            }
            if (StandardFunctions.NOT_FUNCTION_NAME.equals((Object)call.getFunctionName()) && call.getArguments().size() == 1) {
                Call innerCall;
                ConnectorExpression expression = (ConnectorExpression)Iterables.getOnlyElement((Iterable)call.getArguments());
                if (expression instanceof Call && (innerCall = (Call)expression).getFunctionName().equals((Object)StandardFunctions.IS_NULL_FUNCTION_NAME) && innerCall.getArguments().size() == 1) {
                    return this.translateIsNotNull((ConnectorExpression)innerCall.getArguments().get(0));
                }
                return this.translateNot(expression);
            }
            if (StandardFunctions.IS_NULL_FUNCTION_NAME.equals((Object)call.getFunctionName()) && call.getArguments().size() == 1) {
                return this.translateIsNull((ConnectorExpression)call.getArguments().get(0));
            }
            if (StandardFunctions.NULLIF_FUNCTION_NAME.equals((Object)call.getFunctionName()) && call.getArguments().size() == 2) {
                return this.translateNullIf((ConnectorExpression)call.getArguments().get(0), (ConnectorExpression)call.getArguments().get(1));
            }
            if (StandardFunctions.CAST_FUNCTION_NAME.equals((Object)call.getFunctionName()) && call.getArguments().size() == 1) {
                return this.translateCast(call.getType(), (ConnectorExpression)call.getArguments().get(0));
            }
            if (call.getArguments().size() == 2 && (operator = this.comparisonOperatorForFunctionName(call.getFunctionName())).isPresent()) {
                return this.translateComparison(operator.get(), (ConnectorExpression)call.getArguments().get(0), (ConnectorExpression)call.getArguments().get(1));
            }
            if (call.getArguments().size() == 2 && (operator = this.arithmeticBinaryOperatorForFunctionName(call.getFunctionName())).isPresent()) {
                return this.translateArithmeticBinary((ArithmeticBinaryExpression.Operator)operator.get(), (ConnectorExpression)call.getArguments().get(0), (ConnectorExpression)call.getArguments().get(1));
            }
            if (StandardFunctions.NEGATE_FUNCTION_NAME.equals((Object)call.getFunctionName()) && call.getArguments().size() == 1) {
                return this.translate((ConnectorExpression)Iterables.getOnlyElement((Iterable)call.getArguments())).map(argument -> new ArithmeticUnaryExpression(ArithmeticUnaryExpression.Sign.MINUS, (Expression)argument));
            }
            if (StandardFunctions.LIKE_FUNCTION_NAME.equals((Object)call.getFunctionName())) {
                return switch (call.getArguments().size()) {
                    case 2 -> this.translateLike((ConnectorExpression)call.getArguments().get(0), (ConnectorExpression)call.getArguments().get(1), Optional.empty());
                    case 3 -> this.translateLike((ConnectorExpression)call.getArguments().get(0), (ConnectorExpression)call.getArguments().get(1), Optional.of((ConnectorExpression)call.getArguments().get(2)));
                    default -> Optional.empty();
                };
            }
            if (StandardFunctions.IN_PREDICATE_FUNCTION_NAME.equals((Object)call.getFunctionName()) && call.getArguments().size() == 2) {
                return this.translateInPredicate((ConnectorExpression)call.getArguments().get(0), (ConnectorExpression)call.getArguments().get(1));
            }
            ResolvedFunction resolved = this.plannerContext.getMetadata().resolveBuiltinFunction(call.getFunctionName().getName(), TypeSignatureProvider.fromTypes((List)call.getArguments().stream().map(ConnectorExpression::getType).collect(ImmutableList.toImmutableList())));
            return this.translateCall(call.getFunctionName().getName(), resolved, call.getArguments());
        }

        private Optional<Expression> translateCall(String functionName, ResolvedFunction resolved, List<ConnectorExpression> arguments) {
            ResolvedFunctionCallBuilder builder = ResolvedFunctionCallBuilder.builder(resolved);
            for (int i = 0; i < arguments.size(); ++i) {
                ConnectorExpression argument = arguments.get(i);
                Type formalType = (Type)resolved.getSignature().getArgumentTypes().get(i);
                Type argumentType = argument.getType();
                Optional<Expression> translated = this.translate(argument);
                if (translated.isEmpty()) {
                    return Optional.empty();
                }
                Expression expression = translated.get();
                if ((formalType == JoniRegexpType.JONI_REGEXP || formalType instanceof Re2JRegexpType || formalType instanceof JsonPathType) && argumentType instanceof VarcharType) {
                    expression = new Cast(expression, formalType);
                } else if (!argumentType.equals((Object)formalType)) {
                    throw new IllegalArgumentException("Unexpected type %s for argument %s of type %s of %s".formatted(argumentType, formalType, i, functionName));
                }
                builder.addArgument(expression);
            }
            return Optional.of(builder.build());
        }

        private Optional<Expression> translateIsNotNull(ConnectorExpression argument) {
            Optional<Expression> translatedArgument = this.translate(argument);
            if (translatedArgument.isPresent()) {
                return Optional.of(new IsNotNullPredicate(translatedArgument.get()));
            }
            return Optional.empty();
        }

        private Optional<Expression> translateIsNull(ConnectorExpression argument) {
            Optional<Expression> translatedArgument = this.translate(argument);
            if (translatedArgument.isPresent()) {
                return Optional.of(new IsNullPredicate(translatedArgument.get()));
            }
            return Optional.empty();
        }

        private Optional<Expression> translateNot(ConnectorExpression argument) {
            Optional<Expression> translatedArgument = this.translate(argument);
            if (argument.getType().equals((Object)BooleanType.BOOLEAN) && translatedArgument.isPresent()) {
                return Optional.of(new NotExpression(translatedArgument.get()));
            }
            return Optional.empty();
        }

        private Optional<Expression> translateCast(Type type, ConnectorExpression expression) {
            Optional<Expression> translatedExpression = this.translate(expression);
            if (translatedExpression.isPresent()) {
                return Optional.of(new Cast(translatedExpression.get(), type));
            }
            return Optional.empty();
        }

        private Optional<Expression> translateLogicalExpression(LogicalExpression.Operator operator, List<ConnectorExpression> arguments) {
            Optional<List<Expression>> translatedArguments = this.translateExpressions(arguments);
            return translatedArguments.map(expressions -> new LogicalExpression(operator, (List<Expression>)expressions));
        }

        private Optional<Expression> translateComparison(ComparisonExpression.Operator operator, ConnectorExpression left, ConnectorExpression right) {
            return this.translate(left).flatMap(leftTranslated -> this.translate(right).map(rightTranslated -> new ComparisonExpression(operator, (Expression)leftTranslated, (Expression)rightTranslated)));
        }

        private Optional<Expression> translateNullIf(ConnectorExpression first, ConnectorExpression second) {
            Optional<Expression> firstExpression = this.translate(first);
            Optional<Expression> secondExpression = this.translate(second);
            if (firstExpression.isPresent() && secondExpression.isPresent()) {
                return Optional.of(new NullIfExpression(firstExpression.get(), secondExpression.get()));
            }
            return Optional.empty();
        }

        private Optional<ComparisonExpression.Operator> comparisonOperatorForFunctionName(FunctionName functionName) {
            if (StandardFunctions.EQUAL_OPERATOR_FUNCTION_NAME.equals((Object)functionName)) {
                return Optional.of(ComparisonExpression.Operator.EQUAL);
            }
            if (StandardFunctions.NOT_EQUAL_OPERATOR_FUNCTION_NAME.equals((Object)functionName)) {
                return Optional.of(ComparisonExpression.Operator.NOT_EQUAL);
            }
            if (StandardFunctions.LESS_THAN_OPERATOR_FUNCTION_NAME.equals((Object)functionName)) {
                return Optional.of(ComparisonExpression.Operator.LESS_THAN);
            }
            if (StandardFunctions.LESS_THAN_OR_EQUAL_OPERATOR_FUNCTION_NAME.equals((Object)functionName)) {
                return Optional.of(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL);
            }
            if (StandardFunctions.GREATER_THAN_OPERATOR_FUNCTION_NAME.equals((Object)functionName)) {
                return Optional.of(ComparisonExpression.Operator.GREATER_THAN);
            }
            if (StandardFunctions.GREATER_THAN_OR_EQUAL_OPERATOR_FUNCTION_NAME.equals((Object)functionName)) {
                return Optional.of(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL);
            }
            if (StandardFunctions.IS_DISTINCT_FROM_OPERATOR_FUNCTION_NAME.equals((Object)functionName)) {
                return Optional.of(ComparisonExpression.Operator.IS_DISTINCT_FROM);
            }
            return Optional.empty();
        }

        private Optional<Expression> translateArithmeticBinary(ArithmeticBinaryExpression.Operator operator, ConnectorExpression left, ConnectorExpression right) {
            return this.translate(left).flatMap(leftTranslated -> this.translate(right).map(rightTranslated -> new ArithmeticBinaryExpression(operator, (Expression)leftTranslated, (Expression)rightTranslated)));
        }

        private Optional<ArithmeticBinaryExpression.Operator> arithmeticBinaryOperatorForFunctionName(FunctionName functionName) {
            if (StandardFunctions.ADD_FUNCTION_NAME.equals((Object)functionName)) {
                return Optional.of(ArithmeticBinaryExpression.Operator.ADD);
            }
            if (StandardFunctions.SUBTRACT_FUNCTION_NAME.equals((Object)functionName)) {
                return Optional.of(ArithmeticBinaryExpression.Operator.SUBTRACT);
            }
            if (StandardFunctions.MULTIPLY_FUNCTION_NAME.equals((Object)functionName)) {
                return Optional.of(ArithmeticBinaryExpression.Operator.MULTIPLY);
            }
            if (StandardFunctions.DIVIDE_FUNCTION_NAME.equals((Object)functionName)) {
                return Optional.of(ArithmeticBinaryExpression.Operator.DIVIDE);
            }
            if (StandardFunctions.MODULUS_FUNCTION_NAME.equals((Object)functionName)) {
                return Optional.of(ArithmeticBinaryExpression.Operator.MODULUS);
            }
            return Optional.empty();
        }

        protected Optional<Expression> translateLike(ConnectorExpression value, ConnectorExpression pattern, Optional<ConnectorExpression> escape) {
            Optional<Expression> translatedValue = this.translate(value);
            Optional<Expression> translatedPattern = this.translate(pattern);
            if (translatedValue.isPresent() && translatedPattern.isPresent()) {
                FunctionCall patternCall;
                if (escape.isPresent()) {
                    Optional<Expression> translatedEscape = this.translate(escape.get());
                    if (translatedEscape.isEmpty()) {
                        return Optional.empty();
                    }
                    patternCall = BuiltinFunctionCallBuilder.resolve(this.plannerContext.getMetadata()).setName("$like_pattern").addArgument(pattern.getType(), translatedPattern.get()).addArgument(escape.get().getType(), translatedEscape.get()).build();
                } else {
                    patternCall = BuiltinFunctionCallBuilder.resolve(this.plannerContext.getMetadata()).setName("$like_pattern").addArgument(pattern.getType(), translatedPattern.get()).build();
                }
                FunctionCall call = BuiltinFunctionCallBuilder.resolve(this.plannerContext.getMetadata()).setName("$like").addArgument(value.getType(), translatedValue.get()).addArgument((Type)LikePatternType.LIKE_PATTERN, (Expression)patternCall).build();
                return Optional.of(call);
            }
            return Optional.empty();
        }

        protected Optional<Expression> translateInPredicate(ConnectorExpression value, ConnectorExpression values) {
            Optional<Expression> translatedValue = this.translate(value);
            Optional<List<Expression>> translatedValues = this.extractExpressionsFromArrayCall(values);
            if (translatedValue.isPresent() && translatedValues.isPresent()) {
                return Optional.of(new InPredicate(translatedValue.get(), translatedValues.get()));
            }
            return Optional.empty();
        }

        protected Optional<List<Expression>> extractExpressionsFromArrayCall(ConnectorExpression expression) {
            if (!(expression instanceof Call)) {
                return Optional.empty();
            }
            Call call = (Call)expression;
            if (!call.getFunctionName().equals((Object)StandardFunctions.ARRAY_CONSTRUCTOR_FUNCTION_NAME)) {
                return Optional.empty();
            }
            return this.translateExpressions(call.getArguments());
        }

        protected Optional<List<Expression>> translateExpressions(List<ConnectorExpression> expressions) {
            ImmutableList.Builder translatedExpressions = ImmutableList.builderWithExpectedSize((int)expressions.size());
            for (ConnectorExpression expression : expressions) {
                Optional<Expression> translated = this.translate(expression);
                if (translated.isEmpty()) {
                    return Optional.empty();
                }
                translatedExpressions.add((Object)translated.get());
            }
            return Optional.of(translatedExpressions.build());
        }
    }

    public static class SqlToConnectorExpressionTranslator
    extends IrVisitor<Optional<ConnectorExpression>, Void> {
        private final Session session;
        private final Map<NodeRef<Expression>, Type> types;
        private final PlannerContext plannerContext;
        private final IrLiteralInterpreter literalInterpreter;

        public SqlToConnectorExpressionTranslator(Session session, Map<NodeRef<Expression>, Type> types, PlannerContext plannerContext) {
            this.session = Objects.requireNonNull(session, "session is null");
            this.types = Objects.requireNonNull(types, "types is null");
            this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
            this.literalInterpreter = new IrLiteralInterpreter(plannerContext, session);
        }

        @Override
        protected Optional<ConnectorExpression> visitSymbolReference(SymbolReference node, Void context) {
            return Optional.of(new Variable(node.getName(), this.typeOf(node)));
        }

        @Override
        protected Optional<ConnectorExpression> visitLiteral(Literal node, Void context) {
            Type type = this.typeOf(node);
            return Optional.of(new Constant(this.literalInterpreter.evaluate(node, type), type));
        }

        @Override
        protected Optional<ConnectorExpression> visitLogicalExpression(LogicalExpression node, Void context) {
            if (!SystemSessionProperties.isComplexExpressionPushdown(this.session)) {
                return Optional.empty();
            }
            ImmutableList.Builder arguments = ImmutableList.builderWithExpectedSize((int)node.getTerms().size());
            for (Expression argument : node.getTerms()) {
                Optional translated = (Optional)this.process(argument);
                if (translated.isEmpty()) {
                    return Optional.empty();
                }
                arguments.add((Object)((ConnectorExpression)translated.get()));
            }
            return switch (node.getOperator()) {
                default -> throw new MatchException(null, null);
                case LogicalExpression.Operator.AND -> Optional.of(new Call((Type)BooleanType.BOOLEAN, StandardFunctions.AND_FUNCTION_NAME, (List)arguments.build()));
                case LogicalExpression.Operator.OR -> Optional.of(new Call((Type)BooleanType.BOOLEAN, StandardFunctions.OR_FUNCTION_NAME, (List)arguments.build()));
            };
        }

        @Override
        protected Optional<ConnectorExpression> visitComparisonExpression(ComparisonExpression node, Void context) {
            if (!SystemSessionProperties.isComplexExpressionPushdown(this.session)) {
                return Optional.empty();
            }
            return ((Optional)this.process(node.getLeft())).flatMap(left -> ((Optional)this.process(node.getRight())).map(right -> new Call(this.typeOf(node), ConnectorExpressionTranslator.functionNameForComparisonOperator(node.getOperator()), (List)ImmutableList.of((Object)left, (Object)right))));
        }

        @Override
        protected Optional<ConnectorExpression> visitArithmeticBinary(ArithmeticBinaryExpression node, Void context) {
            if (!SystemSessionProperties.isComplexExpressionPushdown(this.session)) {
                return Optional.empty();
            }
            return ((Optional)this.process(node.getLeft())).flatMap(left -> ((Optional)this.process(node.getRight())).map(right -> new Call(this.typeOf(node), ConnectorExpressionTranslator.functionNameForArithmeticBinaryOperator(node.getOperator()), (List)ImmutableList.of((Object)left, (Object)right))));
        }

        @Override
        protected Optional<ConnectorExpression> visitBetweenPredicate(BetweenPredicate node, Void context) {
            if (!SystemSessionProperties.isComplexExpressionPushdown(this.session)) {
                return Optional.empty();
            }
            return ((Optional)this.process(node.getValue())).flatMap(value -> ((Optional)this.process(node.getMin())).flatMap(min -> ((Optional)this.process(node.getMax())).map(max -> new Call((Type)BooleanType.BOOLEAN, StandardFunctions.AND_FUNCTION_NAME, (List)ImmutableList.of((Object)new Call((Type)BooleanType.BOOLEAN, StandardFunctions.GREATER_THAN_OR_EQUAL_OPERATOR_FUNCTION_NAME, (List)ImmutableList.of((Object)value, (Object)min)), (Object)new Call((Type)BooleanType.BOOLEAN, StandardFunctions.LESS_THAN_OR_EQUAL_OPERATOR_FUNCTION_NAME, (List)ImmutableList.of((Object)value, (Object)max)))))));
        }

        @Override
        protected Optional<ConnectorExpression> visitArithmeticUnary(ArithmeticUnaryExpression node, Void context) {
            if (!SystemSessionProperties.isComplexExpressionPushdown(this.session)) {
                return Optional.empty();
            }
            return switch (node.getSign()) {
                default -> throw new MatchException(null, null);
                case ArithmeticUnaryExpression.Sign.PLUS -> (Optional<ConnectorExpression>)this.process(node.getValue());
                case ArithmeticUnaryExpression.Sign.MINUS -> ((Optional)this.process(node.getValue())).map(value -> new Call(this.typeOf(node), StandardFunctions.NEGATE_FUNCTION_NAME, (List)ImmutableList.of((Object)value)));
            };
        }

        @Override
        protected Optional<ConnectorExpression> visitCast(Cast node, Void context) {
            if (IrUtils.isEffectivelyLiteral(this.plannerContext, this.session, node)) {
                return Optional.of(this.constantFor(node));
            }
            if (node.isSafe()) {
                return Optional.empty();
            }
            if (!SystemSessionProperties.isComplexExpressionPushdown(this.session)) {
                return Optional.empty();
            }
            Optional translatedExpression = (Optional)this.process(node.getExpression());
            if (translatedExpression.isPresent()) {
                return Optional.of(new Call(node.getType(), StandardFunctions.CAST_FUNCTION_NAME, List.of((ConnectorExpression)translatedExpression.get())));
            }
            return Optional.empty();
        }

        @Override
        protected Optional<ConnectorExpression> visitFunctionCall(FunctionCall node, Void context) {
            if (!SystemSessionProperties.isComplexExpressionPushdown(this.session)) {
                return Optional.empty();
            }
            if (IrUtils.isEffectivelyLiteral(this.plannerContext, this.session, node)) {
                return Optional.of(this.constantFor(node));
            }
            CatalogSchemaFunctionName functionName = ResolvedFunction.extractFunctionName(node.getName());
            Preconditions.checkArgument((!DynamicFilters.isDynamicFilterFunction(functionName) ? 1 : 0) != 0, (Object)"Dynamic filter has no meaning for a connector, it should not be translated into ConnectorExpression");
            Preconditions.checkArgument((!GlobalFunctionCatalog.builtinFunctionName("$literal$").equals((Object)functionName) ? 1 : 0) != 0, (Object)"Unexpected literal function");
            if (functionName.equals((Object)GlobalFunctionCatalog.builtinFunctionName("$like"))) {
                return this.translateLike(node);
            }
            ImmutableList.Builder arguments = ImmutableList.builder();
            for (Expression argumentExpression : node.getArguments()) {
                Optional argument = (Optional)this.process(argumentExpression);
                if (argument.isEmpty()) {
                    return Optional.empty();
                }
                arguments.add((Object)((ConnectorExpression)argument.get()));
            }
            if (LanguageFunctionManager.isInlineFunction(functionName)) {
                return Optional.empty();
            }
            FunctionName name = GlobalFunctionCatalog.isBuiltinFunctionName(functionName) ? new FunctionName(functionName.getFunctionName()) : new FunctionName(Optional.of(new CatalogSchemaName(functionName.getCatalogName(), functionName.getSchemaName())), functionName.getFunctionName());
            return Optional.of(new Call(this.typeOf(node), name, (List)arguments.build()));
        }

        private Optional<ConnectorExpression> translateLike(FunctionCall node) {
            FunctionCall call;
            ImmutableList.Builder arguments = ImmutableList.builder();
            Optional value = (Optional)this.process(node.getArguments().get(0));
            if (value.isEmpty()) {
                return Optional.empty();
            }
            arguments.add((Object)((ConnectorExpression)value.get()));
            Expression patternArgument = node.getArguments().get(1);
            if (IrUtils.isEffectivelyLiteral(this.plannerContext, this.session, patternArgument)) {
                LikePattern matcher = (LikePattern)IrExpressionInterpreter.evaluateConstantExpression(patternArgument, this.plannerContext, this.session);
                arguments.add((Object)new Constant((Object)Slices.utf8Slice((String)matcher.getPattern()), (Type)VarcharType.createVarcharType((int)matcher.getPattern().length())));
                if (matcher.getEscape().isPresent()) {
                    arguments.add((Object)new Constant((Object)Slices.utf8Slice((String)matcher.getEscape().get().toString()), (Type)VarcharType.createVarcharType((int)1)));
                }
            } else if (patternArgument instanceof FunctionCall && ResolvedFunction.extractFunctionName((call = (FunctionCall)patternArgument).getName()).equals((Object)GlobalFunctionCatalog.builtinFunctionName("$like_pattern"))) {
                Optional translatedPattern = (Optional)this.process(call.getArguments().get(0));
                if (translatedPattern.isEmpty()) {
                    return Optional.empty();
                }
                arguments.add((Object)((ConnectorExpression)translatedPattern.get()));
                if (call.getArguments().size() == 2) {
                    Optional translatedEscape = (Optional)this.process(call.getArguments().get(1));
                    if (translatedEscape.isEmpty()) {
                        return Optional.empty();
                    }
                    arguments.add((Object)((ConnectorExpression)translatedEscape.get()));
                }
            } else {
                return Optional.empty();
            }
            return Optional.of(new Call(this.typeOf(node), StandardFunctions.LIKE_FUNCTION_NAME, (List)arguments.build()));
        }

        @Override
        protected Optional<ConnectorExpression> visitIsNullPredicate(IsNullPredicate node, Void context) {
            Optional translatedValue = (Optional)this.process(node.getValue());
            if (translatedValue.isPresent()) {
                return Optional.of(new Call((Type)BooleanType.BOOLEAN, StandardFunctions.IS_NULL_FUNCTION_NAME, (List)ImmutableList.of((Object)((ConnectorExpression)translatedValue.get()))));
            }
            return Optional.empty();
        }

        @Override
        protected Optional<ConnectorExpression> visitIsNotNullPredicate(IsNotNullPredicate node, Void context) {
            Optional translatedValue = (Optional)this.process(node.getValue());
            if (translatedValue.isPresent()) {
                Call isNullCall = new Call(this.typeOf(node), StandardFunctions.IS_NULL_FUNCTION_NAME, List.of((ConnectorExpression)translatedValue.get()));
                return Optional.of(new Call((Type)BooleanType.BOOLEAN, StandardFunctions.NOT_FUNCTION_NAME, List.of(isNullCall)));
            }
            return Optional.empty();
        }

        @Override
        protected Optional<ConnectorExpression> visitNotExpression(NotExpression node, Void context) {
            Optional translatedValue = (Optional)this.process(node.getValue());
            if (translatedValue.isPresent()) {
                return Optional.of(new Call((Type)BooleanType.BOOLEAN, StandardFunctions.NOT_FUNCTION_NAME, List.of((ConnectorExpression)translatedValue.get())));
            }
            return Optional.empty();
        }

        private ConnectorExpression constantFor(Expression node) {
            Type type = this.typeOf(node);
            Object value = IrExpressionInterpreter.evaluateConstantExpression(node, this.plannerContext, this.session);
            if (type == JoniRegexpType.JONI_REGEXP) {
                Slice pattern = ((JoniRegexp)value).pattern();
                return new Constant((Object)pattern, (Type)VarcharType.createVarcharType((int)SliceUtf8.countCodePoints((Slice)pattern)));
            }
            if (type instanceof Re2JRegexpType) {
                Slice pattern = Slices.utf8Slice((String)((Re2JRegexp)value).pattern());
                return new Constant((Object)pattern, (Type)VarcharType.createVarcharType((int)SliceUtf8.countCodePoints((Slice)pattern)));
            }
            if (type instanceof JsonPathType) {
                Slice pattern = Slices.utf8Slice((String)((JsonPath)value).pattern());
                return new Constant((Object)pattern, (Type)VarcharType.createVarcharType((int)SliceUtf8.countCodePoints((Slice)pattern)));
            }
            return new Constant(value, type);
        }

        @Override
        protected Optional<ConnectorExpression> visitNullIfExpression(NullIfExpression node, Void context) {
            Optional firstValue = (Optional)this.process(node.getFirst());
            Optional secondValue = (Optional)this.process(node.getSecond());
            if (firstValue.isPresent() && secondValue.isPresent()) {
                return Optional.of(new Call(this.typeOf(node), StandardFunctions.NULLIF_FUNCTION_NAME, (List)ImmutableList.of((Object)((ConnectorExpression)firstValue.get()), (Object)((ConnectorExpression)secondValue.get()))));
            }
            return Optional.empty();
        }

        @Override
        protected Optional<ConnectorExpression> visitSubscriptExpression(SubscriptExpression node, Void context) {
            if (!(this.typeOf(node.getBase()) instanceof RowType)) {
                return Optional.empty();
            }
            Optional translatedBase = (Optional)this.process(node.getBase());
            if (translatedBase.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(new FieldDereference(this.typeOf(node), (ConnectorExpression)translatedBase.get(), Math.toIntExact(((LongLiteral)node.getIndex()).getValue() - 1L)));
        }

        @Override
        protected Optional<ConnectorExpression> visitInPredicate(InPredicate node, Void context) {
            Optional valueExpression = (Optional)this.process(node.getValue());
            if (valueExpression.isEmpty()) {
                return Optional.empty();
            }
            ImmutableList.Builder values = ImmutableList.builderWithExpectedSize((int)node.getValueList().size());
            for (Expression value : node.getValueList()) {
                if (value == null || value instanceof NullLiteral) {
                    return Optional.empty();
                }
                Optional processedValue = (Optional)this.process(value);
                if (processedValue.isEmpty()) {
                    return Optional.empty();
                }
                values.add((Object)((ConnectorExpression)processedValue.get()));
            }
            Call arrayExpression = new Call((Type)new ArrayType(this.typeOf(node.getValue())), StandardFunctions.ARRAY_CONSTRUCTOR_FUNCTION_NAME, (List)values.build());
            return Optional.of(new Call(this.typeOf(node), StandardFunctions.IN_PREDICATE_FUNCTION_NAME, List.of((ConnectorExpression)valueExpression.get(), arrayExpression)));
        }

        @Override
        protected Optional<ConnectorExpression> visitExpression(Expression node, Void context) {
            return Optional.empty();
        }

        private Type typeOf(Expression node) {
            return this.types.get(NodeRef.of(node));
        }
    }

    public record ConnectorExpressionTranslation(ConnectorExpression connectorExpression, Expression remainingExpression) {
        public ConnectorExpressionTranslation {
            Objects.requireNonNull(connectorExpression, "connectorExpression is null");
            Objects.requireNonNull(remainingExpression, "remainingExpression is null");
        }
    }
}

