/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.ExpressionRewriter;
import io.trino.sql.ir.ExpressionTreeRewriter;
import io.trino.sql.ir.LambdaExpression;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.Symbol;
import java.util.Map;
import java.util.function.Function;

public final class ExpressionSymbolInliner {
    private final Function<Symbol, Expression> mapping;

    public static Expression inlineSymbols(Map<Symbol, ? extends Expression> mapping, Expression expression) {
        return ExpressionSymbolInliner.inlineSymbols(mapping::get, expression);
    }

    public static Expression inlineSymbols(Function<Symbol, Expression> mapping, Expression expression) {
        return new ExpressionSymbolInliner(mapping).rewrite(expression);
    }

    private ExpressionSymbolInliner(Function<Symbol, Expression> mapping) {
        this.mapping = mapping;
    }

    private Expression rewrite(Expression expression) {
        return ExpressionTreeRewriter.rewriteWith(new Visitor(), expression);
    }

    private class Visitor
    extends ExpressionRewriter<Void> {
        private final Multiset<String> excludedNames = HashMultiset.create();

        private Visitor() {
        }

        @Override
        public Expression rewriteSymbolReference(SymbolReference node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            if (this.excludedNames.contains((Object)node.getName())) {
                return node;
            }
            Expression expression = ExpressionSymbolInliner.this.mapping.apply(Symbol.from(node));
            Preconditions.checkState((expression != null ? 1 : 0) != 0, (String)"Cannot resolve symbol %s", (Object)node.getName());
            return expression;
        }

        @Override
        public Expression rewriteLambdaExpression(LambdaExpression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            this.excludedNames.addAll(node.getArguments());
            LambdaExpression result = treeRewriter.defaultRewrite(node, context);
            for (String argument : node.getArguments()) {
                Verify.verify((boolean)this.excludedNames.remove((Object)argument));
            }
            return result;
        }
    }
}

