/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.collect.ImmutableMap;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.ExpressionRewriter;
import io.trino.sql.ir.ExpressionTreeRewriter;
import io.trino.sql.ir.NodeRef;
import java.util.Map;
import java.util.Objects;

public class ReferenceAwareExpressionNodeInliner
extends ExpressionRewriter<Void> {
    private final Map<NodeRef<Expression>, Expression> mappings;

    public static Expression replaceExpression(Expression expression, Map<NodeRef<Expression>, Expression> mappings) {
        return ExpressionTreeRewriter.rewriteWith(new ReferenceAwareExpressionNodeInliner(mappings), expression);
    }

    private ReferenceAwareExpressionNodeInliner(Map<NodeRef<Expression>, Expression> mappings) {
        this.mappings = ImmutableMap.copyOf(Objects.requireNonNull(mappings, "mappings is null"));
    }

    @Override
    protected Expression rewriteExpression(Expression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
        return this.mappings.get(NodeRef.of(node));
    }
}

