/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import io.trino.metadata.ResolvedFunction;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.analyzer.Field;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.FunctionCall;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.TypeProvider;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class SymbolAllocator {
    private final Map<Symbol, Type> symbols;
    private int nextId;

    public SymbolAllocator() {
        this.symbols = new HashMap<Symbol, Type>();
    }

    public SymbolAllocator(Map<Symbol, Type> initial) {
        this.symbols = new HashMap<Symbol, Type>(initial);
    }

    public Symbol newSymbol(Symbol symbolHint) {
        return this.newSymbol(symbolHint, null);
    }

    public Symbol newSymbol(Symbol symbolHint, String suffix) {
        Preconditions.checkArgument((boolean)this.symbols.containsKey(symbolHint), (Object)"symbolHint not in symbols map");
        return this.newSymbol(symbolHint.getName(), this.symbols.get(symbolHint), suffix);
    }

    public Symbol newSymbol(String nameHint, Type type) {
        return this.newSymbol(nameHint, type, null);
    }

    public Symbol newHashSymbol() {
        return this.newSymbol("$hashValue", (Type)BigintType.BIGINT);
    }

    public Symbol newSymbol(String nameHint, Type type, @Nullable String suffix) {
        String tail;
        Objects.requireNonNull(nameHint, "nameHint is null");
        Objects.requireNonNull(type, "type is null");
        nameHint = nameHint.toLowerCase(Locale.ENGLISH);
        int index = nameHint.lastIndexOf("_");
        if (index > 0 && (Ints.tryParse((String)(tail = nameHint.substring(index + 1))) != null || index == nameHint.length() - 1)) {
            nameHint = nameHint.substring(0, index);
        }
        Object unique = nameHint;
        if (suffix != null) {
            unique = (String)unique + "$" + suffix;
        }
        Symbol symbol = new Symbol((String)unique);
        while (this.symbols.putIfAbsent(symbol, type) != null) {
            symbol = new Symbol((String)unique + "_" + this.nextId());
        }
        return symbol;
    }

    public Symbol newSymbol(Expression expression, Type type) {
        return this.newSymbol(expression, type, null);
    }

    public Symbol newSymbol(Expression expression, Type type, String suffix) {
        String nameHint = "expr";
        if (expression instanceof FunctionCall) {
            FunctionCall functionCall = (FunctionCall)expression;
            nameHint = ResolvedFunction.isResolved(functionCall.getName()) ? ResolvedFunction.extractFunctionName(functionCall.getName()).getFunctionName() : functionCall.getName().getSuffix();
        } else if (expression instanceof SymbolReference) {
            SymbolReference symbolReference = (SymbolReference)expression;
            nameHint = symbolReference.getName();
        }
        return this.newSymbol(nameHint, type, suffix);
    }

    public Symbol newSymbol(Field field) {
        String nameHint = field.getName().orElse("field");
        return this.newSymbol(nameHint, field.getType());
    }

    public TypeProvider getTypes() {
        return TypeProvider.viewOf(this.symbols);
    }

    private int nextId() {
        return this.nextId++;
    }
}

