/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.trino.Session;
import io.trino.metadata.GlobalFunctionCatalog;
import io.trino.metadata.ResolvedFunction;
import io.trino.spi.function.CatalogSchemaFunctionName;
import io.trino.spi.type.DateType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.PlannerContext;
import io.trino.sql.ir.ArithmeticBinaryExpression;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.ComparisonExpression;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.ExpressionRewriter;
import io.trino.sql.ir.ExpressionTreeRewriter;
import io.trino.sql.ir.FunctionCall;
import io.trino.sql.ir.IfExpression;
import io.trino.sql.ir.IrUtils;
import io.trino.sql.ir.IsNotNullPredicate;
import io.trino.sql.ir.IsNullPredicate;
import io.trino.sql.ir.NotExpression;
import io.trino.sql.ir.SearchedCaseExpression;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.ir.WhenClause;
import io.trino.sql.planner.IrTypeAnalyzer;
import io.trino.sql.planner.TypeProvider;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class CanonicalizeExpressionRewriter {
    public static Expression canonicalizeExpression(Expression expression, IrTypeAnalyzer typeAnalyzer, TypeProvider types, PlannerContext plannerContext, Session session) {
        return ExpressionTreeRewriter.rewriteWith(new Visitor(session, plannerContext, typeAnalyzer, types), expression);
    }

    private CanonicalizeExpressionRewriter() {
    }

    public static Expression rewrite(Expression expression, Session session, PlannerContext plannerContext, IrTypeAnalyzer typeAnalyzer, TypeProvider types) {
        Objects.requireNonNull(plannerContext, "plannerContext is null");
        Objects.requireNonNull(typeAnalyzer, "typeAnalyzer is null");
        if (expression instanceof SymbolReference) {
            return expression;
        }
        return ExpressionTreeRewriter.rewriteWith(new Visitor(session, plannerContext, typeAnalyzer, types), expression);
    }

    private static class Visitor
    extends ExpressionRewriter<Void> {
        private final Session session;
        private final PlannerContext plannerContext;
        private final IrTypeAnalyzer typeAnalyzer;
        private final TypeProvider types;

        public Visitor(Session session, PlannerContext plannerContext, IrTypeAnalyzer typeAnalyzer, TypeProvider types) {
            this.session = session;
            this.plannerContext = plannerContext;
            this.typeAnalyzer = typeAnalyzer;
            this.types = types;
        }

        @Override
        public Expression rewriteComparisonExpression(ComparisonExpression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            if (this.isConstant(node.getLeft()) && !this.isConstant(node.getRight())) {
                node = new ComparisonExpression(node.getOperator().flip(), node.getRight(), node.getLeft());
            }
            return treeRewriter.defaultRewrite(node, context);
        }

        @Override
        public Expression rewriteArithmeticBinary(ArithmeticBinaryExpression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            if ((node.getOperator() == ArithmeticBinaryExpression.Operator.MULTIPLY || node.getOperator() == ArithmeticBinaryExpression.Operator.ADD) && this.isConstant(node.getLeft()) && !this.isConstant(node.getRight())) {
                node = new ArithmeticBinaryExpression(node.getOperator(), node.getRight(), node.getLeft());
            }
            return treeRewriter.defaultRewrite(node, context);
        }

        @Override
        public Expression rewriteIsNotNullPredicate(IsNotNullPredicate node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            Expression value = treeRewriter.rewrite(node.getValue(), context);
            return new NotExpression(new IsNullPredicate(value));
        }

        @Override
        public Expression rewriteIfExpression(IfExpression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            Expression condition = treeRewriter.rewrite(node.getCondition(), context);
            Expression trueValue = treeRewriter.rewrite(node.getTrueValue(), context);
            Optional<Expression> falseValue = node.getFalseValue().map(value -> treeRewriter.rewrite(value, context));
            return new SearchedCaseExpression((List<WhenClause>)ImmutableList.of((Object)new WhenClause(condition, trueValue)), falseValue);
        }

        @Override
        public Expression rewriteFunctionCall(FunctionCall node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            Expression argument;
            Type argumentType;
            CatalogSchemaFunctionName functionName = ResolvedFunction.extractFunctionName(node.getName());
            if (functionName.equals((Object)GlobalFunctionCatalog.builtinFunctionName("date")) && node.getArguments().size() == 1 && ((argumentType = this.typeAnalyzer.getType(this.session, this.types, argument = node.getArguments().get(0))) instanceof TimestampType || argumentType instanceof TimestampWithTimeZoneType || argumentType instanceof VarcharType)) {
                return new Cast(treeRewriter.rewrite(argument, context), (Type)DateType.DATE);
            }
            return treeRewriter.defaultRewrite(node, context);
        }

        private boolean isConstant(Expression expression) {
            return IrUtils.isEffectivelyLiteral(this.plannerContext, this.session, expression);
        }
    }
}

