/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.metadata.Metadata;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.ComparisonExpression;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.GenericLiteral;
import io.trino.sql.ir.IrUtils;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.SetOperationNodeTranslator;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.IntersectNode;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.ProjectNode;
import java.util.Collection;
import java.util.Objects;

public class ImplementIntersectDistinctAsUnion
implements Rule<IntersectNode> {
    private static final Pattern<IntersectNode> PATTERN = Patterns.intersect().with(Patterns.Intersect.distinct().equalTo((Object)true));
    private final Metadata metadata;

    public ImplementIntersectDistinctAsUnion(Metadata metadata) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
    }

    @Override
    public Pattern<IntersectNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(IntersectNode node, Captures captures, Rule.Context context) {
        SetOperationNodeTranslator translator = new SetOperationNodeTranslator(context.getSession(), this.metadata, context.getSymbolAllocator(), context.getIdAllocator());
        SetOperationNodeTranslator.TranslationResult result = translator.makeSetContainmentPlanForDistinct(node);
        Expression predicate = IrUtils.and((Collection)result.getCountSymbols().stream().map(symbol -> new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, symbol.toSymbolReference(), new GenericLiteral((Type)BigintType.BIGINT, "1"))).collect(ImmutableList.toImmutableList()));
        return Rule.Result.ofPlanNode(new ProjectNode(context.getIdAllocator().getNextId(), new FilterNode(context.getIdAllocator().getNextId(), result.getPlanNode(), predicate), Assignments.identity(node.getOutputSymbols())));
    }
}

