/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.ComparisonExpression;
import io.trino.sql.ir.GenericLiteral;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.OffsetNode;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.sql.planner.plan.RowNumberNode;
import java.util.List;
import java.util.Optional;

public class ImplementOffset
implements Rule<OffsetNode> {
    private static final Pattern<OffsetNode> PATTERN = Patterns.offset();

    @Override
    public Pattern<OffsetNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(OffsetNode parent, Captures captures, Rule.Context context) {
        Symbol rowNumberSymbol = context.getSymbolAllocator().newSymbol("row_number", (Type)BigintType.BIGINT);
        RowNumberNode rowNumberNode = new RowNumberNode(context.getIdAllocator().getNextId(), parent.getSource(), (List<Symbol>)ImmutableList.of(), true, rowNumberSymbol, Optional.empty(), Optional.empty());
        FilterNode filterNode = new FilterNode(context.getIdAllocator().getNextId(), rowNumberNode, new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, rowNumberSymbol.toSymbolReference(), new GenericLiteral((Type)BigintType.BIGINT, Long.toString(parent.getCount()))));
        ProjectNode projectNode = new ProjectNode(context.getIdAllocator().getNextId(), filterNode, Assignments.identity(parent.getOutputSymbols()));
        return Rule.Result.ofPlanNode(projectNode);
    }
}

