/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.trino.Session;
import io.trino.matching.Capture;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.spi.type.RowType;
import io.trino.sql.PlannerContext;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrUtils;
import io.trino.sql.ir.SubscriptExpression;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.ExpressionSymbolInliner;
import io.trino.sql.planner.IrTypeAnalyzer;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolsExtractor;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.ProjectNode;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class InlineProjections
implements Rule<ProjectNode> {
    private static final Capture<ProjectNode> CHILD = Capture.newCapture();
    private static final Pattern<ProjectNode> PATTERN = Patterns.project().with(Patterns.source().matching(Patterns.project().capturedAs(CHILD)));
    private final PlannerContext plannerContext;
    private final IrTypeAnalyzer typeAnalyzer;

    public InlineProjections(PlannerContext plannerContext, IrTypeAnalyzer typeAnalyzer) {
        this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
        this.typeAnalyzer = Objects.requireNonNull(typeAnalyzer, "typeAnalyzer is null");
    }

    @Override
    public Pattern<ProjectNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(ProjectNode parent, Captures captures, Rule.Context context) {
        ProjectNode child = (ProjectNode)captures.get(CHILD);
        return InlineProjections.inlineProjections(this.plannerContext, parent, child, context.getSession(), this.typeAnalyzer, context.getSymbolAllocator().getTypes()).map(Rule.Result::ofPlanNode).orElse(Rule.Result.empty());
    }

    static Optional<ProjectNode> inlineProjections(PlannerContext plannerContext, ProjectNode parent, ProjectNode child, Session session, IrTypeAnalyzer typeAnalyzer, TypeProvider types) {
        if (parent.isIdentity() && child.isIdentity()) {
            return Optional.of((ProjectNode)parent.replaceChildren((List<PlanNode>)ImmutableList.of((Object)child.getSource())));
        }
        Set<Symbol> targets = InlineProjections.extractInliningTargets(plannerContext, parent, child, session, typeAnalyzer, types);
        if (targets.isEmpty()) {
            return Optional.empty();
        }
        Assignments assignments = child.getAssignments().filter(targets::contains);
        Map<Symbol, Expression> parentAssignments = parent.getAssignments().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> InlineProjections.inlineReferences((Expression)entry.getValue(), assignments)));
        Set inputs = child.getAssignments().entrySet().stream().filter(entry -> targets.contains(entry.getKey())).map(Map.Entry::getValue).flatMap(entry -> SymbolsExtractor.extractAll(entry).stream()).collect(Collectors.toSet());
        Assignments.Builder newChildAssignmentsBuilder = Assignments.builder();
        for (Map.Entry<Symbol, Expression> assignment : child.getAssignments().entrySet()) {
            if (targets.contains(assignment.getKey())) continue;
            newChildAssignmentsBuilder.put(assignment);
            if (InlineProjections.isSymbolReference(assignment.getKey(), assignment.getValue())) continue;
            inputs.remove(assignment.getKey());
        }
        for (Symbol input : inputs) {
            newChildAssignmentsBuilder.putIdentity(input);
        }
        Assignments newChildAssignments = newChildAssignmentsBuilder.build();
        PlanNode newChild = newChildAssignments.isIdentity() ? child.getSource() : new ProjectNode(child.getId(), child.getSource(), newChildAssignments);
        return Optional.of(new ProjectNode(parent.getId(), newChild, Assignments.copyOf(parentAssignments)));
    }

    private static Expression inlineReferences(Expression expression, Assignments assignments) {
        Function<Symbol, Expression> mapping = symbol -> {
            Expression result = assignments.get((Symbol)symbol);
            if (result != null) {
                return result;
            }
            return symbol.toSymbolReference();
        };
        return ExpressionSymbolInliner.inlineSymbols(mapping, expression);
    }

    private static Set<Symbol> extractInliningTargets(PlannerContext plannerContext, ProjectNode parent, ProjectNode child, Session session, IrTypeAnalyzer typeAnalyzer, TypeProvider types) {
        ImmutableSet childOutputSet = ImmutableSet.copyOf(child.getOutputSymbols());
        Map dependencies = parent.getAssignments().getExpressions().stream().flatMap(expression -> SymbolsExtractor.extractAll(expression).stream()).filter(((Set)childOutputSet)::contains).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
        Set basicReferences = dependencies.keySet().stream().filter(input -> IrUtils.isEffectivelyLiteral(plannerContext, session, child.getAssignments().get((Symbol)input)) || child.getAssignments().get((Symbol)input) instanceof SymbolReference).filter(input -> !child.getAssignments().isIdentity((Symbol)input)).collect(Collectors.toSet());
        Set singletons = dependencies.entrySet().stream().filter(entry -> (Long)entry.getValue() == 1L).filter(entry -> !child.getAssignments().isIdentity((Symbol)entry.getKey())).filter(entry -> {
            Expression assignment = child.getAssignments().get((Symbol)entry.getKey());
            return !(assignment instanceof SubscriptExpression) || !(typeAnalyzer.getType(session, types, ((SubscriptExpression)assignment).getBase()) instanceof RowType);
        }).map(Map.Entry::getKey).collect(Collectors.toSet());
        return Sets.union(singletons, basicReferences);
    }

    private static boolean isSymbolReference(Symbol symbol, Expression expression) {
        return expression instanceof SymbolReference && ((SymbolReference)expression).getName().equals(symbol.getName());
    }
}

