/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import io.trino.sql.ir.ComparisonExpression;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.ExpressionRewriter;
import io.trino.sql.ir.ExpressionTreeRewriter;
import io.trino.sql.ir.InPredicate;
import io.trino.sql.ir.IrUtils;
import io.trino.sql.ir.LogicalExpression;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public final class NormalizeOrExpressionRewriter {
    public static Expression normalizeOrExpression(Expression expression) {
        return ExpressionTreeRewriter.rewriteWith(new Visitor(), expression);
    }

    private NormalizeOrExpressionRewriter() {
    }

    private static class Visitor
    extends ExpressionRewriter<Void> {
        private Visitor() {
        }

        @Override
        public Expression rewriteLogicalExpression(LogicalExpression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            List terms = (List)node.getTerms().stream().map(expression -> treeRewriter.rewrite(expression, context)).collect(ImmutableList.toImmutableList());
            if (node.getOperator() == LogicalExpression.Operator.AND) {
                return IrUtils.and(terms);
            }
            ImmutableList.Builder inPredicateBuilder = ImmutableList.builder();
            ImmutableSet.Builder expressionToSkipBuilder = ImmutableSet.builder();
            ImmutableList.Builder othersExpressionBuilder = ImmutableList.builder();
            this.groupComparisonAndInPredicate(terms).forEach((expression, values) -> {
                if (values.size() > 1) {
                    inPredicateBuilder.add((Object)new InPredicate((Expression)expression, this.mergeToInListExpression((Collection<Expression>)values)));
                    expressionToSkipBuilder.add(expression);
                }
            });
            ImmutableSet expressionToSkip = expressionToSkipBuilder.build();
            for (Expression expression2 : terms) {
                ComparisonExpression comparisonExpression;
                if (expression2 instanceof ComparisonExpression && (comparisonExpression = (ComparisonExpression)expression2).getOperator() == ComparisonExpression.Operator.EQUAL) {
                    if (expressionToSkip.contains(comparisonExpression.getLeft())) continue;
                    othersExpressionBuilder.add((Object)expression2);
                    continue;
                }
                if (expression2 instanceof InPredicate) {
                    InPredicate inPredicate = (InPredicate)expression2;
                    if (expressionToSkip.contains(inPredicate.getValue())) continue;
                    othersExpressionBuilder.add((Object)expression2);
                    continue;
                }
                othersExpressionBuilder.add((Object)expression2);
            }
            return IrUtils.or((Collection<Expression>)ImmutableList.builder().addAll((Iterable)othersExpressionBuilder.build()).addAll((Iterable)inPredicateBuilder.build()).build());
        }

        private List<Expression> mergeToInListExpression(Collection<Expression> expressions) {
            LinkedHashSet<Expression> expressionValues = new LinkedHashSet<Expression>();
            for (Expression expression : expressions) {
                ComparisonExpression comparisonExpression;
                if (expression instanceof ComparisonExpression && (comparisonExpression = (ComparisonExpression)expression).getOperator() == ComparisonExpression.Operator.EQUAL) {
                    expressionValues.add(comparisonExpression.getRight());
                    continue;
                }
                if (expression instanceof InPredicate) {
                    InPredicate inPredicate = (InPredicate)expression;
                    expressionValues.addAll(inPredicate.getValueList());
                    continue;
                }
                throw new IllegalStateException("Unexpected expression: " + String.valueOf(expression));
            }
            return ImmutableList.copyOf(expressionValues);
        }

        private Map<Expression, Collection<Expression>> groupComparisonAndInPredicate(List<Expression> terms) {
            ImmutableMultimap.Builder expressionBuilder = ImmutableMultimap.builder();
            for (Expression expression : terms) {
                ComparisonExpression comparisonExpression;
                if (expression instanceof ComparisonExpression && (comparisonExpression = (ComparisonExpression)expression).getOperator() == ComparisonExpression.Operator.EQUAL) {
                    expressionBuilder.put((Object)comparisonExpression.getLeft(), (Object)comparisonExpression);
                    continue;
                }
                if (!(expression instanceof InPredicate)) continue;
                InPredicate inPredicate = (InPredicate)expression;
                expressionBuilder.put((Object)inPredicate.getValue(), (Object)inPredicate);
            }
            return expressionBuilder.build().asMap();
        }
    }
}

