/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.matching.Capture;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.SubscriptExpression;
import io.trino.sql.planner.ExpressionNodeInliner;
import io.trino.sql.planner.IrTypeAnalyzer;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.DereferencePushdown;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.ProjectNode;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class PushDownDereferenceThroughFilter
implements Rule<ProjectNode> {
    private static final Capture<FilterNode> CHILD = Capture.newCapture();
    private final IrTypeAnalyzer typeAnalyzer;

    public PushDownDereferenceThroughFilter(IrTypeAnalyzer typeAnalyzer) {
        this.typeAnalyzer = Objects.requireNonNull(typeAnalyzer, "typeAnalyzer is null");
    }

    @Override
    public Pattern<ProjectNode> getPattern() {
        return Patterns.project().with(Patterns.source().matching(Patterns.filter().capturedAs(CHILD)));
    }

    @Override
    public Rule.Result apply(ProjectNode node, Captures captures, Rule.Context context) {
        FilterNode filterNode = (FilterNode)captures.get(CHILD);
        ImmutableList expressions = ImmutableList.builder().addAll(node.getAssignments().getExpressions()).add((Object)filterNode.getPredicate()).build();
        Set<SubscriptExpression> dereferences = DereferencePushdown.extractRowSubscripts((Collection<Expression>)expressions, false, context.getSession(), this.typeAnalyzer, context.getSymbolAllocator().getTypes());
        if (dereferences.isEmpty()) {
            return Rule.Result.empty();
        }
        Assignments dereferenceAssignments = Assignments.of(dereferences, context.getSession(), context.getSymbolAllocator(), this.typeAnalyzer);
        Map mappings = (Map)HashBiMap.create(dereferenceAssignments.getMap()).inverse().entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((Symbol)entry.getValue()).toSymbolReference()));
        Assignments assignments = node.getAssignments().rewrite(expression -> ExpressionNodeInliner.replaceExpression(expression, mappings));
        PlanNode source = filterNode.getSource();
        return Rule.Result.ofPlanNode(new ProjectNode(context.getIdAllocator().getNextId(), new FilterNode(context.getIdAllocator().getNextId(), new ProjectNode(context.getIdAllocator().getNextId(), source, Assignments.builder().putIdentities(source.getOutputSymbols()).putAll(dereferenceAssignments).build()), ExpressionNodeInliner.replaceExpression(filterNode.getPredicate(), mappings)), assignments));
    }
}

