/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.matching.Capture;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.sql.planner.ExpressionNodeInliner;
import io.trino.sql.planner.IrTypeAnalyzer;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.DereferencePushdown;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.sql.planner.plan.SortNode;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class PushDownDereferencesThroughSort
implements Rule<ProjectNode> {
    private static final Capture<SortNode> CHILD = Capture.newCapture();
    private final IrTypeAnalyzer typeAnalyzer;

    public PushDownDereferencesThroughSort(IrTypeAnalyzer typeAnalyzer) {
        this.typeAnalyzer = Objects.requireNonNull(typeAnalyzer, "typeAnalyzer is null");
    }

    @Override
    public Pattern<ProjectNode> getPattern() {
        return Patterns.project().with(Patterns.source().matching(Patterns.sort().capturedAs(CHILD)));
    }

    @Override
    public Rule.Result apply(ProjectNode projectNode, Captures captures, Rule.Context context) {
        SortNode sortNode = (SortNode)captures.get(CHILD);
        Set dereferences = DereferencePushdown.extractRowSubscripts(projectNode.getAssignments().getExpressions(), false, context.getSession(), this.typeAnalyzer, context.getSymbolAllocator().getTypes());
        if ((dereferences = (Set)dereferences.stream().filter(expression -> !sortNode.getOrderingScheme().getOrderBy().contains(DereferencePushdown.getBase(expression))).collect(ImmutableSet.toImmutableSet())).isEmpty()) {
            return Rule.Result.empty();
        }
        Assignments dereferenceAssignments = Assignments.of(dereferences, context.getSession(), context.getSymbolAllocator(), this.typeAnalyzer);
        Map mappings = (Map)HashBiMap.create(dereferenceAssignments.getMap()).inverse().entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((Symbol)entry.getValue()).toSymbolReference()));
        Assignments newAssignments = projectNode.getAssignments().rewrite(expression -> ExpressionNodeInliner.replaceExpression(expression, mappings));
        return Rule.Result.ofPlanNode(new ProjectNode(context.getIdAllocator().getNextId(), sortNode.replaceChildren((List<PlanNode>)ImmutableList.of((Object)new ProjectNode(context.getIdAllocator().getNextId(), sortNode.getSource(), Assignments.builder().putIdentities(sortNode.getSource().getOutputSymbols()).putAll(dereferenceAssignments).build()))), newAssignments));
    }
}

