/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.metadata.Metadata;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.ComparisonExpression;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.ExpressionRewriter;
import io.trino.sql.ir.ExpressionTreeRewriter;
import io.trino.sql.ir.IrUtils;
import io.trino.sql.ir.LogicalExpression;
import io.trino.sql.ir.NodeRef;
import io.trino.sql.ir.NotExpression;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class PushDownNegationsExpressionRewriter {
    public static Expression pushDownNegations(Metadata metadata, Expression expression, Map<NodeRef<Expression>, Type> expressionTypes) {
        return ExpressionTreeRewriter.rewriteWith(new Visitor(metadata, expressionTypes), expression);
    }

    private PushDownNegationsExpressionRewriter() {
    }

    private static class Visitor
    extends ExpressionRewriter<Void> {
        private final Metadata metadata;
        private final Map<NodeRef<Expression>, Type> expressionTypes;

        public Visitor(Metadata metadata, Map<NodeRef<Expression>, Type> expressionTypes) {
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
            this.expressionTypes = ImmutableMap.copyOf(Objects.requireNonNull(expressionTypes, "expressionTypes is null"));
        }

        @Override
        public Expression rewriteNotExpression(NotExpression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            Expression child;
            Object predicates;
            Expression expression = node.getValue();
            if (expression instanceof LogicalExpression) {
                LogicalExpression child2 = (LogicalExpression)expression;
                predicates = IrUtils.extractPredicates(child2);
                List negatedPredicates = (List)predicates.stream().map(predicate -> treeRewriter.rewrite(new NotExpression((Expression)predicate), context)).collect(ImmutableList.toImmutableList());
                return IrUtils.combinePredicates(this.metadata, child2.getOperator().flip(), negatedPredicates);
            }
            predicates = node.getValue();
            if (predicates instanceof ComparisonExpression && ((ComparisonExpression)(child = (ComparisonExpression)predicates)).getOperator() != ComparisonExpression.Operator.IS_DISTINCT_FROM) {
                ComparisonExpression.Operator operator = ((ComparisonExpression)child).getOperator();
                Expression left = ((ComparisonExpression)child).getLeft();
                Expression right = ((ComparisonExpression)child).getRight();
                Type leftType = this.expressionTypes.get(NodeRef.of(left));
                Type rightType = this.expressionTypes.get(NodeRef.of(right));
                Preconditions.checkState((leftType != null && rightType != null ? 1 : 0) != 0, (Object)"missing type for expression");
                if ((this.typeHasNaN(leftType) || this.typeHasNaN(rightType)) && (operator == ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL || operator == ComparisonExpression.Operator.GREATER_THAN || operator == ComparisonExpression.Operator.LESS_THAN_OR_EQUAL || operator == ComparisonExpression.Operator.LESS_THAN)) {
                    return new NotExpression(new ComparisonExpression(operator, treeRewriter.rewrite(left, context), treeRewriter.rewrite(right, context)));
                }
                return new ComparisonExpression(operator.negate(), treeRewriter.rewrite(left, context), treeRewriter.rewrite(right, context));
            }
            expression = node.getValue();
            if (expression instanceof NotExpression) {
                child = (NotExpression)expression;
                return treeRewriter.rewrite(((NotExpression)child).getValue(), context);
            }
            return new NotExpression(treeRewriter.rewrite(node.getValue(), context));
        }

        private boolean typeHasNaN(Type type) {
            return type instanceof DoubleType || type instanceof RealType;
        }
    }
}

