/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.trino.matching.Capture;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.IrTypeAnalyzer;
import io.trino.sql.planner.OrderingScheme;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.DereferencePushdown;
import io.trino.sql.planner.iterative.rule.Util;
import io.trino.sql.planner.optimizations.SymbolMapper;
import io.trino.sql.planner.plan.LimitNode;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.ProjectNode;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class PushLimitThroughProject
implements Rule<LimitNode> {
    private static final Capture<ProjectNode> CHILD = Capture.newCapture();
    private static final Pattern<LimitNode> PATTERN = Patterns.limit().with(Patterns.source().matching(Patterns.project().matching(projectNode -> !projectNode.isIdentity()).capturedAs(CHILD)));
    private final IrTypeAnalyzer typeAnalyzer;

    public PushLimitThroughProject(IrTypeAnalyzer typeAnalyzer) {
        this.typeAnalyzer = Objects.requireNonNull(typeAnalyzer, "typeAnalyzer is null");
    }

    @Override
    public Pattern<LimitNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(LimitNode parent, Captures captures, Rule.Context context) {
        ProjectNode projectNode = (ProjectNode)captures.get(CHILD);
        ImmutableSet projections = ImmutableSet.copyOf(projectNode.getAssignments().getExpressions());
        if (!DereferencePushdown.extractRowSubscripts((Collection<Expression>)projections, false, context.getSession(), this.typeAnalyzer, context.getSymbolAllocator().getTypes()).isEmpty() && DereferencePushdown.exclusiveDereferences((Set<Expression>)projections, context.getSession(), this.typeAnalyzer, context.getSymbolAllocator().getTypes())) {
            return Rule.Result.empty();
        }
        if (!parent.isWithTies() && !parent.requiresPreSortedInputs()) {
            return Rule.Result.ofPlanNode(Util.transpose(parent, projectNode));
        }
        SymbolMapper.Builder symbolMapper = SymbolMapper.builder();
        ImmutableSet symbolsForRewrite = ImmutableSet.builder().addAll(parent.getPreSortedInputs()).addAll((Iterable)parent.getTiesResolvingScheme().map(OrderingScheme::getOrderBy).orElse((List)ImmutableList.of())).build();
        for (Symbol symbol : symbolsForRewrite) {
            Expression expression = projectNode.getAssignments().get(symbol);
            if (!(expression instanceof SymbolReference)) {
                return Rule.Result.empty();
            }
            symbolMapper.put(symbol, Symbol.from(expression));
        }
        LimitNode mappedLimitNode = symbolMapper.build().map(parent, projectNode.getSource());
        return Rule.Result.ofPlanNode(projectNode.replaceChildren((List<PlanNode>)ImmutableList.of((Object)mappedLimitNode)));
    }
}

