/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.trino.matching.Capture;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.Range;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.predicate.ValueSet;
import io.trino.spi.type.Type;
import io.trino.sql.PlannerContext;
import io.trino.sql.ir.BooleanLiteral;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrUtils;
import io.trino.sql.planner.DomainTranslator;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.sql.planner.plan.RowNumberNode;
import io.trino.sql.planner.plan.ValuesNode;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;

public class PushPredicateThroughProjectIntoRowNumber
implements Rule<FilterNode> {
    private static final Capture<ProjectNode> PROJECT = Capture.newCapture();
    private static final Capture<RowNumberNode> ROW_NUMBER = Capture.newCapture();
    private static final Pattern<FilterNode> PATTERN = Patterns.filter().with(Patterns.source().matching(Patterns.project().matching(ProjectNode::isIdentity).capturedAs(PROJECT).with(Patterns.source().matching(Patterns.rowNumber().capturedAs(ROW_NUMBER)))));
    private final PlannerContext plannerContext;

    public PushPredicateThroughProjectIntoRowNumber(PlannerContext plannerContext) {
        this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
    }

    @Override
    public Pattern<FilterNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(FilterNode filter, Captures captures, Rule.Context context) {
        ProjectNode project = (ProjectNode)captures.get(PROJECT);
        RowNumberNode rowNumber = (RowNumberNode)captures.get(ROW_NUMBER);
        Symbol rowNumberSymbol = rowNumber.getRowNumberSymbol();
        if (!project.getAssignments().getSymbols().contains(rowNumberSymbol)) {
            return Rule.Result.empty();
        }
        DomainTranslator.ExtractionResult extractionResult = DomainTranslator.getExtractionResult(this.plannerContext, context.getSession(), filter.getPredicate(), context.getSymbolAllocator().getTypes());
        TupleDomain<Symbol> tupleDomain = extractionResult.getTupleDomain();
        OptionalInt upperBound = PushPredicateThroughProjectIntoRowNumber.extractUpperBound(tupleDomain, rowNumberSymbol);
        if (upperBound.isEmpty()) {
            return Rule.Result.empty();
        }
        if (upperBound.getAsInt() <= 0) {
            return Rule.Result.ofPlanNode(new ValuesNode(filter.getId(), filter.getOutputSymbols(), (List<Expression>)ImmutableList.of()));
        }
        boolean updatedMaxRowCountPerPartition = false;
        if (rowNumber.getMaxRowCountPerPartition().isEmpty() || rowNumber.getMaxRowCountPerPartition().get() > upperBound.getAsInt()) {
            rowNumber = new RowNumberNode(rowNumber.getId(), rowNumber.getSource(), rowNumber.getPartitionBy(), rowNumber.isOrderSensitive(), rowNumber.getRowNumberSymbol(), Optional.of(upperBound.getAsInt()), rowNumber.getHashSymbol());
            project = (ProjectNode)project.replaceChildren((List<PlanNode>)ImmutableList.of((Object)rowNumber));
            updatedMaxRowCountPerPartition = true;
        }
        if (!PushPredicateThroughProjectIntoRowNumber.allRowNumberValuesInDomain(tupleDomain, rowNumberSymbol, rowNumber.getMaxRowCountPerPartition().get().intValue())) {
            if (updatedMaxRowCountPerPartition) {
                return Rule.Result.ofPlanNode(filter.replaceChildren((List<PlanNode>)ImmutableList.of((Object)project)));
            }
            return Rule.Result.empty();
        }
        TupleDomain newTupleDomain = tupleDomain.filter((symbol, domain) -> !symbol.equals(rowNumberSymbol));
        Expression newPredicate = IrUtils.combineConjuncts(this.plannerContext.getMetadata(), extractionResult.getRemainingExpression(), new DomainTranslator(this.plannerContext).toPredicate((TupleDomain<Symbol>)newTupleDomain));
        if (newPredicate.equals(BooleanLiteral.TRUE_LITERAL)) {
            return Rule.Result.ofPlanNode(project);
        }
        return Rule.Result.ofPlanNode(new FilterNode(filter.getId(), project, newPredicate));
    }

    private static OptionalInt extractUpperBound(TupleDomain<Symbol> tupleDomain, Symbol symbol) {
        if (tupleDomain.isNone()) {
            return OptionalInt.empty();
        }
        Domain rowNumberDomain = (Domain)((Map)tupleDomain.getDomains().get()).get(symbol);
        if (rowNumberDomain == null) {
            return OptionalInt.empty();
        }
        ValueSet values = rowNumberDomain.getValues();
        if (values.isAll() || values.isNone() || values.getRanges().getRangeCount() <= 0) {
            return OptionalInt.empty();
        }
        Range span = values.getRanges().getSpan();
        if (span.isHighUnbounded()) {
            return OptionalInt.empty();
        }
        long upperBound = (Long)span.getHighBoundedValue();
        if (!span.isHighInclusive()) {
            --upperBound;
        }
        if (upperBound >= Integer.MIN_VALUE && upperBound <= Integer.MAX_VALUE) {
            return OptionalInt.of(Math.toIntExact(upperBound));
        }
        return OptionalInt.empty();
    }

    private static boolean allRowNumberValuesInDomain(TupleDomain<Symbol> tupleDomain, Symbol symbol, long upperBound) {
        if (tupleDomain.isNone()) {
            return false;
        }
        Domain domain = (Domain)((Map)tupleDomain.getDomains().get()).get(symbol);
        if (domain == null) {
            return true;
        }
        return domain.getValues().contains(ValueSet.ofRanges((Range)Range.range((Type)domain.getType(), (Object)0L, (boolean)true, (Object)upperBound, (boolean)true), (Range[])new Range[0]));
    }
}

