/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.trino.Session;
import io.trino.SystemSessionProperties;
import io.trino.matching.Capture;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.Range;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.predicate.ValueSet;
import io.trino.spi.type.Type;
import io.trino.sql.PlannerContext;
import io.trino.sql.ir.BooleanLiteral;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrUtils;
import io.trino.sql.planner.DomainTranslator;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.Util;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.sql.planner.plan.TopNRankingNode;
import io.trino.sql.planner.plan.ValuesNode;
import io.trino.sql.planner.plan.WindowNode;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;

public class PushPredicateThroughProjectIntoWindow
implements Rule<FilterNode> {
    private static final Capture<ProjectNode> PROJECT = Capture.newCapture();
    private static final Capture<WindowNode> WINDOW = Capture.newCapture();
    private final PlannerContext plannerContext;
    private final Pattern<FilterNode> pattern;

    public PushPredicateThroughProjectIntoWindow(PlannerContext plannerContext) {
        this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
        this.pattern = Patterns.filter().with(Patterns.source().matching(Patterns.project().matching(ProjectNode::isIdentity).capturedAs(PROJECT).with(Patterns.source().matching(Patterns.window().matching(window -> Util.toTopNRankingType(window).isPresent()).capturedAs(WINDOW)))));
    }

    @Override
    public Pattern<FilterNode> getPattern() {
        return this.pattern;
    }

    @Override
    public boolean isEnabled(Session session) {
        return SystemSessionProperties.isOptimizeTopNRanking(session);
    }

    @Override
    public Rule.Result apply(FilterNode filter, Captures captures, Rule.Context context) {
        ProjectNode project = (ProjectNode)captures.get(PROJECT);
        WindowNode window = (WindowNode)captures.get(WINDOW);
        Symbol rankingSymbol = (Symbol)Iterables.getOnlyElement(window.getWindowFunctions().keySet());
        if (!project.getAssignments().getSymbols().contains(rankingSymbol)) {
            return Rule.Result.empty();
        }
        DomainTranslator.ExtractionResult extractionResult = DomainTranslator.getExtractionResult(this.plannerContext, context.getSession(), filter.getPredicate(), context.getSymbolAllocator().getTypes());
        TupleDomain<Symbol> tupleDomain = extractionResult.getTupleDomain();
        OptionalInt upperBound = PushPredicateThroughProjectIntoWindow.extractUpperBound(tupleDomain, rankingSymbol);
        if (upperBound.isEmpty()) {
            return Rule.Result.empty();
        }
        if (upperBound.getAsInt() <= 0) {
            return Rule.Result.ofPlanNode(new ValuesNode(filter.getId(), filter.getOutputSymbols(), (List<Expression>)ImmutableList.of()));
        }
        TopNRankingNode.RankingType rankingType = Util.toTopNRankingType(window).orElseThrow();
        project = (ProjectNode)project.replaceChildren((List<PlanNode>)ImmutableList.of((Object)new TopNRankingNode(window.getId(), window.getSource(), window.getSpecification(), rankingType, rankingSymbol, upperBound.getAsInt(), false, Optional.empty())));
        if (!PushPredicateThroughProjectIntoWindow.allRankingValuesInDomain(tupleDomain, rankingSymbol, upperBound.getAsInt())) {
            return Rule.Result.ofPlanNode(filter.replaceChildren((List<PlanNode>)ImmutableList.of((Object)project)));
        }
        TupleDomain newTupleDomain = tupleDomain.filter((symbol, domain) -> !symbol.equals(rankingSymbol));
        Expression newPredicate = IrUtils.combineConjuncts(this.plannerContext.getMetadata(), extractionResult.getRemainingExpression(), new DomainTranslator(this.plannerContext).toPredicate((TupleDomain<Symbol>)newTupleDomain));
        if (newPredicate.equals(BooleanLiteral.TRUE_LITERAL)) {
            return Rule.Result.ofPlanNode(project);
        }
        return Rule.Result.ofPlanNode(new FilterNode(filter.getId(), project, newPredicate));
    }

    private static OptionalInt extractUpperBound(TupleDomain<Symbol> tupleDomain, Symbol symbol) {
        if (tupleDomain.isNone()) {
            return OptionalInt.empty();
        }
        Domain rankingDomain = (Domain)((Map)tupleDomain.getDomains().get()).get(symbol);
        if (rankingDomain == null) {
            return OptionalInt.empty();
        }
        ValueSet values = rankingDomain.getValues();
        if (values.isAll() || values.isNone() || values.getRanges().getRangeCount() <= 0) {
            return OptionalInt.empty();
        }
        Range span = values.getRanges().getSpan();
        if (span.isHighUnbounded()) {
            return OptionalInt.empty();
        }
        long upperBound = (Long)span.getHighBoundedValue();
        if (!span.isHighInclusive()) {
            --upperBound;
        }
        if (upperBound >= Integer.MIN_VALUE && upperBound <= Integer.MAX_VALUE) {
            return OptionalInt.of(Math.toIntExact(upperBound));
        }
        return OptionalInt.empty();
    }

    private static boolean allRankingValuesInDomain(TupleDomain<Symbol> tupleDomain, Symbol symbol, long upperBound) {
        if (tupleDomain.isNone()) {
            return false;
        }
        Domain domain = (Domain)((Map)tupleDomain.getDomains().get()).get(symbol);
        if (domain == null) {
            return true;
        }
        return domain.getValues().contains(ValueSet.ofRanges((Range)Range.range((Type)domain.getType(), (Object)0L, (boolean)true, (Object)upperBound, (boolean)true), (Range[])new Range[0]));
    }
}

