/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.NullLiteral;
import io.trino.sql.ir.Row;
import io.trino.sql.planner.iterative.Lookup;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.plan.ExchangeNode;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.TableExecuteNode;
import io.trino.sql.planner.plan.TableFinishNode;
import io.trino.sql.planner.plan.ValuesNode;
import java.util.List;
import java.util.Optional;

public class RemoveEmptyTableExecute
implements Rule<TableFinishNode> {
    private static final Pattern<TableFinishNode> PATTERN = Patterns.tableFinish();

    private static Pattern<ValuesNode> emptyValues() {
        return Patterns.values().with(Patterns.Values.rowCount().equalTo((Object)0));
    }

    @Override
    public Pattern<TableFinishNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(TableFinishNode finishNode, Captures captures, Rule.Context context) {
        PlanNode planNode;
        Optional<PlanNode> finishSource = this.getSingleSourceSkipExchange(finishNode, context.getLookup());
        if (finishSource.isEmpty() || !(finishSource.get() instanceof TableExecuteNode)) {
            return Rule.Result.empty();
        }
        Optional<PlanNode> tableExecuteSource = this.getSingleSourceSkipExchange(finishSource.get(), context.getLookup());
        if (tableExecuteSource.isEmpty() || !((planNode = tableExecuteSource.get()) instanceof ValuesNode)) {
            return Rule.Result.empty();
        }
        ValuesNode valuesNode = (ValuesNode)planNode;
        Verify.verify((valuesNode.getRowCount() == 0 ? 1 : 0) != 0, (String)"Unexpected non-empty Values as source of TableExecuteNode", (Object[])new Object[0]);
        return Rule.Result.ofPlanNode(new ValuesNode(finishNode.getId(), finishNode.getOutputSymbols(), (List<Expression>)ImmutableList.of((Object)new Row((List<Expression>)ImmutableList.of((Object)new Cast(new NullLiteral(), (Type)BigintType.BIGINT))))));
    }

    private Optional<PlanNode> getSingleSourceSkipExchange(PlanNode node, Lookup lookup) {
        if (node.getSources().size() != 1) {
            return Optional.empty();
        }
        PlanNode source = lookup.resolve(node.getSources().get(0));
        if (source instanceof ExchangeNode) {
            if (source.getSources().size() != 1) {
                return Optional.empty();
            }
            PlanNode exchangeSource = lookup.resolve(source.getSources().get(0));
            return Optional.of(lookup.resolve(exchangeSource));
        }
        return Optional.of(source);
    }
}

