/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.sql.ir.Expression;
import io.trino.sql.planner.iterative.Lookup;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.optimizations.QueryCardinalityUtil;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.JoinType;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.ValuesNode;
import java.util.List;

public class RemoveRedundantJoin
implements Rule<JoinNode> {
    private static final Pattern<JoinNode> PATTERN = Patterns.join();

    @Override
    public Pattern<JoinNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(JoinNode node, Captures captures, Rule.Context context) {
        if (this.canRemoveJoin(node, context.getLookup())) {
            return Rule.Result.ofPlanNode(new ValuesNode(context.getIdAllocator().getNextId(), node.getOutputSymbols(), (List<Expression>)ImmutableList.of()));
        }
        return Rule.Result.empty();
    }

    private boolean canRemoveJoin(JoinNode joinNode, Lookup lookup) {
        PlanNode left = joinNode.getLeft();
        PlanNode right = joinNode.getRight();
        return switch (joinNode.getType()) {
            default -> throw new MatchException(null, null);
            case JoinType.INNER -> {
                if (QueryCardinalityUtil.isEmpty(left, lookup) || QueryCardinalityUtil.isEmpty(right, lookup)) {
                    yield true;
                }
                yield false;
            }
            case JoinType.LEFT -> QueryCardinalityUtil.isEmpty(left, lookup);
            case JoinType.RIGHT -> QueryCardinalityUtil.isEmpty(right, lookup);
            case JoinType.FULL -> QueryCardinalityUtil.isEmpty(left, lookup) && QueryCardinalityUtil.isEmpty(right, lookup);
        };
    }
}

