/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.base.Preconditions;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.sql.ir.BooleanLiteral;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.NullLiteral;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.ValuesNode;
import java.util.Collections;

public class RemoveTrivialFilters
implements Rule<FilterNode> {
    private static final Pattern<FilterNode> PATTERN = Patterns.filter();

    @Override
    public Pattern<FilterNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(FilterNode filterNode, Captures captures, Rule.Context context) {
        Cast cast;
        Expression predicate = filterNode.getPredicate();
        Preconditions.checkArgument((!(predicate instanceof NullLiteral) ? 1 : 0) != 0, (Object)"Unexpected null literal without a cast to boolean");
        if (predicate.equals(BooleanLiteral.TRUE_LITERAL)) {
            return Rule.Result.ofPlanNode(filterNode.getSource());
        }
        if (predicate.equals(BooleanLiteral.FALSE_LITERAL) || predicate instanceof Cast && (cast = (Cast)predicate).getExpression() instanceof NullLiteral) {
            return Rule.Result.ofPlanNode(new ValuesNode(context.getIdAllocator().getNextId(), filterNode.getOutputSymbols(), Collections.emptyList()));
        }
        return Rule.Result.empty();
    }
}

