/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableSet;
import io.trino.Session;
import io.trino.spi.type.Type;
import io.trino.sql.PlannerContext;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.NodeRef;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.IrExpressionInterpreter;
import io.trino.sql.planner.IrTypeAnalyzer;
import io.trino.sql.planner.LiteralEncoder;
import io.trino.sql.planner.NoOpSymbolResolver;
import io.trino.sql.planner.SymbolAllocator;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.ExpressionRewriteRuleSet;
import io.trino.sql.planner.iterative.rule.ExtractCommonPredicatesExpressionRewriter;
import io.trino.sql.planner.iterative.rule.NormalizeOrExpressionRewriter;
import io.trino.sql.planner.iterative.rule.PushDownNegationsExpressionRewriter;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class SimplifyExpressions
extends ExpressionRewriteRuleSet {
    public static Expression rewrite(Expression expression, Session session, SymbolAllocator symbolAllocator, PlannerContext plannerContext, IrTypeAnalyzer typeAnalyzer) {
        Objects.requireNonNull(plannerContext, "plannerContext is null");
        Objects.requireNonNull(typeAnalyzer, "typeAnalyzer is null");
        if (expression instanceof SymbolReference) {
            return expression;
        }
        Map<NodeRef<Expression>, Type> expressionTypes = typeAnalyzer.getTypes(session, symbolAllocator.getTypes(), expression);
        expression = PushDownNegationsExpressionRewriter.pushDownNegations(plannerContext.getMetadata(), expression, expressionTypes);
        expression = ExtractCommonPredicatesExpressionRewriter.extractCommonPredicates(plannerContext.getMetadata(), expression);
        expression = NormalizeOrExpressionRewriter.normalizeOrExpression(expression);
        expressionTypes = typeAnalyzer.getTypes(session, symbolAllocator.getTypes(), expression);
        IrExpressionInterpreter interpreter = new IrExpressionInterpreter(expression, plannerContext, session, expressionTypes);
        Object optimized = interpreter.optimize(NoOpSymbolResolver.INSTANCE);
        return new LiteralEncoder(plannerContext).toExpression(optimized, expressionTypes.get(NodeRef.of(expression)));
    }

    public SimplifyExpressions(PlannerContext plannerContext, IrTypeAnalyzer typeAnalyzer) {
        super(SimplifyExpressions.createRewrite(plannerContext, typeAnalyzer));
    }

    @Override
    public Set<Rule<?>> rules() {
        return ImmutableSet.of(this.projectExpressionRewrite(), this.filterExpressionRewrite(), this.joinExpressionRewrite(), this.valuesExpressionRewrite(), this.patternRecognitionExpressionRewrite());
    }

    private static ExpressionRewriteRuleSet.ExpressionRewriter createRewrite(PlannerContext plannerContext, IrTypeAnalyzer typeAnalyzer) {
        Objects.requireNonNull(plannerContext, "plannerContext is null");
        Objects.requireNonNull(typeAnalyzer, "typeAnalyzer is null");
        return (expression, context) -> SimplifyExpressions.rewrite(expression, context.getSession(), context.getSymbolAllocator(), plannerContext, typeAnalyzer);
    }
}

