/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.trino.Session;
import io.trino.metadata.GlobalFunctionCatalog;
import io.trino.metadata.ResolvedFunction;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.LongTimestamp;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.sql.PlannerContext;
import io.trino.sql.ir.BetweenPredicate;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.ComparisonExpression;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.ExpressionRewriter;
import io.trino.sql.ir.ExpressionTreeRewriter;
import io.trino.sql.ir.FunctionCall;
import io.trino.sql.ir.InPredicate;
import io.trino.sql.ir.IrUtils;
import io.trino.sql.ir.IsNotNullPredicate;
import io.trino.sql.ir.IsNullPredicate;
import io.trino.sql.ir.NodeRef;
import io.trino.sql.ir.NotExpression;
import io.trino.sql.ir.NullLiteral;
import io.trino.sql.planner.IrExpressionInterpreter;
import io.trino.sql.planner.IrTypeAnalyzer;
import io.trino.sql.planner.LiteralEncoder;
import io.trino.sql.planner.NoOpSymbolResolver;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.planner.iterative.rule.ExpressionRewriteRuleSet;
import io.trino.type.DateTimes;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.temporal.TemporalAdjusters;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;

public class UnwrapYearInComparison
extends ExpressionRewriteRuleSet {
    public UnwrapYearInComparison(PlannerContext plannerContext, IrTypeAnalyzer typeAnalyzer) {
        super(UnwrapYearInComparison.createRewrite(plannerContext, typeAnalyzer));
    }

    private static ExpressionRewriteRuleSet.ExpressionRewriter createRewrite(PlannerContext plannerContext, IrTypeAnalyzer typeAnalyzer) {
        Objects.requireNonNull(plannerContext, "plannerContext is null");
        Objects.requireNonNull(typeAnalyzer, "typeAnalyzer is null");
        return (expression, context) -> UnwrapYearInComparison.unwrapYear(context.getSession(), plannerContext, typeAnalyzer, context.getSymbolAllocator().getTypes(), expression);
    }

    private static Expression unwrapYear(Session session, PlannerContext plannerContext, IrTypeAnalyzer typeAnalyzer, TypeProvider types, Expression expression) {
        return ExpressionTreeRewriter.rewriteWith(new Visitor(plannerContext, typeAnalyzer, session, types), expression);
    }

    private static Object calculateRangeStartInclusive(int year, Type type) {
        if (type == DateType.DATE) {
            LocalDate firstDay = LocalDate.ofYearDay(year, 1);
            return firstDay.toEpochDay();
        }
        if (type instanceof TimestampType) {
            TimestampType timestampType = (TimestampType)type;
            long yearStartEpochSecond = LocalDateTime.of(year, 1, 1, 0, 0).toEpochSecond(ZoneOffset.UTC);
            long yearStartEpochMicros = Math.multiplyExact(yearStartEpochSecond, 1000000);
            if (timestampType.isShort()) {
                return yearStartEpochMicros;
            }
            return new LongTimestamp(yearStartEpochMicros, 0);
        }
        throw new UnsupportedOperationException("Unsupported type: " + String.valueOf(type));
    }

    @VisibleForTesting
    public static Object calculateRangeEndInclusive(int year, Type type) {
        if (type == DateType.DATE) {
            LocalDate lastDay = LocalDate.ofYearDay(year, 1).with(TemporalAdjusters.lastDayOfYear());
            return lastDay.toEpochDay();
        }
        if (type instanceof TimestampType) {
            TimestampType timestampType = (TimestampType)type;
            long nextYearStartEpochSecond = LocalDateTime.of(year + 1, 1, 1, 0, 0).toEpochSecond(ZoneOffset.UTC);
            long nextYearStartEpochMicros = Math.multiplyExact(nextYearStartEpochSecond, 1000000);
            if (timestampType.isShort()) {
                return nextYearStartEpochMicros - DateTimes.scaleFactor(timestampType.getPrecision(), 6);
            }
            int picosOfMicro = Math.toIntExact(1000000L - DateTimes.scaleFactor(timestampType.getPrecision(), 12));
            return new LongTimestamp(nextYearStartEpochMicros - 1L, picosOfMicro);
        }
        throw new UnsupportedOperationException("Unsupported type: " + String.valueOf(type));
    }

    private static class Visitor
    extends ExpressionRewriter<Void> {
        private final PlannerContext plannerContext;
        private final IrTypeAnalyzer typeAnalyzer;
        private final Session session;
        private final TypeProvider types;
        private final LiteralEncoder literalEncoder;

        public Visitor(PlannerContext plannerContext, IrTypeAnalyzer typeAnalyzer, Session session, TypeProvider types) {
            this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
            this.typeAnalyzer = Objects.requireNonNull(typeAnalyzer, "typeAnalyzer is null");
            this.session = Objects.requireNonNull(session, "session is null");
            this.types = Objects.requireNonNull(types, "types is null");
            this.literalEncoder = new LiteralEncoder(plannerContext);
        }

        @Override
        public Expression rewriteComparisonExpression(ComparisonExpression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            ComparisonExpression expression = treeRewriter.defaultRewrite(node, null);
            return this.unwrapYear(expression);
        }

        @Override
        public Expression rewriteInPredicate(InPredicate node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            FunctionCall call;
            InPredicate inPredicate = treeRewriter.defaultRewrite(node, null);
            Expression value = inPredicate.getValue();
            if (!(value instanceof FunctionCall) || !ResolvedFunction.extractFunctionName((call = (FunctionCall)value).getName()).equals((Object)GlobalFunctionCatalog.builtinFunctionName("year")) || call.getArguments().size() != 1) {
                return inPredicate;
            }
            ImmutableList.Builder comparisonExpressions = ImmutableList.builderWithExpectedSize((int)node.getValueList().size());
            for (Expression rightExpression : node.getValueList()) {
                ComparisonExpression comparisonExpression = new ComparisonExpression(ComparisonExpression.Operator.EQUAL, value, rightExpression);
                Expression unwrappedExpression = this.unwrapYear(comparisonExpression);
                if (unwrappedExpression == comparisonExpression) {
                    return inPredicate;
                }
                comparisonExpressions.add((Object)unwrappedExpression);
            }
            return IrUtils.or((Collection<Expression>)comparisonExpressions.build());
        }

        private Expression unwrapYear(ComparisonExpression expression) {
            FunctionCall call;
            Expression expression2 = expression.getLeft();
            if (!(expression2 instanceof FunctionCall) || !ResolvedFunction.extractFunctionName((call = (FunctionCall)expression2).getName()).equals((Object)GlobalFunctionCatalog.builtinFunctionName("year")) || call.getArguments().size() != 1) {
                return expression;
            }
            Map<NodeRef<Expression>, Type> expressionTypes = this.typeAnalyzer.getTypes(this.session, this.types, expression);
            Expression argument = (Expression)Iterables.getOnlyElement(call.getArguments());
            Type argumentType = expressionTypes.get(NodeRef.of(argument));
            Object right = new IrExpressionInterpreter(expression.getRight(), this.plannerContext, this.session, expressionTypes).optimize(NoOpSymbolResolver.INSTANCE);
            if (right == null || right instanceof NullLiteral) {
                return switch (expression.getOperator()) {
                    default -> throw new MatchException(null, null);
                    case ComparisonExpression.Operator.EQUAL, ComparisonExpression.Operator.NOT_EQUAL, ComparisonExpression.Operator.LESS_THAN, ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, ComparisonExpression.Operator.GREATER_THAN, ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL -> new Cast(new NullLiteral(), (Type)BooleanType.BOOLEAN);
                    case ComparisonExpression.Operator.IS_DISTINCT_FROM -> new IsNotNullPredicate(argument);
                };
            }
            if (right instanceof Expression) {
                return expression;
            }
            if (argumentType instanceof TimestampWithTimeZoneType) {
                return expression;
            }
            if (argumentType != DateType.DATE && !(argumentType instanceof TimestampType)) {
                return expression;
            }
            int year = Math.toIntExact((Long)right);
            return switch (expression.getOperator()) {
                default -> throw new MatchException(null, null);
                case ComparisonExpression.Operator.EQUAL -> this.between(argument, argumentType, UnwrapYearInComparison.calculateRangeStartInclusive(year, argumentType), UnwrapYearInComparison.calculateRangeEndInclusive(year, argumentType));
                case ComparisonExpression.Operator.NOT_EQUAL -> new NotExpression(this.between(argument, argumentType, UnwrapYearInComparison.calculateRangeStartInclusive(year, argumentType), UnwrapYearInComparison.calculateRangeEndInclusive(year, argumentType)));
                case ComparisonExpression.Operator.IS_DISTINCT_FROM -> IrUtils.or(new IsNullPredicate(argument), new NotExpression(this.between(argument, argumentType, UnwrapYearInComparison.calculateRangeStartInclusive(year, argumentType), UnwrapYearInComparison.calculateRangeEndInclusive(year, argumentType))));
                case ComparisonExpression.Operator.LESS_THAN -> new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, argument, this.toExpression(UnwrapYearInComparison.calculateRangeStartInclusive(year, argumentType), argumentType));
                case ComparisonExpression.Operator.LESS_THAN_OR_EQUAL -> new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, argument, this.toExpression(UnwrapYearInComparison.calculateRangeEndInclusive(year, argumentType), argumentType));
                case ComparisonExpression.Operator.GREATER_THAN -> new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, argument, this.toExpression(UnwrapYearInComparison.calculateRangeEndInclusive(year, argumentType), argumentType));
                case ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL -> new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, argument, this.toExpression(UnwrapYearInComparison.calculateRangeStartInclusive(year, argumentType), argumentType));
            };
        }

        private BetweenPredicate between(Expression argument, Type type, Object minInclusive, Object maxInclusive) {
            return new BetweenPredicate(argument, this.toExpression(minInclusive, type), this.toExpression(maxInclusive, type));
        }

        private Expression toExpression(Object value, Type type) {
            return this.literalEncoder.toExpression(value, type);
        }
    }
}

