/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.plan;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import io.trino.spi.type.Type;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.plan.PlanVisitor;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AdaptivePlanNode
extends PlanNode {
    private final PlanNode initialPlan;
    private final Map<Symbol, Type> initialPlanTypes;
    private final PlanNode currentPlan;

    @JsonCreator
    public AdaptivePlanNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="initialPlan") PlanNode initialPlan, @JsonProperty(value="initialPlanTypes") Map<Symbol, Type> initialPlanTypes, @JsonProperty(value="currentPlan") PlanNode currentPlan) {
        super(id);
        this.initialPlan = Objects.requireNonNull(initialPlan, "initialPlan is null");
        this.initialPlanTypes = ImmutableMap.copyOf(Objects.requireNonNull(initialPlanTypes, "initialPlanTypes is null"));
        this.currentPlan = Objects.requireNonNull(currentPlan, "currentPlan is null");
    }

    @JsonProperty
    public PlanNode getInitialPlan() {
        return this.initialPlan;
    }

    @JsonProperty
    public Map<Symbol, Type> getInitialPlanTypes() {
        return this.initialPlanTypes;
    }

    @JsonProperty
    public PlanNode getCurrentPlan() {
        return this.currentPlan;
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.currentPlan);
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        return this.currentPlan.getOutputSymbols();
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        return new AdaptivePlanNode(this.getId(), this.initialPlan, this.initialPlanTypes, (PlanNode)Iterables.getOnlyElement(newChildren));
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitAdaptivePlanNode(this, context);
    }
}

