/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.plan;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.errorprone.annotations.Immutable;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.Row;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.plan.PlanVisitor;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@Immutable
public class ValuesNode
extends PlanNode {
    private final List<Symbol> outputSymbols;
    private final int rowCount;
    private final Optional<List<Expression>> rows;

    public ValuesNode(PlanNodeId id, List<Symbol> outputSymbols, List<Expression> rows) {
        this(id, outputSymbols, rows.size(), Optional.of(rows));
    }

    public ValuesNode(PlanNodeId id, int rowCount) {
        this(id, (List<Symbol>)ImmutableList.of(), rowCount, Optional.empty());
    }

    @JsonCreator
    public ValuesNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="outputSymbols") List<Symbol> outputSymbols, @JsonProperty(value="rowCount") int rowCount, @JsonProperty(value="rows") Optional<List<Expression>> rows) {
        super(id);
        this.outputSymbols = ImmutableList.copyOf((Collection)Objects.requireNonNull(outputSymbols, "outputSymbols is null"));
        this.rowCount = rowCount;
        Objects.requireNonNull(rows, "rows is null");
        if (rows.isPresent()) {
            Preconditions.checkArgument((rowCount == rows.get().size() ? 1 : 0) != 0, (String)"declared and actual row counts don't match: %s vs %s", (int)rowCount, (int)rows.get().size());
            List rowSizes = (List)rows.get().stream().map(row -> Objects.requireNonNull(row, "row is null")).filter(expression -> expression instanceof Row).map(expression -> ((Row)expression).getItems().size()).distinct().collect(ImmutableList.toImmutableList());
            Preconditions.checkState((rowSizes.size() <= 1 ? 1 : 0) != 0, (Object)"mismatched rows. All rows must be the same size");
            if (rowSizes.size() == 1) {
                Preconditions.checkState((boolean)((Integer)Iterables.getOnlyElement((Iterable)rowSizes)).equals(outputSymbols.size()), (String)"row size doesn't match the number of output symbols: %s vs %s", (Object)Iterables.getOnlyElement((Iterable)rowSizes), (int)outputSymbols.size());
            }
        } else {
            Preconditions.checkArgument((outputSymbols.size() == 0 ? 1 : 0) != 0, (Object)"missing rows specification for Values with non-empty output symbols");
        }
        this.rows = outputSymbols.size() == 0 ? Optional.empty() : rows.map(ImmutableList::copyOf);
    }

    @Override
    @JsonProperty
    public List<Symbol> getOutputSymbols() {
        return this.outputSymbols;
    }

    @JsonProperty
    public int getRowCount() {
        return this.rowCount;
    }

    @JsonProperty
    public Optional<List<Expression>> getRows() {
        return this.rows;
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of();
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitValues(this, context);
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        Preconditions.checkArgument((boolean)newChildren.isEmpty(), (Object)"newChildren is not empty");
        return this;
    }
}

