/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.planprinter;

import com.google.common.collect.ImmutableMap;
import io.trino.execution.TableInfo;
import io.trino.metadata.IndexHandle;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.TableExecuteHandle;
import io.trino.metadata.TableHandle;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorPartitioningHandle;
import io.trino.spi.type.Type;
import io.trino.sql.ir.BinaryLiteral;
import io.trino.sql.ir.BooleanLiteral;
import io.trino.sql.ir.DecimalLiteral;
import io.trino.sql.ir.DoubleLiteral;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.ExpressionFormatter;
import io.trino.sql.ir.GenericLiteral;
import io.trino.sql.ir.IntervalLiteral;
import io.trino.sql.ir.Literal;
import io.trino.sql.ir.LongLiteral;
import io.trino.sql.ir.NullLiteral;
import io.trino.sql.ir.StringLiteral;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.Partitioning;
import io.trino.sql.planner.PartitioningHandle;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SystemPartitioningHandle;
import io.trino.sql.planner.plan.StatisticsWriterNode;
import io.trino.sql.planner.plan.TableWriterNode;
import io.trino.sql.planner.planprinter.Anonymizer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class CounterBasedAnonymizer
implements Anonymizer {
    private final ExpressionFormatter.Formatter anonymizeExpressionFormatter = new ExpressionFormatter.Formatter(Optional.of(this::anonymizeLiteral), Optional.of(this::anonymizeSymbolReference));
    private final Map<String, String> anonymizedMap = new HashMap<String, String>();
    private final Map<ObjectType, Integer> counterMap = Arrays.stream(ObjectType.values()).collect(Collectors.toMap(objectType -> objectType, objectType -> 0));

    @Override
    public String anonymize(Type type, String value) {
        String formattedTypeName = type.getDisplayName().replaceAll("\\W", "_").replaceAll("__", "_");
        return formattedTypeName + "_" + this.anonymize(value, ObjectType.VALUE);
    }

    @Override
    public String anonymize(Symbol symbol) {
        return this.anonymize(symbol.getName(), ObjectType.SYMBOL);
    }

    @Override
    public String anonymizeColumn(String symbol) {
        return this.anonymize(symbol, ObjectType.COLUMN);
    }

    @Override
    public String anonymize(Expression expression) {
        return (String)this.anonymizeExpressionFormatter.process(expression);
    }

    private String anonymizeSymbolReference(SymbolReference node) {
        return "\"" + this.anonymize(Symbol.from(node)) + "\"";
    }

    private String anonymizeLiteral(Literal node) {
        if (node instanceof StringLiteral) {
            StringLiteral literal = (StringLiteral)node;
            return this.anonymizeLiteral("string", literal.getValue());
        }
        if (node instanceof GenericLiteral) {
            GenericLiteral literal = (GenericLiteral)node;
            return this.anonymizeLiteral(literal.getType().getDisplayName(), literal.getValue());
        }
        if (node instanceof BinaryLiteral) {
            BinaryLiteral literal = (BinaryLiteral)node;
            return this.anonymizeLiteral("binary", new String(literal.getValue(), StandardCharsets.UTF_8));
        }
        if (node instanceof DecimalLiteral) {
            DecimalLiteral literal = (DecimalLiteral)node;
            return this.anonymizeLiteral("decimal", literal.getValue());
        }
        if (node instanceof DoubleLiteral) {
            DoubleLiteral literal = (DoubleLiteral)node;
            return this.anonymizeLiteral("double", literal.getValue());
        }
        if (node instanceof LongLiteral) {
            LongLiteral literal = (LongLiteral)node;
            return this.anonymizeLiteral("long", literal.getValue());
        }
        if (node instanceof IntervalLiteral) {
            IntervalLiteral literal = (IntervalLiteral)node;
            return this.anonymizeLiteral("interval", literal.getValue());
        }
        if (node instanceof BooleanLiteral) {
            BooleanLiteral literal = (BooleanLiteral)node;
            return String.valueOf(literal.getValue());
        }
        if (node instanceof NullLiteral) {
            return "null";
        }
        throw new UnsupportedOperationException("Anonymization is not supported for literal " + String.valueOf(node));
    }

    private <T> String anonymizeLiteral(String type, T value) {
        return "'" + type + "_" + this.anonymize(value, ObjectType.LITERAL) + "'";
    }

    @Override
    public String anonymize(ColumnHandle columnHandle) {
        return this.anonymize(columnHandle, ObjectType.COLUMN);
    }

    @Override
    public String anonymize(QualifiedObjectName objectName) {
        return this.anonymize(objectName.getCatalogName(), objectName.getSchemaName(), objectName.getObjectName());
    }

    @Override
    public String anonymize(Partitioning.ArgumentBinding argument) {
        if (argument.getConstant() != null) {
            return argument.getConstant().toString();
        }
        return this.anonymize(argument.getExpression());
    }

    @Override
    public String anonymize(IndexHandle indexHandle) {
        return CounterBasedAnonymizer.formatMap((Map<String, String>)ImmutableMap.of((Object)"catalog", (Object)this.anonymize(indexHandle.getCatalogHandle().getCatalogName(), ObjectType.CATALOG), (Object)"connectorHandleType", (Object)indexHandle.getConnectorHandle().getClass().getSimpleName()));
    }

    @Override
    public String anonymize(TableHandle tableHandle, TableInfo tableInfo) {
        ImmutableMap.Builder result = ImmutableMap.builder().put((Object)"table", (Object)this.anonymize(tableInfo.getTableName()));
        tableInfo.getConnectorName().ifPresent(connector -> result.put((Object)"connector", connector));
        return CounterBasedAnonymizer.formatMap((Map<String, String>)result.buildOrThrow());
    }

    @Override
    public String anonymize(PartitioningHandle partitioningHandle) {
        ConnectorPartitioningHandle connectorHandle = partitioningHandle.getConnectorHandle();
        ImmutableMap.Builder result = ImmutableMap.builder().put((Object)"connectorHandleType", (Object)connectorHandle.getClass().getSimpleName());
        partitioningHandle.getCatalogHandle().ifPresent(catalog -> result.put((Object)"catalog", (Object)this.anonymize(catalog.getCatalogName(), ObjectType.CATALOG)));
        if (connectorHandle instanceof SystemPartitioningHandle) {
            result.put((Object)"partitioning", (Object)((SystemPartitioningHandle)connectorHandle).getPartitioningName()).put((Object)"function", (Object)((SystemPartitioningHandle)connectorHandle).getFunction().name());
        }
        return CounterBasedAnonymizer.formatMap((Map<String, String>)result.buildOrThrow());
    }

    @Override
    public String anonymize(TableWriterNode.WriterTarget target) {
        if (target instanceof TableWriterNode.CreateTarget) {
            return this.anonymize((TableWriterNode.CreateTarget)target);
        }
        if (target instanceof TableWriterNode.InsertTarget) {
            return this.anonymize((TableWriterNode.InsertTarget)target);
        }
        if (target instanceof TableWriterNode.MergeTarget) {
            return this.anonymize((TableWriterNode.MergeTarget)target);
        }
        if (target instanceof TableWriterNode.RefreshMaterializedViewTarget) {
            return this.anonymize((TableWriterNode.RefreshMaterializedViewTarget)target);
        }
        if (target instanceof TableWriterNode.TableExecuteTarget) {
            return this.anonymize((TableWriterNode.TableExecuteTarget)target);
        }
        throw new UnsupportedOperationException("Anonymization is not supported for WriterTarget type: " + target.getClass().getSimpleName());
    }

    @Override
    public String anonymize(StatisticsWriterNode.WriteStatisticsTarget target) {
        if (target instanceof StatisticsWriterNode.WriteStatisticsHandle) {
            return this.anonymize(((StatisticsWriterNode.WriteStatisticsHandle)target).getHandle().getCatalogHandle().getCatalogName(), ObjectType.CATALOG);
        }
        throw new UnsupportedOperationException("Anonymization is not supported for WriterTarget type: " + target.getClass().getSimpleName());
    }

    @Override
    public String anonymize(TableHandle tableHandle) {
        return this.anonymize(tableHandle.getCatalogHandle().getCatalogName(), ObjectType.CATALOG);
    }

    @Override
    public String anonymize(TableExecuteHandle tableHandle) {
        return this.anonymize(tableHandle.getCatalogHandle().getCatalogName(), ObjectType.CATALOG);
    }

    private String anonymize(TableWriterNode.CreateTarget target) {
        return this.anonymize(target.getHandle().getCatalogHandle().getCatalogName(), target.getSchemaTableName().getSchemaName(), target.getSchemaTableName().getTableName());
    }

    private String anonymize(TableWriterNode.InsertTarget target) {
        return this.anonymize(target.getHandle().getCatalogHandle().getCatalogName(), target.getSchemaTableName().getSchemaName(), target.getSchemaTableName().getTableName());
    }

    private String anonymize(TableWriterNode.MergeTarget target) {
        return this.anonymize(target.getHandle().getCatalogHandle().getCatalogName(), target.getSchemaTableName().getSchemaName(), target.getSchemaTableName().getTableName());
    }

    private String anonymize(TableWriterNode.RefreshMaterializedViewTarget target) {
        return this.anonymize(target.getInsertHandle().getCatalogHandle().getCatalogName(), target.getSchemaTableName().getSchemaName(), target.getSchemaTableName().getTableName());
    }

    private String anonymize(TableWriterNode.TableExecuteTarget target) {
        return this.anonymize(target.getExecuteHandle().getCatalogHandle().getCatalogName(), target.getSchemaTableName().getSchemaName(), target.getSchemaTableName().getTableName());
    }

    private String anonymize(String catalogName, String schemaName, String objectName) {
        return new QualifiedObjectName(this.anonymize(catalogName, ObjectType.CATALOG), this.anonymize(schemaName, ObjectType.SCHEMA), this.anonymize(objectName, ObjectType.TABLE)).toString();
    }

    private <T> String anonymize(T object, ObjectType objectType) {
        return this.anonymizedMap.computeIfAbsent(objectType.name() + String.valueOf(object), ignored -> {
            Integer counter = this.counterMap.computeIfPresent(objectType, (k, v) -> v + 1);
            return objectType.name().toLowerCase(Locale.ENGLISH) + "_" + counter;
        });
    }

    private static String formatMap(Map<String, String> map) {
        return map.entrySet().stream().map(entry -> (String)entry.getKey() + " = " + (String)entry.getValue()).collect(Collectors.joining(", ", "[", "]"));
    }

    private static enum ObjectType {
        CATALOG,
        SCHEMA,
        TABLE,
        COLUMN,
        SYMBOL,
        LITERAL,
        VALUE;

    }
}

