/*
 * Decompiled with CFR 0.152.
 */
package io.trino;

import io.trino.block.BlockAssertions;
import io.trino.jmh.Benchmarks;
import io.trino.operator.PagesIndex;
import io.trino.operator.PagesIndexPageSorter;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.RunnerException;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.SECONDS)
@Fork(value=3)
@Warmup(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
public class BenchmarkPagesIndexPageSorter {
    @Benchmark
    public int runBenchmark(BenchmarkData data) {
        PagesIndexPageSorter pageSorter = new PagesIndexPageSorter((PagesIndex.Factory)new PagesIndex.TestingFactory(false));
        long[] addresses = pageSorter.sort(data.types, data.pages, data.sortChannels, Collections.nCopies(data.sortChannels.size(), SortOrder.ASC_NULLS_FIRST), 10000);
        return addresses.length;
    }

    private static List<Page> createPages(int pageCount, int channelCount, Type type) {
        int positionCount = 0x100000 / (channelCount * 8);
        ArrayList<Page> pages = new ArrayList<Page>(pageCount);
        for (int numPage = 0; numPage < pageCount; ++numPage) {
            Block[] blocks = new Block[channelCount];
            for (int numChannel = 0; numChannel < channelCount; ++numChannel) {
                if (type.equals((Object)BigintType.BIGINT)) {
                    blocks[numChannel] = BlockAssertions.createLongSequenceBlock(0, positionCount);
                    continue;
                }
                if (type.equals((Object)VarcharType.VARCHAR)) {
                    blocks[numChannel] = BlockAssertions.createStringSequenceBlock(0, positionCount);
                    continue;
                }
                if (type.equals((Object)DoubleType.DOUBLE)) {
                    blocks[numChannel] = BlockAssertions.createDoubleSequenceBlock(0, positionCount);
                    continue;
                }
                if (type.equals((Object)BooleanType.BOOLEAN)) {
                    blocks[numChannel] = BlockAssertions.createBooleanSequenceBlock(0, positionCount);
                    continue;
                }
                throw new IllegalArgumentException("Unsupported type: " + String.valueOf(type));
            }
            pages.add(new Page(blocks));
        }
        return pages;
    }

    public static void main(String[] args) throws RunnerException {
        Benchmarks.benchmark(BenchmarkPagesIndexPageSorter.class).run();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        @Param(value={"2", "3", "4", "5"})
        private int numSortChannels;
        @Param(value={"BIGINT", "VARCHAR", "DOUBLE", "BOOLEAN"})
        private String sortChannelType;
        private List<Page> pages;
        private final int maxPages = 500;
        public List<Type> types;
        public List<Integer> sortChannels;

        @Setup
        public void setup() {
            int totalChannels = 20;
            Type type = this.getType();
            this.pages = BenchmarkPagesIndexPageSorter.createPages(500, totalChannels, type);
            this.types = Collections.nCopies(totalChannels, type);
            this.sortChannels = new ArrayList<Integer>();
            for (int i = 0; i < this.numSortChannels; ++i) {
                this.sortChannels.add(i);
            }
        }

        private Type getType() {
            switch (this.sortChannelType) {
                case "BIGINT": {
                    return BigintType.BIGINT;
                }
                case "VARCHAR": {
                    return VarcharType.VARCHAR;
                }
                case "DOUBLE": {
                    return DoubleType.DOUBLE;
                }
                case "BOOLEAN": {
                    return BooleanType.BOOLEAN;
                }
            }
            throw new IllegalArgumentException("Unsupported type: " + this.sortChannelType);
        }
    }
}

