/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cost;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.trino.cost.EstimateAssertion;
import io.trino.cost.PlanNodeStatsEstimate;
import io.trino.cost.SymbolStatsAssertion;
import io.trino.cost.SymbolStatsEstimate;
import io.trino.spi.type.Type;
import io.trino.sql.planner.Symbol;
import io.trino.type.UnknownType;
import java.util.Collection;
import java.util.Set;
import java.util.function.Consumer;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;

public class PlanNodeStatsAssertion {
    private final PlanNodeStatsEstimate actual;

    private PlanNodeStatsAssertion(PlanNodeStatsEstimate actual) {
        this.actual = actual;
    }

    public static PlanNodeStatsAssertion assertThat(PlanNodeStatsEstimate actual) {
        return new PlanNodeStatsAssertion(actual);
    }

    public PlanNodeStatsAssertion outputRowsCount(double expected) {
        EstimateAssertion.assertEstimateEquals(this.actual.getOutputRowCount(), expected, "outputRowsCount mismatch", new Object[0]);
        return this;
    }

    public PlanNodeStatsAssertion outputRowsCountUnknown() {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)Double.isNaN(this.actual.getOutputRowCount())).describedAs("expected unknown outputRowsCount but got " + this.actual.getOutputRowCount(), new Object[0])).isTrue();
        return this;
    }

    public PlanNodeStatsAssertion symbolStats(String symbolName, Consumer<SymbolStatsAssertion> symbolStatsAssertionConsumer) {
        return this.symbolStats(new Symbol((Type)UnknownType.UNKNOWN, symbolName), symbolStatsAssertionConsumer);
    }

    public PlanNodeStatsAssertion symbolStats(Symbol symbol, Consumer<SymbolStatsAssertion> columnAssertionConsumer) {
        SymbolStatsAssertion columnAssertion = SymbolStatsAssertion.assertThat(this.actual.getSymbolStatistics(symbol));
        columnAssertionConsumer.accept(columnAssertion);
        return this;
    }

    public PlanNodeStatsAssertion symbolStatsUnknown(String symbolName) {
        return this.symbolStatsUnknown(new Symbol((Type)UnknownType.UNKNOWN, symbolName));
    }

    public PlanNodeStatsAssertion symbolStatsUnknown(Symbol symbol) {
        return this.symbolStats(symbol, (SymbolStatsAssertion columnStats) -> columnStats.lowValueUnknown().highValueUnknown().nullsFractionUnknown().distinctValuesCountUnknown());
    }

    public PlanNodeStatsAssertion symbolsWithKnownStats(Symbol ... symbols) {
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)this.actual.getSymbolsWithKnownStatistics()).describedAs("symbols with known stats", new Object[0])).isEqualTo((Object)ImmutableSet.copyOf((Object[])symbols));
        return this;
    }

    public PlanNodeStatsAssertion equalTo(PlanNodeStatsEstimate expected) {
        EstimateAssertion.assertEstimateEquals(this.actual.getOutputRowCount(), expected.getOutputRowCount(), "outputRowCount mismatch", new Object[0]);
        for (Symbol symbol : Sets.union((Set)expected.getSymbolsWithKnownStatistics(), (Set)this.actual.getSymbolsWithKnownStatistics())) {
            this.assertSymbolStatsEqual(symbol, this.actual.getSymbolStatistics(symbol), expected.getSymbolStatistics(symbol));
        }
        return this;
    }

    private void assertSymbolStatsEqual(Symbol symbol, SymbolStatsEstimate actual, SymbolStatsEstimate expected) {
        EstimateAssertion.assertEstimateEquals(actual.getNullsFraction(), expected.getNullsFraction(), "nullsFraction mismatch for %s", symbol.getName());
        EstimateAssertion.assertEstimateEquals(actual.getLowValue(), expected.getLowValue(), "lowValue mismatch for %s", symbol.getName());
        EstimateAssertion.assertEstimateEquals(actual.getHighValue(), expected.getHighValue(), "highValue mismatch for %s", symbol.getName());
        EstimateAssertion.assertEstimateEquals(actual.getDistinctValuesCount(), expected.getDistinctValuesCount(), "distinct values count mismatch for %s", symbol.getName());
        EstimateAssertion.assertEstimateEquals(actual.getAverageRowSize(), expected.getAverageRowSize(), "average row size mismatch for %s", symbol.getName());
    }
}

