/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cost;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import io.trino.Session;
import io.trino.cost.CachingCostProvider;
import io.trino.cost.CachingStatsProvider;
import io.trino.cost.CachingTableStatsProvider;
import io.trino.cost.CostCalculator;
import io.trino.cost.CostCalculatorUsingExchanges;
import io.trino.cost.CostCalculatorWithEstimatedExchanges;
import io.trino.cost.CostProvider;
import io.trino.cost.PlanCostEstimate;
import io.trino.cost.PlanNodeStatsEstimate;
import io.trino.cost.StatsAndCosts;
import io.trino.cost.StatsCalculator;
import io.trino.cost.StatsProvider;
import io.trino.cost.SymbolStatsEstimate;
import io.trino.cost.TableStatsProvider;
import io.trino.cost.TaskCountEstimator;
import io.trino.execution.QueryManagerConfig;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.plugin.tpch.TpchColumnHandle;
import io.trino.plugin.tpch.TpchConnectorFactory;
import io.trino.security.AccessControl;
import io.trino.security.AllowAllAccessControl;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.PlannerContext;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IsNullPredicate;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.Plan;
import io.trino.sql.planner.PlanFragmenter;
import io.trino.sql.planner.SubPlan;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.EnforceSingleRowNode;
import io.trino.sql.planner.plan.ExchangeNode;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.JoinType;
import io.trino.sql.planner.plan.LimitNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.sql.planner.plan.TableScanNode;
import io.trino.sql.planner.plan.UnionNode;
import io.trino.testing.PlanTester;
import io.trino.testing.TestingSession;
import io.trino.testing.TransactionBuilder;
import io.trino.transaction.TransactionManager;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestCostCalculator {
    private static final int NUMBER_OF_NODES = 10;
    private static final double AVERAGE_ROW_SIZE = 8.0;
    private static final double IS_NULL_OVERHEAD = 1.125;
    private static final double OFFSET_AND_IS_NULL_OVERHEAD = 1.625;
    private CostCalculator costCalculatorUsingExchanges;
    private CostCalculator costCalculatorWithEstimatedExchanges;
    private PlanFragmenter planFragmenter;
    private Session session;
    private PlanTester planTester;

    @BeforeAll
    public void setUp() {
        TaskCountEstimator taskCountEstimator = new TaskCountEstimator(() -> 10);
        this.costCalculatorUsingExchanges = new CostCalculatorUsingExchanges(taskCountEstimator);
        this.costCalculatorWithEstimatedExchanges = new CostCalculatorWithEstimatedExchanges(this.costCalculatorUsingExchanges, taskCountEstimator);
        this.session = TestingSession.testSessionBuilder().setCatalog("test_catalog").build();
        this.planTester = PlanTester.create((Session)this.session);
        PlannerContext plannerContext = this.planTester.getPlannerContext();
        plannerContext.getLanguageFunctionManager().registerQuery(this.session);
        this.planTester.createCatalog("test_catalog", (ConnectorFactory)new TpchConnectorFactory(), (Map)ImmutableMap.of());
        this.planFragmenter = new PlanFragmenter(plannerContext.getMetadata(), plannerContext.getFunctionManager(), this.planTester.getTransactionManager(), this.planTester.getCatalogManager(), plannerContext.getLanguageFunctionManager(), new QueryManagerConfig());
    }

    @AfterAll
    public void tearDown() {
        this.costCalculatorUsingExchanges = null;
        this.costCalculatorWithEstimatedExchanges = null;
        this.planFragmenter = null;
        this.session = null;
        this.planTester.close();
        this.planTester = null;
    }

    @Test
    public void testTableScan() {
        TableScanNode tableScan = this.tableScan("ts", new Symbol((Type)BigintType.BIGINT, "orderkey"));
        this.assertCost((PlanNode)tableScan, (Map<String, PlanCostEstimate>)ImmutableMap.of(), (Map<String, PlanNodeStatsEstimate>)ImmutableMap.of((Object)"ts", (Object)TestCostCalculator.statsEstimate((PlanNode)tableScan, 1000.0))).cpu(1125.0).memory(0.0).network(0.0);
        this.assertCostEstimatedExchanges((PlanNode)tableScan, (Map<String, PlanCostEstimate>)ImmutableMap.of(), (Map<String, PlanNodeStatsEstimate>)ImmutableMap.of((Object)"ts", (Object)TestCostCalculator.statsEstimate((PlanNode)tableScan, 1000.0))).cpu(1125.0).memory(0.0).network(0.0);
        this.assertCostFragmentedPlan((PlanNode)tableScan, (Map<String, PlanCostEstimate>)ImmutableMap.of(), (Map<String, PlanNodeStatsEstimate>)ImmutableMap.of((Object)"ts", (Object)TestCostCalculator.statsEstimate((PlanNode)tableScan, 1000.0))).cpu(1125.0).memory(0.0).network(0.0);
        this.assertCostHasUnknownComponentsForUnknownStats((PlanNode)tableScan);
    }

    @Test
    public void testProject() {
        TableScanNode tableScan = this.tableScan("ts", new Symbol((Type)BigintType.BIGINT, "orderkey"));
        PlanNode project = this.project("project", (PlanNode)tableScan, new Symbol((Type)VarcharType.VARCHAR, "string"), (Expression)new Cast((Expression)new SymbolReference((Type)BigintType.BIGINT, "orderkey"), (Type)VarcharType.VARCHAR));
        ImmutableMap costs = ImmutableMap.of((Object)"ts", (Object)TestCostCalculator.cpuCost(1000.0));
        ImmutableMap stats = ImmutableMap.of((Object)"project", (Object)TestCostCalculator.statsEstimate(project, 4000.0), (Object)"ts", (Object)TestCostCalculator.statsEstimate((PlanNode)tableScan, 1000.0));
        this.assertCost(project, (Map<String, PlanCostEstimate>)costs, (Map<String, PlanNodeStatsEstimate>)stats).cpu(7500.0).memory(0.0).network(0.0);
        this.assertCostEstimatedExchanges(project, (Map<String, PlanCostEstimate>)costs, (Map<String, PlanNodeStatsEstimate>)stats).cpu(7500.0).memory(0.0).network(0.0);
        this.assertCostFragmentedPlan(project, (Map<String, PlanCostEstimate>)costs, (Map<String, PlanNodeStatsEstimate>)stats).cpu(7500.0).memory(0.0).network(0.0);
        this.assertCostHasUnknownComponentsForUnknownStats(project);
    }

    @Test
    public void testFilter() {
        TableScanNode tableScan = this.tableScan("ts", new Symbol((Type)VarcharType.VARCHAR, "string"));
        IsNullPredicate expression = new IsNullPredicate((Expression)new SymbolReference((Type)VarcharType.VARCHAR, "string"));
        FilterNode filter = new FilterNode(new PlanNodeId("filter"), (PlanNode)tableScan, (Expression)expression);
        ImmutableMap costs = ImmutableMap.of((Object)"ts", (Object)TestCostCalculator.cpuCost(1000.0));
        ImmutableMap stats = ImmutableMap.of((Object)"filter", (Object)TestCostCalculator.statsEstimate((PlanNode)filter, 4000.0), (Object)"ts", (Object)TestCostCalculator.statsEstimate((PlanNode)tableScan, 1000.0));
        this.assertCost((PlanNode)filter, (Map<String, PlanCostEstimate>)costs, (Map<String, PlanNodeStatsEstimate>)stats).cpu(2625.0).memory(0.0).network(0.0);
        this.assertCostEstimatedExchanges((PlanNode)filter, (Map<String, PlanCostEstimate>)costs, (Map<String, PlanNodeStatsEstimate>)stats).cpu(2625.0).memory(0.0).network(0.0);
        this.assertCostFragmentedPlan((PlanNode)filter, (Map<String, PlanCostEstimate>)costs, (Map<String, PlanNodeStatsEstimate>)stats).cpu(2625.0).memory(0.0).network(0.0);
        this.assertCostHasUnknownComponentsForUnknownStats((PlanNode)filter);
    }

    @Test
    public void testRepartitionedJoin() {
        TableScanNode ts1 = this.tableScan("ts1", new Symbol((Type)BigintType.BIGINT, "orderkey"));
        TableScanNode ts2 = this.tableScan("ts2", new Symbol((Type)BigintType.BIGINT, "orderkey_0"));
        JoinNode join = this.join("join", (PlanNode)ts1, (PlanNode)ts2, JoinNode.DistributionType.PARTITIONED, "orderkey", "orderkey_0");
        ImmutableMap costs = ImmutableMap.of((Object)"ts1", (Object)TestCostCalculator.cpuCost(6000.0), (Object)"ts2", (Object)TestCostCalculator.cpuCost(1000.0));
        ImmutableMap stats = ImmutableMap.of((Object)"join", (Object)TestCostCalculator.statsEstimate((PlanNode)join, 12000.0), (Object)"ts1", (Object)TestCostCalculator.statsEstimate((PlanNode)ts1, 6000.0), (Object)"ts2", (Object)TestCostCalculator.statsEstimate((PlanNode)ts2, 1000.0));
        this.assertCost((PlanNode)join, (Map<String, PlanCostEstimate>)costs, (Map<String, PlanNodeStatsEstimate>)stats).cpu(28375.0).memory(1125.0).network(0.0);
        this.assertCostEstimatedExchanges((PlanNode)join, (Map<String, PlanCostEstimate>)costs, (Map<String, PlanNodeStatsEstimate>)stats).cpu(37375.0).memory(1125.0).network(7875.0);
        this.assertCostFragmentedPlan((PlanNode)join, (Map<String, PlanCostEstimate>)costs, (Map<String, PlanNodeStatsEstimate>)stats).cpu(28375.0).memory(1125.0).network(0.0);
        this.assertCostHasUnknownComponentsForUnknownStats((PlanNode)join);
    }

    @Test
    public void testReplicatedJoin() {
        TableScanNode ts1 = this.tableScan("ts1", new Symbol((Type)BigintType.BIGINT, "orderkey"));
        TableScanNode ts2 = this.tableScan("ts2", new Symbol((Type)BigintType.BIGINT, "orderkey_0"));
        JoinNode join = this.join("join", (PlanNode)ts1, (PlanNode)ts2, JoinNode.DistributionType.REPLICATED, "orderkey", "orderkey_0");
        ImmutableMap costs = ImmutableMap.of((Object)"ts1", (Object)TestCostCalculator.cpuCost(6000.0), (Object)"ts2", (Object)TestCostCalculator.cpuCost(1000.0));
        ImmutableMap stats = ImmutableMap.of((Object)"join", (Object)TestCostCalculator.statsEstimate((PlanNode)join, 12000.0), (Object)"ts1", (Object)TestCostCalculator.statsEstimate((PlanNode)ts1, 6000.0), (Object)"ts2", (Object)TestCostCalculator.statsEstimate((PlanNode)ts2, 1000.0));
        this.assertCost((PlanNode)join, (Map<String, PlanCostEstimate>)costs, (Map<String, PlanNodeStatsEstimate>)stats).cpu(48625.0).memory(11250.0).network(0.0);
        this.assertCostEstimatedExchanges((PlanNode)join, (Map<String, PlanCostEstimate>)costs, (Map<String, PlanNodeStatsEstimate>)stats).cpu(49750.0).memory(11250.0).network(11250.0);
        this.assertCostFragmentedPlan((PlanNode)join, (Map<String, PlanCostEstimate>)costs, (Map<String, PlanNodeStatsEstimate>)stats).cpu(48625.0).memory(11250.0).network(0.0);
        this.assertCostHasUnknownComponentsForUnknownStats((PlanNode)join);
    }

    @Test
    public void testMemoryCostJoinAboveJoin() {
        TableScanNode ts1 = this.tableScan("ts1", new Symbol((Type)BigintType.BIGINT, "key1"));
        TableScanNode ts2 = this.tableScan("ts2", new Symbol((Type)BigintType.BIGINT, "key2"));
        TableScanNode ts3 = this.tableScan("ts3", new Symbol((Type)BigintType.BIGINT, "key3"));
        JoinNode join23 = this.join("join23", (PlanNode)ts2, (PlanNode)ts3, JoinNode.DistributionType.PARTITIONED, "key2", "key3");
        JoinNode join = this.join("join", (PlanNode)ts1, (PlanNode)join23, JoinNode.DistributionType.PARTITIONED, "key1", "key2");
        ImmutableMap costs = ImmutableMap.of((Object)"ts1", (Object)new PlanCostEstimate(0.0, 128.0, 128.0, 0.0), (Object)"ts2", (Object)new PlanCostEstimate(0.0, 64.0, 64.0, 0.0), (Object)"ts3", (Object)new PlanCostEstimate(0.0, 32.0, 32.0, 0.0));
        ImmutableMap stats = ImmutableMap.of((Object)"join", (Object)TestCostCalculator.statsEstimate((PlanNode)join, 10000.0), (Object)"join23", (Object)TestCostCalculator.statsEstimate((PlanNode)join23, 2000.0), (Object)"ts1", (Object)TestCostCalculator.statsEstimate((PlanNode)ts1, 10000.0), (Object)"ts2", (Object)TestCostCalculator.statsEstimate((PlanNode)ts2, 1000.0), (Object)"ts3", (Object)TestCostCalculator.statsEstimate((PlanNode)ts3, 100.0));
        this.assertCost((PlanNode)join23, (Map<String, PlanCostEstimate>)costs, (Map<String, PlanNodeStatsEstimate>)stats).memory(208.5).memoryWhenOutputting(176.5);
        this.assertCost((PlanNode)join, (Map<String, PlanCostEstimate>)costs, (Map<String, PlanNodeStatsEstimate>)stats).memory(2554.5).memoryWhenOutputting(2378.0);
        this.assertCostEstimatedExchanges((PlanNode)join23, (Map<String, PlanCostEstimate>)costs, (Map<String, PlanNodeStatsEstimate>)stats).memory(208.5).memoryWhenOutputting(176.5);
        this.assertCostEstimatedExchanges((PlanNode)join, (Map<String, PlanCostEstimate>)costs, (Map<String, PlanNodeStatsEstimate>)stats).memory(2554.5).memoryWhenOutputting(2378.0);
        this.assertCostFragmentedPlan((PlanNode)join23, (Map<String, PlanCostEstimate>)costs, (Map<String, PlanNodeStatsEstimate>)stats).memory(208.5).memoryWhenOutputting(176.5);
        this.assertCostFragmentedPlan((PlanNode)join, (Map<String, PlanCostEstimate>)costs, (Map<String, PlanNodeStatsEstimate>)stats).memory(2554.5).memoryWhenOutputting(2378.0);
    }

    @Test
    public void testAggregation() {
        TableScanNode tableScan = this.tableScan("ts", new Symbol((Type)BigintType.BIGINT, "orderkey"));
        AggregationNode aggregation = this.aggregation("agg", (PlanNode)tableScan);
        ImmutableMap costs = ImmutableMap.of((Object)"ts", (Object)TestCostCalculator.cpuCost(6000.0));
        ImmutableMap stats = ImmutableMap.of((Object)"ts", (Object)TestCostCalculator.statsEstimate((PlanNode)tableScan, 6000.0), (Object)"agg", (Object)TestCostCalculator.statsEstimate((PlanNode)aggregation, 13.0));
        this.assertCost((PlanNode)aggregation, (Map<String, PlanCostEstimate>)costs, (Map<String, PlanNodeStatsEstimate>)stats).cpu(12750.0).memory(14.625).network(0.0);
        this.assertCostEstimatedExchanges((PlanNode)aggregation, (Map<String, PlanCostEstimate>)costs, (Map<String, PlanNodeStatsEstimate>)stats).cpu(26250.0).memory(14.625).network(6750.0);
        this.assertCostFragmentedPlan((PlanNode)aggregation, (Map<String, PlanCostEstimate>)costs, (Map<String, PlanNodeStatsEstimate>)stats).cpu(12750.0).memory(14.625).network(0.0);
        this.assertCostHasUnknownComponentsForUnknownStats((PlanNode)aggregation);
    }

    @Test
    public void testRepartitionedJoinWithExchange() {
        TableScanNode ts1 = this.tableScan("ts1", new Symbol((Type)BigintType.BIGINT, "orderkey"));
        TableScanNode ts2 = this.tableScan("ts2", new Symbol((Type)BigintType.BIGINT, "orderkey_0"));
        ExchangeNode remoteExchange1 = ExchangeNode.partitionedExchange((PlanNodeId)new PlanNodeId("re1"), (ExchangeNode.Scope)ExchangeNode.Scope.REMOTE, (PlanNode)ts1, (List)ImmutableList.of((Object)new Symbol((Type)BigintType.BIGINT, "orderkey")), Optional.empty());
        ExchangeNode remoteExchange2 = ExchangeNode.partitionedExchange((PlanNodeId)new PlanNodeId("re2"), (ExchangeNode.Scope)ExchangeNode.Scope.REMOTE, (PlanNode)ts2, (List)ImmutableList.of((Object)new Symbol((Type)BigintType.BIGINT, "orderkey_0")), Optional.empty());
        ExchangeNode localExchange = ExchangeNode.partitionedExchange((PlanNodeId)new PlanNodeId("le"), (ExchangeNode.Scope)ExchangeNode.Scope.LOCAL, (PlanNode)remoteExchange2, (List)ImmutableList.of((Object)new Symbol((Type)BigintType.BIGINT, "orderkey_0")), Optional.empty());
        JoinNode join = this.join("join", (PlanNode)remoteExchange1, (PlanNode)localExchange, JoinNode.DistributionType.PARTITIONED, "orderkey", "orderkey_0");
        ImmutableMap stats = ImmutableMap.builder().put((Object)"join", (Object)TestCostCalculator.statsEstimate((PlanNode)join, 12000.0)).put((Object)"re1", (Object)TestCostCalculator.statsEstimate((PlanNode)remoteExchange1, 10000.0)).put((Object)"re2", (Object)TestCostCalculator.statsEstimate((PlanNode)remoteExchange2, 10000.0)).put((Object)"le", (Object)TestCostCalculator.statsEstimate((PlanNode)localExchange, 6000.0)).put((Object)"ts1", (Object)TestCostCalculator.statsEstimate((PlanNode)ts1, 6000.0)).put((Object)"ts2", (Object)TestCostCalculator.statsEstimate((PlanNode)ts2, 1000.0)).buildOrThrow();
        this.assertFragmentedEqualsUnfragmented((PlanNode)join, (Map<String, PlanNodeStatsEstimate>)stats);
    }

    @Test
    public void testReplicatedJoinWithExchange() {
        TableScanNode ts1 = this.tableScan("ts1", new Symbol((Type)BigintType.BIGINT, "orderkey"));
        TableScanNode ts2 = this.tableScan("ts2", new Symbol((Type)BigintType.BIGINT, "orderkey_0"));
        ExchangeNode remoteExchange2 = ExchangeNode.replicatedExchange((PlanNodeId)new PlanNodeId("re2"), (ExchangeNode.Scope)ExchangeNode.Scope.REMOTE, (PlanNode)ts2);
        ExchangeNode localExchange = ExchangeNode.partitionedExchange((PlanNodeId)new PlanNodeId("le"), (ExchangeNode.Scope)ExchangeNode.Scope.LOCAL, (PlanNode)remoteExchange2, (List)ImmutableList.of((Object)new Symbol((Type)BigintType.BIGINT, "orderkey_0")), Optional.empty());
        JoinNode join = this.join("join", (PlanNode)ts1, (PlanNode)localExchange, JoinNode.DistributionType.REPLICATED, "orderkey", "orderkey_0");
        ImmutableMap stats = ImmutableMap.builder().put((Object)"join", (Object)TestCostCalculator.statsEstimate((PlanNode)join, 12000.0)).put((Object)"re2", (Object)TestCostCalculator.statsEstimate((PlanNode)remoteExchange2, 10000.0)).put((Object)"le", (Object)TestCostCalculator.statsEstimate((PlanNode)localExchange, 6000.0)).put((Object)"ts1", (Object)TestCostCalculator.statsEstimate((PlanNode)ts1, 6000.0)).put((Object)"ts2", (Object)TestCostCalculator.statsEstimate((PlanNode)ts2, 1000.0)).buildOrThrow();
        this.assertFragmentedEqualsUnfragmented((PlanNode)join, (Map<String, PlanNodeStatsEstimate>)stats);
    }

    @Test
    public void testUnion() {
        TableScanNode ts1 = this.tableScan("ts1", new Symbol((Type)BigintType.BIGINT, "orderkey"));
        TableScanNode ts2 = this.tableScan("ts2", new Symbol((Type)BigintType.BIGINT, "orderkey_0"));
        ImmutableListMultimap.Builder outputMappings = ImmutableListMultimap.builder();
        outputMappings.put((Object)new Symbol((Type)BigintType.BIGINT, "orderkey_1"), (Object)new Symbol((Type)BigintType.BIGINT, "orderkey"));
        outputMappings.put((Object)new Symbol((Type)BigintType.BIGINT, "orderkey_1"), (Object)new Symbol((Type)BigintType.BIGINT, "orderkey_0"));
        UnionNode union = new UnionNode(new PlanNodeId("union"), (List)ImmutableList.of((Object)ts1, (Object)ts2), (ListMultimap)outputMappings.build(), (List)ImmutableList.of((Object)new Symbol((Type)BigintType.BIGINT, "orderkey_1")));
        ImmutableMap stats = ImmutableMap.of((Object)"ts1", (Object)TestCostCalculator.statsEstimate((PlanNode)ts1, 4000.0), (Object)"ts2", (Object)TestCostCalculator.statsEstimate((PlanNode)ts2, 1000.0), (Object)"union", (Object)TestCostCalculator.statsEstimate((PlanNode)ts1, 5000.0));
        ImmutableMap costs = ImmutableMap.of((Object)"ts1", (Object)TestCostCalculator.cpuCost(1000.0), (Object)"ts2", (Object)TestCostCalculator.cpuCost(1000.0));
        this.assertCost((PlanNode)union, (Map<String, PlanCostEstimate>)costs, (Map<String, PlanNodeStatsEstimate>)stats).cpu(2000.0).memory(0.0).network(0.0);
        this.assertCostEstimatedExchanges((PlanNode)union, (Map<String, PlanCostEstimate>)costs, (Map<String, PlanNodeStatsEstimate>)stats).cpu(2000.0).memory(0.0).network(5625.0);
    }

    @Test
    public void testLimit() {
        TableScanNode ts1 = this.tableScan("ts1", new Symbol((Type)BigintType.BIGINT, "orderkey"));
        LimitNode limit = new LimitNode(new PlanNodeId("limit"), (PlanNode)ts1, 5L, false);
        ImmutableMap stats = ImmutableMap.of((Object)"ts1", (Object)TestCostCalculator.statsEstimate((PlanNode)ts1, 4000.0), (Object)"limit", (Object)TestCostCalculator.statsEstimate((PlanNode)ts1, 40.0));
        ImmutableMap costs = ImmutableMap.of((Object)"ts1", (Object)TestCostCalculator.cpuCost(1000.0));
        this.assertCost((PlanNode)limit, (Map<String, PlanCostEstimate>)costs, (Map<String, PlanNodeStatsEstimate>)stats).cpu(1045.0).memory(0.0).network(0.0);
        this.assertCostEstimatedExchanges((PlanNode)limit, (Map<String, PlanCostEstimate>)costs, (Map<String, PlanNodeStatsEstimate>)stats).cpu(1045.0).memory(0.0).network(0.0);
    }

    @Test
    public void testEnforceSingleRow() {
        TableScanNode ts1 = this.tableScan("ts1", new Symbol((Type)BigintType.BIGINT, "orderkey"));
        EnforceSingleRowNode singleRow = new EnforceSingleRowNode(new PlanNodeId("singleRow"), (PlanNode)ts1);
        ImmutableMap stats = ImmutableMap.of((Object)"ts1", (Object)TestCostCalculator.statsEstimate((PlanNode)ts1, 4000.0), (Object)"singleRow", (Object)TestCostCalculator.statsEstimate((PlanNode)ts1, 8.0));
        ImmutableMap costs = ImmutableMap.of((Object)"ts1", (Object)TestCostCalculator.cpuCost(1000.0));
        this.assertCost((PlanNode)singleRow, (Map<String, PlanCostEstimate>)costs, (Map<String, PlanNodeStatsEstimate>)stats).cpu(1000.0).memory(0.0).network(0.0);
        this.assertCostEstimatedExchanges((PlanNode)singleRow, (Map<String, PlanCostEstimate>)costs, (Map<String, PlanNodeStatsEstimate>)stats).cpu(1000.0).memory(0.0).network(0.0);
    }

    private CostAssertionBuilder assertCost(PlanNode node, Map<String, PlanCostEstimate> costs, Map<String, PlanNodeStatsEstimate> stats) {
        return this.assertCost(this.costCalculatorUsingExchanges, node, costs, stats);
    }

    private CostAssertionBuilder assertCostEstimatedExchanges(PlanNode node, Map<String, PlanCostEstimate> costs, Map<String, PlanNodeStatsEstimate> stats) {
        return this.assertCost(this.costCalculatorWithEstimatedExchanges, node, costs, stats);
    }

    private CostAssertionBuilder assertCostFragmentedPlan(PlanNode node, Map<String, PlanCostEstimate> costs, Map<String, PlanNodeStatsEstimate> stats) {
        CachingStatsProvider statsProvider = new CachingStatsProvider(this.statsCalculator(stats), this.session, (TableStatsProvider)new CachingTableStatsProvider(this.planTester.getPlannerContext().getMetadata(), this.session));
        TestingCostProvider costProvider = new TestingCostProvider(costs, this.costCalculatorUsingExchanges, (StatsProvider)statsProvider, this.session);
        SubPlan subPlan = this.fragment(new Plan(node, StatsAndCosts.create((PlanNode)node, (StatsProvider)statsProvider, (CostProvider)costProvider)));
        return new CostAssertionBuilder(subPlan.getFragment().getStatsAndCosts().getCosts().getOrDefault(node.getId(), PlanCostEstimate.unknown()));
    }

    private CostAssertionBuilder assertCost(CostCalculator costCalculator, PlanNode node, Map<String, PlanCostEstimate> costs, Map<String, PlanNodeStatsEstimate> stats) {
        Function<PlanNode, PlanNodeStatsEstimate> statsProvider = planNode -> (PlanNodeStatsEstimate)stats.get(planNode.getId().toString());
        PlanCostEstimate cost = this.calculateCost(costCalculator, node, this.sourceCostProvider(costCalculator, costs, statsProvider), statsProvider);
        return new CostAssertionBuilder(cost);
    }

    private Function<PlanNode, PlanCostEstimate> sourceCostProvider(CostCalculator costCalculator, Map<String, PlanCostEstimate> costs, Function<PlanNode, PlanNodeStatsEstimate> statsProvider) {
        return node -> {
            PlanCostEstimate providedCost = (PlanCostEstimate)costs.get(node.getId().toString());
            if (providedCost != null) {
                return providedCost;
            }
            return this.calculateCost(costCalculator, (PlanNode)node, this.sourceCostProvider(costCalculator, costs, statsProvider), statsProvider);
        };
    }

    private void assertCostHasUnknownComponentsForUnknownStats(PlanNode node) {
        new CostAssertionBuilder(this.calculateCost(this.costCalculatorUsingExchanges, node, planNode -> PlanCostEstimate.unknown(), planNode -> PlanNodeStatsEstimate.unknown())).hasUnknownComponents();
        new CostAssertionBuilder(this.calculateCost(this.costCalculatorWithEstimatedExchanges, node, planNode -> PlanCostEstimate.unknown(), planNode -> PlanNodeStatsEstimate.unknown())).hasUnknownComponents();
    }

    private void assertFragmentedEqualsUnfragmented(PlanNode node, Map<String, PlanNodeStatsEstimate> stats) {
        StatsCalculator statsCalculator = this.statsCalculator(stats);
        PlanCostEstimate costWithExchanges = this.calculateCost(node, this.costCalculatorUsingExchanges, statsCalculator);
        PlanCostEstimate costWithFragments = this.calculateCostFragmentedPlan(node, statsCalculator);
        Assertions.assertThat((Object)costWithExchanges).isEqualTo((Object)costWithFragments);
    }

    private StatsCalculator statsCalculator(Map<String, PlanNodeStatsEstimate> stats) {
        return (node, context) -> Objects.requireNonNull((PlanNodeStatsEstimate)stats.get(node.getId().toString()), "no stats for node");
    }

    private PlanCostEstimate calculateCost(CostCalculator costCalculator, PlanNode node, Function<PlanNode, PlanCostEstimate> costs, Function<PlanNode, PlanNodeStatsEstimate> stats) {
        return costCalculator.calculateCost(node, planNode -> Objects.requireNonNull((PlanNodeStatsEstimate)stats.apply(planNode), "no stats for node"), source -> Objects.requireNonNull((PlanCostEstimate)costs.apply(source), String.format("no cost for source: %s", source.getId())), this.session);
    }

    private PlanCostEstimate calculateCost(PlanNode node, CostCalculator costCalculator, StatsCalculator statsCalculator) {
        CachingStatsProvider statsProvider = new CachingStatsProvider(statsCalculator, this.session, (TableStatsProvider)new CachingTableStatsProvider(this.planTester.getPlannerContext().getMetadata(), this.session));
        CachingCostProvider costProvider = new CachingCostProvider(costCalculator, (StatsProvider)statsProvider, Optional.empty(), this.session);
        return costProvider.getCost(node);
    }

    private PlanCostEstimate calculateCostFragmentedPlan(PlanNode node, StatsCalculator statsCalculator) {
        CachingStatsProvider statsProvider = new CachingStatsProvider(statsCalculator, this.session, (TableStatsProvider)new CachingTableStatsProvider(this.planTester.getPlannerContext().getMetadata(), this.session));
        CachingCostProvider costProvider = new CachingCostProvider(this.costCalculatorUsingExchanges, (StatsProvider)statsProvider, Optional.empty(), this.session);
        SubPlan subPlan = this.fragment(new Plan(node, StatsAndCosts.create((PlanNode)node, (StatsProvider)statsProvider, (CostProvider)costProvider)));
        return subPlan.getFragment().getStatsAndCosts().getCosts().getOrDefault(node.getId(), PlanCostEstimate.unknown());
    }

    private static PlanNodeStatsEstimate statsEstimate(PlanNode node, double outputSizeInBytes) {
        return TestCostCalculator.statsEstimate(node.getOutputSymbols(), outputSizeInBytes);
    }

    private static PlanNodeStatsEstimate statsEstimate(Collection<Symbol> symbols, double outputSizeInBytes) {
        Preconditions.checkArgument((symbols.size() > 0 ? 1 : 0) != 0, (Object)"No symbols");
        Preconditions.checkArgument((ImmutableSet.copyOf(symbols).size() == symbols.size() ? 1 : 0) != 0, (Object)"Duplicate symbols");
        double rowCount = outputSizeInBytes / (double)symbols.size() / 8.0;
        PlanNodeStatsEstimate.Builder builder = PlanNodeStatsEstimate.builder().setOutputRowCount(rowCount);
        for (Symbol symbol : symbols) {
            builder.addSymbolStatistics(symbol, SymbolStatsEstimate.builder().setNullsFraction(0.0).setAverageRowSize(8.0).build());
        }
        return builder.build();
    }

    private TableScanNode tableScan(String id, Symbol ... symbols) {
        ImmutableList symbolsList = ImmutableList.copyOf((Object[])symbols);
        ImmutableMap.Builder assignments = ImmutableMap.builder();
        for (Symbol symbol : symbolsList) {
            assignments.put((Object)symbol, (Object)new TpchColumnHandle("orderkey", (Type)BigintType.BIGINT));
        }
        return new TableScanNode(new PlanNodeId(id), this.planTester.getTableHandle("test_catalog", "sf1", "orders"), (List)symbolsList, (Map)assignments.buildOrThrow(), TupleDomain.all(), Optional.empty(), false, Optional.of(false));
    }

    private PlanNode project(String id, PlanNode source, Symbol symbol, Expression expression) {
        return new ProjectNode(new PlanNodeId(id), source, Assignments.of((Symbol)symbol, (Expression)expression));
    }

    private AggregationNode aggregation(String id, PlanNode source) {
        AggregationNode.Aggregation aggregation = new AggregationNode.Aggregation(new TestingFunctionResolution(this.planTester.getTransactionManager(), this.planTester.getPlannerContext()).resolveFunction("count", (List<TypeSignatureProvider>)ImmutableList.of()), (List)ImmutableList.of(), false, Optional.empty(), Optional.empty(), Optional.empty());
        return AggregationNode.singleAggregation((PlanNodeId)new PlanNodeId(id), (PlanNode)source, (Map)ImmutableMap.of((Object)new Symbol((Type)BigintType.BIGINT, "count"), (Object)aggregation), (AggregationNode.GroupingSetDescriptor)AggregationNode.singleGroupingSet((List)source.getOutputSymbols()));
    }

    private JoinNode join(String planNodeId, PlanNode left, PlanNode right, JoinNode.DistributionType distributionType, String ... symbols) {
        Preconditions.checkArgument((symbols.length % 2 == 0 ? 1 : 0) != 0);
        ImmutableList.Builder criteria = ImmutableList.builder();
        for (int i = 0; i < symbols.length; i += 2) {
            criteria.add((Object)new JoinNode.EquiJoinClause(new Symbol((Type)BigintType.BIGINT, symbols[i]), new Symbol((Type)BigintType.BIGINT, symbols[i + 1])));
        }
        return new JoinNode(new PlanNodeId(planNodeId), JoinType.INNER, left, right, (List)criteria.build(), left.getOutputSymbols(), right.getOutputSymbols(), false, Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(distributionType), Optional.empty(), (Map)ImmutableMap.of(), Optional.empty());
    }

    private SubPlan fragment(Plan plan) {
        return this.inTransaction(session -> this.planFragmenter.createSubPlans(session, plan, false, WarningCollector.NOOP));
    }

    private <T> T inTransaction(Function<Session, T> transactionSessionConsumer) {
        Metadata metadata = this.planTester.getPlannerContext().getMetadata();
        return (T)TransactionBuilder.transaction((TransactionManager)this.planTester.getTransactionManager(), (Metadata)metadata, (AccessControl)new AllowAllAccessControl()).singleStatement().execute(this.session, session -> {
            session.getCatalog().ifPresent(catalog -> metadata.getCatalogHandle(session, catalog));
            return transactionSessionConsumer.apply((Session)session);
        });
    }

    private static PlanCostEstimate cpuCost(double cpuCost) {
        return new PlanCostEstimate(cpuCost, 0.0, 0.0, 0.0);
    }

    private static class CostAssertionBuilder {
        private final PlanCostEstimate actual;

        CostAssertionBuilder(PlanCostEstimate actual) {
            this.actual = Objects.requireNonNull(actual, "actual is null");
        }

        CostAssertionBuilder cpu(double value) {
            Assertions.assertThat((double)this.actual.getCpuCost()).isCloseTo(value, Assertions.offset((Double)1.0E-6));
            return this;
        }

        CostAssertionBuilder memory(double value) {
            Assertions.assertThat((double)this.actual.getMaxMemory()).isCloseTo(value, Assertions.offset((Double)1.0E-6));
            return this;
        }

        CostAssertionBuilder memoryWhenOutputting(double value) {
            Assertions.assertThat((double)this.actual.getMaxMemoryWhenOutputting()).isCloseTo(value, Assertions.offset((Double)1.0E-6));
            return this;
        }

        CostAssertionBuilder network(double value) {
            Assertions.assertThat((double)this.actual.getNetworkCost()).isCloseTo(value, Assertions.offset((Double)1.0E-6));
            return this;
        }

        CostAssertionBuilder hasUnknownComponents() {
            Assertions.assertThat((boolean)this.actual.hasUnknownComponents()).isTrue();
            return this;
        }
    }

    private static class TestingCostProvider
    implements CostProvider {
        private final Map<String, PlanCostEstimate> costs;
        private final CostCalculator costCalculator;
        private final StatsProvider statsProvider;
        private final Session session;

        private TestingCostProvider(Map<String, PlanCostEstimate> costs, CostCalculator costCalculator, StatsProvider statsProvider, Session session) {
            this.costs = ImmutableMap.copyOf(Objects.requireNonNull(costs, "costs is null"));
            this.costCalculator = Objects.requireNonNull(costCalculator, "costCalculator is null");
            this.statsProvider = Objects.requireNonNull(statsProvider, "statsProvider is null");
            this.session = Objects.requireNonNull(session, "session is null");
        }

        public PlanCostEstimate getCost(PlanNode node) {
            if (this.costs.containsKey(node.getId().toString())) {
                return this.costs.get(node.getId().toString());
            }
            return this.costCalculator.calculateCost(node, this.statsProvider, (CostProvider)this, this.session);
        }
    }
}

