/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cost;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.Session;
import io.trino.cost.FilterStatsCalculator;
import io.trino.cost.PlanNodeStatsAssertion;
import io.trino.cost.PlanNodeStatsEstimate;
import io.trino.cost.ScalarStatsCalculator;
import io.trino.cost.StatsNormalizer;
import io.trino.cost.SymbolStatsAssertion;
import io.trino.cost.SymbolStatsEstimate;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataManager;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.plugin.base.util.JsonTypeUtil;
import io.trino.security.AccessControl;
import io.trino.security.AllowAllAccessControl;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.PlannerContext;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.ir.ArithmeticBinaryExpression;
import io.trino.sql.ir.ArithmeticNegation;
import io.trino.sql.ir.BetweenPredicate;
import io.trino.sql.ir.BooleanLiteral;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.CoalesceExpression;
import io.trino.sql.ir.ComparisonExpression;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.FunctionCall;
import io.trino.sql.ir.InPredicate;
import io.trino.sql.ir.IsNullPredicate;
import io.trino.sql.ir.LogicalExpression;
import io.trino.sql.ir.NotExpression;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.TestingPlannerContext;
import io.trino.testing.TestingSession;
import io.trino.testing.TransactionBuilder;
import io.trino.transaction.TestingTransactionManager;
import io.trino.transaction.TransactionManager;
import io.trino.type.JsonType;
import io.trino.type.UnknownType;
import java.math.BigDecimal;
import java.util.List;
import java.util.function.Consumer;
import org.junit.jupiter.api.Test;

public class TestFilterStatsCalculator {
    private static final TestingTransactionManager TRANSACTION_MANAGER = new TestingTransactionManager();
    private static final PlannerContext PLANNER_CONTEXT = TestingPlannerContext.plannerContextBuilder().withTransactionManager(TRANSACTION_MANAGER).build();
    private static final VarcharType MEDIUM_VARCHAR_TYPE = VarcharType.createVarcharType((int)100);
    private final SymbolStatsEstimate xStats = SymbolStatsEstimate.builder().setAverageRowSize(4.0).setDistinctValuesCount(40.0).setLowValue(-10.0).setHighValue(10.0).setNullsFraction(0.25).build();
    private final SymbolStatsEstimate yStats = SymbolStatsEstimate.builder().setAverageRowSize(4.0).setDistinctValuesCount(20.0).setLowValue(0.0).setHighValue(5.0).setNullsFraction(0.5).build();
    private final SymbolStatsEstimate zStats = SymbolStatsEstimate.builder().setAverageRowSize(4.0).setDistinctValuesCount(5.0).setLowValue(-100.0).setHighValue(100.0).setNullsFraction(0.1).build();
    private final SymbolStatsEstimate leftOpenStats = SymbolStatsEstimate.builder().setAverageRowSize(4.0).setDistinctValuesCount(50.0).setLowValue(Double.NEGATIVE_INFINITY).setHighValue(15.0).setNullsFraction(0.1).build();
    private final SymbolStatsEstimate rightOpenStats = SymbolStatsEstimate.builder().setAverageRowSize(4.0).setDistinctValuesCount(50.0).setLowValue(-15.0).setHighValue(Double.POSITIVE_INFINITY).setNullsFraction(0.1).build();
    private final SymbolStatsEstimate unknownRangeStats = SymbolStatsEstimate.builder().setAverageRowSize(4.0).setDistinctValuesCount(50.0).setLowValue(Double.NEGATIVE_INFINITY).setHighValue(Double.POSITIVE_INFINITY).setNullsFraction(0.1).build();
    private final SymbolStatsEstimate emptyRangeStats = SymbolStatsEstimate.builder().setAverageRowSize(0.0).setDistinctValuesCount(0.0).setLowValue(Double.NaN).setHighValue(Double.NaN).setNullsFraction(Double.NaN).build();
    private final SymbolStatsEstimate mediumVarcharStats = SymbolStatsEstimate.builder().setAverageRowSize(85.0).setDistinctValuesCount(165.0).setLowValue(Double.NEGATIVE_INFINITY).setHighValue(Double.POSITIVE_INFINITY).setNullsFraction(0.34).build();
    private final FilterStatsCalculator statsCalculator = new FilterStatsCalculator(PLANNER_CONTEXT, new ScalarStatsCalculator(PLANNER_CONTEXT), new StatsNormalizer());
    private final PlanNodeStatsEstimate standardInputStatistics = PlanNodeStatsEstimate.builder().addSymbolStatistics(new Symbol((Type)UnknownType.UNKNOWN, "x"), this.xStats).addSymbolStatistics(new Symbol((Type)UnknownType.UNKNOWN, "y"), this.yStats).addSymbolStatistics(new Symbol((Type)UnknownType.UNKNOWN, "z"), this.zStats).addSymbolStatistics(new Symbol((Type)UnknownType.UNKNOWN, "leftOpen"), this.leftOpenStats).addSymbolStatistics(new Symbol((Type)UnknownType.UNKNOWN, "rightOpen"), this.rightOpenStats).addSymbolStatistics(new Symbol((Type)UnknownType.UNKNOWN, "unknownRange"), this.unknownRangeStats).addSymbolStatistics(new Symbol((Type)UnknownType.UNKNOWN, "emptyRange"), this.emptyRangeStats).addSymbolStatistics(new Symbol((Type)UnknownType.UNKNOWN, "mediumVarchar"), this.mediumVarcharStats).setOutputRowCount(1000.0).build();
    private final PlanNodeStatsEstimate zeroStatistics = PlanNodeStatsEstimate.builder().addSymbolStatistics(new Symbol((Type)UnknownType.UNKNOWN, "x"), SymbolStatsEstimate.zero()).addSymbolStatistics(new Symbol((Type)UnknownType.UNKNOWN, "y"), SymbolStatsEstimate.zero()).addSymbolStatistics(new Symbol((Type)UnknownType.UNKNOWN, "z"), SymbolStatsEstimate.zero()).addSymbolStatistics(new Symbol((Type)UnknownType.UNKNOWN, "leftOpen"), SymbolStatsEstimate.zero()).addSymbolStatistics(new Symbol((Type)UnknownType.UNKNOWN, "rightOpen"), SymbolStatsEstimate.zero()).addSymbolStatistics(new Symbol((Type)UnknownType.UNKNOWN, "unknownRange"), SymbolStatsEstimate.zero()).addSymbolStatistics(new Symbol((Type)UnknownType.UNKNOWN, "emptyRange"), SymbolStatsEstimate.zero()).addSymbolStatistics(new Symbol((Type)UnknownType.UNKNOWN, "mediumVarchar"), SymbolStatsEstimate.zero()).setOutputRowCount(0.0).build();
    private final Session session = TestingSession.testSessionBuilder().build();
    private static final TestingFunctionResolution FUNCTIONS = new TestingFunctionResolution();
    private static final ResolvedFunction JSON_ARRAY_CONTAINS = FUNCTIONS.resolveFunction("json_array_contains", TypeSignatureProvider.fromTypes((Type[])new Type[]{JsonType.JSON, DoubleType.DOUBLE}));
    private static final ResolvedFunction SIN = FUNCTIONS.resolveFunction("sin", TypeSignatureProvider.fromTypes((Type[])new Type[]{DoubleType.DOUBLE}));
    private static final ResolvedFunction ADD_DOUBLE = FUNCTIONS.resolveOperator(OperatorType.ADD, (List<? extends Type>)ImmutableList.of((Object)DoubleType.DOUBLE, (Object)DoubleType.DOUBLE));
    private static final ResolvedFunction SUBTRACT_DOUBLE = FUNCTIONS.resolveOperator(OperatorType.SUBTRACT, (List<? extends Type>)ImmutableList.of((Object)DoubleType.DOUBLE, (Object)DoubleType.DOUBLE));
    private static final ResolvedFunction MULTIPLY_DOUBLE = FUNCTIONS.resolveOperator(OperatorType.MULTIPLY, (List<? extends Type>)ImmutableList.of((Object)DoubleType.DOUBLE, (Object)DoubleType.DOUBLE));
    private static final ResolvedFunction SUBTRACT_INTEGER = FUNCTIONS.resolveOperator(OperatorType.SUBTRACT, (List<? extends Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER));
    private static final ResolvedFunction ADD_INTEGER = FUNCTIONS.resolveOperator(OperatorType.ADD, (List<? extends Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER));

    @Test
    public void testBooleanLiteralStats() {
        this.assertExpression((Expression)BooleanLiteral.TRUE_LITERAL).equalTo(this.standardInputStatistics);
        this.assertExpression((Expression)BooleanLiteral.FALSE_LITERAL).equalTo(this.zeroStatistics);
        this.assertExpression((Expression)new Constant((Type)BooleanType.BOOLEAN, null)).equalTo(this.zeroStatistics);
    }

    @Test
    public void testComparison() {
        double lessThan3Rows = 487.5;
        this.assertExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "x"), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)3.0))).outputRowsCount(lessThan3Rows).symbolStats(new Symbol((Type)UnknownType.UNKNOWN, "x"), symbolAssert -> symbolAssert.averageRowSize(4.0).lowValue(-10.0).highValue(3.0).distinctValuesCount(26.0).nullsFraction(0.0));
        this.assertExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new ArithmeticNegation((Expression)new SymbolReference((Type)DoubleType.DOUBLE, "x")), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)-3.0))).outputRowsCount(lessThan3Rows);
        for (Expression minusThree : ImmutableList.of((Object)new Constant((Type)DecimalType.createDecimalType((int)3), (Object)Decimals.valueOfShort((BigDecimal)new BigDecimal("-3"))), (Object)new Constant((Type)DoubleType.DOUBLE, (Object)-3.0), (Object)new ArithmeticBinaryExpression(SUBTRACT_DOUBLE, ArithmeticBinaryExpression.Operator.SUBTRACT, (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)4.0), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)7.0)), (Object)new Cast((Expression)new Constant((Type)IntegerType.INTEGER, (Object)-3L), (Type)DecimalType.createDecimalType((int)7, (int)3)))) {
            this.assertExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "x"), (Expression)new Cast(minusThree, (Type)DoubleType.DOUBLE))).outputRowsCount(18.75).symbolStats(new Symbol((Type)UnknownType.UNKNOWN, "x"), symbolAssert -> symbolAssert.averageRowSize(4.0).lowValue(-3.0).highValue(-3.0).distinctValuesCount(1.0).nullsFraction(0.0));
            this.assertExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new Cast(minusThree, (Type)DoubleType.DOUBLE), (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "x"))).outputRowsCount(18.75).symbolStats(new Symbol((Type)UnknownType.UNKNOWN, "x"), symbolAssert -> symbolAssert.averageRowSize(4.0).lowValue(-3.0).highValue(-3.0).distinctValuesCount(1.0).nullsFraction(0.0));
            this.assertExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new CoalesceExpression((Expression)new ArithmeticBinaryExpression(MULTIPLY_DOUBLE, ArithmeticBinaryExpression.Operator.MULTIPLY, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "x"), (Expression)new Constant((Type)DoubleType.DOUBLE, null)), (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "x"), new Expression[0]), (Expression)new Cast(minusThree, (Type)DoubleType.DOUBLE))).outputRowsCount(18.75).symbolStats(new Symbol((Type)UnknownType.UNKNOWN, "x"), symbolAssert -> symbolAssert.averageRowSize(4.0).lowValue(-3.0).highValue(-3.0).distinctValuesCount(1.0).nullsFraction(0.0));
            this.assertExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "x"), (Expression)new Cast(minusThree, (Type)DoubleType.DOUBLE))).outputRowsCount(262.5).symbolStats(new Symbol((Type)UnknownType.UNKNOWN, "x"), symbolAssert -> symbolAssert.averageRowSize(4.0).lowValue(-10.0).highValue(-3.0).distinctValuesCount(14.0).nullsFraction(0.0));
            this.assertExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new Cast(minusThree, (Type)DoubleType.DOUBLE), (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "x"))).outputRowsCount(262.5).symbolStats(new Symbol((Type)UnknownType.UNKNOWN, "x"), symbolAssert -> symbolAssert.averageRowSize(4.0).lowValue(-10.0).highValue(-3.0).distinctValuesCount(14.0).nullsFraction(0.0));
        }
    }

    @Test
    public void testInequalityComparisonApproximation() {
        this.assertExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "x"), (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "emptyRange"))).outputRowsCount(0.0);
        this.assertExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "x"), (Expression)new ArithmeticBinaryExpression(ADD_INTEGER, ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "y"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)20L)))).outputRowsCount(0.0);
        this.assertExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "x"), (Expression)new ArithmeticBinaryExpression(ADD_INTEGER, ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "y"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)20L)))).outputRowsCount(0.0);
        this.assertExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "x"), (Expression)new ArithmeticBinaryExpression(SUBTRACT_INTEGER, ArithmeticBinaryExpression.Operator.SUBTRACT, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "y"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)25L)))).outputRowsCount(0.0);
        this.assertExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "x"), (Expression)new ArithmeticBinaryExpression(SUBTRACT_INTEGER, ArithmeticBinaryExpression.Operator.SUBTRACT, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "y"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)25L)))).outputRowsCount(0.0);
        double nullsFractionY = 0.5;
        double inputRowCount = this.standardInputStatistics.getOutputRowCount();
        double nonNullRowCount = inputRowCount * (1.0 - nullsFractionY);
        SymbolStatsEstimate nonNullStatsX = this.xStats.mapNullsFraction(nullsFraction -> 0.0);
        this.assertExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "x"), (Expression)new ArithmeticBinaryExpression(SUBTRACT_INTEGER, ArithmeticBinaryExpression.Operator.SUBTRACT, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "y"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)25L)))).outputRowsCount(nonNullRowCount).symbolStats("x", symbolAssert -> symbolAssert.isEqualTo(nonNullStatsX));
        this.assertExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "x"), (Expression)new ArithmeticBinaryExpression(SUBTRACT_INTEGER, ArithmeticBinaryExpression.Operator.SUBTRACT, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "y"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)25L)))).outputRowsCount(nonNullRowCount).symbolStats("x", symbolAssert -> symbolAssert.isEqualTo(nonNullStatsX));
        this.assertExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "x"), (Expression)new ArithmeticBinaryExpression(ADD_INTEGER, ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "y"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)20L)))).outputRowsCount(nonNullRowCount).symbolStats("x", symbolAssert -> symbolAssert.isEqualTo(nonNullStatsX));
        this.assertExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "x"), (Expression)new ArithmeticBinaryExpression(ADD_INTEGER, ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "y"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)20L)))).outputRowsCount(nonNullRowCount).symbolStats("x", symbolAssert -> symbolAssert.isEqualTo(nonNullStatsX));
    }

    @Test
    public void testOrStats() {
        this.assertExpression((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "x"), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)0.0)), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "x"), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)-7.5))))).outputRowsCount(375.0).symbolStats(new Symbol((Type)UnknownType.UNKNOWN, "x"), symbolAssert -> symbolAssert.averageRowSize(4.0).lowValue(-10.0).highValue(0.0).distinctValuesCount(20.0).nullsFraction(0.0));
        this.assertExpression((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "x"), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)0.0)), (Object)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "x"), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)-7.5))))).outputRowsCount(37.5).symbolStats(new Symbol((Type)UnknownType.UNKNOWN, "x"), symbolAssert -> symbolAssert.averageRowSize(4.0).lowValue(-7.5).highValue(0.0).distinctValuesCount(2.0).nullsFraction(0.0));
        this.assertExpression((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "x"), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)1.0)), (Object)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "x"), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)3.0))))).outputRowsCount(37.5).symbolStats(new Symbol((Type)UnknownType.UNKNOWN, "x"), symbolAssert -> symbolAssert.averageRowSize(4.0).lowValue(1.0).highValue(3.0).distinctValuesCount(2.0).nullsFraction(0.0));
        this.assertExpression((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "x"), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)1.0)), (Object)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"a")), (Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"b"))), (Object)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "x"), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)3.0))))).outputRowsCount(37.5).symbolStats(new Symbol((Type)UnknownType.UNKNOWN, "x"), symbolAssert -> symbolAssert.averageRowSize(4.0).lowValue(1.0).highValue(3.0).distinctValuesCount(2.0).nullsFraction(0.0));
        this.assertExpression((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "x"), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)1.0)), (Object)new InPredicate((Expression)new Cast((Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"b")), (Type)VarcharType.createVarcharType((int)3)), (List)ImmutableList.of((Object)new Cast((Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"a")), (Type)VarcharType.createVarcharType((int)3)), (Object)new Cast((Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"b")), (Type)VarcharType.createVarcharType((int)3)))), (Object)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "x"), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)3.0))))).equalTo(this.standardInputStatistics);
    }

    @Test
    public void testUnsupportedExpression() {
        this.assertExpression((Expression)new FunctionCall(SIN, (List)ImmutableList.of((Object)new SymbolReference((Type)DoubleType.DOUBLE, "x")))).outputRowsCountUnknown();
        this.assertExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "x"), (Expression)new FunctionCall(SIN, (List)ImmutableList.of((Object)new SymbolReference((Type)DoubleType.DOUBLE, "x"))))).outputRowsCountUnknown();
    }

    @Test
    public void testAndStats() {
        this.assertExpression((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "x"), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)0.0)), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "x"), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)1.0)))), PlanNodeStatsEstimate.unknown()).outputRowsCountUnknown();
        this.assertExpression((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "x"), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)0.0)), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "y"), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)1.0)))), PlanNodeStatsEstimate.unknown()).outputRowsCountUnknown();
        this.assertExpression((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "x"), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)0.0)), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "x"), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)1.0)))), this.zeroStatistics).equalTo(this.zeroStatistics);
        this.assertExpression((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "x"), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)0.0)), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "y"), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)1.0)))), this.zeroStatistics).equalTo(this.zeroStatistics);
        this.assertExpression((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "x"), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)0.0)), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "x"), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)1.0))))).equalTo(this.zeroStatistics);
        this.assertExpression((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "x"), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)0.0)), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "x"), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)-7.5))))).outputRowsCount(281.25).symbolStats(new Symbol((Type)UnknownType.UNKNOWN, "x"), symbolAssert -> symbolAssert.averageRowSize(4.0).lowValue(-7.5).highValue(0.0).distinctValuesCount(15.0).nullsFraction(0.0));
        this.assertExpression((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "x"), (Expression)new ArithmeticBinaryExpression(ADD_DOUBLE, ArithmeticBinaryExpression.Operator.ADD, (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)0.0), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)1.0))), (Object)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "x"), (Expression)new ArithmeticBinaryExpression(ADD_DOUBLE, ArithmeticBinaryExpression.Operator.ADD, (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)0.0), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)3.0)))))).outputRowsCount(0.0).symbolStats(new Symbol((Type)UnknownType.UNKNOWN, "x"), SymbolStatsAssertion::emptyRange).symbolStats(new Symbol((Type)UnknownType.UNKNOWN, "y"), SymbolStatsAssertion::emptyRange);
        this.assertExpression((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new FunctionCall(JSON_ARRAY_CONTAINS, (List)ImmutableList.of((Object)new Constant((Type)JsonType.JSON, (Object)JsonTypeUtil.jsonParse((Slice)Slices.utf8Slice((String)"[]"))), (Object)new SymbolReference((Type)DoubleType.DOUBLE, "x"))), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "x"), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)0.0))))).outputRowsCount(337.5).symbolStats(new Symbol((Type)UnknownType.UNKNOWN, "x"), symbolAssert -> symbolAssert.lowValue(-10.0).highValue(0.0).distinctValuesCount(20.0).nullsFraction(0.0));
        this.assertExpression((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "x"), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)0.0)), (Object)new FunctionCall(JSON_ARRAY_CONTAINS, (List)ImmutableList.of((Object)new Constant((Type)JsonType.JSON, (Object)JsonTypeUtil.jsonParse((Slice)Slices.utf8Slice((String)"[]"))), (Object)new SymbolReference((Type)DoubleType.DOUBLE, "x")))))).outputRowsCount(337.5).symbolStats(new Symbol((Type)UnknownType.UNKNOWN, "x"), symbolAssert -> symbolAssert.lowValue(-10.0).highValue(0.0).distinctValuesCount(20.0).nullsFraction(0.0));
        this.assertExpression((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new FunctionCall(JSON_ARRAY_CONTAINS, (List)ImmutableList.of((Object)new Constant((Type)JsonType.JSON, (Object)JsonTypeUtil.jsonParse((Slice)Slices.utf8Slice((String)"[11]"))), (Object)new SymbolReference((Type)DoubleType.DOUBLE, "x"))), (Object)new FunctionCall(JSON_ARRAY_CONTAINS, (List)ImmutableList.of((Object)new Constant((Type)JsonType.JSON, (Object)JsonTypeUtil.jsonParse((Slice)Slices.utf8Slice((String)"[13]"))), (Object)new SymbolReference((Type)DoubleType.DOUBLE, "x")))))).outputRowsCountUnknown();
        this.assertExpression((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new InPredicate((Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"a")), (List)ImmutableList.of((Object)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"b")), (Object)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"c")))), (Object)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "unknownRange"), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)3.0))))).outputRowsCount(0.0);
        this.assertExpression((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new Constant((Type)BooleanType.BOOLEAN, null), (Object)new Constant((Type)BooleanType.BOOLEAN, null)))).equalTo(this.zeroStatistics);
        this.assertExpression((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new Constant((Type)BooleanType.BOOLEAN, null), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "x"), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)0.0)), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "x"), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)1.0))))))).equalTo(this.zeroStatistics);
        Consumer<SymbolStatsAssertion> symbolAssertX = symbolAssert -> symbolAssert.averageRowSize(4.0).lowValue(-5.0).highValue(5.0).distinctValuesCount(20.0).nullsFraction(0.0);
        Consumer<SymbolStatsAssertion> symbolAssertY = symbolAssert -> symbolAssert.averageRowSize(4.0).lowValue(1.0).highValue(5.0).distinctValuesCount(16.0).nullsFraction(0.0);
        double inputRowCount = this.standardInputStatistics.getOutputRowCount();
        double filterSelectivityX = 0.375;
        double inequalityFilterSelectivityY = 0.4;
        this.assertExpression((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new BetweenPredicate((Expression)new SymbolReference((Type)DoubleType.DOUBLE, "x"), (Expression)new Cast((Expression)new Constant((Type)IntegerType.INTEGER, (Object)-5L), (Type)DoubleType.DOUBLE), (Expression)new Cast((Expression)new Constant((Type)IntegerType.INTEGER, (Object)5L), (Type)DoubleType.DOUBLE)), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "y"), (Expression)new Cast((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Type)DoubleType.DOUBLE)))), Session.builder((Session)this.session).setSystemProperty("filter_conjunction_independence_factor", "0").build()).outputRowsCount(filterSelectivityX * inputRowCount).symbolStats("x", symbolAssertX).symbolStats("y", symbolAssertY);
        this.assertExpression((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new BetweenPredicate((Expression)new SymbolReference((Type)DoubleType.DOUBLE, "x"), (Expression)new Cast((Expression)new Constant((Type)IntegerType.INTEGER, (Object)-5L), (Type)DoubleType.DOUBLE), (Expression)new Cast((Expression)new Constant((Type)IntegerType.INTEGER, (Object)5L), (Type)DoubleType.DOUBLE)), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "y"), (Expression)new Cast((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Type)DoubleType.DOUBLE)))), Session.builder((Session)this.session).setSystemProperty("filter_conjunction_independence_factor", "1").build()).outputRowsCount(filterSelectivityX * inequalityFilterSelectivityY * inputRowCount).symbolStats("x", symbolAssertX).symbolStats("y", symbolAssertY);
        this.assertExpression((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new BetweenPredicate((Expression)new SymbolReference((Type)DoubleType.DOUBLE, "x"), (Expression)new Cast((Expression)new Constant((Type)IntegerType.INTEGER, (Object)-5L), (Type)DoubleType.DOUBLE), (Expression)new Cast((Expression)new Constant((Type)IntegerType.INTEGER, (Object)5L), (Type)DoubleType.DOUBLE)), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "y"), (Expression)new Cast((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Type)DoubleType.DOUBLE)))), Session.builder((Session)this.session).setSystemProperty("filter_conjunction_independence_factor", "0.5").build()).outputRowsCount(filterSelectivityX * Math.pow(inequalityFilterSelectivityY, 0.5) * inputRowCount).symbolStats("x", symbolAssertX).symbolStats("y", symbolAssertY);
        double nullFilterSelectivityY = 0.5;
        this.assertExpression((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new BetweenPredicate((Expression)new SymbolReference((Type)DoubleType.DOUBLE, "x"), (Expression)new Cast((Expression)new Constant((Type)IntegerType.INTEGER, (Object)-5L), (Type)DoubleType.DOUBLE), (Expression)new Cast((Expression)new Constant((Type)IntegerType.INTEGER, (Object)5L), (Type)DoubleType.DOUBLE)), (Object)new IsNullPredicate((Expression)new SymbolReference((Type)DoubleType.DOUBLE, "y")))), Session.builder((Session)this.session).setSystemProperty("filter_conjunction_independence_factor", "1").build()).outputRowsCount(filterSelectivityX * nullFilterSelectivityY * inputRowCount).symbolStats("x", symbolAssertX).symbolStats("y", symbolAssert -> symbolAssert.isEqualTo(SymbolStatsEstimate.zero()));
        this.assertExpression((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new BetweenPredicate((Expression)new SymbolReference((Type)DoubleType.DOUBLE, "x"), (Expression)new Cast((Expression)new Constant((Type)IntegerType.INTEGER, (Object)-5L), (Type)DoubleType.DOUBLE), (Expression)new Cast((Expression)new Constant((Type)IntegerType.INTEGER, (Object)5L), (Type)DoubleType.DOUBLE)), (Object)new IsNullPredicate((Expression)new SymbolReference((Type)DoubleType.DOUBLE, "y")))), Session.builder((Session)this.session).setSystemProperty("filter_conjunction_independence_factor", "0.5").build()).outputRowsCount(filterSelectivityX * Math.pow(nullFilterSelectivityY, 0.5) * inputRowCount).symbolStats("x", symbolAssertX).symbolStats("y", symbolAssert -> symbolAssert.isEqualTo(SymbolStatsEstimate.zero()));
        this.assertExpression((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new BetweenPredicate((Expression)new SymbolReference((Type)DoubleType.DOUBLE, "x"), (Expression)new Cast((Expression)new Constant((Type)IntegerType.INTEGER, (Object)-5L), (Type)DoubleType.DOUBLE), (Expression)new Cast((Expression)new Constant((Type)IntegerType.INTEGER, (Object)5L), (Type)DoubleType.DOUBLE)), (Object)new IsNullPredicate((Expression)new SymbolReference((Type)DoubleType.DOUBLE, "y")))), Session.builder((Session)this.session).setSystemProperty("filter_conjunction_independence_factor", "0").build()).outputRowsCount(filterSelectivityX * inputRowCount).symbolStats("x", symbolAssertX).symbolStats("y", symbolAssert -> symbolAssert.isEqualTo(SymbolStatsEstimate.zero()));
        this.assertExpression((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "y"), (Expression)new Cast((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Type)DoubleType.DOUBLE)), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new Cast((Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Type)DoubleType.DOUBLE), (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "y")))), Session.builder((Session)this.session).setSystemProperty("filter_conjunction_independence_factor", "0.5").build()).outputRowsCount(100.0).symbolStats("y", symbolAssert -> symbolAssert.averageRowSize(4.0).lowValue(0.0).highValue(1.0).distinctValuesCount(4.0).nullsFraction(0.0));
        this.assertExpression((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "x"), (Expression)new Cast((Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Type)DoubleType.DOUBLE)), (Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "y"), (Expression)new Cast((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Type)DoubleType.DOUBLE)), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "y"), (Expression)new Cast((Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Type)DoubleType.DOUBLE)))))), Session.builder((Session)this.session).setSystemProperty("filter_conjunction_independence_factor", "0.5").build()).outputRowsCount(filterSelectivityX * Math.pow(inequalityFilterSelectivityY, 0.5) * inputRowCount).symbolStats("x", symbolAssert -> symbolAssert.averageRowSize(4.0).lowValue(0.0).highValue(10.0).distinctValuesCount(20.0).nullsFraction(0.0)).symbolStats("y", symbolAssert -> symbolAssert.averageRowSize(4.0).lowValue(0.0).highValue(5.0).distinctValuesCount(16.0).nullsFraction(0.0));
        this.assertExpression((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "x"), (Expression)new Cast((Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Type)DoubleType.DOUBLE)), (Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "x"), (Expression)new Cast((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Type)DoubleType.DOUBLE)), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "y"), (Expression)new Cast((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Type)DoubleType.DOUBLE)))))), Session.builder((Session)this.session).setSystemProperty("filter_conjunction_independence_factor", "0.5").build()).outputRowsCount(172.0).symbolStats("x", symbolAssert -> symbolAssert.averageRowSize(4.0).lowValue(0.0).highValue(10.0).distinctValuesCount(20.0).nullsFraction(0.0)).symbolStats("y", symbolAssert -> symbolAssert.averageRowSize(4.0).lowValue(0.0).highValue(5.0).distinctValuesCount(20.0).nullsFraction(0.1053779069));
        this.assertExpression((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new InPredicate((Expression)new SymbolReference((Type)DoubleType.DOUBLE, "x"), (List)ImmutableList.of((Object)new Cast((Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Type)DoubleType.DOUBLE), (Object)new Cast((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Type)DoubleType.DOUBLE), (Object)new Cast((Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Type)DoubleType.DOUBLE))), (Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "x"), (Expression)new Cast((Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Type)DoubleType.DOUBLE)), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "x"), (Expression)new Cast((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Type)DoubleType.DOUBLE)), (Object)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "y"), (Expression)new Cast((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Type)DoubleType.DOUBLE)))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "x"), (Expression)new Cast((Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Type)DoubleType.DOUBLE)), (Object)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "y"), (Expression)new Cast((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Type)DoubleType.DOUBLE)))))))), Session.builder((Session)this.session).setSystemProperty("filter_conjunction_independence_factor", "0.5").build()).outputRowsCount(20.373798).symbolStats("x", symbolAssert -> symbolAssert.averageRowSize(4.0).lowValue(0.0).highValue(2.0).distinctValuesCount(2.623798).nullsFraction(0.0)).symbolStats("y", symbolAssert -> symbolAssert.averageRowSize(4.0).lowValue(0.0).highValue(5.0).distinctValuesCount(15.686298).nullsFraction(0.2300749269));
        this.assertExpression((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "x"), (Expression)new Cast((Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Type)DoubleType.DOUBLE)), (Object)new Constant((Type)BooleanType.BOOLEAN, null))), Session.builder((Session)this.session).setSystemProperty("filter_conjunction_independence_factor", "0.5").build()).outputRowsCount(filterSelectivityX * inputRowCount * 0.9).symbolStats("x", symbolAssert -> symbolAssert.averageRowSize(4.0).lowValue(0.0).highValue(10.0).distinctValuesCount(20.0).nullsFraction(0.0));
    }

    @Test
    public void testNotStats() {
        this.assertExpression((Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "x"), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)0.0)))).outputRowsCount(625.0).symbolStats(new Symbol((Type)UnknownType.UNKNOWN, "x"), symbolAssert -> symbolAssert.averageRowSize(4.0).lowValue(-10.0).highValue(10.0).distinctValuesCount(20.0).nullsFraction(0.4)).symbolStats(new Symbol((Type)UnknownType.UNKNOWN, "y"), symbolAssert -> symbolAssert.isEqualTo(this.yStats));
        this.assertExpression((Expression)new NotExpression((Expression)new IsNullPredicate((Expression)new SymbolReference((Type)DoubleType.DOUBLE, "x")))).outputRowsCount(750.0).symbolStats(new Symbol((Type)UnknownType.UNKNOWN, "x"), symbolAssert -> symbolAssert.averageRowSize(4.0).lowValue(-10.0).highValue(10.0).distinctValuesCount(40.0).nullsFraction(0.0)).symbolStats(new Symbol((Type)UnknownType.UNKNOWN, "y"), symbolAssert -> symbolAssert.isEqualTo(this.yStats));
        this.assertExpression((Expression)new NotExpression((Expression)new FunctionCall(JSON_ARRAY_CONTAINS, (List)ImmutableList.of((Object)new Constant((Type)JsonType.JSON, (Object)JsonTypeUtil.jsonParse((Slice)Slices.utf8Slice((String)"[]"))), (Object)new SymbolReference((Type)DoubleType.DOUBLE, "x"))))).outputRowsCountUnknown();
    }

    @Test
    public void testIsNullFilter() {
        this.assertExpression((Expression)new IsNullPredicate((Expression)new SymbolReference((Type)DoubleType.DOUBLE, "x"))).outputRowsCount(250.0).symbolStats(new Symbol((Type)UnknownType.UNKNOWN, "x"), symbolStats -> symbolStats.distinctValuesCount(0.0).emptyRange().nullsFraction(1.0));
        this.assertExpression((Expression)new IsNullPredicate((Expression)new SymbolReference((Type)DoubleType.DOUBLE, "emptyRange"))).outputRowsCount(1000.0).symbolStats(new Symbol((Type)UnknownType.UNKNOWN, "emptyRange"), SymbolStatsAssertion::empty);
    }

    @Test
    public void testIsNotNullFilter() {
        this.assertExpression((Expression)new NotExpression((Expression)new IsNullPredicate((Expression)new SymbolReference((Type)DoubleType.DOUBLE, "x")))).outputRowsCount(750.0).symbolStats("x", symbolStats -> symbolStats.distinctValuesCount(40.0).lowValue(-10.0).highValue(10.0).nullsFraction(0.0));
        this.assertExpression((Expression)new NotExpression((Expression)new IsNullPredicate((Expression)new SymbolReference((Type)DoubleType.DOUBLE, "emptyRange")))).outputRowsCount(0.0).symbolStats("emptyRange", SymbolStatsAssertion::empty);
    }

    @Test
    public void testBetweenOperatorFilter() {
        this.assertExpression((Expression)new BetweenPredicate((Expression)new SymbolReference((Type)DoubleType.DOUBLE, "x"), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)7.5), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)12.0))).outputRowsCount(93.75).symbolStats("x", symbolStats -> symbolStats.distinctValuesCount(5.0).lowValue(7.5).highValue(10.0).nullsFraction(0.0));
        this.assertExpression((Expression)new BetweenPredicate((Expression)new SymbolReference((Type)DoubleType.DOUBLE, "x"), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)-12.0), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)-7.5))).outputRowsCount(93.75).symbolStats("x", symbolStats -> symbolStats.distinctValuesCount(5.0).lowValue(-10.0).highValue(-7.5).nullsFraction(0.0));
        this.assertExpression((Expression)new BetweenPredicate((Expression)new SymbolReference((Type)DoubleType.DOUBLE, "x"), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)-12.0), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)-7.5))).outputRowsCount(93.75).symbolStats("x", symbolStats -> symbolStats.distinctValuesCount(5.0).lowValue(-10.0).highValue(-7.5).nullsFraction(0.0));
        this.assertExpression((Expression)new BetweenPredicate((Expression)new SymbolReference((Type)DoubleType.DOUBLE, "x"), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)-2.5), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)2.5))).outputRowsCount(187.5).symbolStats("x", symbolStats -> symbolStats.distinctValuesCount(10.0).lowValue(-2.5).highValue(2.5).nullsFraction(0.0));
        this.assertExpression((Expression)new BetweenPredicate((Expression)new SymbolReference((Type)DoubleType.DOUBLE, "unknownRange"), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)2.72), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)3.14))).outputRowsCount(112.5).symbolStats("unknownRange", symbolStats -> symbolStats.distinctValuesCount(6.25).lowValue(2.72).highValue(3.14).nullsFraction(0.0));
        this.assertExpression((Expression)new BetweenPredicate((Expression)new SymbolReference((Type)DoubleType.DOUBLE, "leftOpen"), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)-10.0), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)10.0))).outputRowsCount(180.0).symbolStats("leftOpen", symbolStats -> symbolStats.distinctValuesCount(10.0).lowValue(-10.0).highValue(10.0).nullsFraction(0.0));
        this.assertExpression((Expression)new BetweenPredicate((Expression)new SymbolReference((Type)DoubleType.DOUBLE, "rightOpen"), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)-10.0), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)10.0))).outputRowsCount(180.0).symbolStats("rightOpen", symbolStats -> symbolStats.distinctValuesCount(10.0).lowValue(-10.0).highValue(10.0).nullsFraction(0.0));
        this.assertExpression((Expression)new BetweenPredicate((Expression)new SymbolReference((Type)DoubleType.DOUBLE, "y"), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)27.5), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)107.0))).outputRowsCount(0.0).symbolStats("y", SymbolStatsAssertion::empty);
        this.assertExpression((Expression)new BetweenPredicate((Expression)new SymbolReference((Type)DoubleType.DOUBLE, "y"), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)-100.0), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)100.0))).outputRowsCount(500.0).symbolStats("y", symbolStats -> symbolStats.distinctValuesCount(20.0).lowValue(0.0).highValue(5.0).nullsFraction(0.0));
        this.assertExpression((Expression)new BetweenPredicate((Expression)new SymbolReference((Type)DoubleType.DOUBLE, "z"), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)-100.0), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)100.0))).outputRowsCount(900.0).symbolStats("z", symbolStats -> symbolStats.distinctValuesCount(5.0).lowValue(-100.0).highValue(100.0).nullsFraction(0.0));
        this.assertExpression((Expression)new BetweenPredicate((Expression)new Cast((Expression)new SymbolReference((Type)DoubleType.DOUBLE, "x"), (Type)DecimalType.createDecimalType((int)7, (int)2)), (Expression)new Constant((Type)DecimalType.createDecimalType((int)7, (int)2), (Object)Decimals.valueOfShort((BigDecimal)new BigDecimal("-2.50"))), (Expression)new Constant((Type)DecimalType.createDecimalType((int)7, (int)2), (Object)Decimals.valueOfShort((BigDecimal)new BigDecimal("2.50"))))).outputRowsCount(219.726563).symbolStats("x", symbolStats -> symbolStats.distinctValuesCount(this.xStats.getDistinctValuesCount()).lowValue(this.xStats.getLowValue()).highValue(this.xStats.getHighValue()).nullsFraction(this.xStats.getNullsFraction()));
        this.assertExpression((Expression)new InPredicate((Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"a")), (List)ImmutableList.of((Object)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"a")), (Object)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"b"))))).equalTo(this.standardInputStatistics);
        this.assertExpression((Expression)new InPredicate((Expression)new Constant((Type)VarcharType.createVarcharType((int)1), (Object)Slices.utf8Slice((String)"a")), (List)ImmutableList.of((Object)new Constant((Type)VarcharType.createVarcharType((int)1), (Object)Slices.utf8Slice((String)"a")), (Object)new Constant((Type)VarcharType.createVarcharType((int)1), (Object)Slices.utf8Slice((String)"b")), (Object)new Constant((Type)VarcharType.createVarcharType((int)1), null)))).equalTo(this.standardInputStatistics);
        this.assertExpression((Expression)new InPredicate((Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"a")), (List)ImmutableList.of((Object)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"b")), (Object)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"c"))))).outputRowsCount(0.0);
        this.assertExpression((Expression)new InPredicate((Expression)new Constant((Type)VarcharType.createVarcharType((int)1), (Object)Slices.utf8Slice((String)"a")), (List)ImmutableList.of((Object)new Constant((Type)VarcharType.createVarcharType((int)1), (Object)Slices.utf8Slice((String)"b")), (Object)new Constant((Type)VarcharType.createVarcharType((int)1), (Object)Slices.utf8Slice((String)"c")), (Object)new Constant((Type)VarcharType.createVarcharType((int)1), null)))).outputRowsCount(0.0);
        this.assertExpression((Expression)new InPredicate((Expression)new Cast((Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"b")), (Type)VarcharType.createVarcharType((int)3)), (List)ImmutableList.of((Object)new Cast((Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"a")), (Type)VarcharType.createVarcharType((int)3)), (Object)new Cast((Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"b")), (Type)VarcharType.createVarcharType((int)3))))).equalTo(this.standardInputStatistics);
        this.assertExpression((Expression)new InPredicate((Expression)new Cast((Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"c")), (Type)VarcharType.createVarcharType((int)3)), (List)ImmutableList.of((Object)new Cast((Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"a")), (Type)VarcharType.createVarcharType((int)3)), (Object)new Cast((Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"b")), (Type)VarcharType.createVarcharType((int)3))))).outputRowsCount(0.0);
    }

    @Test
    public void testSymbolEqualsSameSymbolFilter() {
        this.assertExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "x"), (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "x"))).outputRowsCount(750.0).symbolStats("x", symbolStats -> SymbolStatsEstimate.builder().setAverageRowSize(4.0).setDistinctValuesCount(40.0).setLowValue(-10.0).setHighValue(10.0).build());
    }

    @Test
    public void testInPredicateFilter() {
        this.assertExpression((Expression)new InPredicate((Expression)new SymbolReference((Type)DoubleType.DOUBLE, "x"), (List)ImmutableList.of((Object)new Constant((Type)DoubleType.DOUBLE, (Object)7.5)))).outputRowsCount(18.75).symbolStats("x", symbolStats -> symbolStats.distinctValuesCount(1.0).lowValue(7.5).highValue(7.5).nullsFraction(0.0));
        this.assertExpression((Expression)new InPredicate((Expression)new SymbolReference((Type)DoubleType.DOUBLE, "x"), (List)ImmutableList.of((Object)new Constant((Type)DoubleType.DOUBLE, (Object)-7.5)))).outputRowsCount(18.75).symbolStats("x", symbolStats -> symbolStats.distinctValuesCount(1.0).lowValue(-7.5).highValue(-7.5).nullsFraction(0.0));
        this.assertExpression((Expression)new InPredicate((Expression)new SymbolReference((Type)DoubleType.DOUBLE, "x"), (List)ImmutableList.of((Object)new ArithmeticBinaryExpression(ADD_DOUBLE, ArithmeticBinaryExpression.Operator.ADD, (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)2.0), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)5.5))))).outputRowsCount(18.75).symbolStats("x", symbolStats -> symbolStats.distinctValuesCount(1.0).lowValue(7.5).highValue(7.5).nullsFraction(0.0));
        this.assertExpression((Expression)new InPredicate((Expression)new SymbolReference((Type)DoubleType.DOUBLE, "x"), (List)ImmutableList.of((Object)new Constant((Type)DoubleType.DOUBLE, (Object)-7.5)))).outputRowsCount(18.75).symbolStats("x", symbolStats -> symbolStats.distinctValuesCount(1.0).lowValue(-7.5).highValue(-7.5).nullsFraction(0.0));
        this.assertExpression((Expression)new InPredicate((Expression)new SymbolReference((Type)DoubleType.DOUBLE, "x"), (List)ImmutableList.of((Object)new Constant((Type)DoubleType.DOUBLE, (Object)1.5), (Object)new Constant((Type)DoubleType.DOUBLE, (Object)2.5), (Object)new Constant((Type)DoubleType.DOUBLE, (Object)7.5)))).outputRowsCount(56.25).symbolStats("x", symbolStats -> symbolStats.distinctValuesCount(3.0).lowValue(1.5).highValue(7.5).nullsFraction(0.0)).symbolStats("y", symbolStats -> symbolStats.distinctValuesCount(20.0).lowValue(0.0).highValue(5.0).nullsFraction(0.5));
        this.assertExpression((Expression)new InPredicate((Expression)new SymbolReference((Type)DoubleType.DOUBLE, "x"), (List)ImmutableList.of((Object)new Constant((Type)DoubleType.DOUBLE, (Object)-42.0), (Object)new Constant((Type)DoubleType.DOUBLE, (Object)1.5), (Object)new Constant((Type)DoubleType.DOUBLE, (Object)2.5), (Object)new Constant((Type)DoubleType.DOUBLE, (Object)7.5), (Object)new Constant((Type)DoubleType.DOUBLE, (Object)314.0)))).outputRowsCount(56.25).symbolStats("x", symbolStats -> symbolStats.distinctValuesCount(3.0).lowValue(1.5).highValue(7.5).nullsFraction(0.0));
        this.assertExpression((Expression)new InPredicate((Expression)new SymbolReference((Type)DoubleType.DOUBLE, "x"), (List)ImmutableList.of((Object)new Constant((Type)DoubleType.DOUBLE, (Object)-42.0), (Object)new Constant((Type)DoubleType.DOUBLE, (Object)1.5), (Object)new Constant((Type)DoubleType.DOUBLE, (Object)2.5), (Object)new Constant((Type)DoubleType.DOUBLE, (Object)7.5), (Object)new Constant((Type)DoubleType.DOUBLE, (Object)314.0), (Object)new Constant((Type)DoubleType.DOUBLE, null)))).outputRowsCount(56.25).symbolStats("x", symbolStats -> symbolStats.distinctValuesCount(3.0).lowValue(1.5).highValue(7.5).nullsFraction(0.0));
        this.assertExpression((Expression)new InPredicate((Expression)new SymbolReference((Type)DoubleType.DOUBLE, "unknownRange"), (List)ImmutableList.of((Object)new Constant((Type)DoubleType.DOUBLE, (Object)-42.0), (Object)new Constant((Type)DoubleType.DOUBLE, (Object)1.5), (Object)new Constant((Type)DoubleType.DOUBLE, (Object)2.5), (Object)new Constant((Type)DoubleType.DOUBLE, (Object)7.5), (Object)new Constant((Type)DoubleType.DOUBLE, (Object)314.0)))).outputRowsCount(90.0).symbolStats("unknownRange", symbolStats -> symbolStats.distinctValuesCount(5.0).lowValue(-42.0).highValue(314.0).nullsFraction(0.0));
        this.assertExpression((Expression)new InPredicate((Expression)new SymbolReference((Type)MEDIUM_VARCHAR_TYPE, "mediumVarchar"), (List)ImmutableList.of((Object)new Cast((Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"abc")), (Type)MEDIUM_VARCHAR_TYPE)))).outputRowsCount(4.0).symbolStats("mediumVarchar", symbolStats -> symbolStats.distinctValuesCount(1.0).nullsFraction(0.0));
        this.assertExpression((Expression)new InPredicate((Expression)new SymbolReference((Type)MEDIUM_VARCHAR_TYPE, "mediumVarchar"), (List)ImmutableList.of((Object)new Cast((Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"abc")), (Type)VarcharType.createVarcharType((int)100)), (Object)new Cast((Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"def")), (Type)VarcharType.createVarcharType((int)100))))).outputRowsCount(8.0).symbolStats("mediumVarchar", symbolStats -> symbolStats.distinctValuesCount(2.0).nullsFraction(0.0));
        this.assertExpression((Expression)new InPredicate((Expression)new SymbolReference((Type)DoubleType.DOUBLE, "y"), (List)ImmutableList.of((Object)new Constant((Type)DoubleType.DOUBLE, (Object)-42.0), (Object)new Constant((Type)DoubleType.DOUBLE, (Object)6.0), (Object)new Constant((Type)DoubleType.DOUBLE, (Object)31.1341), (Object)new Constant((Type)DoubleType.DOUBLE, (Object)-2.0E-9), (Object)new Constant((Type)DoubleType.DOUBLE, (Object)314.0)))).outputRowsCount(0.0).symbolStats("y", SymbolStatsAssertion::empty);
        this.assertExpression((Expression)new InPredicate((Expression)new SymbolReference((Type)DoubleType.DOUBLE, "z"), (List)ImmutableList.of((Object)new Constant((Type)DoubleType.DOUBLE, (Object)-1.0), (Object)new Constant((Type)DoubleType.DOUBLE, (Object)3.14), (Object)new Constant((Type)DoubleType.DOUBLE, (Object)0.0), (Object)new Constant((Type)DoubleType.DOUBLE, (Object)1.0), (Object)new Constant((Type)DoubleType.DOUBLE, (Object)2.0), (Object)new Constant((Type)DoubleType.DOUBLE, (Object)3.0), (Object)new Constant((Type)DoubleType.DOUBLE, (Object)4.0), (Object)new Constant((Type)DoubleType.DOUBLE, (Object)5.0), (Object)new Constant((Type)DoubleType.DOUBLE, (Object)6.0), (Object)new Constant((Type)DoubleType.DOUBLE, (Object)7.0), (Object)new Constant((Type)DoubleType.DOUBLE, (Object)8.0), (Object)new Constant((Type)DoubleType.DOUBLE, (Object)-2.0), (Object[])new Expression[0]))).outputRowsCount(900.0).symbolStats("z", symbolStats -> symbolStats.distinctValuesCount(5.0).lowValue(-2.0).highValue(8.0).nullsFraction(0.0));
        this.assertExpression((Expression)new InPredicate((Expression)new SymbolReference((Type)DoubleType.DOUBLE, "z"), (List)ImmutableList.of((Object)new Constant((Type)DoubleType.DOUBLE, (Object)-1.0), (Object)new Constant((Type)DoubleType.DOUBLE, (Object)1.0), (Object)new Constant((Type)DoubleType.DOUBLE, (Object)0.0)))).outputRowsCount(540.0).symbolStats("z", symbolStats -> symbolStats.distinctValuesCount(3.0).lowValue(-1.0).highValue(1.0).nullsFraction(0.0));
    }

    private PlanNodeStatsAssertion assertExpression(Expression expression) {
        return this.assertExpression(expression, this.session);
    }

    private PlanNodeStatsAssertion assertExpression(Expression expression, PlanNodeStatsEstimate inputStatistics) {
        return this.assertExpression(expression, this.session, inputStatistics);
    }

    private PlanNodeStatsAssertion assertExpression(Expression expression, Session session) {
        return this.assertExpression(expression, session, this.standardInputStatistics);
    }

    private PlanNodeStatsAssertion assertExpression(Expression expression, Session session, PlanNodeStatsEstimate inputStatistics) {
        TestingTransactionManager transactionManager = new TestingTransactionManager();
        MetadataManager metadata = MetadataManager.testMetadataManagerBuilder().withTransactionManager((TransactionManager)transactionManager).build();
        return (PlanNodeStatsAssertion)TransactionBuilder.transaction((TransactionManager)transactionManager, (Metadata)metadata, (AccessControl)new AllowAllAccessControl()).singleStatement().execute(session, transactionSession -> PlanNodeStatsAssertion.assertThat(this.statsCalculator.filterStats(inputStatistics, expression, transactionSession)));
    }
}

