/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cost;

import io.trino.cost.BaseStatsCalculatorTest;
import io.trino.cost.PlanNodeStatsAssertion;
import io.trino.cost.PlanNodeStatsEstimate;
import io.trino.cost.StatsCalculatorTester;
import io.trino.cost.SymbolStatsEstimate;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.ComparisonExpression;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.testing.TestingSession;
import io.trino.type.UnknownType;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestFilterStatsRule
extends BaseStatsCalculatorTest {
    public StatsCalculatorTester defaultFilterTester;

    @BeforeAll
    public void setupClass() {
        this.defaultFilterTester = new StatsCalculatorTester(TestingSession.testSessionBuilder().setSystemProperty("default_filter_factor_enabled", "true").build());
    }

    @AfterAll
    public void tearDownClass() {
        this.defaultFilterTester.close();
        this.defaultFilterTester = null;
    }

    @Test
    public void testEstimatableFilter() {
        this.tester().assertStatsFor(pb -> pb.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "i1"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)5L)), (PlanNode)pb.values(pb.symbol("i1"), pb.symbol("i2"), pb.symbol("i3")))).withSourceStats(0, PlanNodeStatsEstimate.builder().setOutputRowCount(10.0).addSymbolStatistics(new Symbol((Type)UnknownType.UNKNOWN, "i1"), SymbolStatsEstimate.builder().setLowValue(1.0).setHighValue(10.0).setDistinctValuesCount(5.0).setNullsFraction(0.0).build()).addSymbolStatistics(new Symbol((Type)UnknownType.UNKNOWN, "i2"), SymbolStatsEstimate.builder().setLowValue(0.0).setHighValue(3.0).setDistinctValuesCount(4.0).setNullsFraction(0.0).build()).addSymbolStatistics(new Symbol((Type)UnknownType.UNKNOWN, "i3"), SymbolStatsEstimate.builder().setLowValue(10.0).setHighValue(15.0).setDistinctValuesCount(4.0).setNullsFraction(0.1).build()).build()).check(check -> check.outputRowsCount(2.0).symbolStats("i1", assertion -> assertion.lowValue(5.0).highValue(5.0).distinctValuesCount(1.0).dataSizeUnknown().nullsFraction(0.0)).symbolStats("i2", assertion -> assertion.lowValue(0.0).highValue(3.0).dataSizeUnknown().distinctValuesCount(2.0).nullsFraction(0.0)).symbolStats("i3", assertion -> assertion.lowValue(10.0).highValue(15.0).dataSizeUnknown().distinctValuesCount(1.9).nullsFraction(0.05)));
        this.defaultFilterTester.assertStatsFor(pb -> pb.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "i1"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)5L)), (PlanNode)pb.values(pb.symbol("i1"), pb.symbol("i2"), pb.symbol("i3")))).withSourceStats(0, PlanNodeStatsEstimate.builder().setOutputRowCount(10.0).addSymbolStatistics(new Symbol((Type)UnknownType.UNKNOWN, "i1"), SymbolStatsEstimate.builder().setLowValue(1.0).setHighValue(10.0).setDistinctValuesCount(5.0).setNullsFraction(0.0).build()).addSymbolStatistics(new Symbol((Type)UnknownType.UNKNOWN, "i2"), SymbolStatsEstimate.builder().setLowValue(0.0).setHighValue(3.0).setDistinctValuesCount(4.0).setNullsFraction(0.0).build()).addSymbolStatistics(new Symbol((Type)UnknownType.UNKNOWN, "i3"), SymbolStatsEstimate.builder().setLowValue(10.0).setHighValue(15.0).setDistinctValuesCount(4.0).setNullsFraction(0.1).build()).build()).check(check -> check.outputRowsCount(2.0).symbolStats("i1", assertion -> assertion.lowValue(5.0).highValue(5.0).distinctValuesCount(1.0).dataSizeUnknown().nullsFraction(0.0)).symbolStats("i2", assertion -> assertion.lowValue(0.0).highValue(3.0).dataSizeUnknown().distinctValuesCount(2.0).nullsFraction(0.0)).symbolStats("i3", assertion -> assertion.lowValue(10.0).highValue(15.0).dataSizeUnknown().distinctValuesCount(1.9).nullsFraction(0.05)));
    }

    @Test
    public void testUnestimatableFunction() {
        ComparisonExpression unestimatableExpression = new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new TestingFunctionResolution().functionCallBuilder("sin").addArgument((Type)DoubleType.DOUBLE, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "i1")).build(), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)1.0));
        this.tester().assertStatsFor(pb -> pb.filter((Expression)unestimatableExpression, (PlanNode)pb.values(pb.symbol("i1"), pb.symbol("i2"), pb.symbol("i3")))).withSourceStats(0, PlanNodeStatsEstimate.builder().setOutputRowCount(10.0).addSymbolStatistics(new Symbol((Type)UnknownType.UNKNOWN, "i1"), SymbolStatsEstimate.builder().setLowValue(1.0).setHighValue(10.0).setDistinctValuesCount(5.0).setNullsFraction(0.0).build()).addSymbolStatistics(new Symbol((Type)UnknownType.UNKNOWN, "i2"), SymbolStatsEstimate.builder().setLowValue(0.0).setHighValue(3.0).setDistinctValuesCount(4.0).setNullsFraction(0.0).build()).addSymbolStatistics(new Symbol((Type)UnknownType.UNKNOWN, "i3"), SymbolStatsEstimate.builder().setLowValue(10.0).setHighValue(15.0).setDistinctValuesCount(4.0).setNullsFraction(0.1).build()).build()).check(PlanNodeStatsAssertion::outputRowsCountUnknown);
        this.defaultFilterTester.assertStatsFor(pb -> pb.filter((Expression)unestimatableExpression, (PlanNode)pb.values(pb.symbol("i1"), pb.symbol("i2"), pb.symbol("i3")))).withSourceStats(0, PlanNodeStatsEstimate.builder().setOutputRowCount(10.0).addSymbolStatistics(new Symbol((Type)UnknownType.UNKNOWN, "i1"), SymbolStatsEstimate.builder().setLowValue(1.0).setHighValue(10.0).setDistinctValuesCount(5.0).setNullsFraction(0.0).build()).addSymbolStatistics(new Symbol((Type)UnknownType.UNKNOWN, "i2"), SymbolStatsEstimate.builder().setLowValue(0.0).setHighValue(3.0).setDistinctValuesCount(4.0).setNullsFraction(0.0).build()).addSymbolStatistics(new Symbol((Type)UnknownType.UNKNOWN, "i3"), SymbolStatsEstimate.builder().setLowValue(10.0).setHighValue(15.0).setDistinctValuesCount(4.0).setNullsFraction(0.1).build()).build()).check(check -> check.outputRowsCount(9.0).symbolStats("i1", assertion -> assertion.lowValue(1.0).highValue(10.0).dataSizeUnknown().distinctValuesCount(5.0).nullsFraction(0.0)).symbolStats("i2", assertion -> assertion.lowValue(0.0).highValue(3.0).dataSizeUnknown().distinctValuesCount(4.0).nullsFraction(0.0)).symbolStats("i3", assertion -> assertion.lowValue(10.0).highValue(15.0).dataSizeUnknown().distinctValuesCount(4.0).nullsFraction(0.1)));
    }
}

