/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cost;

import io.trino.cost.BaseStatsCalculatorTest;
import io.trino.cost.PlanNodeStatsEstimate;
import io.trino.cost.SymbolStatsEstimate;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.type.UnknownType;
import java.util.Optional;
import org.junit.jupiter.api.Test;

public class TestSemiJoinStatsRule
extends BaseStatsCalculatorTest {
    @Test
    public void testSemiJoinPropagatesSourceStats() {
        SymbolStatsEstimate stats = SymbolStatsEstimate.builder().setLowValue(1.0).setHighValue(10.0).setDistinctValuesCount(5.0).setNullsFraction(0.3).build();
        this.tester().assertStatsFor(pb -> {
            Symbol a = pb.symbol("a", (Type)BigintType.BIGINT);
            Symbol b = pb.symbol("b", (Type)BigintType.BIGINT);
            Symbol c = pb.symbol("c", (Type)BigintType.BIGINT);
            Symbol semiJoinOutput = pb.symbol("sjo", (Type)BooleanType.BOOLEAN);
            return pb.semiJoin((PlanNode)pb.values(a, b), (PlanNode)pb.values(c), a, c, semiJoinOutput, Optional.empty(), Optional.empty(), Optional.empty());
        }).withSourceStats(0, PlanNodeStatsEstimate.builder().setOutputRowCount(10.0).addSymbolStatistics(new Symbol((Type)UnknownType.UNKNOWN, "a"), stats).addSymbolStatistics(new Symbol((Type)UnknownType.UNKNOWN, "b"), stats).build()).withSourceStats(1, PlanNodeStatsEstimate.builder().setOutputRowCount(20.0).addSymbolStatistics(new Symbol((Type)UnknownType.UNKNOWN, "c"), stats).build()).check(check -> check.outputRowsCount(10.0).symbolStats("a", assertion -> assertion.isEqualTo(stats)).symbolStats("b", assertion -> assertion.isEqualTo(stats)).symbolStatsUnknown("c").symbolStatsUnknown("sjo"));
    }
}

