/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.concurrent.Threads;
import io.airlift.slice.Slices;
import io.airlift.tracing.Tracing;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.opentelemetry.api.trace.Span;
import io.trino.cost.StatsAndCosts;
import io.trino.execution.BasicStageInfo;
import io.trino.execution.BasicStageStats;
import io.trino.execution.ExecutionFailureInfo;
import io.trino.execution.StageId;
import io.trino.execution.StageInfo;
import io.trino.execution.StageState;
import io.trino.execution.StageStateMachine;
import io.trino.execution.TaskId;
import io.trino.execution.TaskInfo;
import io.trino.execution.TaskState;
import io.trino.execution.TaskStatus;
import io.trino.execution.scheduler.SplitSchedulerStats;
import io.trino.operator.PipelineContext;
import io.trino.operator.TaskStats;
import io.trino.operator.TestingOperatorContext;
import io.trino.spi.QueryId;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Row;
import io.trino.sql.planner.Partitioning;
import io.trino.sql.planner.PartitioningHandle;
import io.trino.sql.planner.PartitioningScheme;
import io.trino.sql.planner.PlanFragment;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SystemPartitioningHandle;
import io.trino.sql.planner.plan.PlanFragmentId;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.plan.ValuesNode;
import java.io.IOException;
import java.net.URI;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.joda.time.DateTime;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestStageStateMachine {
    private static final StageId STAGE_ID = new StageId("query", 0);
    private static final PlanFragment PLAN_FRAGMENT = TestStageStateMachine.createValuesPlan();
    private static final SQLException FAILED_CAUSE = new SQLException("FAILED");
    private ExecutorService executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-%s")));

    @AfterAll
    public void tearDown() {
        this.executor.shutdownNow();
        this.executor = null;
    }

    @Test
    public void testBasicStateChanges() {
        StageStateMachine stateMachine = this.createStageStateMachine();
        TestStageStateMachine.assertState(stateMachine, StageState.PLANNED);
        Assertions.assertThat((boolean)stateMachine.transitionToScheduling()).isTrue();
        TestStageStateMachine.assertState(stateMachine, StageState.SCHEDULING);
        Assertions.assertThat((boolean)stateMachine.transitionToRunning()).isTrue();
        TestStageStateMachine.assertState(stateMachine, StageState.RUNNING);
        Assertions.assertThat((boolean)stateMachine.transitionToPending()).isTrue();
        TestStageStateMachine.assertState(stateMachine, StageState.PENDING);
        Assertions.assertThat((boolean)stateMachine.transitionToRunning()).isTrue();
        TestStageStateMachine.assertState(stateMachine, StageState.RUNNING);
        Assertions.assertThat((boolean)stateMachine.transitionToFinished()).isTrue();
        TestStageStateMachine.assertState(stateMachine, StageState.FINISHED);
    }

    @Test
    public void testPlanned() {
        StageStateMachine stateMachine = this.createStageStateMachine();
        TestStageStateMachine.assertState(stateMachine, StageState.PLANNED);
        stateMachine = this.createStageStateMachine();
        Assertions.assertThat((boolean)stateMachine.transitionToScheduling()).isTrue();
        TestStageStateMachine.assertState(stateMachine, StageState.SCHEDULING);
        stateMachine = this.createStageStateMachine();
        Assertions.assertThat((boolean)stateMachine.transitionToRunning()).isTrue();
        TestStageStateMachine.assertState(stateMachine, StageState.RUNNING);
        stateMachine = this.createStageStateMachine();
        Assertions.assertThat((boolean)stateMachine.transitionToFinished()).isTrue();
        TestStageStateMachine.assertState(stateMachine, StageState.FINISHED);
        stateMachine = this.createStageStateMachine();
        Assertions.assertThat((boolean)stateMachine.transitionToFailed((Throwable)FAILED_CAUSE)).isTrue();
        TestStageStateMachine.assertState(stateMachine, StageState.FAILED);
    }

    @Test
    public void testScheduling() {
        StageStateMachine stateMachine = this.createStageStateMachine();
        Assertions.assertThat((boolean)stateMachine.transitionToScheduling()).isTrue();
        TestStageStateMachine.assertState(stateMachine, StageState.SCHEDULING);
        Assertions.assertThat((boolean)stateMachine.transitionToScheduling()).isFalse();
        TestStageStateMachine.assertState(stateMachine, StageState.SCHEDULING);
        stateMachine = this.createStageStateMachine();
        stateMachine.transitionToScheduling();
        Assertions.assertThat((boolean)stateMachine.transitionToRunning()).isTrue();
        TestStageStateMachine.assertState(stateMachine, StageState.RUNNING);
        stateMachine = this.createStageStateMachine();
        stateMachine.transitionToScheduling();
        Assertions.assertThat((boolean)stateMachine.transitionToFinished()).isTrue();
        TestStageStateMachine.assertState(stateMachine, StageState.FINISHED);
        stateMachine = this.createStageStateMachine();
        stateMachine.transitionToScheduling();
        Assertions.assertThat((boolean)stateMachine.transitionToFailed((Throwable)FAILED_CAUSE)).isTrue();
        TestStageStateMachine.assertState(stateMachine, StageState.FAILED);
    }

    @Test
    public void testRunning() {
        StageStateMachine stateMachine = this.createStageStateMachine();
        Assertions.assertThat((boolean)stateMachine.transitionToRunning()).isTrue();
        TestStageStateMachine.assertState(stateMachine, StageState.RUNNING);
        Assertions.assertThat((boolean)stateMachine.transitionToScheduling()).isFalse();
        TestStageStateMachine.assertState(stateMachine, StageState.RUNNING);
        Assertions.assertThat((boolean)stateMachine.transitionToRunning()).isFalse();
        TestStageStateMachine.assertState(stateMachine, StageState.RUNNING);
        Assertions.assertThat((boolean)stateMachine.transitionToPending()).isTrue();
        TestStageStateMachine.assertState(stateMachine, StageState.PENDING);
        Assertions.assertThat((boolean)stateMachine.transitionToRunning()).isTrue();
        TestStageStateMachine.assertState(stateMachine, StageState.RUNNING);
        stateMachine = this.createStageStateMachine();
        stateMachine.transitionToRunning();
        Assertions.assertThat((boolean)stateMachine.transitionToFinished()).isTrue();
        TestStageStateMachine.assertState(stateMachine, StageState.FINISHED);
        stateMachine = this.createStageStateMachine();
        stateMachine.transitionToRunning();
        Assertions.assertThat((boolean)stateMachine.transitionToFailed((Throwable)FAILED_CAUSE)).isTrue();
        TestStageStateMachine.assertState(stateMachine, StageState.FAILED);
    }

    @Test
    public void testFinished() {
        StageStateMachine stateMachine = this.createStageStateMachine();
        Assertions.assertThat((boolean)stateMachine.transitionToFinished()).isTrue();
        TestStageStateMachine.assertFinalState(stateMachine, StageState.FINISHED);
    }

    @Test
    public void testFailed() {
        StageStateMachine stateMachine = this.createStageStateMachine();
        Assertions.assertThat((boolean)stateMachine.transitionToFailed((Throwable)FAILED_CAUSE)).isTrue();
        TestStageStateMachine.assertFinalState(stateMachine, StageState.FAILED);
    }

    @Test
    public void testGetBasicStageInfo() {
        ScheduledThreadPoolExecutor executorService = new ScheduledThreadPoolExecutor(1);
        StageStateMachine stateMachine = this.createStageStateMachine();
        StageId stageId = new StageId(new QueryId("0"), 0);
        PipelineContext pipeline0Context = TestingOperatorContext.createDriverContext(executorService).getPipelineContext();
        PipelineContext pipeline1Context = TestingOperatorContext.createDriverContext(executorService).getPipelineContext();
        int baseValue = 1;
        TaskInfo task0 = TaskInfo.createInitialTask((TaskId)new TaskId(stageId, 0, 0), (URI)URI.create(""), (String)"0", (boolean)false, Optional.empty(), (TaskStats)TestStageStateMachine.taskStats((List<PipelineContext>)ImmutableList.of((Object)pipeline0Context, (Object)pipeline1Context), baseValue));
        TaskInfo task1 = task0.withTaskStatus(TaskStatus.failWith((TaskStatus)task0.getTaskStatus(), (TaskState)TaskState.FAILED, (List)ImmutableList.of()));
        ImmutableList taskInfos = ImmutableList.of((Object)task0, (Object)task1);
        int expectedStatsValue = baseValue * taskInfos.size();
        BasicStageInfo stageInfo = stateMachine.getBasicStageInfo(() -> TestStageStateMachine.lambda$testGetBasicStageInfo$0((List)taskInfos));
        Assertions.assertThat((Object)stageInfo.getStageId()).isEqualTo((Object)STAGE_ID);
        Assertions.assertThat((Comparable)stageInfo.getState()).isEqualTo((Object)StageState.PLANNED);
        Assertions.assertThat((boolean)stageInfo.isCoordinatorOnly()).isFalse();
        Assertions.assertThat((List)stageInfo.getSubStages()).isEmpty();
        Assertions.assertThat((int)stageInfo.getTasks().size()).isEqualTo(taskInfos.size());
        BasicStageStats stats = stageInfo.getStageStats();
        Assertions.assertThat((boolean)stats.isScheduled()).isFalse();
        Assertions.assertThat((int)stats.getFailedTasks()).isEqualTo(1);
        Assertions.assertThat((int)stats.getTotalDrivers()).isEqualTo(expectedStatsValue);
        Assertions.assertThat((int)stats.getQueuedDrivers()).isEqualTo(expectedStatsValue);
        Assertions.assertThat((int)stats.getRunningDrivers()).isEqualTo(expectedStatsValue);
        Assertions.assertThat((int)stats.getCompletedDrivers()).isEqualTo(expectedStatsValue);
        Assertions.assertThat((int)stats.getBlockedDrivers()).isEqualTo(expectedStatsValue);
        Assertions.assertThat((Comparable)stats.getPhysicalInputDataSize()).isEqualTo((Object)DataSize.succinctBytes((long)expectedStatsValue));
        Assertions.assertThat((Comparable)stats.getPhysicalWrittenDataSize()).isEqualTo((Object)DataSize.succinctBytes((long)expectedStatsValue));
        Assertions.assertThat((Comparable)stats.getInternalNetworkInputDataSize()).isEqualTo((Object)DataSize.succinctBytes((long)expectedStatsValue));
        Assertions.assertThat((long)stats.getInternalNetworkInputPositions()).isEqualTo((long)expectedStatsValue);
        Assertions.assertThat((long)stats.getPhysicalInputPositions()).isEqualTo((long)expectedStatsValue);
        Assertions.assertThat((Comparable)stats.getPhysicalInputReadTime()).isEqualTo((Object)Duration.succinctDuration((double)expectedStatsValue, (TimeUnit)TimeUnit.MILLISECONDS));
        Assertions.assertThat((long)stats.getPhysicalInputPositions()).isEqualTo((long)expectedStatsValue);
        Assertions.assertThat((Comparable)stats.getRawInputDataSize()).isEqualTo((Object)DataSize.succinctBytes((long)0L));
        Assertions.assertThat((long)stats.getRawInputPositions()).isEqualTo(0L);
        Assertions.assertThat((double)stats.getCumulativeUserMemory()).isEqualTo((double)expectedStatsValue);
        Assertions.assertThat((double)stats.getFailedCumulativeUserMemory()).isEqualTo(1.0);
        Assertions.assertThat((Comparable)stats.getTotalMemoryReservation()).isEqualTo((Object)DataSize.succinctBytes((long)((long)expectedStatsValue * 2L)));
        Assertions.assertThat((Comparable)stats.getUserMemoryReservation()).isEqualTo((Object)DataSize.succinctBytes((long)expectedStatsValue));
        Assertions.assertThat((boolean)stats.isFullyBlocked()).isFalse();
        Assertions.assertThat((Collection)stats.getBlockedReasons()).isEmpty();
        Assertions.assertThat((Comparable)stats.getTotalCpuTime()).isEqualTo((Object)Duration.succinctDuration((double)expectedStatsValue, (TimeUnit)TimeUnit.MILLISECONDS));
        Assertions.assertThat((Comparable)stats.getTotalScheduledTime()).isEqualTo((Object)Duration.succinctDuration((double)expectedStatsValue, (TimeUnit)TimeUnit.MILLISECONDS));
        Assertions.assertThat((Comparable)stats.getFailedCpuTime()).isEqualTo((Object)Duration.succinctDuration((double)1.0, (TimeUnit)TimeUnit.MILLISECONDS));
        Assertions.assertThat((Comparable)stats.getFailedScheduledTime()).isEqualTo((Object)Duration.succinctDuration((double)1.0, (TimeUnit)TimeUnit.MILLISECONDS));
        Assertions.assertThat((OptionalDouble)stats.getRunningPercentage()).isEmpty();
        Assertions.assertThat((OptionalDouble)stats.getProgressPercentage()).isEmpty();
        Assertions.assertThat((Comparable)stats.getSpilledDataSize()).isEqualTo((Object)DataSize.succinctBytes((long)0L));
    }

    private static TaskStats taskStats(List<PipelineContext> pipelineContexts) {
        return TestStageStateMachine.taskStats(pipelineContexts, 0);
    }

    private static TaskStats taskStats(List<PipelineContext> pipelineContexts, int baseValue) {
        return new TaskStats(DateTime.now(), null, null, null, null, null, new Duration((double)baseValue, TimeUnit.MILLISECONDS), new Duration((double)baseValue, TimeUnit.MILLISECONDS), baseValue, baseValue, baseValue, (long)baseValue, baseValue, baseValue, (long)baseValue, baseValue, baseValue, (double)baseValue, DataSize.ofBytes((long)baseValue), DataSize.ofBytes((long)baseValue), DataSize.ofBytes((long)baseValue), new Duration((double)baseValue, TimeUnit.MILLISECONDS), new Duration((double)baseValue, TimeUnit.MILLISECONDS), new Duration((double)baseValue, TimeUnit.MILLISECONDS), false, (Set)ImmutableSet.of(), DataSize.ofBytes((long)baseValue), (long)baseValue, new Duration((double)baseValue, TimeUnit.MILLISECONDS), DataSize.ofBytes((long)baseValue), (long)baseValue, DataSize.ofBytes((long)baseValue), (long)baseValue, DataSize.ofBytes((long)baseValue), (long)baseValue, new Duration((double)baseValue, TimeUnit.MILLISECONDS), DataSize.ofBytes((long)baseValue), (long)baseValue, new Duration((double)baseValue, TimeUnit.MILLISECONDS), DataSize.ofBytes((long)baseValue), DataSize.ofBytes((long)baseValue), Optional.empty(), baseValue, new Duration((double)baseValue, TimeUnit.MILLISECONDS), (List)pipelineContexts.stream().map(PipelineContext::getPipelineStats).collect(ImmutableList.toImmutableList()));
    }

    private static void assertFinalState(StageStateMachine stateMachine, StageState expectedState) {
        Assertions.assertThat((boolean)expectedState.isDone()).isTrue();
        TestStageStateMachine.assertState(stateMachine, expectedState);
        Assertions.assertThat((boolean)stateMachine.transitionToScheduling()).isFalse();
        TestStageStateMachine.assertState(stateMachine, expectedState);
        Assertions.assertThat((boolean)stateMachine.transitionToPending()).isFalse();
        TestStageStateMachine.assertState(stateMachine, expectedState);
        Assertions.assertThat((boolean)stateMachine.transitionToRunning()).isFalse();
        TestStageStateMachine.assertState(stateMachine, expectedState);
        Assertions.assertThat((boolean)stateMachine.transitionToFinished()).isFalse();
        TestStageStateMachine.assertState(stateMachine, expectedState);
        Assertions.assertThat((boolean)stateMachine.transitionToFailed((Throwable)FAILED_CAUSE)).isFalse();
        TestStageStateMachine.assertState(stateMachine, expectedState);
        Assertions.assertThat((boolean)stateMachine.transitionToFailed((Throwable)new IOException("failure after finish"))).isFalse();
        TestStageStateMachine.assertState(stateMachine, expectedState);
    }

    private static void assertState(StageStateMachine stateMachine, StageState expectedState) {
        Assertions.assertThat((Object)stateMachine.getStageId()).isEqualTo((Object)STAGE_ID);
        StageInfo stageInfo = stateMachine.getStageInfo(ImmutableList::of);
        Assertions.assertThat((Object)stageInfo.getStageId()).isEqualTo((Object)STAGE_ID);
        Assertions.assertThat((List)stageInfo.getSubStages()).isEqualTo((Object)ImmutableList.of());
        Assertions.assertThat((List)stageInfo.getTasks()).isEqualTo((Object)ImmutableList.of());
        Assertions.assertThat((List)stageInfo.getTypes()).isEqualTo((Object)ImmutableList.of((Object)VarcharType.VARCHAR));
        Assertions.assertThat((Object)stageInfo.getPlan()).isSameAs((Object)PLAN_FRAGMENT);
        Assertions.assertThat((Comparable)stateMachine.getState()).isEqualTo((Object)expectedState);
        Assertions.assertThat((Comparable)stageInfo.getState()).isEqualTo((Object)expectedState);
        if (expectedState == StageState.FAILED) {
            ExecutionFailureInfo failure = stageInfo.getFailureCause();
            Assertions.assertThat((String)failure.getMessage()).isEqualTo(FAILED_CAUSE.getMessage());
            Assertions.assertThat((String)failure.getType()).isEqualTo(FAILED_CAUSE.getClass().getName());
        } else {
            Assertions.assertThat((Object)stageInfo.getFailureCause()).isNull();
        }
    }

    private StageStateMachine createStageStateMachine() {
        return new StageStateMachine(STAGE_ID, PLAN_FRAGMENT, (Map)ImmutableMap.of(), (Executor)this.executor, Tracing.noopTracer(), Span.getInvalid(), new SplitSchedulerStats());
    }

    private static PlanFragment createValuesPlan() {
        Symbol symbol = new Symbol((Type)VarcharType.VARCHAR, "column");
        PlanNodeId valuesNodeId = new PlanNodeId("plan");
        PlanFragment planFragment = new PlanFragment(new PlanFragmentId("plan"), (PlanNode)new ValuesNode(valuesNodeId, (List)ImmutableList.of((Object)symbol), (List)ImmutableList.of((Object)new Row((List)ImmutableList.of((Object)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"foo")))))), (Set)ImmutableSet.of((Object)symbol), SystemPartitioningHandle.SOURCE_DISTRIBUTION, Optional.empty(), (List)ImmutableList.of((Object)valuesNodeId), new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List)ImmutableList.of()), (List)ImmutableList.of((Object)symbol)), StatsAndCosts.empty(), (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty());
        return planFragment;
    }

    private static /* synthetic */ Iterable lambda$testGetBasicStageInfo$0(List taskInfos) {
        return taskInfos;
    }

    static {
        FAILED_CAUSE.setStackTrace(new StackTraceElement[0]);
    }
}

