/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler.faulttolerant;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.units.DataSize;
import io.trino.Session;
import io.trino.client.NodeVersion;
import io.trino.cost.StatsAndCosts;
import io.trino.execution.scheduler.faulttolerant.ExponentialGrowthPartitionMemoryEstimator;
import io.trino.execution.scheduler.faulttolerant.PartitionMemoryEstimator;
import io.trino.memory.MemoryInfo;
import io.trino.metadata.InternalNode;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.memory.MemoryPoolInfo;
import io.trino.sql.planner.Partitioning;
import io.trino.sql.planner.PartitioningHandle;
import io.trino.sql.planner.PartitioningScheme;
import io.trino.sql.planner.PlanFragment;
import io.trino.sql.planner.SystemPartitioningHandle;
import io.trino.sql.planner.plan.PlanFragmentId;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.plan.ValuesNode;
import io.trino.testing.TestingSession;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestExponentialGrowthPartitionMemoryEstimator {
    private static final Function<PlanFragmentId, PlanFragment> THROWING_PLAN_FRAGMENT_LOOKUP = planFragmentId -> {
        throw new RuntimeException("should not be used");
    };

    private ExponentialGrowthPartitionMemoryEstimator.Factory makeFactory() {
        ExponentialGrowthPartitionMemoryEstimator.Factory factory = new ExponentialGrowthPartitionMemoryEstimator.Factory(() -> ImmutableMap.of((Object)new InternalNode("a-node", URI.create("local://blah"), NodeVersion.UNKNOWN, false).getNodeIdentifier(), Optional.of(this.buildWorkerMemoryInfo(DataSize.ofBytes((long)0L)))), true);
        factory.refreshNodePoolMemoryInfos();
        return factory;
    }

    @Test
    public void testDefaultInitialEstimation() {
        ExponentialGrowthPartitionMemoryEstimator.Factory estimatorFactory = this.makeFactory();
        Session session = TestingSession.testSessionBuilder().setSystemProperty("fault_tolerant_execution_coordinator_task_memory", "107MB").setSystemProperty("fault_tolerant_execution_task_memory", "113MB").build();
        Assertions.assertThat((Object)estimatorFactory.createPartitionMemoryEstimator(session, TestExponentialGrowthPartitionMemoryEstimator.getPlanFragment(SystemPartitioningHandle.COORDINATOR_DISTRIBUTION), THROWING_PLAN_FRAGMENT_LOOKUP).getInitialMemoryRequirements()).isEqualTo((Object)new PartitionMemoryEstimator.MemoryRequirements(DataSize.of((long)107L, (DataSize.Unit)DataSize.Unit.MEGABYTE)));
        Assertions.assertThat((Object)estimatorFactory.createPartitionMemoryEstimator(session, TestExponentialGrowthPartitionMemoryEstimator.getPlanFragment(SystemPartitioningHandle.SINGLE_DISTRIBUTION), THROWING_PLAN_FRAGMENT_LOOKUP).getInitialMemoryRequirements()).isEqualTo((Object)new PartitionMemoryEstimator.MemoryRequirements(DataSize.of((long)113L, (DataSize.Unit)DataSize.Unit.MEGABYTE)));
    }

    @Test
    public void testEstimator() {
        ExponentialGrowthPartitionMemoryEstimator.Factory estimatorFactory = this.makeFactory();
        Session session = TestingSession.testSessionBuilder().setSystemProperty("fault_tolerant_execution_task_memory", "107MB").build();
        PartitionMemoryEstimator estimator = estimatorFactory.createPartitionMemoryEstimator(session, TestExponentialGrowthPartitionMemoryEstimator.getPlanFragment(SystemPartitioningHandle.SINGLE_DISTRIBUTION), THROWING_PLAN_FRAGMENT_LOOKUP);
        Assertions.assertThat((Object)estimator.getInitialMemoryRequirements()).isEqualTo((Object)new PartitionMemoryEstimator.MemoryRequirements(DataSize.of((long)107L, (DataSize.Unit)DataSize.Unit.MEGABYTE)));
        Assertions.assertThat((Object)estimator.getNextRetryMemoryRequirements(new PartitionMemoryEstimator.MemoryRequirements(DataSize.of((long)50L, (DataSize.Unit)DataSize.Unit.MEGABYTE)), DataSize.of((long)10L, (DataSize.Unit)DataSize.Unit.MEGABYTE), StandardErrorCode.CORRUPT_PAGE.toErrorCode())).isEqualTo((Object)new PartitionMemoryEstimator.MemoryRequirements(DataSize.of((long)50L, (DataSize.Unit)DataSize.Unit.MEGABYTE)));
        Assertions.assertThat((Object)estimator.getNextRetryMemoryRequirements(new PartitionMemoryEstimator.MemoryRequirements(DataSize.of((long)50L, (DataSize.Unit)DataSize.Unit.MEGABYTE)), DataSize.of((long)10L, (DataSize.Unit)DataSize.Unit.MEGABYTE), StandardErrorCode.CLUSTER_OUT_OF_MEMORY.toErrorCode())).isEqualTo((Object)new PartitionMemoryEstimator.MemoryRequirements(DataSize.of((long)150L, (DataSize.Unit)DataSize.Unit.MEGABYTE)));
        Assertions.assertThat((Object)estimator.getNextRetryMemoryRequirements(new PartitionMemoryEstimator.MemoryRequirements(DataSize.of((long)50L, (DataSize.Unit)DataSize.Unit.MEGABYTE)), DataSize.of((long)10L, (DataSize.Unit)DataSize.Unit.MEGABYTE), StandardErrorCode.TOO_MANY_REQUESTS_FAILED.toErrorCode())).isEqualTo((Object)new PartitionMemoryEstimator.MemoryRequirements(DataSize.of((long)150L, (DataSize.Unit)DataSize.Unit.MEGABYTE)));
        Assertions.assertThat((Object)estimator.getNextRetryMemoryRequirements(new PartitionMemoryEstimator.MemoryRequirements(DataSize.of((long)50L, (DataSize.Unit)DataSize.Unit.MEGABYTE)), DataSize.of((long)10L, (DataSize.Unit)DataSize.Unit.MEGABYTE), StandardErrorCode.EXCEEDED_LOCAL_MEMORY_LIMIT.toErrorCode())).isEqualTo((Object)new PartitionMemoryEstimator.MemoryRequirements(DataSize.of((long)150L, (DataSize.Unit)DataSize.Unit.MEGABYTE)));
        Assertions.assertThat((Object)estimator.getNextRetryMemoryRequirements(new PartitionMemoryEstimator.MemoryRequirements(DataSize.of((long)50L, (DataSize.Unit)DataSize.Unit.MEGABYTE)), DataSize.of((long)70L, (DataSize.Unit)DataSize.Unit.MEGABYTE), StandardErrorCode.CORRUPT_PAGE.toErrorCode())).isEqualTo((Object)new PartitionMemoryEstimator.MemoryRequirements(DataSize.of((long)70L, (DataSize.Unit)DataSize.Unit.MEGABYTE)));
        Assertions.assertThat((Object)estimator.getNextRetryMemoryRequirements(new PartitionMemoryEstimator.MemoryRequirements(DataSize.of((long)50L, (DataSize.Unit)DataSize.Unit.MEGABYTE)), DataSize.of((long)70L, (DataSize.Unit)DataSize.Unit.MEGABYTE), StandardErrorCode.EXCEEDED_LOCAL_MEMORY_LIMIT.toErrorCode())).isEqualTo((Object)new PartitionMemoryEstimator.MemoryRequirements(DataSize.of((long)210L, (DataSize.Unit)DataSize.Unit.MEGABYTE)));
        estimator.registerPartitionFinished(new PartitionMemoryEstimator.MemoryRequirements(DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.MEGABYTE)), DataSize.of((long)1000L, (DataSize.Unit)DataSize.Unit.MEGABYTE), true, Optional.empty());
        estimator.registerPartitionFinished(new PartitionMemoryEstimator.MemoryRequirements(DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.MEGABYTE)), DataSize.of((long)300L, (DataSize.Unit)DataSize.Unit.MEGABYTE), true, Optional.empty());
        estimator.registerPartitionFinished(new PartitionMemoryEstimator.MemoryRequirements(DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.MEGABYTE)), DataSize.of((long)300L, (DataSize.Unit)DataSize.Unit.MEGABYTE), true, Optional.empty());
        estimator.registerPartitionFinished(new PartitionMemoryEstimator.MemoryRequirements(DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.MEGABYTE)), DataSize.of((long)300L, (DataSize.Unit)DataSize.Unit.MEGABYTE), true, Optional.empty());
        estimator.registerPartitionFinished(new PartitionMemoryEstimator.MemoryRequirements(DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.MEGABYTE)), DataSize.of((long)300L, (DataSize.Unit)DataSize.Unit.MEGABYTE), true, Optional.empty());
        estimator.registerPartitionFinished(new PartitionMemoryEstimator.MemoryRequirements(DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.MEGABYTE)), DataSize.of((long)300L, (DataSize.Unit)DataSize.Unit.MEGABYTE), true, Optional.empty());
        estimator.registerPartitionFinished(new PartitionMemoryEstimator.MemoryRequirements(DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.MEGABYTE)), DataSize.of((long)300L, (DataSize.Unit)DataSize.Unit.MEGABYTE), true, Optional.empty());
        estimator.registerPartitionFinished(new PartitionMemoryEstimator.MemoryRequirements(DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.MEGABYTE)), DataSize.of((long)300L, (DataSize.Unit)DataSize.Unit.MEGABYTE), true, Optional.empty());
        estimator.registerPartitionFinished(new PartitionMemoryEstimator.MemoryRequirements(DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.MEGABYTE)), DataSize.of((long)300L, (DataSize.Unit)DataSize.Unit.MEGABYTE), true, Optional.empty());
        estimator.registerPartitionFinished(new PartitionMemoryEstimator.MemoryRequirements(DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.MEGABYTE)), DataSize.of((long)300L, (DataSize.Unit)DataSize.Unit.MEGABYTE), true, Optional.empty());
        estimator.registerPartitionFinished(new PartitionMemoryEstimator.MemoryRequirements(DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.MEGABYTE)), DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.MEGABYTE), true, Optional.empty());
        Assertions.assertThat((Object)estimator.getInitialMemoryRequirements()).isEqualTo((Object)new PartitionMemoryEstimator.MemoryRequirements(DataSize.of((long)300L, (DataSize.Unit)DataSize.Unit.MEGABYTE)));
        Assertions.assertThat((Object)estimator.getNextRetryMemoryRequirements(new PartitionMemoryEstimator.MemoryRequirements(DataSize.of((long)50L, (DataSize.Unit)DataSize.Unit.MEGABYTE)), DataSize.of((long)70L, (DataSize.Unit)DataSize.Unit.MEGABYTE), StandardErrorCode.EXCEEDED_LOCAL_MEMORY_LIMIT.toErrorCode())).isEqualTo((Object)new PartitionMemoryEstimator.MemoryRequirements(DataSize.of((long)300L, (DataSize.Unit)DataSize.Unit.MEGABYTE)));
        estimator.registerPartitionFinished(new PartitionMemoryEstimator.MemoryRequirements(DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.MEGABYTE)), DataSize.of((long)200L, (DataSize.Unit)DataSize.Unit.MEGABYTE), false, Optional.of(StandardErrorCode.EXCEEDED_LOCAL_MEMORY_LIMIT.toErrorCode()));
        estimator.registerPartitionFinished(new PartitionMemoryEstimator.MemoryRequirements(DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.MEGABYTE)), DataSize.of((long)200L, (DataSize.Unit)DataSize.Unit.MEGABYTE), true, Optional.of(StandardErrorCode.CLUSTER_OUT_OF_MEMORY.toErrorCode()));
        Assertions.assertThat((Object)estimator.getInitialMemoryRequirements()).isEqualTo((Object)new PartitionMemoryEstimator.MemoryRequirements(DataSize.of((long)600L, (DataSize.Unit)DataSize.Unit.MEGABYTE)));
        estimator.registerPartitionFinished(new PartitionMemoryEstimator.MemoryRequirements(DataSize.of((long)300L, (DataSize.Unit)DataSize.Unit.MEGABYTE)), DataSize.of((long)200L, (DataSize.Unit)DataSize.Unit.MEGABYTE), false, Optional.of(StandardErrorCode.EXCEEDED_LOCAL_MEMORY_LIMIT.toErrorCode()));
        estimator.registerPartitionFinished(new PartitionMemoryEstimator.MemoryRequirements(DataSize.of((long)300L, (DataSize.Unit)DataSize.Unit.MEGABYTE)), DataSize.of((long)200L, (DataSize.Unit)DataSize.Unit.MEGABYTE), false, Optional.of(StandardErrorCode.EXCEEDED_LOCAL_MEMORY_LIMIT.toErrorCode()));
        estimator.registerPartitionFinished(new PartitionMemoryEstimator.MemoryRequirements(DataSize.of((long)300L, (DataSize.Unit)DataSize.Unit.MEGABYTE)), DataSize.of((long)200L, (DataSize.Unit)DataSize.Unit.MEGABYTE), true, Optional.of(StandardErrorCode.CLUSTER_OUT_OF_MEMORY.toErrorCode()));
        Assertions.assertThat((Object)estimator.getInitialMemoryRequirements()).isEqualTo((Object)new PartitionMemoryEstimator.MemoryRequirements(DataSize.of((long)900L, (DataSize.Unit)DataSize.Unit.MEGABYTE)));
        estimator.registerPartitionFinished(new PartitionMemoryEstimator.MemoryRequirements(DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.MEGABYTE)), DataSize.of((long)500L, (DataSize.Unit)DataSize.Unit.MEGABYTE), false, Optional.of(StandardErrorCode.ADMINISTRATIVELY_PREEMPTED.toErrorCode()));
        estimator.registerPartitionFinished(new PartitionMemoryEstimator.MemoryRequirements(DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.MEGABYTE)), DataSize.of((long)500L, (DataSize.Unit)DataSize.Unit.MEGABYTE), false, Optional.of(StandardErrorCode.ADMINISTRATIVELY_PREEMPTED.toErrorCode()));
        estimator.registerPartitionFinished(new PartitionMemoryEstimator.MemoryRequirements(DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.MEGABYTE)), DataSize.of((long)500L, (DataSize.Unit)DataSize.Unit.MEGABYTE), false, Optional.of(StandardErrorCode.ADMINISTRATIVELY_PREEMPTED.toErrorCode()));
        estimator.registerPartitionFinished(new PartitionMemoryEstimator.MemoryRequirements(DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.MEGABYTE)), DataSize.of((long)500L, (DataSize.Unit)DataSize.Unit.MEGABYTE), false, Optional.of(StandardErrorCode.ADMINISTRATIVELY_PREEMPTED.toErrorCode()));
        estimator.registerPartitionFinished(new PartitionMemoryEstimator.MemoryRequirements(DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.MEGABYTE)), DataSize.of((long)500L, (DataSize.Unit)DataSize.Unit.MEGABYTE), false, Optional.of(StandardErrorCode.ADMINISTRATIVELY_PREEMPTED.toErrorCode()));
        Assertions.assertThat((Object)estimator.getInitialMemoryRequirements()).isEqualTo((Object)new PartitionMemoryEstimator.MemoryRequirements(DataSize.of((long)900L, (DataSize.Unit)DataSize.Unit.MEGABYTE)));
    }

    @Test
    public void testDefaultInitialEstimationPickedIfLarge() {
        ExponentialGrowthPartitionMemoryEstimator.Factory estimatorFactory = this.makeFactory();
        TestExponentialGrowthPartitionMemoryEstimator.testInitialEstimationWithFinishedPartitions(estimatorFactory, DataSize.of((long)300L, (DataSize.Unit)DataSize.Unit.MEGABYTE), 10, DataSize.of((long)500L, (DataSize.Unit)DataSize.Unit.MEGABYTE), DataSize.of((long)500L, (DataSize.Unit)DataSize.Unit.MEGABYTE));
        TestExponentialGrowthPartitionMemoryEstimator.testInitialEstimationWithFinishedPartitions(estimatorFactory, DataSize.of((long)300L, (DataSize.Unit)DataSize.Unit.MEGABYTE), 10, DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.MEGABYTE), DataSize.of((long)300L, (DataSize.Unit)DataSize.Unit.MEGABYTE));
    }

    private static void testInitialEstimationWithFinishedPartitions(ExponentialGrowthPartitionMemoryEstimator.Factory estimatorFactory, DataSize recordedMemoryUsage, int recordedPartitionsCount, DataSize defaultInitialTaskMemory, DataSize expectedEstimation) {
        Session session = TestingSession.testSessionBuilder().setSystemProperty("fault_tolerant_execution_task_memory", defaultInitialTaskMemory.toString()).build();
        PartitionMemoryEstimator estimator = estimatorFactory.createPartitionMemoryEstimator(session, TestExponentialGrowthPartitionMemoryEstimator.getPlanFragment(SystemPartitioningHandle.SINGLE_DISTRIBUTION), THROWING_PLAN_FRAGMENT_LOOKUP);
        for (int i = 0; i < recordedPartitionsCount; ++i) {
            estimator.registerPartitionFinished(new PartitionMemoryEstimator.MemoryRequirements(recordedMemoryUsage), recordedMemoryUsage, true, Optional.empty());
        }
        Assertions.assertThat((Object)estimator.getInitialMemoryRequirements()).isEqualTo((Object)new PartitionMemoryEstimator.MemoryRequirements(expectedEstimation));
    }

    private static PlanFragment getPlanFragment(PartitioningHandle partitioningHandle) {
        return new PlanFragment(new PlanFragmentId("exchange_fragment_id"), (PlanNode)new ValuesNode(new PlanNodeId("values"), 1), (Set)ImmutableSet.of(), partitioningHandle, Optional.empty(), (List)ImmutableList.of(), new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List)ImmutableList.of()), (List)ImmutableList.of()), StatsAndCosts.empty(), (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty());
    }

    private MemoryInfo buildWorkerMemoryInfo(DataSize usedMemory) {
        return new MemoryInfo(4, new MemoryPoolInfo(DataSize.of((long)64L, (DataSize.Unit)DataSize.Unit.GIGABYTE).toBytes(), usedMemory.toBytes(), 0L, (Map)ImmutableMap.of(), (Map)ImmutableMap.of(), (Map)ImmutableMap.of(), (Map)ImmutableMap.of(), (Map)ImmutableMap.of()));
    }
}

