/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.json.JsonCodec;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.operator.PipelineStats;
import io.trino.operator.TaskStats;
import io.trino.operator.TestPipelineStats;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.junit.jupiter.api.Test;

public class TestTaskStats {
    public static final TaskStats EXPECTED = new TaskStats(new DateTime(1L), new DateTime(2L), new DateTime(100L), new DateTime(102L), new DateTime(101L), new DateTime(3L), new Duration(4.0, TimeUnit.NANOSECONDS), new Duration(5.0, TimeUnit.NANOSECONDS), 6, 7, 5, 28L, 8, 6, 29L, 24, 10, 11.0, DataSize.ofBytes((long)12L), DataSize.ofBytes((long)120L), DataSize.ofBytes((long)13L), new Duration(15.0, TimeUnit.NANOSECONDS), new Duration(16.0, TimeUnit.NANOSECONDS), new Duration(18.0, TimeUnit.NANOSECONDS), false, (Set)ImmutableSet.of(), DataSize.ofBytes((long)191L), 201L, new Duration(15.0, TimeUnit.NANOSECONDS), DataSize.ofBytes((long)192L), 202L, DataSize.ofBytes((long)19L), 20L, DataSize.ofBytes((long)21L), 22L, new Duration(271.0, TimeUnit.NANOSECONDS), DataSize.ofBytes((long)23L), 24L, new Duration(272.0, TimeUnit.NANOSECONDS), DataSize.ofBytes((long)25L), DataSize.ofBytes((long)25L), Optional.of(2), 26, new Duration(27.0, TimeUnit.NANOSECONDS), (List)ImmutableList.of((Object)TestPipelineStats.EXPECTED));

    @Test
    public void testJson() {
        JsonCodec codec = JsonCodec.jsonCodec(TaskStats.class);
        String json = codec.toJson((Object)EXPECTED);
        TaskStats actual = (TaskStats)codec.fromJson(json);
        TestTaskStats.assertExpectedTaskStats(actual);
    }

    public static void assertExpectedTaskStats(TaskStats actual) {
        Assertions.assertThat((Comparable)actual.getCreateTime()).isEqualTo((Object)new DateTime(1L, DateTimeZone.UTC));
        Assertions.assertThat((Comparable)actual.getFirstStartTime()).isEqualTo((Object)new DateTime(2L, DateTimeZone.UTC));
        Assertions.assertThat((Comparable)actual.getLastStartTime()).isEqualTo((Object)new DateTime(100L, DateTimeZone.UTC));
        Assertions.assertThat((Comparable)actual.getTerminatingStartTime()).isEqualTo((Object)new DateTime(102L, DateTimeZone.UTC));
        Assertions.assertThat((Comparable)actual.getLastEndTime()).isEqualTo((Object)new DateTime(101L, DateTimeZone.UTC));
        Assertions.assertThat((Comparable)actual.getEndTime()).isEqualTo((Object)new DateTime(3L, DateTimeZone.UTC));
        Assertions.assertThat((Comparable)actual.getElapsedTime()).isEqualTo((Object)new Duration(4.0, TimeUnit.NANOSECONDS));
        Assertions.assertThat((Comparable)actual.getQueuedTime()).isEqualTo((Object)new Duration(5.0, TimeUnit.NANOSECONDS));
        Assertions.assertThat((int)actual.getTotalDrivers()).isEqualTo(6);
        Assertions.assertThat((int)actual.getQueuedDrivers()).isEqualTo(7);
        Assertions.assertThat((int)actual.getQueuedPartitionedDrivers()).isEqualTo(5);
        Assertions.assertThat((long)actual.getQueuedPartitionedSplitsWeight()).isEqualTo(28L);
        Assertions.assertThat((int)actual.getRunningDrivers()).isEqualTo(8);
        Assertions.assertThat((int)actual.getRunningPartitionedDrivers()).isEqualTo(6);
        Assertions.assertThat((long)actual.getRunningPartitionedSplitsWeight()).isEqualTo(29L);
        Assertions.assertThat((int)actual.getBlockedDrivers()).isEqualTo(24);
        Assertions.assertThat((int)actual.getCompletedDrivers()).isEqualTo(10);
        Assertions.assertThat((double)actual.getCumulativeUserMemory()).isEqualTo(11.0);
        Assertions.assertThat((Comparable)actual.getUserMemoryReservation()).isEqualTo((Object)DataSize.ofBytes((long)12L));
        Assertions.assertThat((Comparable)actual.getPeakUserMemoryReservation()).isEqualTo((Object)DataSize.ofBytes((long)120L));
        Assertions.assertThat((Comparable)actual.getRevocableMemoryReservation()).isEqualTo((Object)DataSize.ofBytes((long)13L));
        Assertions.assertThat((Comparable)actual.getTotalScheduledTime()).isEqualTo((Object)new Duration(15.0, TimeUnit.NANOSECONDS));
        Assertions.assertThat((Comparable)actual.getTotalCpuTime()).isEqualTo((Object)new Duration(16.0, TimeUnit.NANOSECONDS));
        Assertions.assertThat((Comparable)actual.getTotalBlockedTime()).isEqualTo((Object)new Duration(18.0, TimeUnit.NANOSECONDS));
        Assertions.assertThat((Comparable)actual.getPhysicalInputDataSize()).isEqualTo((Object)DataSize.ofBytes((long)191L));
        Assertions.assertThat((long)actual.getPhysicalInputPositions()).isEqualTo(201L);
        Assertions.assertThat((Comparable)actual.getPhysicalInputReadTime()).isEqualTo((Object)new Duration(15.0, TimeUnit.NANOSECONDS));
        Assertions.assertThat((Comparable)actual.getInternalNetworkInputDataSize()).isEqualTo((Object)DataSize.ofBytes((long)192L));
        Assertions.assertThat((long)actual.getInternalNetworkInputPositions()).isEqualTo(202L);
        Assertions.assertThat((Comparable)actual.getRawInputDataSize()).isEqualTo((Object)DataSize.ofBytes((long)19L));
        Assertions.assertThat((long)actual.getRawInputPositions()).isEqualTo(20L);
        Assertions.assertThat((Comparable)actual.getProcessedInputDataSize()).isEqualTo((Object)DataSize.ofBytes((long)21L));
        Assertions.assertThat((long)actual.getProcessedInputPositions()).isEqualTo(22L);
        Assertions.assertThat((Comparable)actual.getInputBlockedTime()).isEqualTo((Object)new Duration(271.0, TimeUnit.NANOSECONDS));
        Assertions.assertThat((Comparable)actual.getOutputDataSize()).isEqualTo((Object)DataSize.ofBytes((long)23L));
        Assertions.assertThat((long)actual.getOutputPositions()).isEqualTo(24L);
        Assertions.assertThat((Comparable)actual.getOutputBlockedTime()).isEqualTo((Object)new Duration(272.0, TimeUnit.NANOSECONDS));
        Assertions.assertThat((Comparable)actual.getPhysicalWrittenDataSize()).isEqualTo((Object)DataSize.ofBytes((long)25L));
        Assertions.assertThat((int)actual.getPipelines().size()).isEqualTo(1);
        TestPipelineStats.assertExpectedPipelineStats((PipelineStats)actual.getPipelines().get(0));
    }
}

