/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.listagg;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.block.BlockAssertions;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.operator.aggregation.AggregationTestUtils;
import io.trino.operator.aggregation.listagg.ListaggAggregationFunction;
import io.trino.operator.aggregation.listagg.ListaggAggregationState;
import io.trino.operator.aggregation.listagg.SingleListaggAggregationState;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.ValueBlock;
import io.trino.spi.block.VariableWidthBlock;
import io.trino.spi.block.VariableWidthBlockBuilder;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.analyzer.TypeSignatureProvider;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestListaggAggregationFunction {
    private static final TestingFunctionResolution FUNCTION_RESOLUTION = new TestingFunctionResolution();

    @Test
    public void testInputEmptyState() {
        SingleListaggAggregationState state = new SingleListaggAggregationState();
        String s = "value1";
        VariableWidthBlock value = BlockAssertions.createStringsBlock(s);
        Slice separator = Slices.utf8Slice((String)",");
        Slice overflowFiller = Slices.utf8Slice((String)"...");
        ListaggAggregationFunction.input((ListaggAggregationState)state, (ValueBlock)value, (int)0, (Slice)separator, (boolean)false, (Slice)overflowFiller, (boolean)true);
        VariableWidthBlockBuilder blockBuilder = VarcharType.VARCHAR.createBlockBuilder(null, 1);
        state.write(blockBuilder);
        String result = VarcharType.VARCHAR.getSlice(blockBuilder.build(), 0).toString(StandardCharsets.UTF_8);
        Assertions.assertThat((String)result).isEqualTo(s);
    }

    @Test
    public void testInputOverflowOverflowFillerTooLong() {
        String overflowFillerTooLong = ".".repeat(65537);
        SingleListaggAggregationState state = new SingleListaggAggregationState();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ListaggAggregationFunction.input((ListaggAggregationState)state, (ValueBlock)BlockAssertions.createStringsBlock("value1"), (int)0, (Slice)Slices.utf8Slice((String)","), (boolean)false, (Slice)Slices.utf8Slice((String)overflowFillerTooLong), (boolean)false)).isInstanceOf(TrinoException.class)).matches(throwable -> ((TrinoException)throwable).getErrorCode() == StandardErrorCode.INVALID_FUNCTION_ARGUMENT.toErrorCode());
    }

    @Test
    public void testOutputStateSingleValue() {
        SingleListaggAggregationState state = TestListaggAggregationFunction.createListaggAggregationState(",", true, "...", false, "value1");
        Assertions.assertThat((String)TestListaggAggregationFunction.getOutputStateOnlyValue(state, 1024)).isEqualTo("value1");
    }

    @Test
    public void testOutputStateWithOverflowError() {
        SingleListaggAggregationState state = TestListaggAggregationFunction.createListaggAggregationState("", true, "...", false, "overflowvalue1", "overflowvalue2");
        state.setMaxOutputLength(20);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> state.write(VarcharType.VARCHAR.createBlockBuilder(null, 1))).isInstanceOf(TrinoException.class)).matches(throwable -> ((TrinoException)throwable).getErrorCode() == StandardErrorCode.EXCEEDED_FUNCTION_MEMORY_LIMIT.toErrorCode());
    }

    @Test
    public void testOutputStateWithEmptyValues() {
        SingleListaggAggregationState state = TestListaggAggregationFunction.createListaggAggregationState(",", true, "...", false, "trino", "", "", "", "");
        Assertions.assertThat((String)TestListaggAggregationFunction.getOutputStateOnlyValue(state, 12)).isEqualTo("trino,,,,");
    }

    @Test
    public void testOutputStateWithEmptyDelimiter() {
        SingleListaggAggregationState state = TestListaggAggregationFunction.createListaggAggregationState("", true, "...", false, "value1", "value2");
        Assertions.assertThat((String)TestListaggAggregationFunction.getOutputStateOnlyValue(state, 12)).isEqualTo("value1value2");
    }

    @Test
    public void testOutputStateWithSeparatorSpecialUnicodeCharacter() {
        SingleListaggAggregationState state = TestListaggAggregationFunction.createListaggAggregationState("\u2665", true, "...", false, "Trino", "SQL", "on", "everything");
        Assertions.assertThat((String)TestListaggAggregationFunction.getOutputStateOnlyValue(state, 29)).isEqualTo("Trino\u2665SQL\u2665on\u2665everything");
    }

    @Test
    public void testOutputTruncatedStateFirstValueTooBigWithoutIndicationCount() {
        SingleListaggAggregationState state = TestListaggAggregationFunction.createListaggAggregationState(",", false, "...", false, "value1", "value2");
        Assertions.assertThat((String)TestListaggAggregationFunction.getOutputStateOnlyValue(state, 5)).isEqualTo("...");
    }

    @Test
    public void testOutputTruncatedStateLastDelimiterOmitted() {
        SingleListaggAggregationState state = TestListaggAggregationFunction.createListaggAggregationState("###", false, "...", false, "value1", "value2", "value3");
        Assertions.assertThat((String)TestListaggAggregationFunction.getOutputStateOnlyValue(state, 18)).isEqualTo("value1###value2###...");
        Assertions.assertThat((String)TestListaggAggregationFunction.getOutputStateOnlyValue(state, 19)).isEqualTo("value1###value2###...");
        Assertions.assertThat((String)TestListaggAggregationFunction.getOutputStateOnlyValue(state, 20)).isEqualTo("value1###value2###...");
        Assertions.assertThat((String)TestListaggAggregationFunction.getOutputStateOnlyValue(state, 21)).isEqualTo("value1###value2###...");
        Assertions.assertThat((String)TestListaggAggregationFunction.getOutputStateOnlyValue(state, 22)).isEqualTo("value1###value2###...");
    }

    @Test
    public void testOutputTruncatedStateWithoutIndicationCount() {
        SingleListaggAggregationState state = TestListaggAggregationFunction.createListaggAggregationState(",", false, "...", false, "value1", "value2");
        Assertions.assertThat((String)TestListaggAggregationFunction.getOutputStateOnlyValue(state, 9)).isEqualTo("value1,...");
        Assertions.assertThat((String)TestListaggAggregationFunction.getOutputStateOnlyValue(state, 10)).isEqualTo("value1,...");
        Assertions.assertThat((String)TestListaggAggregationFunction.getOutputStateOnlyValue(state, 11)).isEqualTo("value1,...");
        Assertions.assertThat((String)TestListaggAggregationFunction.getOutputStateOnlyValue(state, 12)).isEqualTo("value1,...");
        Assertions.assertThat((String)TestListaggAggregationFunction.getOutputStateOnlyValue(state, 13)).isEqualTo("value1,value2");
    }

    @Test
    public void testOutputTruncatedStateWithIndicationCount() {
        SingleListaggAggregationState state = TestListaggAggregationFunction.createListaggAggregationState(",", false, "...", true, "string1", "string2");
        Assertions.assertThat((String)TestListaggAggregationFunction.getOutputStateOnlyValue(state, 12)).isEqualTo("string1,...(1)");
        Assertions.assertThat((String)TestListaggAggregationFunction.getOutputStateOnlyValue(state, 13)).isEqualTo("string1,...(1)");
        Assertions.assertThat((String)TestListaggAggregationFunction.getOutputStateOnlyValue(state, 14)).isEqualTo("string1,...(1)");
    }

    @Test
    public void testOutputTruncatedStateWithIndicationCountAlphabet() {
        SingleListaggAggregationState state = TestListaggAggregationFunction.createListaggAggregationState(",", false, "...", true, "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "x", "y", "z");
        Assertions.assertThat((String)TestListaggAggregationFunction.getOutputStateOnlyValue(state, 13)).isEqualTo("a,b,c,d,e,f,g,...(18)");
        Assertions.assertThat((String)TestListaggAggregationFunction.getOutputStateOnlyValue(state, 14)).isEqualTo("a,b,c,d,e,f,g,...(18)");
        Assertions.assertThat((String)TestListaggAggregationFunction.getOutputStateOnlyValue(state, 15)).isEqualTo("a,b,c,d,e,f,g,h,...(17)");
        Assertions.assertThat((String)TestListaggAggregationFunction.getOutputStateOnlyValue(state, 16)).isEqualTo("a,b,c,d,e,f,g,h,...(17)");
        Assertions.assertThat((String)TestListaggAggregationFunction.getOutputStateOnlyValue(state, 17)).isEqualTo("a,b,c,d,e,f,g,h,i,...(16)");
        Assertions.assertThat((String)TestListaggAggregationFunction.getOutputStateOnlyValue(state, 18)).isEqualTo("a,b,c,d,e,f,g,h,i,...(16)");
        Assertions.assertThat((String)TestListaggAggregationFunction.getOutputStateOnlyValue(state, 19)).isEqualTo("a,b,c,d,e,f,g,h,i,j,...(15)");
        Assertions.assertThat((String)TestListaggAggregationFunction.getOutputStateOnlyValue(state, 20)).isEqualTo("a,b,c,d,e,f,g,h,i,j,...(15)");
        Assertions.assertThat((String)TestListaggAggregationFunction.getOutputStateOnlyValue(state, 21)).isEqualTo("a,b,c,d,e,f,g,h,i,j,k,...(14)");
    }

    @Test
    public void testOutputTruncatedStateWithIndicationCountComplexSeparator() {
        SingleListaggAggregationState state = TestListaggAggregationFunction.createListaggAggregationState("###", false, "...", true, "a", "b", "c", "dd", "e", "f", "g", "h", "i", "j", "k", "l");
        Assertions.assertThat((String)TestListaggAggregationFunction.getOutputStateOnlyValue(state, 100)).isEqualTo("a###b###c###dd###e###f###g###h###i###j###k###l");
        Assertions.assertThat((String)TestListaggAggregationFunction.getOutputStateOnlyValue(state, 15)).isEqualTo("a###b###c###dd###...(8)");
        Assertions.assertThat((String)TestListaggAggregationFunction.getOutputStateOnlyValue(state, 16)).isEqualTo("a###b###c###dd###...(8)");
        Assertions.assertThat((String)TestListaggAggregationFunction.getOutputStateOnlyValue(state, 17)).isEqualTo("a###b###c###dd###...(8)");
        Assertions.assertThat((String)TestListaggAggregationFunction.getOutputStateOnlyValue(state, 18)).isEqualTo("a###b###c###dd###e###...(7)");
        Assertions.assertThat((String)TestListaggAggregationFunction.getOutputStateOnlyValue(state, 19)).isEqualTo("a###b###c###dd###e###...(7)");
        Assertions.assertThat((String)TestListaggAggregationFunction.getOutputStateOnlyValue(state, 20)).isEqualTo("a###b###c###dd###e###...(7)");
        Assertions.assertThat((String)TestListaggAggregationFunction.getOutputStateOnlyValue(state, 21)).isEqualTo("a###b###c###dd###e###...(7)");
    }

    @Test
    public void testExecute() {
        List parameterTypes = TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, BooleanType.BOOLEAN, VarcharType.VARCHAR, BooleanType.BOOLEAN});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "listagg", (List<TypeSignatureProvider>)parameterTypes, null, new Block[]{BlockAssertions.createStringsBlock(null, null, null), BlockAssertions.createStringsBlock(",", ",", ","), BlockAssertions.createBooleansBlock(false, false, false), BlockAssertions.createStringsBlock("", "", ""), BlockAssertions.createBooleansBlock(false, false, false)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "listagg", (List<TypeSignatureProvider>)parameterTypes, (Object)"a,c", new Block[]{BlockAssertions.createStringsBlock("a", null, "c"), BlockAssertions.createStringsBlock(",", ",", ","), BlockAssertions.createBooleansBlock(false, false, false), BlockAssertions.createStringsBlock("", "", ""), BlockAssertions.createBooleansBlock(false, false, false)});
    }

    private static String getOutputStateOnlyValue(SingleListaggAggregationState state, int maxOutputLengthInBytes) {
        VariableWidthBlockBuilder blockBuilder = VarcharType.VARCHAR.createBlockBuilder(null, 1, maxOutputLengthInBytes + 20);
        state.setMaxOutputLength(maxOutputLengthInBytes);
        state.write(blockBuilder);
        return VarcharType.VARCHAR.getSlice(blockBuilder.build(), 0).toStringUtf8();
    }

    private static SingleListaggAggregationState createListaggAggregationState(String separator, boolean overflowError, String overflowFiller, boolean showOverflowEntryCount, String ... values) {
        SingleListaggAggregationState state = new SingleListaggAggregationState();
        state.initialize(Slices.utf8Slice((String)separator), overflowError, Slices.utf8Slice((String)overflowFiller), showOverflowEntryCount);
        for (String value : values) {
            state.add((ValueBlock)BlockAssertions.createStringsBlock(value), 0);
        }
        return state;
    }
}

