/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.security.oauth2;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Resources;
import com.google.inject.Key;
import com.google.inject.Module;
import io.airlift.http.client.HttpClient;
import io.airlift.http.client.HttpClientConfig;
import io.airlift.http.client.jetty.JettyHttpClient;
import io.airlift.log.Level;
import io.airlift.log.Logging;
import io.airlift.testing.Closeables;
import io.jsonwebtoken.SigningKeyResolver;
import io.trino.client.OkHttpUtil;
import io.trino.server.security.jwt.JwkService;
import io.trino.server.security.jwt.JwkSigningKeyResolver;
import io.trino.server.security.jwt.JwtUtil;
import io.trino.server.security.oauth2.OAuth2Client;
import io.trino.server.security.oauth2.OAuth2Service;
import io.trino.server.security.oauth2.TestingHydraIdentityProvider;
import io.trino.server.security.oauth2.TokenEndpointAuthMethod;
import io.trino.server.testing.TestingTrinoServer;
import io.trino.server.ui.OAuth2WebUiAuthenticationFilter;
import io.trino.server.ui.WebUiModule;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookieStore;
import java.net.HttpCookie;
import java.net.URI;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import okhttp3.CookieJar;
import okhttp3.JavaNetCookieJar;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestOAuth2WebUiAuthenticationFilterWithRefreshTokens {
    protected static final Duration TTL_ACCESS_TOKEN_IN_SECONDS = Duration.ofSeconds(5L);
    protected static final String TRINO_CLIENT_ID = "trino-client";
    protected static final String TRINO_CLIENT_SECRET = "trino-secret";
    private static final String TRINO_AUDIENCE = "trino-client";
    private static final String ADDITIONAL_AUDIENCE = "https://external-service.com";
    protected static final String TRUSTED_CLIENT_ID = "trusted-client";
    protected OkHttpClient httpClient;
    protected TestingHydraIdentityProvider hydraIdP;
    private TestingTrinoServer server;
    private URI serverUri;
    private URI uiUri;

    @BeforeAll
    public void setup() throws Exception {
        Logging logging = Logging.initialize();
        logging.setLevel(OAuth2WebUiAuthenticationFilter.class.getName(), Level.DEBUG);
        logging.setLevel(OAuth2Service.class.getName(), Level.DEBUG);
        OkHttpClient.Builder httpClientBuilder = new OkHttpClient.Builder();
        OkHttpUtil.setupInsecureSsl((OkHttpClient.Builder)httpClientBuilder);
        httpClientBuilder.followRedirects(false);
        this.httpClient = httpClientBuilder.build();
        this.hydraIdP = new TestingHydraIdentityProvider(TTL_ACCESS_TOKEN_IN_SECONDS, true, false);
        this.hydraIdP.start();
        String idpUrl = "https://localhost:" + this.hydraIdP.getAuthPort();
        this.server = TestingTrinoServer.builder().setCoordinator(true).setAdditionalModule((Module)new WebUiModule()).setProperties((Map)ImmutableMap.builder().put((Object)"web-ui.enabled", (Object)"true").put((Object)"web-ui.authentication.type", (Object)"oauth2").put((Object)"http-server.https.enabled", (Object)"true").put((Object)"http-server.https.keystore.path", (Object)Resources.getResource((String)"cert/localhost.pem").getPath()).put((Object)"http-server.https.keystore.key", (Object)"").put((Object)"http-server.authentication.oauth2.issuer", (Object)"https://localhost:4444/").put((Object)"http-server.authentication.oauth2.auth-url", (Object)(idpUrl + "/oauth2/auth")).put((Object)"http-server.authentication.oauth2.token-url", (Object)(idpUrl + "/oauth2/token")).put((Object)"http-server.authentication.oauth2.end-session-url", (Object)(idpUrl + "/oauth2/sessions/logout")).put((Object)"http-server.authentication.oauth2.jwks-url", (Object)(idpUrl + "/.well-known/jwks.json")).put((Object)"http-server.authentication.oauth2.client-id", (Object)"trino-client").put((Object)"http-server.authentication.oauth2.client-secret", (Object)TRINO_CLIENT_SECRET).put((Object)"http-server.authentication.oauth2.additional-audiences", (Object)TRUSTED_CLIENT_ID).put((Object)"http-server.authentication.oauth2.max-clock-skew", (Object)"0s").put((Object)"http-server.authentication.oauth2.user-mapping.pattern", (Object)"(.*)(@.*)?").put((Object)"http-server.authentication.oauth2.oidc.discovery", (Object)"false").put((Object)"http-server.authentication.oauth2.scopes", (Object)"openid,offline").put((Object)"http-server.authentication.oauth2.refresh-tokens", (Object)"true").put((Object)"oauth2-jwk.http-client.trust-store-path", (Object)Resources.getResource((String)"cert/localhost.pem").getPath()).buildOrThrow()).build();
        ((OAuth2Client)this.server.getInstance(Key.get(OAuth2Client.class))).load();
        this.serverUri = this.server.getHttpsBaseUrl();
        this.uiUri = this.serverUri.resolve("/ui/");
        this.hydraIdP.createClient("trino-client", TRINO_CLIENT_SECRET, TokenEndpointAuthMethod.CLIENT_SECRET_BASIC, (List<String>)ImmutableList.of((Object)"trino-client", (Object)ADDITIONAL_AUDIENCE), String.valueOf(this.serverUri) + "/oauth2/callback", String.valueOf(this.serverUri) + "/ui/logout/logout.html");
    }

    @AfterAll
    public void tearDown() throws Exception {
        Logging logging = Logging.initialize();
        logging.clearLevel(OAuth2WebUiAuthenticationFilter.class.getName());
        logging.clearLevel(OAuth2Service.class.getName());
        Closeables.closeAll((AutoCloseable[])new AutoCloseable[]{this.server, this.hydraIdP, () -> {
            this.httpClient.dispatcher().executorService().shutdown();
            this.httpClient.connectionPool().evictAll();
        }});
        this.server = null;
        this.hydraIdP = null;
        this.httpClient = null;
    }

    @Test
    public void testSuccessfulFlowWithRefreshedAccessToken() throws Exception {
        CookieManager cookieManager = new CookieManager();
        CookieStore cookieStore = cookieManager.getCookieStore();
        OkHttpClient.Builder httpClientBuilder = new OkHttpClient.Builder();
        OkHttpUtil.setupInsecureSsl((OkHttpClient.Builder)httpClientBuilder);
        OkHttpClient httpClient = httpClientBuilder.followRedirects(true).cookieJar((CookieJar)new JavaNetCookieJar((CookieHandler)cookieManager)).build();
        Assertions.assertThat(cookieStore.get(this.uiUri)).isEmpty();
        this.accessUi(httpClient);
        HttpCookie idTokenCookie = cookieStore.get(this.uiUri).stream().filter(cookie -> cookie.getName().equals("__Secure-Trino-ID-Token")).findFirst().orElseThrow();
        Thread.sleep(TTL_ACCESS_TOKEN_IN_SECONDS.plusSeconds(1L).toMillis());
        this.accessUi(httpClient);
        HttpCookie newIdTokenCookie = cookieStore.get(this.uiUri).stream().filter(cookie -> cookie.getName().equals("__Secure-Trino-ID-Token")).findFirst().orElseThrow();
        Assertions.assertThat((String)newIdTokenCookie.getValue()).isEqualTo(idTokenCookie.getValue());
        this.assertTokenIsExpired(newIdTokenCookie.getValue());
        try (Response response = httpClient.newCall(new Request.Builder().url(this.uiUri.resolve("logout").toURL()).get().build()).execute();){
            Assertions.assertThat((int)response.code()).isEqualTo(200);
            Assertions.assertThat((String)response.request().url().toString()).isEqualTo(this.uiUri.resolve("logout/logout.html").toString());
        }
        Assertions.assertThat(cookieStore.get(this.uiUri)).isEmpty();
    }

    protected void assertTokenIsExpired(String claimsJws) {
        Assertions.assertThatThrownBy(() -> JwtUtil.newJwtParserBuilder().setSigningKeyResolver((SigningKeyResolver)new JwkSigningKeyResolver(new JwkService(URI.create("https://localhost:" + this.hydraIdP.getAuthPort() + "/.well-known/jwks.json"), (HttpClient)new JettyHttpClient(new HttpClientConfig().setTrustStorePath(Resources.getResource((String)"cert/localhost.pem").getPath()))))).build().parseClaimsJws((CharSequence)claimsJws));
    }

    private void accessUi(OkHttpClient httpClient) throws Exception {
        try (Response response = httpClient.newCall(new Request.Builder().url(this.uiUri.toURL()).get().build()).execute();){
            Assertions.assertThat((int)response.code()).isEqualTo(200);
            Assertions.assertThat((String)response.request().url().toString()).isEqualTo(this.uiUri.toString());
        }
    }
}

