/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql;

import com.google.common.collect.ImmutableList;
import io.trino.jmh.Benchmarks;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.sql.TestExpressionInterpreter;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.InPredicate;
import io.trino.sql.ir.SymbolReference;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.options.WarmupMode;

@State(value=Scope.Benchmark)
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@Warmup(iterations=5)
@Fork(value=1)
@Measurement(iterations=20)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkExpressionInterpreter {
    @Benchmark
    public List<Object> optimize(BenchmarkData benchmarkData) {
        return (List)benchmarkData.expressions.stream().map(TestExpressionInterpreter::optimize).collect(ImmutableList.toImmutableList());
    }

    @Test
    public void verify() {
        BenchmarkData data = new BenchmarkData();
        data.setup();
        BenchmarkExpressionInterpreter benchmark = new BenchmarkExpressionInterpreter();
        Assertions.assertThat((int)benchmark.optimize(data).size()).isEqualTo(data.expressions.size());
    }

    public static void main(String[] args) throws Exception {
        Benchmarks.benchmark(BenchmarkExpressionInterpreter.class, (WarmupMode)WarmupMode.BULK).run();
    }

    @State(value=Scope.Benchmark)
    public static class BenchmarkData {
        @Param(value={"200", "500", "1000", "5000"})
        private int inValuesCount = 2;
        private List<Expression> expressions;

        @Setup
        public void setup() {
            this.expressions = ImmutableList.of((Object)new InPredicate((Expression)new SymbolReference((Type)IntegerType.INTEGER, "bound_value"), IntStream.range(0, this.inValuesCount).mapToObj(i -> new Constant((Type)IntegerType.INTEGER, (Object)i)).collect(Collectors.toList())));
        }
    }
}

