/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slices;
import io.trino.SessionTestUtils;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.ExpressionTestUtils;
import io.trino.sql.PlannerContext;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.ir.ArithmeticBinaryExpression;
import io.trino.sql.ir.ArithmeticNegation;
import io.trino.sql.ir.BetweenPredicate;
import io.trino.sql.ir.BooleanLiteral;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.CoalesceExpression;
import io.trino.sql.ir.ComparisonExpression;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.FunctionCall;
import io.trino.sql.ir.InPredicate;
import io.trino.sql.ir.IrExpressions;
import io.trino.sql.ir.IsNullPredicate;
import io.trino.sql.ir.LogicalExpression;
import io.trino.sql.ir.NotExpression;
import io.trino.sql.ir.NullIfExpression;
import io.trino.sql.ir.Row;
import io.trino.sql.ir.SearchedCaseExpression;
import io.trino.sql.ir.SimpleCaseExpression;
import io.trino.sql.ir.SubscriptExpression;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.ir.WhenClause;
import io.trino.sql.planner.IrExpressionInterpreter;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolResolver;
import io.trino.sql.planner.TestingPlannerContext;
import io.trino.sql.planner.assertions.SymbolAliases;
import io.trino.testing.assertions.TrinoExceptionAssert;
import io.trino.transaction.TestingTransactionManager;
import io.trino.type.UnknownType;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestExpressionInterpreter {
    private static final Set<Symbol> SYMBOLS = ImmutableSet.of((Object)new Symbol((Type)IntegerType.INTEGER, "bound_value"), (Object)new Symbol((Type)IntegerType.INTEGER, "unbound_value"));
    private static final SymbolResolver INPUTS = symbol -> {
        if (symbol.getName().toLowerCase(Locale.ENGLISH).equals("bound_value")) {
            return 1234L;
        }
        return symbol.toSymbolReference();
    };
    private static final TestingTransactionManager TRANSACTION_MANAGER = new TestingTransactionManager();
    private static final PlannerContext PLANNER_CONTEXT = TestingPlannerContext.plannerContextBuilder().withTransactionManager(TRANSACTION_MANAGER).build();
    private static final TestingFunctionResolution FUNCTIONS = new TestingFunctionResolution();
    private static final ResolvedFunction ABS = FUNCTIONS.resolveFunction("abs", TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT}));
    private static final ResolvedFunction RANDOM = FUNCTIONS.resolveFunction("random", TypeSignatureProvider.fromTypes((Type[])new Type[0]));
    private static final ResolvedFunction ADD_INTEGER = FUNCTIONS.resolveOperator(OperatorType.ADD, (List<? extends Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER));
    private static final ResolvedFunction SUBTRACT_INTEGER = FUNCTIONS.resolveOperator(OperatorType.SUBTRACT, (List<? extends Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER));
    private static final ResolvedFunction MULTIPLY_INTEGER = FUNCTIONS.resolveOperator(OperatorType.MULTIPLY, (List<? extends Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER));
    private static final ResolvedFunction DIVIDE_INTEGER = FUNCTIONS.resolveOperator(OperatorType.DIVIDE, (List<? extends Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER));

    @Test
    public void testAnd() {
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)BooleanLiteral.TRUE_LITERAL, (Object)BooleanLiteral.FALSE_LITERAL)), (Expression)BooleanLiteral.FALSE_LITERAL);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)BooleanLiteral.FALSE_LITERAL, (Object)BooleanLiteral.TRUE_LITERAL)), (Expression)BooleanLiteral.FALSE_LITERAL);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)BooleanLiteral.FALSE_LITERAL, (Object)BooleanLiteral.FALSE_LITERAL)), (Expression)BooleanLiteral.FALSE_LITERAL);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)BooleanLiteral.TRUE_LITERAL, (Object)new Constant((Type)UnknownType.UNKNOWN, null))), (Expression)new Constant((Type)UnknownType.UNKNOWN, null));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)BooleanLiteral.FALSE_LITERAL, (Object)new Constant((Type)UnknownType.UNKNOWN, null))), (Expression)BooleanLiteral.FALSE_LITERAL);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new Constant((Type)UnknownType.UNKNOWN, null), (Object)BooleanLiteral.TRUE_LITERAL)), (Expression)new Constant((Type)UnknownType.UNKNOWN, null));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new Constant((Type)UnknownType.UNKNOWN, null), (Object)BooleanLiteral.FALSE_LITERAL)), (Expression)BooleanLiteral.FALSE_LITERAL);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new Constant((Type)UnknownType.UNKNOWN, null), (Object)new Constant((Type)UnknownType.UNKNOWN, null))), (Expression)new Constant((Type)UnknownType.UNKNOWN, null));
    }

    @Test
    public void testOr() {
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)BooleanLiteral.TRUE_LITERAL, (Object)BooleanLiteral.TRUE_LITERAL)), (Expression)BooleanLiteral.TRUE_LITERAL);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)BooleanLiteral.TRUE_LITERAL, (Object)BooleanLiteral.FALSE_LITERAL)), (Expression)BooleanLiteral.TRUE_LITERAL);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)BooleanLiteral.FALSE_LITERAL, (Object)BooleanLiteral.TRUE_LITERAL)), (Expression)BooleanLiteral.TRUE_LITERAL);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)BooleanLiteral.FALSE_LITERAL, (Object)BooleanLiteral.FALSE_LITERAL)), (Expression)BooleanLiteral.FALSE_LITERAL);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)BooleanLiteral.TRUE_LITERAL, (Object)new Constant((Type)UnknownType.UNKNOWN, null))), (Expression)BooleanLiteral.TRUE_LITERAL);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new Constant((Type)UnknownType.UNKNOWN, null), (Object)BooleanLiteral.TRUE_LITERAL)), (Expression)BooleanLiteral.TRUE_LITERAL);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new Constant((Type)UnknownType.UNKNOWN, null), (Object)new Constant((Type)UnknownType.UNKNOWN, null))), (Expression)new Constant((Type)UnknownType.UNKNOWN, null));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)BooleanLiteral.FALSE_LITERAL, (Object)new Constant((Type)UnknownType.UNKNOWN, null))), (Expression)new Constant((Type)UnknownType.UNKNOWN, null));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new Constant((Type)UnknownType.UNKNOWN, null), (Object)BooleanLiteral.FALSE_LITERAL)), (Expression)new Constant((Type)UnknownType.UNKNOWN, null));
    }

    @Test
    public void testComparison() {
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new Constant((Type)UnknownType.UNKNOWN, null), (Expression)new Constant((Type)UnknownType.UNKNOWN, null)), (Expression)new Constant((Type)UnknownType.UNKNOWN, null));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"a")), (Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"b"))), (Expression)BooleanLiteral.FALSE_LITERAL);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"a")), (Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"a"))), (Expression)BooleanLiteral.TRUE_LITERAL);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"a")), (Expression)new Constant((Type)UnknownType.UNKNOWN, null)), (Expression)new Constant((Type)UnknownType.UNKNOWN, null));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new Constant((Type)UnknownType.UNKNOWN, null), (Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"a"))), (Expression)new Constant((Type)UnknownType.UNKNOWN, null));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "bound_value"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1234L)), (Expression)BooleanLiteral.TRUE_LITERAL);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "bound_value"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)), (Expression)BooleanLiteral.FALSE_LITERAL);
    }

    @Test
    public void testIsDistinctFrom() {
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)new Constant((Type)UnknownType.UNKNOWN, null), (Expression)new Constant((Type)UnknownType.UNKNOWN, null)), (Expression)BooleanLiteral.FALSE_LITERAL);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)4L)), (Expression)BooleanLiteral.TRUE_LITERAL);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L)), (Expression)BooleanLiteral.FALSE_LITERAL);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L), (Expression)new Constant((Type)UnknownType.UNKNOWN, null)), (Expression)BooleanLiteral.TRUE_LITERAL);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)new Constant((Type)UnknownType.UNKNOWN, null), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L)), (Expression)BooleanLiteral.TRUE_LITERAL);
        TestExpressionInterpreter.assertOptimizedMatches((Expression)new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "unbound_value"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)), (Expression)new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "unbound_value"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)));
        TestExpressionInterpreter.assertOptimizedMatches((Expression)new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)new SymbolReference((Type)UnknownType.UNKNOWN, "unbound_value"), (Expression)new Constant((Type)UnknownType.UNKNOWN, null)), (Expression)new NotExpression((Expression)new IsNullPredicate((Expression)new SymbolReference((Type)IntegerType.INTEGER, "unbound_value"))));
        TestExpressionInterpreter.assertOptimizedMatches((Expression)new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)new Constant((Type)UnknownType.UNKNOWN, null), (Expression)new SymbolReference((Type)IntegerType.INTEGER, "unbound_value")), (Expression)new NotExpression((Expression)new IsNullPredicate((Expression)new SymbolReference((Type)IntegerType.INTEGER, "unbound_value"))));
    }

    @Test
    public void testIsNull() {
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new IsNullPredicate((Expression)new Constant((Type)UnknownType.UNKNOWN, null)), (Expression)BooleanLiteral.TRUE_LITERAL);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new IsNullPredicate((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)), (Expression)BooleanLiteral.FALSE_LITERAL);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new IsNullPredicate((Expression)new ArithmeticBinaryExpression(ADD_INTEGER, ArithmeticBinaryExpression.Operator.ADD, (Expression)new Constant((Type)IntegerType.INTEGER, null), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L))), (Expression)BooleanLiteral.TRUE_LITERAL);
    }

    @Test
    public void testIsNotNull() {
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new NotExpression((Expression)new IsNullPredicate((Expression)new Constant((Type)UnknownType.UNKNOWN, null))), (Expression)BooleanLiteral.FALSE_LITERAL);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new NotExpression((Expression)new IsNullPredicate((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L))), (Expression)BooleanLiteral.TRUE_LITERAL);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new NotExpression((Expression)new IsNullPredicate((Expression)new ArithmeticBinaryExpression(ADD_INTEGER, ArithmeticBinaryExpression.Operator.ADD, (Expression)new Constant((Type)IntegerType.INTEGER, null), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)))), (Expression)BooleanLiteral.FALSE_LITERAL);
    }

    @Test
    public void testNullIf() {
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new NullIfExpression((Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"a")), (Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"a"))), (Expression)new Constant((Type)UnknownType.UNKNOWN, null));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new NullIfExpression((Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"a")), (Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"b"))), (Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"a")));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new NullIfExpression((Expression)new Constant((Type)UnknownType.UNKNOWN, null), (Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"b"))), (Expression)new Constant((Type)UnknownType.UNKNOWN, null));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new NullIfExpression((Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"a")), (Expression)new Constant((Type)UnknownType.UNKNOWN, null)), (Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"a")));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new NullIfExpression((Expression)new SymbolReference((Type)IntegerType.INTEGER, "unbound_value"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)), (Expression)new NullIfExpression((Expression)new SymbolReference((Type)IntegerType.INTEGER, "unbound_value"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)));
    }

    @Test
    public void testNegative() {
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new ArithmeticNegation((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)-1L));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new ArithmeticNegation((Expression)new ArithmeticBinaryExpression(ADD_INTEGER, ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "unbound_value"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L))), (Expression)new ArithmeticNegation((Expression)new ArithmeticBinaryExpression(ADD_INTEGER, ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "unbound_value"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L))));
    }

    @Test
    public void testNot() {
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new NotExpression((Expression)BooleanLiteral.TRUE_LITERAL), (Expression)BooleanLiteral.FALSE_LITERAL);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new NotExpression((Expression)BooleanLiteral.FALSE_LITERAL), (Expression)BooleanLiteral.TRUE_LITERAL);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new NotExpression((Expression)new Constant((Type)UnknownType.UNKNOWN, null)), (Expression)new Constant((Type)UnknownType.UNKNOWN, null));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "unbound_value"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L))), (Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "unbound_value"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L))));
    }

    @Test
    public void testFunctionCall() {
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new FunctionCall(ABS, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)5L))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)5L));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new FunctionCall(ABS, (List)ImmutableList.of((Object)new SymbolReference((Type)IntegerType.INTEGER, "unbound_value"))), (Expression)new FunctionCall(ABS, (List)ImmutableList.of((Object)new SymbolReference((Type)IntegerType.INTEGER, "unbound_value"))));
    }

    @Test
    public void testNonDeterministicFunctionCall() {
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new FunctionCall(RANDOM, (List)ImmutableList.of()), (Expression)new FunctionCall(RANDOM, (List)ImmutableList.of()));
    }

    @Test
    public void testBetween() {
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new BetweenPredicate((Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)4L)), (Expression)BooleanLiteral.TRUE_LITERAL);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new BetweenPredicate((Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)4L)), (Expression)BooleanLiteral.FALSE_LITERAL);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new BetweenPredicate((Expression)new Constant((Type)UnknownType.UNKNOWN, null), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)4L)), (Expression)new Constant((Type)UnknownType.UNKNOWN, null));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new BetweenPredicate((Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L), (Expression)new Constant((Type)UnknownType.UNKNOWN, null), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)4L)), (Expression)new Constant((Type)UnknownType.UNKNOWN, null));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new BetweenPredicate((Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Expression)new Constant((Type)UnknownType.UNKNOWN, null)), (Expression)new Constant((Type)UnknownType.UNKNOWN, null));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new BetweenPredicate((Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L), (Expression)new Constant((Type)UnknownType.UNKNOWN, null)), (Expression)BooleanLiteral.FALSE_LITERAL);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new BetweenPredicate((Expression)new Constant((Type)IntegerType.INTEGER, (Object)8L), (Expression)new Constant((Type)UnknownType.UNKNOWN, null), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)6L)), (Expression)BooleanLiteral.FALSE_LITERAL);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new BetweenPredicate((Expression)new SymbolReference((Type)IntegerType.INTEGER, "bound_value"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1000L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2000L)), (Expression)BooleanLiteral.TRUE_LITERAL);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new BetweenPredicate((Expression)new SymbolReference((Type)IntegerType.INTEGER, "bound_value"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)4L)), (Expression)BooleanLiteral.FALSE_LITERAL);
    }

    @Test
    public void testIn() {
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new InPredicate((Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L), (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)4L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)3L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)5L))), (Expression)BooleanLiteral.TRUE_LITERAL);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new InPredicate((Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L), (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)4L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)9L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)5L))), (Expression)BooleanLiteral.FALSE_LITERAL);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new InPredicate((Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L), (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Object)new Constant((Type)IntegerType.INTEGER, null), (Object)new Constant((Type)IntegerType.INTEGER, (Object)3L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)5L))), (Expression)BooleanLiteral.TRUE_LITERAL);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new InPredicate((Expression)new Constant((Type)IntegerType.INTEGER, null), (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Object)new Constant((Type)IntegerType.INTEGER, null), (Object)new Constant((Type)IntegerType.INTEGER, (Object)3L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)5L))), (Expression)new Constant((Type)UnknownType.UNKNOWN, null));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new InPredicate((Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L), (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Object)new Constant((Type)IntegerType.INTEGER, null))), (Expression)new Constant((Type)UnknownType.UNKNOWN, null));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new InPredicate((Expression)new SymbolReference((Type)IntegerType.INTEGER, "bound_value"), (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)1234L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)3L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)5L))), (Expression)BooleanLiteral.TRUE_LITERAL);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new InPredicate((Expression)new SymbolReference((Type)IntegerType.INTEGER, "bound_value"), (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)4L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)3L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)5L))), (Expression)BooleanLiteral.FALSE_LITERAL);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new InPredicate((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1234L), (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Object)new SymbolReference((Type)IntegerType.INTEGER, "bound_value"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)3L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)5L))), (Expression)BooleanLiteral.TRUE_LITERAL);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new InPredicate((Expression)new Constant((Type)IntegerType.INTEGER, (Object)99L), (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Object)new SymbolReference((Type)IntegerType.INTEGER, "bound_value"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)3L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)5L))), (Expression)BooleanLiteral.FALSE_LITERAL);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new InPredicate((Expression)new SymbolReference((Type)IntegerType.INTEGER, "bound_value"), (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Object)new SymbolReference((Type)IntegerType.INTEGER, "bound_value"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)3L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)5L))), (Expression)BooleanLiteral.TRUE_LITERAL);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new InPredicate((Expression)new SymbolReference((Type)IntegerType.INTEGER, "unbound_value"), (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)1L))), (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "unbound_value"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new InPredicate((Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L), (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)4L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)3L), (Object)new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)5L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)))), (Expression)new InPredicate((Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L), (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)4L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)3L), (Object)new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)5L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)))));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new InPredicate((Expression)new Constant((Type)IntegerType.INTEGER, null), (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)4L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)3L), (Object)new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)5L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)))), (Expression)new InPredicate((Expression)new Constant((Type)IntegerType.INTEGER, null), (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)4L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)3L), (Object)new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)5L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)))));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new InPredicate((Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L), (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)4L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)3L), (Object)new Constant((Type)IntegerType.INTEGER, null), (Object)new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)5L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)))), (Expression)new InPredicate((Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L), (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)4L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)3L), (Object)new Constant((Type)IntegerType.INTEGER, null), (Object)new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)5L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)))));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new InPredicate((Expression)new Constant((Type)IntegerType.INTEGER, null), (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)4L), (Object)new Constant((Type)IntegerType.INTEGER, null), (Object)new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)5L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)))), (Expression)new InPredicate((Expression)new Constant((Type)IntegerType.INTEGER, null), (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)4L), (Object)new Constant((Type)IntegerType.INTEGER, null), (Object)new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)5L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)))));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new InPredicate((Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L), (List)ImmutableList.of((Object)new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)5L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Object)new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)5L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)))), (Expression)new InPredicate((Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L), (List)ImmutableList.of((Object)new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)5L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Object)new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)5L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)))));
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> TestExpressionInterpreter.evaluate((Expression)new InPredicate((Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L), (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)4L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)3L), (Object)new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)5L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)))))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.DIVISION_BY_ZERO});
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new InPredicate((Expression)new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)4L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)3L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)5L))), (Expression)new InPredicate((Expression)new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)4L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)3L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)5L))));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new InPredicate((Expression)new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)4L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)4L))), (Expression)new InPredicate((Expression)new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)4L))));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new InPredicate((Expression)new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)2L))), (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L)));
    }

    @Test
    public void testCastOptimization() {
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Cast((Expression)new SymbolReference((Type)IntegerType.INTEGER, "bound_value"), (Type)VarcharType.VARCHAR), (Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"1234")));
        TestExpressionInterpreter.assertOptimizedMatches((Expression)new Cast((Expression)new SymbolReference((Type)IntegerType.INTEGER, "unbound_value"), (Type)IntegerType.INTEGER), (Expression)new SymbolReference((Type)IntegerType.INTEGER, "unbound_value"));
    }

    @Test
    public void testTryCast() {
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Cast((Expression)new Constant((Type)UnknownType.UNKNOWN, null), (Type)BigintType.BIGINT, true), (Expression)new Constant((Type)UnknownType.UNKNOWN, null));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Cast((Expression)new Constant((Type)IntegerType.INTEGER, (Object)123L), (Type)BigintType.BIGINT, true), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)123L));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Cast((Expression)new Constant((Type)UnknownType.UNKNOWN, null), (Type)IntegerType.INTEGER, true), (Expression)new Constant((Type)UnknownType.UNKNOWN, null));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new Cast((Expression)new Constant((Type)IntegerType.INTEGER, (Object)123L), (Type)IntegerType.INTEGER, true), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)123L));
    }

    @Test
    public void testSearchCase() {
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new SearchedCaseExpression((List)ImmutableList.of((Object)new WhenClause((Expression)BooleanLiteral.TRUE_LITERAL, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)33L))), Optional.empty()), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)33L));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new SearchedCaseExpression((List)ImmutableList.of((Object)new WhenClause((Expression)BooleanLiteral.FALSE_LITERAL, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L))), Optional.of(new Constant((Type)IntegerType.INTEGER, (Object)33L))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)33L));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new SearchedCaseExpression((List)ImmutableList.of((Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "bound_value"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1234L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)33L))), Optional.empty()), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)33L));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new SearchedCaseExpression((List)ImmutableList.of((Object)new WhenClause((Expression)BooleanLiteral.TRUE_LITERAL, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "bound_value"))), Optional.empty()), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1234L));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new SearchedCaseExpression((List)ImmutableList.of((Object)new WhenClause((Expression)BooleanLiteral.FALSE_LITERAL, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L))), Optional.of(new SymbolReference((Type)IntegerType.INTEGER, "bound_value"))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1234L));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new SearchedCaseExpression((List)ImmutableList.of((Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "bound_value"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1234L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)33L))), Optional.of(new SymbolReference((Type)IntegerType.INTEGER, "unbound_value"))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)33L));
        TestExpressionInterpreter.assertOptimizedMatches((Expression)new SearchedCaseExpression((List)ImmutableList.of((Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L))), Optional.empty()), (Expression)new SearchedCaseExpression((List)ImmutableList.of((Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L))), Optional.empty()));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new SearchedCaseExpression((List)ImmutableList.of((Object)new WhenClause((Expression)BooleanLiteral.TRUE_LITERAL, (Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"a"))), (Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"b")))), Optional.of(new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"c")))), (Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"a")));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new SearchedCaseExpression((List)ImmutableList.of((Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"a"))), (Object)new WhenClause((Expression)BooleanLiteral.TRUE_LITERAL, (Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"b")))), Optional.of(new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"c")))), (Expression)new SearchedCaseExpression((List)ImmutableList.of((Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"a")))), Optional.of(new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"b")))));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new SearchedCaseExpression((List)ImmutableList.of((Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"a"))), (Object)new WhenClause((Expression)BooleanLiteral.FALSE_LITERAL, (Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"b")))), Optional.of(new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"c")))), (Expression)new SearchedCaseExpression((List)ImmutableList.of((Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"a")))), Optional.of(new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"c")))));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new SearchedCaseExpression((List)ImmutableList.of((Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"a"))), (Object)new WhenClause((Expression)BooleanLiteral.FALSE_LITERAL, (Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"b")))), Optional.empty()), (Expression)new SearchedCaseExpression((List)ImmutableList.of((Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"a")))), Optional.empty()));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new SearchedCaseExpression((List)ImmutableList.of((Object)new WhenClause((Expression)BooleanLiteral.TRUE_LITERAL, (Expression)new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L))), (Object)new WhenClause((Expression)BooleanLiteral.FALSE_LITERAL, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L))), Optional.empty()), (Expression)new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new SearchedCaseExpression((List)ImmutableList.of((Object)new WhenClause((Expression)BooleanLiteral.FALSE_LITERAL, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)), (Object)new WhenClause((Expression)BooleanLiteral.FALSE_LITERAL, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L))), Optional.of(new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)))), (Expression)new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)));
        TestExpressionInterpreter.assertEvaluatedEquals((Expression)new SearchedCaseExpression((List)ImmutableList.of((Object)new WhenClause((Expression)BooleanLiteral.FALSE_LITERAL, (Expression)new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L))), (Object)new WhenClause((Expression)BooleanLiteral.TRUE_LITERAL, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L))), Optional.of(new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L));
        TestExpressionInterpreter.assertEvaluatedEquals((Expression)new SearchedCaseExpression((List)ImmutableList.of((Object)new WhenClause((Expression)BooleanLiteral.TRUE_LITERAL, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)), (Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L))), Optional.of(new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L));
    }

    @Test
    public void testSimpleCase() {
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new SimpleCaseExpression((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (List)ImmutableList.of((Object)new WhenClause((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)33L)), (Object)new WhenClause((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)34L))), Optional.empty()), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)33L));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new SimpleCaseExpression((Expression)new Constant((Type)BooleanType.BOOLEAN, null), (List)ImmutableList.of((Object)new WhenClause((Expression)BooleanLiteral.TRUE_LITERAL, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)33L))), Optional.empty()), (Expression)new Constant((Type)UnknownType.UNKNOWN, null));
        for (SimpleCaseExpression simpleCaseExpression : Arrays.asList(new SimpleCaseExpression((Expression)new Constant((Type)BooleanType.BOOLEAN, null), (List)ImmutableList.of((Object)new WhenClause((Expression)BooleanLiteral.TRUE_LITERAL, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)33L))), Optional.of(new Constant((Type)IntegerType.INTEGER, (Object)33L))), new SimpleCaseExpression((Expression)new Constant((Type)IntegerType.INTEGER, (Object)33L), (List)ImmutableList.of((Object)new WhenClause((Expression)new Constant((Type)IntegerType.INTEGER, null), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L))), Optional.of(new Constant((Type)IntegerType.INTEGER, (Object)33L))), new SimpleCaseExpression((Expression)new SymbolReference((Type)IntegerType.INTEGER, "bound_value"), (List)ImmutableList.of((Object)new WhenClause((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1234L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)33L))), Optional.empty()), new SimpleCaseExpression((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1234L), (List)ImmutableList.of((Object)new WhenClause((Expression)new SymbolReference((Type)IntegerType.INTEGER, "bound_value"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)33L))), Optional.empty()))) {
            TestExpressionInterpreter.assertOptimizedEquals((Expression)simpleCaseExpression, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)33L));
        }
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new SimpleCaseExpression((Expression)BooleanLiteral.TRUE_LITERAL, (List)ImmutableList.of((Object)new WhenClause((Expression)BooleanLiteral.TRUE_LITERAL, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "bound_value"))), Optional.empty()), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1234L));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new SimpleCaseExpression((Expression)BooleanLiteral.TRUE_LITERAL, (List)ImmutableList.of((Object)new WhenClause((Expression)BooleanLiteral.FALSE_LITERAL, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L))), Optional.of(new SymbolReference((Type)IntegerType.INTEGER, "bound_value"))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1234L));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new SimpleCaseExpression((Expression)BooleanLiteral.TRUE_LITERAL, (List)ImmutableList.of((Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "unbound_value"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)), (Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L))), Optional.of(new Constant((Type)IntegerType.INTEGER, (Object)33L))), (Expression)new SimpleCaseExpression((Expression)BooleanLiteral.TRUE_LITERAL, (List)ImmutableList.of((Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "unbound_value"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)), (Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L))), Optional.of(new Constant((Type)IntegerType.INTEGER, (Object)33L))));
        TestExpressionInterpreter.assertOptimizedMatches((Expression)new SimpleCaseExpression((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (List)ImmutableList.of((Object)new WhenClause((Expression)new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)), (Object)new WhenClause((Expression)new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L))), Optional.of(new Constant((Type)IntegerType.INTEGER, (Object)1L))), (Expression)new SimpleCaseExpression((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (List)ImmutableList.of((Object)new WhenClause((Expression)new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)), (Object)new WhenClause((Expression)new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L))), Optional.of(new Constant((Type)IntegerType.INTEGER, (Object)1L))));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new SimpleCaseExpression((Expression)new Constant((Type)IntegerType.INTEGER, null), (List)ImmutableList.of((Object)new WhenClause((Expression)new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)))), Optional.of(new Constant((Type)IntegerType.INTEGER, (Object)1L))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new SimpleCaseExpression((Expression)new Constant((Type)IntegerType.INTEGER, null), (List)ImmutableList.of((Object)new WhenClause((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L))), Optional.of(new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)))), (Expression)new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new SimpleCaseExpression((Expression)new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (List)ImmutableList.of((Object)new WhenClause((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L))), Optional.of(new Constant((Type)IntegerType.INTEGER, (Object)3L))), (Expression)new SimpleCaseExpression((Expression)new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (List)ImmutableList.of((Object)new WhenClause((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L))), Optional.of(new Constant((Type)IntegerType.INTEGER, (Object)3L))));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new SimpleCaseExpression((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (List)ImmutableList.of((Object)new WhenClause((Expression)new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L))), Optional.of(new Constant((Type)IntegerType.INTEGER, (Object)3L))), (Expression)new SimpleCaseExpression((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (List)ImmutableList.of((Object)new WhenClause((Expression)new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L))), Optional.of(new Constant((Type)IntegerType.INTEGER, (Object)3L))));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new SimpleCaseExpression((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (List)ImmutableList.of((Object)new WhenClause((Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L)), (Object)new WhenClause((Expression)new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L))), Optional.of(new Constant((Type)IntegerType.INTEGER, (Object)4L))), (Expression)new SimpleCaseExpression((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (List)ImmutableList.of((Object)new WhenClause((Expression)new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L))), Optional.of(new Constant((Type)IntegerType.INTEGER, (Object)4L))));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new SimpleCaseExpression((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (List)ImmutableList.of((Object)new WhenClause((Expression)new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L))), Optional.empty()), (Expression)new SimpleCaseExpression((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (List)ImmutableList.of((Object)new WhenClause((Expression)new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L))), Optional.empty()));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new SimpleCaseExpression((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (List)ImmutableList.of((Object)new WhenClause((Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L)), (Object)new WhenClause((Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L))), Optional.empty()), (Expression)new Constant((Type)UnknownType.UNKNOWN, null));
        TestExpressionInterpreter.assertEvaluatedEquals((Expression)new SimpleCaseExpression((Expression)new Constant((Type)IntegerType.INTEGER, null), (List)ImmutableList.of((Object)new WhenClause((Expression)new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)))), Optional.of(new Constant((Type)IntegerType.INTEGER, (Object)1L))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L));
        TestExpressionInterpreter.assertEvaluatedEquals((Expression)new SimpleCaseExpression((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (List)ImmutableList.of((Object)new WhenClause((Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Expression)new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)))), Optional.of(new Constant((Type)IntegerType.INTEGER, (Object)3L))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L));
        TestExpressionInterpreter.assertEvaluatedEquals((Expression)new SimpleCaseExpression((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (List)ImmutableList.of((Object)new WhenClause((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L)), (Object)new WhenClause((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Expression)new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)))), Optional.empty()), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L));
        TestExpressionInterpreter.assertEvaluatedEquals((Expression)new SimpleCaseExpression((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (List)ImmutableList.of((Object)new WhenClause((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L))), Optional.of(new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L));
    }

    @Test
    public void testCoalesce() {
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new CoalesceExpression((Expression)new ArithmeticBinaryExpression(MULTIPLY_INTEGER, ArithmeticBinaryExpression.Operator.MULTIPLY, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "unbound_value"), (Expression)new ArithmeticBinaryExpression(MULTIPLY_INTEGER, ArithmeticBinaryExpression.Operator.MULTIPLY, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L))), (Expression)new ArithmeticBinaryExpression(SUBTRACT_INTEGER, ArithmeticBinaryExpression.Operator.SUBTRACT, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)), new Expression[]{new Constant((Type)IntegerType.INTEGER, null)}), (Expression)new CoalesceExpression((Expression)new ArithmeticBinaryExpression(MULTIPLY_INTEGER, ArithmeticBinaryExpression.Operator.MULTIPLY, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "unbound_value"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)6L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L), new Expression[0]));
        TestExpressionInterpreter.assertOptimizedMatches((Expression)new CoalesceExpression((Expression)new SymbolReference((Type)IntegerType.INTEGER, "unbound_value"), (Expression)new SymbolReference((Type)IntegerType.INTEGER, "unbound_value"), new Expression[0]), (Expression)new SymbolReference((Type)IntegerType.INTEGER, "unbound_value"));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new CoalesceExpression((Expression)new Constant((Type)IntegerType.INTEGER, (Object)6L), (Expression)new SymbolReference((Type)IntegerType.INTEGER, "unbound_value"), new Expression[0]), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)6L));
        TestExpressionInterpreter.assertOptimizedMatches((Expression)new CoalesceExpression((Expression)new FunctionCall(RANDOM, (List)ImmutableList.of()), (Expression)new FunctionCall(RANDOM, (List)ImmutableList.of()), new Expression[]{new Constant((Type)DoubleType.DOUBLE, (Object)5.0)}), (Expression)new CoalesceExpression((Expression)new FunctionCall(RANDOM, (List)ImmutableList.of()), (Expression)new FunctionCall(RANDOM, (List)ImmutableList.of()), new Expression[]{new Constant((Type)DoubleType.DOUBLE, (Object)5.0)}));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new CoalesceExpression((Expression)new Constant((Type)UnknownType.UNKNOWN, null), (Expression)new CoalesceExpression((Expression)new Constant((Type)UnknownType.UNKNOWN, null), (Expression)new Constant((Type)UnknownType.UNKNOWN, null), new Expression[0]), new Expression[0]), (Expression)new Constant((Type)UnknownType.UNKNOWN, null));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new CoalesceExpression((Expression)new Constant((Type)IntegerType.INTEGER, null), (Expression)new CoalesceExpression((Expression)new Constant((Type)IntegerType.INTEGER, null), (Expression)new CoalesceExpression((Expression)new Constant((Type)IntegerType.INTEGER, null), (Expression)new Constant((Type)IntegerType.INTEGER, null), new Expression[]{new Constant((Type)IntegerType.INTEGER, (Object)1L)}), new Expression[0]), new Expression[0]), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new CoalesceExpression((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Expression)new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), new Expression[0]), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new CoalesceExpression((Expression)new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), new Expression[0]), (Expression)new CoalesceExpression((Expression)new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), new Expression[0]));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new CoalesceExpression((Expression)new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), new Expression[]{new Constant((Type)IntegerType.INTEGER, null)}), (Expression)new CoalesceExpression((Expression)new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), new Expression[0]));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new CoalesceExpression((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Expression)new CoalesceExpression((Expression)new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L), new Expression[0]), new Expression[0]), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new CoalesceExpression((Expression)new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new Constant((Type)IntegerType.INTEGER, null), new Expression[]{new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), new Constant((Type)IntegerType.INTEGER, null), new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L))}), (Expression)new CoalesceExpression((Expression)new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), new Expression[0]));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new CoalesceExpression((Expression)new FunctionCall(RANDOM, (List)ImmutableList.of()), (Expression)new FunctionCall(RANDOM, (List)ImmutableList.of()), new Expression[]{new Constant((Type)DoubleType.DOUBLE, (Object)1.0), new FunctionCall(RANDOM, (List)ImmutableList.of())}), (Expression)new CoalesceExpression((Expression)new FunctionCall(RANDOM, (List)ImmutableList.of()), (Expression)new FunctionCall(RANDOM, (List)ImmutableList.of()), new Expression[]{new Constant((Type)DoubleType.DOUBLE, (Object)1.0)}));
        TestExpressionInterpreter.assertEvaluatedEquals((Expression)new CoalesceExpression((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Expression)new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), new Expression[0]), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L));
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> TestExpressionInterpreter.evaluate((Expression)new CoalesceExpression((Expression)new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), new Expression[0]))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.DIVISION_BY_ZERO});
    }

    @Test
    public void testIf() {
        TestExpressionInterpreter.assertOptimizedEquals(IrExpressions.ifExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)4L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L));
        TestExpressionInterpreter.assertOptimizedEquals(IrExpressions.ifExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)4L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)4L));
        TestExpressionInterpreter.assertOptimizedEquals(IrExpressions.ifExpression((Expression)BooleanLiteral.TRUE_LITERAL, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)4L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L));
        TestExpressionInterpreter.assertOptimizedEquals(IrExpressions.ifExpression((Expression)BooleanLiteral.FALSE_LITERAL, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)4L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)4L));
        TestExpressionInterpreter.assertOptimizedEquals(IrExpressions.ifExpression((Expression)new Constant((Type)BooleanType.BOOLEAN, null), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)4L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)4L));
        TestExpressionInterpreter.assertOptimizedEquals(IrExpressions.ifExpression((Expression)BooleanLiteral.TRUE_LITERAL, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L), (Expression)new Constant((Type)IntegerType.INTEGER, null)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L));
        TestExpressionInterpreter.assertOptimizedEquals(IrExpressions.ifExpression((Expression)BooleanLiteral.FALSE_LITERAL, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L), (Expression)new Constant((Type)IntegerType.INTEGER, null)), (Expression)new Constant((Type)UnknownType.UNKNOWN, null));
        TestExpressionInterpreter.assertOptimizedEquals(IrExpressions.ifExpression((Expression)BooleanLiteral.TRUE_LITERAL, (Expression)new Constant((Type)IntegerType.INTEGER, null), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)4L)), (Expression)new Constant((Type)UnknownType.UNKNOWN, null));
        TestExpressionInterpreter.assertOptimizedEquals(IrExpressions.ifExpression((Expression)BooleanLiteral.FALSE_LITERAL, (Expression)new Constant((Type)IntegerType.INTEGER, null), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)4L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)4L));
        TestExpressionInterpreter.assertOptimizedEquals(IrExpressions.ifExpression((Expression)BooleanLiteral.TRUE_LITERAL, (Expression)new Constant((Type)IntegerType.INTEGER, null), (Expression)new Constant((Type)IntegerType.INTEGER, null)), (Expression)new Constant((Type)UnknownType.UNKNOWN, null));
        TestExpressionInterpreter.assertOptimizedEquals(IrExpressions.ifExpression((Expression)BooleanLiteral.FALSE_LITERAL, (Expression)new Constant((Type)IntegerType.INTEGER, null), (Expression)new Constant((Type)IntegerType.INTEGER, null)), (Expression)new Constant((Type)UnknownType.UNKNOWN, null));
        TestExpressionInterpreter.assertOptimizedEquals(IrExpressions.ifExpression((Expression)BooleanLiteral.TRUE_LITERAL, (Expression)new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L))), (Expression)new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)));
        TestExpressionInterpreter.assertOptimizedEquals(IrExpressions.ifExpression((Expression)BooleanLiteral.TRUE_LITERAL, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Expression)new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L));
        TestExpressionInterpreter.assertOptimizedEquals(IrExpressions.ifExpression((Expression)BooleanLiteral.FALSE_LITERAL, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Expression)new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L))), (Expression)new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)));
        TestExpressionInterpreter.assertOptimizedEquals(IrExpressions.ifExpression((Expression)BooleanLiteral.FALSE_LITERAL, (Expression)new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L));
        TestExpressionInterpreter.assertOptimizedEquals(IrExpressions.ifExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L)), IrExpressions.ifExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L)));
        TestExpressionInterpreter.assertEvaluatedEquals(IrExpressions.ifExpression((Expression)BooleanLiteral.TRUE_LITERAL, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Expression)new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L));
        TestExpressionInterpreter.assertEvaluatedEquals(IrExpressions.ifExpression((Expression)BooleanLiteral.FALSE_LITERAL, (Expression)new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L));
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> TestExpressionInterpreter.evaluate(IrExpressions.ifExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L)))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.DIVISION_BY_ZERO});
    }

    @Test
    public void testOptimizeDivideByZero() {
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)));
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> TestExpressionInterpreter.evaluate((Expression)new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.DIVISION_BY_ZERO});
    }

    @Test
    public void testRowSubscript() {
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new SubscriptExpression((Type)BooleanType.BOOLEAN, (Expression)new Row((List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Object)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"a")), (Object)BooleanLiteral.TRUE_LITERAL)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L)), (Expression)BooleanLiteral.TRUE_LITERAL);
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new SubscriptExpression((Type)VarcharType.VARCHAR, (Expression)new SubscriptExpression((Type)RowType.anonymousRow((Type[])new Type[]{IntegerType.INTEGER, VarcharType.VARCHAR}), (Expression)new SubscriptExpression((Type)RowType.anonymousRow((Type[])new Type[]{IntegerType.INTEGER, VarcharType.VARCHAR, RowType.anonymousRow((Type[])new Type[]{IntegerType.INTEGER, VarcharType.VARCHAR})}), (Expression)new Row((List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Object)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"a")), (Object)new Row((List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Object)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"b")), (Object)new Row((List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)3L), (Object)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"c")))))))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L)), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L)), (Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"c")));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new SubscriptExpression((Type)UnknownType.UNKNOWN, (Expression)new Row((List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Object)new Constant((Type)UnknownType.UNKNOWN, null))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L)), (Expression)new Constant((Type)UnknownType.UNKNOWN, null));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new SubscriptExpression((Type)IntegerType.INTEGER, (Expression)new Row((List)ImmutableList.of((Object)new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Object)new Constant((Type)IntegerType.INTEGER, (Object)1L))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)), (Expression)new SubscriptExpression((Type)IntegerType.INTEGER, (Expression)new Row((List)ImmutableList.of((Object)new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Object)new Constant((Type)IntegerType.INTEGER, (Object)1L))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)));
        TestExpressionInterpreter.assertOptimizedEquals((Expression)new SubscriptExpression((Type)IntegerType.INTEGER, (Expression)new Row((List)ImmutableList.of((Object)new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Object)new Constant((Type)IntegerType.INTEGER, (Object)1L))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L)), (Expression)new SubscriptExpression((Type)IntegerType.INTEGER, (Expression)new Row((List)ImmutableList.of((Object)new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Object)new Constant((Type)IntegerType.INTEGER, (Object)1L))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L)));
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> TestExpressionInterpreter.evaluate((Expression)new SubscriptExpression((Type)IntegerType.INTEGER, (Expression)new Row((List)ImmutableList.of((Object)new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Object)new Constant((Type)IntegerType.INTEGER, (Object)1L))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L)))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.DIVISION_BY_ZERO});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> TestExpressionInterpreter.evaluate((Expression)new SubscriptExpression((Type)IntegerType.INTEGER, (Expression)new Row((List)ImmutableList.of((Object)new ArithmeticBinaryExpression(DIVIDE_INTEGER, ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Object)new Constant((Type)IntegerType.INTEGER, (Object)1L))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L)))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.DIVISION_BY_ZERO});
    }

    private static void assertOptimizedEquals(Expression actual, Expression expected) {
        Assertions.assertThat((Object)TestExpressionInterpreter.optimize(actual)).isEqualTo(TestExpressionInterpreter.optimize(expected));
    }

    private static void assertOptimizedMatches(Expression actual, Expression expected) {
        Expression actualOptimized = (Expression)TestExpressionInterpreter.optimize(actual);
        SymbolAliases.Builder aliases = SymbolAliases.builder();
        for (Symbol symbol : SYMBOLS) {
            aliases.put(symbol.getName(), symbol.toSymbolReference());
        }
        ExpressionTestUtils.assertExpressionEquals(actualOptimized, expected, aliases.build());
    }

    static Object optimize(Expression parsedExpression) {
        IrExpressionInterpreter interpreter = new IrExpressionInterpreter(parsedExpression, PLANNER_CONTEXT, SessionTestUtils.TEST_SESSION);
        return interpreter.optimize(INPUTS);
    }

    private static void assertEvaluatedEquals(Expression actual, Expression expected) {
        Assertions.assertThat((Object)TestExpressionInterpreter.evaluate(actual)).isEqualTo(TestExpressionInterpreter.evaluate(expected));
    }

    private static Object evaluate(Expression expression) {
        IrExpressionInterpreter interpreter = new IrExpressionInterpreter(expression, PLANNER_CONTEXT, SessionTestUtils.TEST_SESSION);
        return interpreter.evaluate(INPUTS);
    }
}

