/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.planner.RuleStatsRecorder;
import io.trino.sql.planner.assertions.BasePlanTest;
import io.trino.sql.planner.assertions.ExpectedValueProvider;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.IterativeOptimizer;
import io.trino.sql.planner.iterative.rule.RemoveRedundantIdentityProjections;
import io.trino.sql.planner.optimizations.PlanOptimizer;
import io.trino.sql.planner.optimizations.UnaliasSymbolReferences;
import io.trino.sql.planner.plan.DataOrganizationSpecification;
import io.trino.sql.planner.plan.WindowNode;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.jupiter.api.Test;

public class TestCanonicalize
extends BasePlanTest {
    @Test
    public void testJoin() {
        this.assertPlan("SELECT *\nFROM (\n    SELECT EXTRACT(DAY FROM DATE '2017-01-01')\n) t\nCROSS JOIN (VALUES 2)", PlanMatchPattern.anyTree(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"field", (Object)"expr"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Object)new Constant((Type)BigintType.BIGINT, (Object)1L))))));
    }

    @Test
    public void testDuplicatesInWindowOrderBy() {
        ExpectedValueProvider<DataOrganizationSpecification> specification = PlanMatchPattern.specification((List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"A"), (Map<String, SortOrder>)ImmutableMap.of((Object)"A", (Object)SortOrder.ASC_NULLS_LAST));
        this.assertPlan("WITH x as (SELECT a, a as b FROM (VALUES 1) t(a))SELECT *, row_number() OVER(ORDER BY a ASC, b DESC)FROM x", PlanMatchPattern.anyTree(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(specification).addFunction(PlanMatchPattern.windowFunction("row_number", (List<String>)ImmutableList.of(), WindowNode.Frame.DEFAULT_FRAME)), PlanMatchPattern.values("A"))), (List<PlanOptimizer>)ImmutableList.of((Object)new UnaliasSymbolReferences(), (Object)new IterativeOptimizer(this.getPlanTester().getPlannerContext(), new RuleStatsRecorder(), this.getPlanTester().getStatsCalculator(), this.getPlanTester().getCostCalculator(), (Set)ImmutableSet.of((Object)new RemoveRedundantIdentityProjections()))));
    }
}

