/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.Session;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataManager;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.operator.scalar.JoniRegexpCasts;
import io.trino.operator.scalar.JsonPath;
import io.trino.security.AccessControl;
import io.trino.security.AllowAllAccessControl;
import io.trino.spi.expression.Call;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.expression.FieldDereference;
import io.trino.spi.expression.FunctionName;
import io.trino.spi.expression.StandardFunctions;
import io.trino.spi.expression.Variable;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.PlannerContext;
import io.trino.sql.ir.ArithmeticBinaryExpression;
import io.trino.sql.ir.ArithmeticNegation;
import io.trino.sql.ir.BetweenPredicate;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.ComparisonExpression;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.FunctionCall;
import io.trino.sql.ir.InPredicate;
import io.trino.sql.ir.IsNullPredicate;
import io.trino.sql.ir.LogicalExpression;
import io.trino.sql.ir.NotExpression;
import io.trino.sql.ir.NullIfExpression;
import io.trino.sql.ir.SubscriptExpression;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.BuiltinFunctionCallBuilder;
import io.trino.sql.planner.ConnectorExpressionTranslator;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.TestingPlannerContext;
import io.trino.testing.TestingSession;
import io.trino.testing.TransactionBuilder;
import io.trino.transaction.TestingTransactionManager;
import io.trino.transaction.TransactionManager;
import io.trino.type.JoniRegexpType;
import io.trino.type.JsonPathType;
import io.trino.type.LikeFunctions;
import io.trino.type.LikePatternType;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestConnectorExpressionTranslator {
    private static final Session TEST_SESSION = TestingSession.testSessionBuilder().build();
    private static final Type ROW_TYPE = RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"int_symbol_1", (Type)IntegerType.INTEGER), RowType.field((String)"varchar_symbol_1", (Type)VarcharType.createVarcharType((int)5))});
    private static final VarcharType VARCHAR_TYPE = VarcharType.createUnboundedVarcharType();
    private static final ArrayType VARCHAR_ARRAY_TYPE = new ArrayType((Type)VARCHAR_TYPE);
    private static final Map<Symbol, Type> symbols = ImmutableMap.builder().put((Object)new Symbol((Type)DoubleType.DOUBLE, "double_symbol_1"), (Object)DoubleType.DOUBLE).put((Object)new Symbol((Type)DoubleType.DOUBLE, "double_symbol_2"), (Object)DoubleType.DOUBLE).put((Object)new Symbol(ROW_TYPE, "row_symbol_1"), (Object)ROW_TYPE).put((Object)new Symbol((Type)VARCHAR_TYPE, "varchar_symbol_1"), (Object)VARCHAR_TYPE).put((Object)new Symbol((Type)BooleanType.BOOLEAN, "boolean_symbol_1"), (Object)BooleanType.BOOLEAN).buildOrThrow();
    private static final Map<String, Symbol> variableMappings = (Map)symbols.entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> ((Symbol)entry.getKey()).getName(), Map.Entry::getKey));

    @Test
    public void testTranslateConstant() {
        this.testTranslateConstant(true, (Type)BooleanType.BOOLEAN);
        this.testTranslateConstant(42L, (Type)TinyintType.TINYINT);
        this.testTranslateConstant(42L, (Type)SmallintType.SMALLINT);
        this.testTranslateConstant(42L, (Type)IntegerType.INTEGER);
        this.testTranslateConstant(42L, (Type)BigintType.BIGINT);
        this.testTranslateConstant(42L, (Type)RealType.REAL);
        this.testTranslateConstant(42.0, (Type)DoubleType.DOUBLE);
        this.testTranslateConstant(4200L, (Type)DecimalType.createDecimalType((int)4, (int)2));
        this.testTranslateConstant(4200L, (Type)DecimalType.createDecimalType((int)8, (int)2));
        this.testTranslateConstant(Slices.utf8Slice((String)"abc"), (Type)VarcharType.createVarcharType((int)3));
        this.testTranslateConstant(Slices.utf8Slice((String)"abc"), (Type)VarcharType.createVarcharType((int)33));
    }

    private void testTranslateConstant(Object nativeValue, Type type) {
        this.assertTranslationRoundTrips((Expression)new Constant(type, nativeValue), (ConnectorExpression)new io.trino.spi.expression.Constant(nativeValue, type));
    }

    @Test
    public void testTranslateSymbol() {
        this.assertTranslationRoundTrips((Expression)new SymbolReference((Type)DoubleType.DOUBLE, "double_symbol_1"), (ConnectorExpression)new Variable("double_symbol_1", (Type)DoubleType.DOUBLE));
    }

    @Test
    public void testTranslateRowSubscript() {
        this.assertTranslationRoundTrips((Expression)new SubscriptExpression((Type)IntegerType.INTEGER, (Expression)new SymbolReference(ROW_TYPE, "row_symbol_1"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)), (ConnectorExpression)new FieldDereference((Type)IntegerType.INTEGER, (ConnectorExpression)new Variable("row_symbol_1", ROW_TYPE), 0));
    }

    @Test
    public void testTranslateLogicalExpression() {
        for (LogicalExpression.Operator operator : LogicalExpression.Operator.values()) {
            this.assertTranslationRoundTrips((Expression)new LogicalExpression(operator, List.of(new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "double_symbol_1"), (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "double_symbol_2")), new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "double_symbol_1"), (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "double_symbol_2")))), (ConnectorExpression)new Call((Type)BooleanType.BOOLEAN, operator == LogicalExpression.Operator.AND ? StandardFunctions.AND_FUNCTION_NAME : StandardFunctions.OR_FUNCTION_NAME, List.of(new Call((Type)BooleanType.BOOLEAN, StandardFunctions.LESS_THAN_OPERATOR_FUNCTION_NAME, List.of(new Variable("double_symbol_1", (Type)DoubleType.DOUBLE), new Variable("double_symbol_2", (Type)DoubleType.DOUBLE))), new Call((Type)BooleanType.BOOLEAN, StandardFunctions.EQUAL_OPERATOR_FUNCTION_NAME, List.of(new Variable("double_symbol_1", (Type)DoubleType.DOUBLE), new Variable("double_symbol_2", (Type)DoubleType.DOUBLE))))));
        }
    }

    @Test
    public void testTranslateComparisonExpression() {
        for (ComparisonExpression.Operator operator : ComparisonExpression.Operator.values()) {
            this.assertTranslationRoundTrips((Expression)new ComparisonExpression(operator, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "double_symbol_1"), (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "double_symbol_2")), (ConnectorExpression)new Call((Type)BooleanType.BOOLEAN, ConnectorExpressionTranslator.functionNameForComparisonOperator((ComparisonExpression.Operator)operator), List.of(new Variable("double_symbol_1", (Type)DoubleType.DOUBLE), new Variable("double_symbol_2", (Type)DoubleType.DOUBLE))));
        }
    }

    @Test
    public void testTranslateArithmeticBinary() {
        TestingFunctionResolution resolver = new TestingFunctionResolution();
        for (ArithmeticBinaryExpression.Operator operator : ArithmeticBinaryExpression.Operator.values()) {
            this.assertTranslationRoundTrips((Expression)new ArithmeticBinaryExpression(resolver.resolveOperator(switch (operator) {
                default -> throw new MatchException(null, null);
                case ArithmeticBinaryExpression.Operator.ADD -> OperatorType.ADD;
                case ArithmeticBinaryExpression.Operator.SUBTRACT -> OperatorType.SUBTRACT;
                case ArithmeticBinaryExpression.Operator.MULTIPLY -> OperatorType.MULTIPLY;
                case ArithmeticBinaryExpression.Operator.DIVIDE -> OperatorType.DIVIDE;
                case ArithmeticBinaryExpression.Operator.MODULUS -> OperatorType.MODULUS;
            }, (List<? extends Type>)ImmutableList.of((Object)DoubleType.DOUBLE, (Object)DoubleType.DOUBLE)), operator, (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "double_symbol_1"), (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "double_symbol_2")), (ConnectorExpression)new Call((Type)DoubleType.DOUBLE, ConnectorExpressionTranslator.functionNameForArithmeticBinaryOperator((ArithmeticBinaryExpression.Operator)operator), List.of(new Variable("double_symbol_1", (Type)DoubleType.DOUBLE), new Variable("double_symbol_2", (Type)DoubleType.DOUBLE))));
        }
    }

    @Test
    public void testTranslateArithmeticUnaryMinus() {
        this.assertTranslationRoundTrips((Expression)new ArithmeticNegation((Expression)new SymbolReference((Type)DoubleType.DOUBLE, "double_symbol_1")), (ConnectorExpression)new Call((Type)DoubleType.DOUBLE, StandardFunctions.NEGATE_FUNCTION_NAME, List.of(new Variable("double_symbol_1", (Type)DoubleType.DOUBLE))));
    }

    @Test
    public void testTranslateBetween() {
        this.assertTranslationToConnectorExpression(TEST_SESSION, (Expression)new BetweenPredicate((Expression)new SymbolReference((Type)DoubleType.DOUBLE, "double_symbol_1"), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)1.2), (Expression)new SymbolReference((Type)DoubleType.DOUBLE, "double_symbol_2")), (ConnectorExpression)new Call((Type)BooleanType.BOOLEAN, StandardFunctions.AND_FUNCTION_NAME, List.of(new Call((Type)BooleanType.BOOLEAN, StandardFunctions.GREATER_THAN_OR_EQUAL_OPERATOR_FUNCTION_NAME, List.of(new Variable("double_symbol_1", (Type)DoubleType.DOUBLE), new io.trino.spi.expression.Constant((Object)1.2, (Type)DoubleType.DOUBLE))), new Call((Type)BooleanType.BOOLEAN, StandardFunctions.LESS_THAN_OR_EQUAL_OPERATOR_FUNCTION_NAME, List.of(new Variable("double_symbol_1", (Type)DoubleType.DOUBLE), new Variable("double_symbol_2", (Type)DoubleType.DOUBLE))))));
    }

    @Test
    public void testTranslateIsNull() {
        this.assertTranslationRoundTrips((Expression)new IsNullPredicate((Expression)new SymbolReference((Type)VarcharType.VARCHAR, "varchar_symbol_1")), (ConnectorExpression)new Call((Type)BooleanType.BOOLEAN, StandardFunctions.IS_NULL_FUNCTION_NAME, List.of(new Variable("varchar_symbol_1", (Type)VARCHAR_TYPE))));
    }

    @Test
    public void testTranslateNotExpression() {
        this.assertTranslationRoundTrips((Expression)new NotExpression((Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "boolean_symbol_1")), (ConnectorExpression)new Call((Type)BooleanType.BOOLEAN, StandardFunctions.NOT_FUNCTION_NAME, List.of(new Variable("boolean_symbol_1", (Type)BooleanType.BOOLEAN))));
    }

    @Test
    public void testTranslateIsNotNull() {
        this.assertTranslationRoundTrips((Expression)new NotExpression((Expression)new IsNullPredicate((Expression)new SymbolReference((Type)VarcharType.VARCHAR, "varchar_symbol_1"))), (ConnectorExpression)new Call((Type)BooleanType.BOOLEAN, StandardFunctions.NOT_FUNCTION_NAME, List.of(new Call((Type)BooleanType.BOOLEAN, StandardFunctions.IS_NULL_FUNCTION_NAME, List.of(new Variable("varchar_symbol_1", (Type)VARCHAR_TYPE))))));
    }

    @Test
    public void testTranslateCast() {
        this.assertTranslationRoundTrips((Expression)new Cast((Expression)new SymbolReference((Type)VarcharType.VARCHAR, "varchar_symbol_1"), (Type)VARCHAR_TYPE), (ConnectorExpression)new Call((Type)VARCHAR_TYPE, StandardFunctions.CAST_FUNCTION_NAME, List.of(new Variable("varchar_symbol_1", (Type)VARCHAR_TYPE))));
        this.assertTranslationToConnectorExpression(TEST_SESSION, (Expression)new Cast((Expression)new SymbolReference((Type)VarcharType.VARCHAR, "varchar_symbol_1"), (Type)BigintType.BIGINT, true), Optional.empty());
    }

    @Test
    public void testTranslateLike() {
        TestingTransactionManager transactionManager = new TestingTransactionManager();
        MetadataManager metadata = MetadataManager.testMetadataManagerBuilder().withTransactionManager((TransactionManager)transactionManager).build();
        TransactionBuilder.transaction((TransactionManager)transactionManager, (Metadata)metadata, (AccessControl)new AllowAllAccessControl()).readOnly().execute(TEST_SESSION, transactionSession -> {
            String pattern = "%pattern%";
            Call translated = new Call((Type)BooleanType.BOOLEAN, StandardFunctions.LIKE_FUNCTION_NAME, List.of(new Variable("varchar_symbol_1", (Type)VARCHAR_TYPE), new io.trino.spi.expression.Constant((Object)Slices.wrappedBuffer((byte[])pattern.getBytes(StandardCharsets.UTF_8)), (Type)VarcharType.createVarcharType((int)pattern.length()))));
            this.assertTranslationToConnectorExpression((Session)transactionSession, (Expression)BuiltinFunctionCallBuilder.resolve((Metadata)TestingPlannerContext.PLANNER_CONTEXT.getMetadata()).setName("$like").addArgument((Type)VARCHAR_TYPE, (Expression)new SymbolReference((Type)VARCHAR_TYPE, "varchar_symbol_1")).addArgument((Type)LikePatternType.LIKE_PATTERN, (Expression)new Constant((Type)LikePatternType.LIKE_PATTERN, (Object)LikeFunctions.likePattern((Slice)Slices.utf8Slice((String)pattern)))).build(), (Optional<ConnectorExpression>)Optional.of(translated));
            this.assertTranslationFromConnectorExpression((Session)transactionSession, (ConnectorExpression)translated, (Expression)BuiltinFunctionCallBuilder.resolve((Metadata)TestingPlannerContext.PLANNER_CONTEXT.getMetadata()).setName("$like").addArgument((Type)VARCHAR_TYPE, (Expression)new SymbolReference((Type)VARCHAR_TYPE, "varchar_symbol_1")).addArgument((Type)LikePatternType.LIKE_PATTERN, (Expression)BuiltinFunctionCallBuilder.resolve((Metadata)TestingPlannerContext.PLANNER_CONTEXT.getMetadata()).setName("$like_pattern").addArgument(new Constant((Type)VarcharType.createVarcharType((int)pattern.length()), (Object)Slices.utf8Slice((String)pattern))).build()).build());
            String escape = "\\";
            translated = new Call((Type)BooleanType.BOOLEAN, StandardFunctions.LIKE_FUNCTION_NAME, List.of(new Variable("varchar_symbol_1", (Type)VARCHAR_TYPE), new io.trino.spi.expression.Constant((Object)Slices.wrappedBuffer((byte[])pattern.getBytes(StandardCharsets.UTF_8)), (Type)VarcharType.createVarcharType((int)pattern.length())), new io.trino.spi.expression.Constant((Object)Slices.wrappedBuffer((byte[])escape.getBytes(StandardCharsets.UTF_8)), (Type)VarcharType.createVarcharType((int)escape.length()))));
            this.assertTranslationToConnectorExpression((Session)transactionSession, (Expression)BuiltinFunctionCallBuilder.resolve((Metadata)TestingPlannerContext.PLANNER_CONTEXT.getMetadata()).setName("$like").addArgument((Type)VARCHAR_TYPE, (Expression)new SymbolReference((Type)VARCHAR_TYPE, "varchar_symbol_1")).addArgument((Type)LikePatternType.LIKE_PATTERN, (Expression)new Constant((Type)LikePatternType.LIKE_PATTERN, (Object)LikeFunctions.likePattern((Slice)Slices.utf8Slice((String)pattern), (Slice)Slices.utf8Slice((String)escape)))).build(), (Optional<ConnectorExpression>)Optional.of(translated));
            this.assertTranslationFromConnectorExpression((Session)transactionSession, (ConnectorExpression)translated, (Expression)BuiltinFunctionCallBuilder.resolve((Metadata)TestingPlannerContext.PLANNER_CONTEXT.getMetadata()).setName("$like").addArgument((Type)VARCHAR_TYPE, (Expression)new SymbolReference((Type)VARCHAR_TYPE, "varchar_symbol_1")).addArgument((Type)LikePatternType.LIKE_PATTERN, (Expression)BuiltinFunctionCallBuilder.resolve((Metadata)TestingPlannerContext.PLANNER_CONTEXT.getMetadata()).setName("$like_pattern").addArgument((Type)VarcharType.createVarcharType((int)pattern.length()), (Expression)new Constant((Type)VarcharType.createVarcharType((int)9), (Object)Slices.utf8Slice((String)pattern))).addArgument((Type)VarcharType.createVarcharType((int)1), (Expression)new Constant((Type)VarcharType.createVarcharType((int)1), (Object)Slices.utf8Slice((String)escape))).build()).build());
        });
    }

    @Test
    public void testTranslateNullIf() {
        this.assertTranslationRoundTrips((Expression)new NullIfExpression((Expression)new SymbolReference((Type)VarcharType.VARCHAR, "varchar_symbol_1"), (Expression)new SymbolReference((Type)VarcharType.VARCHAR, "varchar_symbol_1")), (ConnectorExpression)new Call((Type)VARCHAR_TYPE, StandardFunctions.NULLIF_FUNCTION_NAME, List.of(new Variable("varchar_symbol_1", (Type)VARCHAR_TYPE), new Variable("varchar_symbol_1", (Type)VARCHAR_TYPE))));
    }

    @Test
    public void testTranslateResolvedFunction() {
        TestingTransactionManager transactionManager = new TestingTransactionManager();
        MetadataManager metadata = MetadataManager.testMetadataManagerBuilder().withTransactionManager((TransactionManager)transactionManager).build();
        TransactionBuilder.transaction((TransactionManager)transactionManager, (Metadata)metadata, (AccessControl)new AllowAllAccessControl()).readOnly().execute(TEST_SESSION, transactionSession -> this.assertTranslationRoundTrips((Session)transactionSession, (Expression)BuiltinFunctionCallBuilder.resolve((Metadata)TestingPlannerContext.PLANNER_CONTEXT.getMetadata()).setName("lower").addArgument((Type)VARCHAR_TYPE, (Expression)new SymbolReference((Type)VARCHAR_TYPE, "varchar_symbol_1")).build(), (ConnectorExpression)new Call((Type)VARCHAR_TYPE, new FunctionName("lower"), List.of(new Variable("varchar_symbol_1", (Type)VARCHAR_TYPE)))));
    }

    @Test
    public void testTranslateRegularExpression() {
        TestingTransactionManager transactionManager = new TestingTransactionManager();
        MetadataManager metadata = MetadataManager.testMetadataManagerBuilder().withTransactionManager((TransactionManager)transactionManager).build();
        TransactionBuilder.transaction((TransactionManager)transactionManager, (Metadata)metadata, (AccessControl)new AllowAllAccessControl()).readOnly().execute(TEST_SESSION, transactionSession -> {
            FunctionCall input = BuiltinFunctionCallBuilder.resolve((Metadata)TestingPlannerContext.PLANNER_CONTEXT.getMetadata()).setName("regexp_like").addArgument((Type)VARCHAR_TYPE, (Expression)new SymbolReference((Type)VARCHAR_TYPE, "varchar_symbol_1")).addArgument(new Constant((Type)JoniRegexpType.JONI_REGEXP, (Object)JoniRegexpCasts.joniRegexp((Slice)Slices.utf8Slice((String)"a+")))).build();
            Call translated = new Call((Type)BooleanType.BOOLEAN, new FunctionName("regexp_like"), List.of(new Variable("varchar_symbol_1", (Type)VARCHAR_TYPE), new io.trino.spi.expression.Constant((Object)Slices.utf8Slice((String)"a+"), (Type)VarcharType.createVarcharType((int)2))));
            FunctionCall translatedBack = BuiltinFunctionCallBuilder.resolve((Metadata)TestingPlannerContext.PLANNER_CONTEXT.getMetadata()).setName("regexp_like").addArgument((Type)VARCHAR_TYPE, (Expression)new SymbolReference((Type)VARCHAR_TYPE, "varchar_symbol_1")).addArgument((Type)JoniRegexpType.JONI_REGEXP, (Expression)new Cast((Expression)new Constant((Type)VarcharType.createVarcharType((int)2), (Object)Slices.utf8Slice((String)"a+")), (Type)JoniRegexpType.JONI_REGEXP)).build();
            this.assertTranslationToConnectorExpression((Session)transactionSession, (Expression)input, (ConnectorExpression)translated);
            this.assertTranslationFromConnectorExpression((Session)transactionSession, (ConnectorExpression)translated, (Expression)translatedBack);
        });
    }

    @Test
    void testTranslateJsonPath() {
        Call connectorExpression = new Call((Type)VARCHAR_TYPE, new FunctionName("json_extract_scalar"), List.of(new Variable("varchar_symbol_1", (Type)VARCHAR_TYPE), new io.trino.spi.expression.Constant((Object)Slices.utf8Slice((String)"$.path"), (Type)VarcharType.createVarcharType((int)6))));
        this.assertTranslationToConnectorExpression(TEST_SESSION, (Expression)BuiltinFunctionCallBuilder.resolve((Metadata)TestingPlannerContext.PLANNER_CONTEXT.getMetadata()).setName("json_extract_scalar").addArgument((Type)VARCHAR_TYPE, (Expression)new SymbolReference((Type)VARCHAR_TYPE, "varchar_symbol_1")).addArgument((Type)JsonPathType.JSON_PATH, (Expression)new Constant((Type)JsonPathType.JSON_PATH, (Object)new JsonPath("$.path"))).build(), Optional.of(connectorExpression));
        this.assertTranslationFromConnectorExpression(TEST_SESSION, (ConnectorExpression)connectorExpression, (Expression)BuiltinFunctionCallBuilder.resolve((Metadata)TestingPlannerContext.PLANNER_CONTEXT.getMetadata()).setName("json_extract_scalar").addArgument((Type)VARCHAR_TYPE, (Expression)new SymbolReference((Type)VARCHAR_TYPE, "varchar_symbol_1")).addArgument((Type)JsonPathType.JSON_PATH, (Expression)new Cast((Expression)new Constant((Type)VarcharType.createVarcharType((int)6), (Object)Slices.utf8Slice((String)"$.path")), (Type)JsonPathType.JSON_PATH)).build());
    }

    @Test
    public void testTranslateIn() {
        String value = "value_1";
        this.assertTranslationRoundTrips((Expression)new InPredicate((Expression)new SymbolReference((Type)VarcharType.VARCHAR, "varchar_symbol_1"), List.of(new SymbolReference((Type)VarcharType.VARCHAR, "varchar_symbol_1"), new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)value)))), (ConnectorExpression)new Call((Type)BooleanType.BOOLEAN, StandardFunctions.IN_PREDICATE_FUNCTION_NAME, List.of(new Variable("varchar_symbol_1", (Type)VARCHAR_TYPE), new Call((Type)VARCHAR_ARRAY_TYPE, StandardFunctions.ARRAY_CONSTRUCTOR_FUNCTION_NAME, List.of(new Variable("varchar_symbol_1", (Type)VARCHAR_TYPE), new io.trino.spi.expression.Constant((Object)Slices.wrappedBuffer((byte[])value.getBytes(StandardCharsets.UTF_8)), (Type)VARCHAR_TYPE))))));
    }

    private void assertTranslationRoundTrips(Expression expression, ConnectorExpression connectorExpression) {
        this.assertTranslationRoundTrips(TEST_SESSION, expression, connectorExpression);
    }

    private void assertTranslationRoundTrips(Session session, Expression expression, ConnectorExpression connectorExpression) {
        this.assertTranslationToConnectorExpression(session, expression, Optional.of(connectorExpression));
        this.assertTranslationFromConnectorExpression(session, connectorExpression, expression);
    }

    private void assertTranslationToConnectorExpression(Session session, Expression expression, ConnectorExpression connectorExpression) {
        this.assertTranslationToConnectorExpression(session, expression, Optional.of(connectorExpression));
    }

    private void assertTranslationToConnectorExpression(Session session, Expression expression, Optional<ConnectorExpression> connectorExpression) {
        Optional translation = ConnectorExpressionTranslator.translate((Session)session, (Expression)expression);
        Assertions.assertThat((boolean)connectorExpression.isPresent()).isEqualTo(translation.isPresent());
        translation.ifPresent(value -> Assertions.assertThat((Object)value).isEqualTo(connectorExpression.get()));
    }

    private void assertTranslationFromConnectorExpression(Session session, ConnectorExpression connectorExpression, Expression expected) {
        Expression translation = ConnectorExpressionTranslator.translate((Session)session, (ConnectorExpression)connectorExpression, (PlannerContext)TestingPlannerContext.PLANNER_CONTEXT, variableMappings);
        Assertions.assertThat((Object)translation).isEqualTo((Object)expected);
    }
}

