/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import io.trino.Session;
import io.trino.connector.system.GlobalSystemConnector;
import io.trino.metadata.AbstractMockMetadata;
import io.trino.metadata.GlobalFunctionCatalog;
import io.trino.metadata.Metadata;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TableHandle;
import io.trino.metadata.TableProperties;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.security.AccessControl;
import io.trino.security.AllowAllAccessControl;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTableProperties;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.function.BoundSignature;
import io.trino.spi.function.FunctionId;
import io.trino.spi.function.FunctionKind;
import io.trino.spi.function.FunctionNullability;
import io.trino.spi.function.Signature;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.sql.PlannerContext;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.ir.BetweenPredicate;
import io.trino.sql.ir.BooleanLiteral;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.ComparisonExpression;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.ExpressionRewriter;
import io.trino.sql.ir.ExpressionTreeRewriter;
import io.trino.sql.ir.FunctionCall;
import io.trino.sql.ir.InPredicate;
import io.trino.sql.ir.IrUtils;
import io.trino.sql.ir.IsNullPredicate;
import io.trino.sql.ir.NotExpression;
import io.trino.sql.ir.Row;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.DomainTranslator;
import io.trino.sql.planner.EffectivePredicateExtractor;
import io.trino.sql.planner.EqualityInference;
import io.trino.sql.planner.ExpressionNodeInliner;
import io.trino.sql.planner.OrderingScheme;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolsExtractor;
import io.trino.sql.planner.TestingConnectorTransactionHandle;
import io.trino.sql.planner.TestingPlannerContext;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.DataOrganizationSpecification;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.JoinType;
import io.trino.sql.planner.plan.LimitNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.sql.planner.plan.SemiJoinNode;
import io.trino.sql.planner.plan.SortNode;
import io.trino.sql.planner.plan.TableScanNode;
import io.trino.sql.planner.plan.TopNNode;
import io.trino.sql.planner.plan.UnionNode;
import io.trino.sql.planner.plan.ValuesNode;
import io.trino.sql.planner.plan.WindowNode;
import io.trino.testing.TestingHandles;
import io.trino.testing.TestingMetadata;
import io.trino.testing.TestingSession;
import io.trino.testing.TestingTransactionHandle;
import io.trino.testing.TransactionBuilder;
import io.trino.tests.BogusType;
import io.trino.transaction.TestingTransactionManager;
import io.trino.transaction.TransactionManager;
import io.trino.type.UnknownType;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_METHOD)
@Execution(value=ExecutionMode.SAME_THREAD)
public class TestEffectivePredicateExtractor {
    private static final Symbol A = new Symbol((Type)BigintType.BIGINT, "a");
    private static final Symbol B = new Symbol((Type)BigintType.BIGINT, "b");
    private static final Symbol C = new Symbol((Type)DoubleType.DOUBLE, "c");
    private static final Symbol D = new Symbol((Type)RealType.REAL, "d");
    private static final Symbol E = new Symbol((Type)UnknownType.UNKNOWN, "e");
    private static final Symbol F = new Symbol((Type)UnknownType.UNKNOWN, "f");
    private static final Symbol G = new Symbol((Type)BogusType.BOGUS, "g");
    private static final Symbol R = new Symbol((Type)RowType.anonymous((List)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT)), "r");
    private static final Expression AE = A.toSymbolReference();
    private static final Expression BE = B.toSymbolReference();
    private static final Expression CE = C.toSymbolReference();
    private static final Expression DE = D.toSymbolReference();
    private static final Expression EE = E.toSymbolReference();
    private static final Expression FE = F.toSymbolReference();
    private static final Expression GE = G.toSymbolReference();
    private static final Session SESSION = TestingSession.testSessionBuilder().build();
    private final TestingFunctionResolution functionResolution = new TestingFunctionResolution();
    private final Metadata metadata = new AbstractMockMetadata(){
        private final Metadata delegate;
        {
            this.delegate = TestEffectivePredicateExtractor.this.functionResolution.getMetadata();
        }

        @Override
        public ResolvedFunction resolveBuiltinFunction(String name, List<TypeSignatureProvider> parameterTypes) {
            return this.delegate.resolveBuiltinFunction(name, parameterTypes);
        }

        public ResolvedFunction getCoercion(Type fromType, Type toType) {
            return this.delegate.getCoercion(fromType, toType);
        }

        @Override
        public TableProperties getTableProperties(Session session, TableHandle handle) {
            return new TableProperties(TestingHandles.TEST_CATALOG_HANDLE, (ConnectorTransactionHandle)TestingConnectorTransactionHandle.INSTANCE, new ConnectorTableProperties(((PredicatedTableHandle)handle.getConnectorHandle()).getPredicate(), Optional.empty(), Optional.empty(), (List)ImmutableList.of()));
        }
    };
    private final PlannerContext plannerContext = TestingPlannerContext.plannerContextBuilder().withMetadata(this.metadata).build();
    private final EffectivePredicateExtractor effectivePredicateExtractor = new EffectivePredicateExtractor(new DomainTranslator(), this.plannerContext, true);
    private final EffectivePredicateExtractor effectivePredicateExtractorWithoutTableProperties = new EffectivePredicateExtractor(new DomainTranslator(), this.plannerContext, false);
    private Map<Symbol, ColumnHandle> scanAssignments;
    private TableScanNode baseTableScan;
    private ExpressionIdentityNormalizer expressionNormalizer;

    @BeforeEach
    public void setUp() {
        this.scanAssignments = ImmutableMap.builder().put((Object)A, (Object)new TestingMetadata.TestingColumnHandle("a")).put((Object)B, (Object)new TestingMetadata.TestingColumnHandle("b")).put((Object)C, (Object)new TestingMetadata.TestingColumnHandle("c")).put((Object)D, (Object)new TestingMetadata.TestingColumnHandle("d")).put((Object)E, (Object)new TestingMetadata.TestingColumnHandle("e")).put((Object)F, (Object)new TestingMetadata.TestingColumnHandle("f")).put((Object)R, (Object)new TestingMetadata.TestingColumnHandle("r")).buildOrThrow();
        Map assignments = Maps.filterKeys(this.scanAssignments, (Predicate)Predicates.in((Collection)ImmutableList.of((Object)A, (Object)B, (Object)C, (Object)D, (Object)E, (Object)F)));
        this.baseTableScan = TableScanNode.newInstance((PlanNodeId)TestEffectivePredicateExtractor.newId(), (TableHandle)TestEffectivePredicateExtractor.makeTableHandle((TupleDomain<ColumnHandle>)TupleDomain.all()), (List)ImmutableList.copyOf(assignments.keySet()), (Map)assignments, (boolean)false, Optional.empty());
        this.expressionNormalizer = new ExpressionIdentityNormalizer();
    }

    @Test
    public void testAggregation() {
        AggregationNode node = AggregationNode.singleAggregation((PlanNodeId)TestEffectivePredicateExtractor.newId(), (PlanNode)TestEffectivePredicateExtractor.filter((PlanNode)this.baseTableScan, IrUtils.and((Expression[])new Expression[]{TestEffectivePredicateExtractor.equals(AE, DE), TestEffectivePredicateExtractor.equals(BE, EE), TestEffectivePredicateExtractor.equals(CE, FE), TestEffectivePredicateExtractor.lessThan(DE, TestEffectivePredicateExtractor.bigintLiteral(10L)), TestEffectivePredicateExtractor.lessThan(CE, DE), TestEffectivePredicateExtractor.greaterThan(AE, TestEffectivePredicateExtractor.bigintLiteral(2L)), TestEffectivePredicateExtractor.equals(EE, FE)})), (Map)ImmutableMap.of((Object)C, (Object)new AggregationNode.Aggregation(TestEffectivePredicateExtractor.fakeFunction("test"), (List)ImmutableList.of(), false, Optional.empty(), Optional.empty(), Optional.empty()), (Object)D, (Object)new AggregationNode.Aggregation(TestEffectivePredicateExtractor.fakeFunction("test"), (List)ImmutableList.of(), false, Optional.empty(), Optional.empty(), Optional.empty())), (AggregationNode.GroupingSetDescriptor)AggregationNode.singleGroupingSet((List)ImmutableList.of((Object)A, (Object)B, (Object)C)));
        Expression effectivePredicate = this.effectivePredicateExtractor.extract(SESSION, (PlanNode)node);
        Assertions.assertThat(this.normalizeConjuncts(effectivePredicate)).isEqualTo(this.normalizeConjuncts(new Expression[]{TestEffectivePredicateExtractor.lessThan(AE, TestEffectivePredicateExtractor.bigintLiteral(10L)), TestEffectivePredicateExtractor.lessThan(BE, AE), TestEffectivePredicateExtractor.greaterThan(AE, TestEffectivePredicateExtractor.bigintLiteral(2L)), TestEffectivePredicateExtractor.equals(BE, CE)}));
    }

    @Test
    public void testGroupByEmpty() {
        AggregationNode node = new AggregationNode(TestEffectivePredicateExtractor.newId(), (PlanNode)TestEffectivePredicateExtractor.filter((PlanNode)this.baseTableScan, (Expression)BooleanLiteral.FALSE_LITERAL), (Map)ImmutableMap.of(), AggregationNode.globalAggregation(), (List)ImmutableList.of(), AggregationNode.Step.FINAL, Optional.empty(), Optional.empty());
        Expression effectivePredicate = this.effectivePredicateExtractor.extract(SESSION, (PlanNode)node);
        Assertions.assertThat((Object)effectivePredicate).isEqualTo((Object)BooleanLiteral.TRUE_LITERAL);
    }

    @Test
    public void testFilter() {
        FilterNode node = TestEffectivePredicateExtractor.filter((PlanNode)this.baseTableScan, IrUtils.and((Expression[])new Expression[]{TestEffectivePredicateExtractor.greaterThan(AE, (Expression)this.functionResolution.functionCallBuilder("rand").build()), TestEffectivePredicateExtractor.lessThan(BE, TestEffectivePredicateExtractor.bigintLiteral(10L))}));
        Expression effectivePredicate = this.effectivePredicateExtractor.extract(SESSION, (PlanNode)node);
        Assertions.assertThat(this.normalizeConjuncts(effectivePredicate)).isEqualTo(this.normalizeConjuncts((Expression)TestEffectivePredicateExtractor.lessThan(BE, TestEffectivePredicateExtractor.bigintLiteral(10L))));
    }

    @Test
    public void testProject() {
        ProjectNode node = new ProjectNode(TestEffectivePredicateExtractor.newId(), (PlanNode)TestEffectivePredicateExtractor.filter((PlanNode)this.baseTableScan, IrUtils.and((Expression[])new Expression[]{TestEffectivePredicateExtractor.equals(AE, BE), TestEffectivePredicateExtractor.equals(BE, CE), TestEffectivePredicateExtractor.lessThan(CE, TestEffectivePredicateExtractor.bigintLiteral(10L))})), Assignments.of((Symbol)D, (Expression)AE, (Symbol)E, (Expression)CE));
        Expression effectivePredicate = this.effectivePredicateExtractor.extract(SESSION, (PlanNode)node);
        Assertions.assertThat(this.normalizeConjuncts(effectivePredicate)).isEqualTo(this.normalizeConjuncts(new Expression[]{TestEffectivePredicateExtractor.lessThan(DE, TestEffectivePredicateExtractor.bigintLiteral(10L)), TestEffectivePredicateExtractor.equals(DE, EE)}));
    }

    @Test
    public void testProjectWithSymbolReuse() {
        ProjectNode projectReusingB = new ProjectNode(TestEffectivePredicateExtractor.newId(), (PlanNode)TestEffectivePredicateExtractor.filter((PlanNode)this.baseTableScan, IrUtils.and((Expression[])new Expression[]{TestEffectivePredicateExtractor.equals(AE, BE), TestEffectivePredicateExtractor.equals(BE, CE), TestEffectivePredicateExtractor.lessThan(CE, TestEffectivePredicateExtractor.bigintLiteral(10L))})), Assignments.of((Symbol)D, (Expression)AE, (Symbol)B, (Expression)CE));
        Expression effectivePredicateWhenBReused = this.effectivePredicateExtractor.extract(SESSION, (PlanNode)projectReusingB);
        Assertions.assertThat(this.normalizeConjuncts(effectivePredicateWhenBReused)).isEqualTo(this.normalizeConjuncts((Expression)TestEffectivePredicateExtractor.lessThan(BE, TestEffectivePredicateExtractor.bigintLiteral(10L))));
        ProjectNode projectReusingC = new ProjectNode(TestEffectivePredicateExtractor.newId(), (PlanNode)TestEffectivePredicateExtractor.filter((PlanNode)this.baseTableScan, IrUtils.and((Expression[])new Expression[]{TestEffectivePredicateExtractor.equals(AE, BE), TestEffectivePredicateExtractor.equals(BE, CE), TestEffectivePredicateExtractor.lessThan(CE, TestEffectivePredicateExtractor.bigintLiteral(10L))})), Assignments.builder().put(C, AE).put(E, CE).put(F, BE).build());
        Expression effectivePredicateWhenCReused = this.effectivePredicateExtractor.extract(SESSION, (PlanNode)projectReusingC);
        Assertions.assertThat(this.normalizeConjuncts(effectivePredicateWhenCReused)).isEqualTo(this.normalizeConjuncts(this.normalizeConjuncts((Expression)TestEffectivePredicateExtractor.equals(CE, FE))));
    }

    @Test
    public void testTopN() {
        TopNNode node = new TopNNode(TestEffectivePredicateExtractor.newId(), (PlanNode)TestEffectivePredicateExtractor.filter((PlanNode)this.baseTableScan, IrUtils.and((Expression[])new Expression[]{TestEffectivePredicateExtractor.equals(AE, BE), TestEffectivePredicateExtractor.equals(BE, CE), TestEffectivePredicateExtractor.lessThan(CE, TestEffectivePredicateExtractor.bigintLiteral(10L))})), 1L, new OrderingScheme((List)ImmutableList.of((Object)A), (Map)ImmutableMap.of((Object)A, (Object)SortOrder.ASC_NULLS_LAST)), TopNNode.Step.PARTIAL);
        Expression effectivePredicate = this.effectivePredicateExtractor.extract(SESSION, (PlanNode)node);
        Assertions.assertThat(this.normalizeConjuncts(effectivePredicate)).isEqualTo(this.normalizeConjuncts(new Expression[]{TestEffectivePredicateExtractor.equals(AE, BE), TestEffectivePredicateExtractor.equals(BE, CE), TestEffectivePredicateExtractor.lessThan(CE, TestEffectivePredicateExtractor.bigintLiteral(10L))}));
    }

    @Test
    public void testLimit() {
        LimitNode node = new LimitNode(TestEffectivePredicateExtractor.newId(), (PlanNode)TestEffectivePredicateExtractor.filter((PlanNode)this.baseTableScan, IrUtils.and((Expression[])new Expression[]{TestEffectivePredicateExtractor.equals(AE, BE), TestEffectivePredicateExtractor.equals(BE, CE), TestEffectivePredicateExtractor.lessThan(CE, TestEffectivePredicateExtractor.bigintLiteral(10L))})), 1L, false);
        Expression effectivePredicate = this.effectivePredicateExtractor.extract(SESSION, (PlanNode)node);
        Assertions.assertThat(this.normalizeConjuncts(effectivePredicate)).isEqualTo(this.normalizeConjuncts(new Expression[]{TestEffectivePredicateExtractor.equals(AE, BE), TestEffectivePredicateExtractor.equals(BE, CE), TestEffectivePredicateExtractor.lessThan(CE, TestEffectivePredicateExtractor.bigintLiteral(10L))}));
    }

    @Test
    public void testSort() {
        SortNode node = new SortNode(TestEffectivePredicateExtractor.newId(), (PlanNode)TestEffectivePredicateExtractor.filter((PlanNode)this.baseTableScan, IrUtils.and((Expression[])new Expression[]{TestEffectivePredicateExtractor.equals(AE, BE), TestEffectivePredicateExtractor.equals(BE, CE), TestEffectivePredicateExtractor.lessThan(CE, TestEffectivePredicateExtractor.bigintLiteral(10L))})), new OrderingScheme((List)ImmutableList.of((Object)A), (Map)ImmutableMap.of((Object)A, (Object)SortOrder.ASC_NULLS_LAST)), false);
        Expression effectivePredicate = this.effectivePredicateExtractor.extract(SESSION, (PlanNode)node);
        Assertions.assertThat(this.normalizeConjuncts(effectivePredicate)).isEqualTo(this.normalizeConjuncts(new Expression[]{TestEffectivePredicateExtractor.equals(AE, BE), TestEffectivePredicateExtractor.equals(BE, CE), TestEffectivePredicateExtractor.lessThan(CE, TestEffectivePredicateExtractor.bigintLiteral(10L))}));
    }

    @Test
    public void testWindow() {
        WindowNode node = new WindowNode(TestEffectivePredicateExtractor.newId(), (PlanNode)TestEffectivePredicateExtractor.filter((PlanNode)this.baseTableScan, IrUtils.and((Expression[])new Expression[]{TestEffectivePredicateExtractor.equals(AE, BE), TestEffectivePredicateExtractor.equals(BE, CE), TestEffectivePredicateExtractor.lessThan(CE, TestEffectivePredicateExtractor.bigintLiteral(10L))})), new DataOrganizationSpecification((List)ImmutableList.of((Object)A), Optional.of(new OrderingScheme((List)ImmutableList.of((Object)A), (Map)ImmutableMap.of((Object)A, (Object)SortOrder.ASC_NULLS_LAST)))), (Map)ImmutableMap.of(), Optional.empty(), (Set)ImmutableSet.of(), 0);
        Expression effectivePredicate = this.effectivePredicateExtractor.extract(SESSION, (PlanNode)node);
        Assertions.assertThat(this.normalizeConjuncts(effectivePredicate)).isEqualTo(this.normalizeConjuncts(new Expression[]{TestEffectivePredicateExtractor.equals(AE, BE), TestEffectivePredicateExtractor.equals(BE, CE), TestEffectivePredicateExtractor.lessThan(CE, TestEffectivePredicateExtractor.bigintLiteral(10L))}));
    }

    @Test
    public void testTableScan() {
        Map assignments = Maps.filterKeys(this.scanAssignments, (Predicate)Predicates.in((Collection)ImmutableList.of((Object)A, (Object)B, (Object)C, (Object)D)));
        TableScanNode node = TableScanNode.newInstance((PlanNodeId)TestEffectivePredicateExtractor.newId(), (TableHandle)TestEffectivePredicateExtractor.makeTableHandle((TupleDomain<ColumnHandle>)TupleDomain.all()), (List)ImmutableList.copyOf(assignments.keySet()), (Map)assignments, (boolean)false, Optional.empty());
        Expression effectivePredicate = this.effectivePredicateExtractor.extract(SESSION, (PlanNode)node);
        Assertions.assertThat((Object)effectivePredicate).isEqualTo((Object)BooleanLiteral.TRUE_LITERAL);
        node = new TableScanNode(TestEffectivePredicateExtractor.newId(), TestEffectivePredicateExtractor.makeTableHandle((TupleDomain<ColumnHandle>)TupleDomain.none()), (List)ImmutableList.copyOf(assignments.keySet()), assignments, TupleDomain.none(), Optional.empty(), false, Optional.empty());
        effectivePredicate = this.effectivePredicateExtractor.extract(SESSION, (PlanNode)node);
        Assertions.assertThat((Object)effectivePredicate).isEqualTo((Object)BooleanLiteral.FALSE_LITERAL);
        TupleDomain predicate = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)this.scanAssignments.get(A), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L)));
        node = new TableScanNode(TestEffectivePredicateExtractor.newId(), TestEffectivePredicateExtractor.makeTableHandle((TupleDomain<ColumnHandle>)predicate), (List)ImmutableList.copyOf(assignments.keySet()), assignments, predicate, Optional.empty(), false, Optional.empty());
        effectivePredicate = this.effectivePredicateExtractor.extract(SESSION, (PlanNode)node);
        Assertions.assertThat(this.normalizeConjuncts(effectivePredicate)).isEqualTo(this.normalizeConjuncts((Expression)TestEffectivePredicateExtractor.equals(TestEffectivePredicateExtractor.bigintLiteral(1L), AE)));
        predicate = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)this.scanAssignments.get(A), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L), (Object)this.scanAssignments.get(B), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)2L)));
        node = new TableScanNode(TestEffectivePredicateExtractor.newId(), TestEffectivePredicateExtractor.makeTableHandle((TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)this.scanAssignments.get(A), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L)))), (List)ImmutableList.copyOf(assignments.keySet()), assignments, predicate, Optional.empty(), false, Optional.empty());
        effectivePredicate = this.effectivePredicateExtractorWithoutTableProperties.extract(SESSION, (PlanNode)node);
        Assertions.assertThat(this.normalizeConjuncts(effectivePredicate)).isEqualTo(this.normalizeConjuncts(new Expression[]{TestEffectivePredicateExtractor.equals(TestEffectivePredicateExtractor.bigintLiteral(2L), BE), TestEffectivePredicateExtractor.equals(TestEffectivePredicateExtractor.bigintLiteral(1L), AE)}));
        node = new TableScanNode(TestEffectivePredicateExtractor.newId(), TestEffectivePredicateExtractor.makeTableHandle((TupleDomain<ColumnHandle>)predicate), (List)ImmutableList.copyOf(assignments.keySet()), assignments, TupleDomain.all(), Optional.empty(), false, Optional.empty());
        effectivePredicate = this.effectivePredicateExtractor.extract(SESSION, (PlanNode)node);
        Assertions.assertThat((Object)effectivePredicate).isEqualTo((Object)IrUtils.and((Expression[])new Expression[]{TestEffectivePredicateExtractor.equals(AE, TestEffectivePredicateExtractor.bigintLiteral(1L)), TestEffectivePredicateExtractor.equals(BE, TestEffectivePredicateExtractor.bigintLiteral(2L))}));
        node = new TableScanNode(TestEffectivePredicateExtractor.newId(), TestEffectivePredicateExtractor.makeTableHandle((TupleDomain<ColumnHandle>)predicate), (List)ImmutableList.copyOf(assignments.keySet()), assignments, TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)this.scanAssignments.get(A), (Object)Domain.multipleValues((Type)BigintType.BIGINT, (List)ImmutableList.of((Object)1L, (Object)2L, (Object)3L)), (Object)this.scanAssignments.get(B), (Object)Domain.multipleValues((Type)BigintType.BIGINT, (List)ImmutableList.of((Object)1L, (Object)2L, (Object)3L)))), Optional.empty(), false, Optional.empty());
        effectivePredicate = this.effectivePredicateExtractor.extract(SESSION, (PlanNode)node);
        Assertions.assertThat(this.normalizeConjuncts(effectivePredicate)).isEqualTo(this.normalizeConjuncts(new Expression[]{TestEffectivePredicateExtractor.equals(TestEffectivePredicateExtractor.bigintLiteral(2L), BE), TestEffectivePredicateExtractor.equals(TestEffectivePredicateExtractor.bigintLiteral(1L), AE)}));
        node = new TableScanNode(TestEffectivePredicateExtractor.newId(), TestEffectivePredicateExtractor.makeTableHandle((TupleDomain<ColumnHandle>)TupleDomain.all()), (List)ImmutableList.copyOf(assignments.keySet()), assignments, TupleDomain.all(), Optional.empty(), false, Optional.empty());
        effectivePredicate = this.effectivePredicateExtractor.extract(SESSION, (PlanNode)node);
        Assertions.assertThat((Object)effectivePredicate).isEqualTo((Object)BooleanLiteral.TRUE_LITERAL);
    }

    @Test
    public void testValues() {
        Assertions.assertThat((Object)this.effectivePredicateExtractor.extract(SESSION, (PlanNode)new ValuesNode(TestEffectivePredicateExtractor.newId(), (List)ImmutableList.of((Object)A), (List)ImmutableList.of((Object)new Row((List)ImmutableList.of((Object)TestEffectivePredicateExtractor.bigintLiteral(1L))), (Object)new Row((List)ImmutableList.of((Object)TestEffectivePredicateExtractor.bigintLiteral(2L))))))).isEqualTo((Object)new InPredicate(AE, (List)ImmutableList.of((Object)TestEffectivePredicateExtractor.bigintLiteral(1L), (Object)TestEffectivePredicateExtractor.bigintLiteral(2L))));
        Assertions.assertThat((Object)this.effectivePredicateExtractor.extract(SESSION, (PlanNode)new ValuesNode(TestEffectivePredicateExtractor.newId(), (List)ImmutableList.of((Object)A), (List)ImmutableList.of((Object)new Row((List)ImmutableList.of((Object)TestEffectivePredicateExtractor.bigintLiteral(1L))), (Object)new Row((List)ImmutableList.of((Object)TestEffectivePredicateExtractor.bigintLiteral(2L))), (Object)new Row((List)ImmutableList.of((Object)new Constant((Type)BigintType.BIGINT, null))))))).isEqualTo((Object)IrUtils.or((Expression[])new Expression[]{new InPredicate(AE, (List)ImmutableList.of((Object)TestEffectivePredicateExtractor.bigintLiteral(1L), (Object)TestEffectivePredicateExtractor.bigintLiteral(2L))), new IsNullPredicate(AE)}));
        Assertions.assertThat((Object)this.effectivePredicateExtractor.extract(SESSION, (PlanNode)new ValuesNode(TestEffectivePredicateExtractor.newId(), (List)ImmutableList.of((Object)A), (List)ImmutableList.of((Object)new Row((List)ImmutableList.of((Object)new Constant((Type)BigintType.BIGINT, null))))))).isEqualTo((Object)new IsNullPredicate(AE));
        Assertions.assertThat((Object)this.effectivePredicateExtractor.extract(SESSION, (PlanNode)new ValuesNode(TestEffectivePredicateExtractor.newId(), (List)ImmutableList.of((Object)R), (List)ImmutableList.of((Object)new Row((List)ImmutableList.of((Object)new Row((List)ImmutableList.of((Object)TestEffectivePredicateExtractor.bigintLiteral(1L), (Object)new Constant((Type)UnknownType.UNKNOWN, null))))))))).isEqualTo((Object)BooleanLiteral.TRUE_LITERAL);
        List rows = (List)IntStream.range(0, 500).mapToObj(TestEffectivePredicateExtractor::bigintLiteral).map(ImmutableList::of).map(Row::new).collect(ImmutableList.toImmutableList());
        Assertions.assertThat((Object)this.effectivePredicateExtractor.extract(SESSION, (PlanNode)new ValuesNode(TestEffectivePredicateExtractor.newId(), (List)ImmutableList.of((Object)A), rows))).isEqualTo((Object)new BetweenPredicate(AE, TestEffectivePredicateExtractor.bigintLiteral(0L), TestEffectivePredicateExtractor.bigintLiteral(499L)));
        Assertions.assertThat((Object)this.effectivePredicateExtractor.extract(SESSION, (PlanNode)new ValuesNode(TestEffectivePredicateExtractor.newId(), (List)ImmutableList.of((Object)new Symbol((Type)DoubleType.DOUBLE, "c")), (List)ImmutableList.of((Object)new Row((List)ImmutableList.of((Object)TestEffectivePredicateExtractor.doubleLiteral(Double.NaN))))))).isEqualTo((Object)new NotExpression((Expression)new IsNullPredicate((Expression)new SymbolReference((Type)DoubleType.DOUBLE, "c"))));
        Assertions.assertThat((Object)this.effectivePredicateExtractor.extract(SESSION, (PlanNode)new ValuesNode(TestEffectivePredicateExtractor.newId(), (List)ImmutableList.of((Object)new Symbol((Type)DoubleType.DOUBLE, "c")), (List)ImmutableList.of((Object)new Row((List)ImmutableList.of((Object)new Constant((Type)DoubleType.DOUBLE, null))), (Object)new Row((List)ImmutableList.of((Object)TestEffectivePredicateExtractor.doubleLiteral(Double.NaN))))))).isEqualTo((Object)BooleanLiteral.TRUE_LITERAL);
        Assertions.assertThat((Object)this.effectivePredicateExtractor.extract(SESSION, (PlanNode)new ValuesNode(TestEffectivePredicateExtractor.newId(), (List)ImmutableList.of((Object)new Symbol((Type)DoubleType.DOUBLE, "x")), (List)ImmutableList.of((Object)new Row((List)ImmutableList.of((Object)TestEffectivePredicateExtractor.doubleLiteral(42.0))), (Object)new Row((List)ImmutableList.of((Object)TestEffectivePredicateExtractor.doubleLiteral(Double.NaN))))))).isEqualTo((Object)new NotExpression((Expression)new IsNullPredicate((Expression)new SymbolReference((Type)DoubleType.DOUBLE, "x"))));
        Assertions.assertThat((Object)this.effectivePredicateExtractor.extract(SESSION, (PlanNode)new ValuesNode(TestEffectivePredicateExtractor.newId(), (List)ImmutableList.of((Object)D), (List)ImmutableList.of((Object)new Row((List)ImmutableList.of((Object)new Cast(TestEffectivePredicateExtractor.doubleLiteral(Double.NaN), (Type)RealType.REAL))))))).isEqualTo((Object)new NotExpression((Expression)new IsNullPredicate(DE)));
        Assertions.assertThat((Object)this.effectivePredicateExtractor.extract(SESSION, (PlanNode)new ValuesNode(TestEffectivePredicateExtractor.newId(), (List)ImmutableList.of((Object)A, (Object)B), (List)ImmutableList.of((Object)new Row((List)ImmutableList.of((Object)TestEffectivePredicateExtractor.bigintLiteral(1L), (Object)TestEffectivePredicateExtractor.bigintLiteral(100L))), (Object)new Row((List)ImmutableList.of((Object)TestEffectivePredicateExtractor.bigintLiteral(2L), (Object)TestEffectivePredicateExtractor.bigintLiteral(200L))))))).isEqualTo((Object)IrUtils.and((Expression[])new Expression[]{new InPredicate(AE, (List)ImmutableList.of((Object)TestEffectivePredicateExtractor.bigintLiteral(1L), (Object)TestEffectivePredicateExtractor.bigintLiteral(2L))), new InPredicate(BE, (List)ImmutableList.of((Object)TestEffectivePredicateExtractor.bigintLiteral(100L), (Object)TestEffectivePredicateExtractor.bigintLiteral(200L)))}));
        Assertions.assertThat((Object)this.effectivePredicateExtractor.extract(SESSION, (PlanNode)new ValuesNode(TestEffectivePredicateExtractor.newId(), (List)ImmutableList.of((Object)A, (Object)B), (List)ImmutableList.of((Object)new Row((List)ImmutableList.of((Object)TestEffectivePredicateExtractor.bigintLiteral(1L), (Object)new Constant((Type)BigintType.BIGINT, null))), (Object)new Row((List)ImmutableList.of((Object)new Constant((Type)BigintType.BIGINT, null), (Object)TestEffectivePredicateExtractor.bigintLiteral(200L))))))).isEqualTo((Object)IrUtils.and((Expression[])new Expression[]{IrUtils.or((Expression[])new Expression[]{new ComparisonExpression(ComparisonExpression.Operator.EQUAL, AE, TestEffectivePredicateExtractor.bigintLiteral(1L)), new IsNullPredicate(AE)}), IrUtils.or((Expression[])new Expression[]{new ComparisonExpression(ComparisonExpression.Operator.EQUAL, BE, TestEffectivePredicateExtractor.bigintLiteral(200L)), new IsNullPredicate(BE)})}));
        ResolvedFunction rand = this.functionResolution.resolveFunction("rand", (List<TypeSignatureProvider>)ImmutableList.of());
        ValuesNode node = new ValuesNode(TestEffectivePredicateExtractor.newId(), (List)ImmutableList.of((Object)A, (Object)B), (List)ImmutableList.of((Object)new Row((List)ImmutableList.of((Object)TestEffectivePredicateExtractor.bigintLiteral(1L), (Object)new FunctionCall(rand, (List)ImmutableList.of())))));
        Assertions.assertThat((Object)this.extract((PlanNode)node)).isEqualTo((Object)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, AE, TestEffectivePredicateExtractor.bigintLiteral(1L)));
        Assertions.assertThat((Object)this.effectivePredicateExtractor.extract(SESSION, (PlanNode)new ValuesNode(TestEffectivePredicateExtractor.newId(), (List)ImmutableList.of((Object)A), (List)ImmutableList.of((Object)new Row((List)ImmutableList.of((Object)TestEffectivePredicateExtractor.bigintLiteral(1L))), (Object)new Row((List)ImmutableList.of((Object)BE)))))).isEqualTo((Object)BooleanLiteral.TRUE_LITERAL);
        Assertions.assertThat((Object)this.effectivePredicateExtractor.extract(SESSION, (PlanNode)new ValuesNode(TestEffectivePredicateExtractor.newId(), (List)ImmutableList.of((Object)G), (List)ImmutableList.of((Object)new Row((List)ImmutableList.of((Object)TestEffectivePredicateExtractor.bigintLiteral(1L))), (Object)new Row((List)ImmutableList.of((Object)TestEffectivePredicateExtractor.bigintLiteral(2L))))))).isEqualTo((Object)BooleanLiteral.TRUE_LITERAL);
    }

    private Expression extract(PlanNode node) {
        return (Expression)TransactionBuilder.transaction((TransactionManager)new TestingTransactionManager(), (Metadata)this.metadata, (AccessControl)new AllowAllAccessControl()).singleStatement().execute(SESSION, transactionSession -> this.effectivePredicateExtractor.extract(transactionSession, node));
    }

    @Test
    public void testUnion() {
        ImmutableListMultimap symbolMapping = ImmutableListMultimap.of((Object)A, (Object)B, (Object)A, (Object)C, (Object)A, (Object)E);
        UnionNode node = new UnionNode(TestEffectivePredicateExtractor.newId(), (List)ImmutableList.of((Object)TestEffectivePredicateExtractor.filter((PlanNode)this.baseTableScan, (Expression)TestEffectivePredicateExtractor.greaterThan(AE, TestEffectivePredicateExtractor.bigintLiteral(10L))), (Object)TestEffectivePredicateExtractor.filter((PlanNode)this.baseTableScan, IrUtils.and((Expression[])new Expression[]{TestEffectivePredicateExtractor.greaterThan(AE, TestEffectivePredicateExtractor.bigintLiteral(10L)), TestEffectivePredicateExtractor.lessThan(AE, TestEffectivePredicateExtractor.bigintLiteral(100L))})), (Object)TestEffectivePredicateExtractor.filter((PlanNode)this.baseTableScan, IrUtils.and((Expression[])new Expression[]{TestEffectivePredicateExtractor.greaterThan(AE, TestEffectivePredicateExtractor.bigintLiteral(10L)), TestEffectivePredicateExtractor.lessThan(AE, TestEffectivePredicateExtractor.bigintLiteral(100L))}))), (ListMultimap)symbolMapping, (List)ImmutableList.copyOf((Collection)symbolMapping.keySet()));
        Expression effectivePredicate = this.effectivePredicateExtractor.extract(SESSION, (PlanNode)node);
        Assertions.assertThat(this.normalizeConjuncts(effectivePredicate)).isEqualTo(this.normalizeConjuncts((Expression)TestEffectivePredicateExtractor.greaterThan(AE, TestEffectivePredicateExtractor.bigintLiteral(10L))));
    }

    @Test
    public void testInnerJoin() {
        ImmutableList.Builder criteriaBuilder = ImmutableList.builder();
        criteriaBuilder.add((Object)new JoinNode.EquiJoinClause(A, D));
        criteriaBuilder.add((Object)new JoinNode.EquiJoinClause(B, E));
        ImmutableList criteria = criteriaBuilder.build();
        Map leftAssignments = Maps.filterKeys(this.scanAssignments, (Predicate)Predicates.in((Collection)ImmutableList.of((Object)A, (Object)B, (Object)C)));
        TableScanNode leftScan = TestEffectivePredicateExtractor.tableScanNode(leftAssignments);
        Map rightAssignments = Maps.filterKeys(this.scanAssignments, (Predicate)Predicates.in((Collection)ImmutableList.of((Object)D, (Object)E, (Object)F)));
        TableScanNode rightScan = TestEffectivePredicateExtractor.tableScanNode(rightAssignments);
        FilterNode left = TestEffectivePredicateExtractor.filter((PlanNode)leftScan, IrUtils.and((Expression[])new Expression[]{TestEffectivePredicateExtractor.lessThan(BE, AE), TestEffectivePredicateExtractor.lessThan(CE, TestEffectivePredicateExtractor.bigintLiteral(10L)), TestEffectivePredicateExtractor.equals(GE, TestEffectivePredicateExtractor.bigintLiteral(10L))}));
        FilterNode right = TestEffectivePredicateExtractor.filter((PlanNode)rightScan, IrUtils.and((Expression[])new Expression[]{TestEffectivePredicateExtractor.equals(DE, EE), TestEffectivePredicateExtractor.lessThan(FE, TestEffectivePredicateExtractor.bigintLiteral(100L))}));
        JoinNode node = new JoinNode(TestEffectivePredicateExtractor.newId(), JoinType.INNER, (PlanNode)left, (PlanNode)right, (List)criteria, left.getOutputSymbols(), right.getOutputSymbols(), false, Optional.of(TestEffectivePredicateExtractor.lessThanOrEqual(BE, EE)), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), (Map)ImmutableMap.of(), Optional.empty());
        Expression effectivePredicate = this.effectivePredicateExtractor.extract(SESSION, (PlanNode)node);
        Assertions.assertThat(this.normalizeConjuncts(effectivePredicate)).isEqualTo(this.normalizeConjuncts(new Expression[]{TestEffectivePredicateExtractor.lessThan(BE, AE), TestEffectivePredicateExtractor.lessThan(CE, TestEffectivePredicateExtractor.bigintLiteral(10L)), TestEffectivePredicateExtractor.equals(DE, EE), TestEffectivePredicateExtractor.lessThan(FE, TestEffectivePredicateExtractor.bigintLiteral(100L)), TestEffectivePredicateExtractor.equals(AE, DE), TestEffectivePredicateExtractor.equals(BE, EE), TestEffectivePredicateExtractor.lessThanOrEqual(BE, EE)}));
    }

    @Test
    public void testInnerJoinPropagatesPredicatesViaEquiConditions() {
        Map leftAssignments = Maps.filterKeys(this.scanAssignments, (Predicate)Predicates.in((Collection)ImmutableList.of((Object)A, (Object)B, (Object)C)));
        TableScanNode leftScan = TestEffectivePredicateExtractor.tableScanNode(leftAssignments);
        Map rightAssignments = Maps.filterKeys(this.scanAssignments, (Predicate)Predicates.in((Collection)ImmutableList.of((Object)D, (Object)E, (Object)F)));
        TableScanNode rightScan = TestEffectivePredicateExtractor.tableScanNode(rightAssignments);
        FilterNode left = TestEffectivePredicateExtractor.filter((PlanNode)leftScan, (Expression)TestEffectivePredicateExtractor.equals(AE, TestEffectivePredicateExtractor.bigintLiteral(10L)));
        JoinNode node = new JoinNode(TestEffectivePredicateExtractor.newId(), JoinType.INNER, (PlanNode)left, (PlanNode)rightScan, (List)ImmutableList.of((Object)new JoinNode.EquiJoinClause(A, D)), (List)ImmutableList.of(), rightScan.getOutputSymbols(), false, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), (Map)ImmutableMap.of(), Optional.empty());
        Expression effectivePredicate = this.effectivePredicateExtractor.extract(SESSION, (PlanNode)node);
        Assertions.assertThat(this.normalizeConjuncts(effectivePredicate)).isEqualTo(this.normalizeConjuncts((Expression)TestEffectivePredicateExtractor.equals(DE, TestEffectivePredicateExtractor.bigintLiteral(10L))));
    }

    @Test
    public void testInnerJoinWithFalseFilter() {
        Map leftAssignments = Maps.filterKeys(this.scanAssignments, (Predicate)Predicates.in((Collection)ImmutableList.of((Object)A, (Object)B, (Object)C)));
        TableScanNode leftScan = TestEffectivePredicateExtractor.tableScanNode(leftAssignments);
        Map rightAssignments = Maps.filterKeys(this.scanAssignments, (Predicate)Predicates.in((Collection)ImmutableList.of((Object)D, (Object)E, (Object)F)));
        TableScanNode rightScan = TestEffectivePredicateExtractor.tableScanNode(rightAssignments);
        JoinNode node = new JoinNode(TestEffectivePredicateExtractor.newId(), JoinType.INNER, (PlanNode)leftScan, (PlanNode)rightScan, (List)ImmutableList.of((Object)new JoinNode.EquiJoinClause(A, D)), leftScan.getOutputSymbols(), rightScan.getOutputSymbols(), false, Optional.of(BooleanLiteral.FALSE_LITERAL), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), (Map)ImmutableMap.of(), Optional.empty());
        Expression effectivePredicate = this.effectivePredicateExtractor.extract(SESSION, (PlanNode)node);
        Assertions.assertThat((Object)effectivePredicate).isEqualTo((Object)BooleanLiteral.FALSE_LITERAL);
    }

    @Test
    public void testLeftJoin() {
        ImmutableList.Builder criteriaBuilder = ImmutableList.builder();
        criteriaBuilder.add((Object)new JoinNode.EquiJoinClause(A, D));
        criteriaBuilder.add((Object)new JoinNode.EquiJoinClause(B, E));
        ImmutableList criteria = criteriaBuilder.build();
        Map leftAssignments = Maps.filterKeys(this.scanAssignments, (Predicate)Predicates.in((Collection)ImmutableList.of((Object)A, (Object)B, (Object)C)));
        TableScanNode leftScan = TestEffectivePredicateExtractor.tableScanNode(leftAssignments);
        Map rightAssignments = Maps.filterKeys(this.scanAssignments, (Predicate)Predicates.in((Collection)ImmutableList.of((Object)D, (Object)E, (Object)F)));
        TableScanNode rightScan = TestEffectivePredicateExtractor.tableScanNode(rightAssignments);
        FilterNode left = TestEffectivePredicateExtractor.filter((PlanNode)leftScan, IrUtils.and((Expression[])new Expression[]{TestEffectivePredicateExtractor.lessThan(BE, AE), TestEffectivePredicateExtractor.lessThan(CE, TestEffectivePredicateExtractor.bigintLiteral(10L)), TestEffectivePredicateExtractor.equals(GE, TestEffectivePredicateExtractor.bigintLiteral(10L))}));
        FilterNode right = TestEffectivePredicateExtractor.filter((PlanNode)rightScan, IrUtils.and((Expression[])new Expression[]{TestEffectivePredicateExtractor.equals(DE, EE), TestEffectivePredicateExtractor.lessThan(FE, TestEffectivePredicateExtractor.bigintLiteral(100L))}));
        JoinNode node = new JoinNode(TestEffectivePredicateExtractor.newId(), JoinType.LEFT, (PlanNode)left, (PlanNode)right, (List)criteria, left.getOutputSymbols(), right.getOutputSymbols(), false, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), (Map)ImmutableMap.of(), Optional.empty());
        Expression effectivePredicate = this.effectivePredicateExtractor.extract(SESSION, (PlanNode)node);
        Assertions.assertThat(this.normalizeConjuncts(effectivePredicate)).isEqualTo(this.normalizeConjuncts(new Expression[]{TestEffectivePredicateExtractor.lessThan(BE, AE), TestEffectivePredicateExtractor.lessThan(CE, TestEffectivePredicateExtractor.bigintLiteral(10L)), IrUtils.or((Expression[])new Expression[]{TestEffectivePredicateExtractor.equals(DE, EE), IrUtils.and((Expression[])new Expression[]{TestEffectivePredicateExtractor.isNull(DE), TestEffectivePredicateExtractor.isNull(EE)})}), IrUtils.or((Expression[])new Expression[]{TestEffectivePredicateExtractor.lessThan(FE, TestEffectivePredicateExtractor.bigintLiteral(100L)), TestEffectivePredicateExtractor.isNull(FE)}), IrUtils.or((Expression[])new Expression[]{TestEffectivePredicateExtractor.equals(AE, DE), TestEffectivePredicateExtractor.isNull(DE)}), IrUtils.or((Expression[])new Expression[]{TestEffectivePredicateExtractor.equals(BE, EE), TestEffectivePredicateExtractor.isNull(EE)})}));
    }

    @Test
    public void testLeftJoinWithFalseInner() {
        ImmutableList criteria = ImmutableList.of((Object)new JoinNode.EquiJoinClause(A, D));
        Map leftAssignments = Maps.filterKeys(this.scanAssignments, (Predicate)Predicates.in((Collection)ImmutableList.of((Object)A, (Object)B, (Object)C)));
        TableScanNode leftScan = TestEffectivePredicateExtractor.tableScanNode(leftAssignments);
        Map rightAssignments = Maps.filterKeys(this.scanAssignments, (Predicate)Predicates.in((Collection)ImmutableList.of((Object)D, (Object)E, (Object)F)));
        TableScanNode rightScan = TestEffectivePredicateExtractor.tableScanNode(rightAssignments);
        FilterNode left = TestEffectivePredicateExtractor.filter((PlanNode)leftScan, IrUtils.and((Expression[])new Expression[]{TestEffectivePredicateExtractor.lessThan(BE, AE), TestEffectivePredicateExtractor.lessThan(CE, TestEffectivePredicateExtractor.bigintLiteral(10L)), TestEffectivePredicateExtractor.equals(GE, TestEffectivePredicateExtractor.bigintLiteral(10L))}));
        FilterNode right = TestEffectivePredicateExtractor.filter((PlanNode)rightScan, (Expression)BooleanLiteral.FALSE_LITERAL);
        JoinNode node = new JoinNode(TestEffectivePredicateExtractor.newId(), JoinType.LEFT, (PlanNode)left, (PlanNode)right, (List)criteria, left.getOutputSymbols(), right.getOutputSymbols(), false, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), (Map)ImmutableMap.of(), Optional.empty());
        Expression effectivePredicate = this.effectivePredicateExtractor.extract(SESSION, (PlanNode)node);
        Assertions.assertThat(this.normalizeConjuncts(effectivePredicate)).isEqualTo(this.normalizeConjuncts(new Expression[]{TestEffectivePredicateExtractor.lessThan(BE, AE), TestEffectivePredicateExtractor.lessThan(CE, TestEffectivePredicateExtractor.bigintLiteral(10L)), IrUtils.or((Expression[])new Expression[]{TestEffectivePredicateExtractor.equals(AE, DE), TestEffectivePredicateExtractor.isNull(DE)})}));
    }

    @Test
    public void testRightJoin() {
        ImmutableList.Builder criteriaBuilder = ImmutableList.builder();
        criteriaBuilder.add((Object)new JoinNode.EquiJoinClause(A, D));
        criteriaBuilder.add((Object)new JoinNode.EquiJoinClause(B, E));
        ImmutableList criteria = criteriaBuilder.build();
        Map leftAssignments = Maps.filterKeys(this.scanAssignments, (Predicate)Predicates.in((Collection)ImmutableList.of((Object)A, (Object)B, (Object)C)));
        TableScanNode leftScan = TestEffectivePredicateExtractor.tableScanNode(leftAssignments);
        Map rightAssignments = Maps.filterKeys(this.scanAssignments, (Predicate)Predicates.in((Collection)ImmutableList.of((Object)D, (Object)E, (Object)F)));
        TableScanNode rightScan = TestEffectivePredicateExtractor.tableScanNode(rightAssignments);
        FilterNode left = TestEffectivePredicateExtractor.filter((PlanNode)leftScan, IrUtils.and((Expression[])new Expression[]{TestEffectivePredicateExtractor.lessThan(BE, AE), TestEffectivePredicateExtractor.lessThan(CE, TestEffectivePredicateExtractor.bigintLiteral(10L)), TestEffectivePredicateExtractor.equals(GE, TestEffectivePredicateExtractor.bigintLiteral(10L))}));
        FilterNode right = TestEffectivePredicateExtractor.filter((PlanNode)rightScan, IrUtils.and((Expression[])new Expression[]{TestEffectivePredicateExtractor.equals(DE, EE), TestEffectivePredicateExtractor.lessThan(FE, TestEffectivePredicateExtractor.bigintLiteral(100L))}));
        JoinNode node = new JoinNode(TestEffectivePredicateExtractor.newId(), JoinType.RIGHT, (PlanNode)left, (PlanNode)right, (List)criteria, left.getOutputSymbols(), right.getOutputSymbols(), false, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), (Map)ImmutableMap.of(), Optional.empty());
        Expression effectivePredicate = this.effectivePredicateExtractor.extract(SESSION, (PlanNode)node);
        Assertions.assertThat(this.normalizeConjuncts(effectivePredicate)).isEqualTo(this.normalizeConjuncts(new Expression[]{IrUtils.or((Expression[])new Expression[]{TestEffectivePredicateExtractor.lessThan(BE, AE), IrUtils.and((Expression[])new Expression[]{TestEffectivePredicateExtractor.isNull(BE), TestEffectivePredicateExtractor.isNull(AE)})}), IrUtils.or((Expression[])new Expression[]{TestEffectivePredicateExtractor.lessThan(CE, TestEffectivePredicateExtractor.bigintLiteral(10L)), TestEffectivePredicateExtractor.isNull(CE)}), TestEffectivePredicateExtractor.equals(DE, EE), TestEffectivePredicateExtractor.lessThan(FE, TestEffectivePredicateExtractor.bigintLiteral(100L)), IrUtils.or((Expression[])new Expression[]{TestEffectivePredicateExtractor.equals(AE, DE), TestEffectivePredicateExtractor.isNull(AE)}), IrUtils.or((Expression[])new Expression[]{TestEffectivePredicateExtractor.equals(BE, EE), TestEffectivePredicateExtractor.isNull(BE)})}));
    }

    @Test
    public void testRightJoinWithFalseInner() {
        ImmutableList criteria = ImmutableList.of((Object)new JoinNode.EquiJoinClause(A, D));
        Map leftAssignments = Maps.filterKeys(this.scanAssignments, (Predicate)Predicates.in((Collection)ImmutableList.of((Object)A, (Object)B, (Object)C)));
        TableScanNode leftScan = TestEffectivePredicateExtractor.tableScanNode(leftAssignments);
        Map rightAssignments = Maps.filterKeys(this.scanAssignments, (Predicate)Predicates.in((Collection)ImmutableList.of((Object)D, (Object)E, (Object)F)));
        TableScanNode rightScan = TestEffectivePredicateExtractor.tableScanNode(rightAssignments);
        FilterNode left = TestEffectivePredicateExtractor.filter((PlanNode)leftScan, (Expression)BooleanLiteral.FALSE_LITERAL);
        FilterNode right = TestEffectivePredicateExtractor.filter((PlanNode)rightScan, IrUtils.and((Expression[])new Expression[]{TestEffectivePredicateExtractor.equals(DE, EE), TestEffectivePredicateExtractor.lessThan(FE, TestEffectivePredicateExtractor.bigintLiteral(100L))}));
        JoinNode node = new JoinNode(TestEffectivePredicateExtractor.newId(), JoinType.RIGHT, (PlanNode)left, (PlanNode)right, (List)criteria, left.getOutputSymbols(), right.getOutputSymbols(), false, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), (Map)ImmutableMap.of(), Optional.empty());
        Expression effectivePredicate = this.effectivePredicateExtractor.extract(SESSION, (PlanNode)node);
        Assertions.assertThat(this.normalizeConjuncts(effectivePredicate)).isEqualTo(this.normalizeConjuncts(new Expression[]{TestEffectivePredicateExtractor.equals(DE, EE), TestEffectivePredicateExtractor.lessThan(FE, TestEffectivePredicateExtractor.bigintLiteral(100L)), IrUtils.or((Expression[])new Expression[]{TestEffectivePredicateExtractor.equals(AE, DE), TestEffectivePredicateExtractor.isNull(AE)})}));
    }

    @Test
    public void testSemiJoin() {
        SemiJoinNode node = new SemiJoinNode(TestEffectivePredicateExtractor.newId(), (PlanNode)TestEffectivePredicateExtractor.filter((PlanNode)this.baseTableScan, IrUtils.and((Expression[])new Expression[]{TestEffectivePredicateExtractor.greaterThan(AE, TestEffectivePredicateExtractor.bigintLiteral(10L)), TestEffectivePredicateExtractor.lessThan(AE, TestEffectivePredicateExtractor.bigintLiteral(100L))})), (PlanNode)TestEffectivePredicateExtractor.filter((PlanNode)this.baseTableScan, (Expression)TestEffectivePredicateExtractor.greaterThan(AE, TestEffectivePredicateExtractor.bigintLiteral(5L))), A, B, C, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
        Expression effectivePredicate = this.effectivePredicateExtractor.extract(SESSION, (PlanNode)node);
        Assertions.assertThat(this.normalizeConjuncts(effectivePredicate)).isEqualTo(this.normalizeConjuncts(IrUtils.and((Expression[])new Expression[]{TestEffectivePredicateExtractor.greaterThan(AE, TestEffectivePredicateExtractor.bigintLiteral(10L)), TestEffectivePredicateExtractor.lessThan(AE, TestEffectivePredicateExtractor.bigintLiteral(100L))})));
    }

    private static TableScanNode tableScanNode(Map<Symbol, ColumnHandle> scanAssignments) {
        return new TableScanNode(TestEffectivePredicateExtractor.newId(), TestEffectivePredicateExtractor.makeTableHandle((TupleDomain<ColumnHandle>)TupleDomain.all()), (List)ImmutableList.copyOf(scanAssignments.keySet()), scanAssignments, TupleDomain.all(), Optional.empty(), false, Optional.empty());
    }

    private static PlanNodeId newId() {
        return new PlanNodeId(UUID.randomUUID().toString());
    }

    private static FilterNode filter(PlanNode source, Expression predicate) {
        return new FilterNode(TestEffectivePredicateExtractor.newId(), source, predicate);
    }

    private static Expression bigintLiteral(long number) {
        return new Constant((Type)BigintType.BIGINT, (Object)number);
    }

    private static Expression doubleLiteral(double value) {
        return new Constant((Type)DoubleType.DOUBLE, (Object)value);
    }

    private static ComparisonExpression equals(Expression expression1, Expression expression2) {
        return new ComparisonExpression(ComparisonExpression.Operator.EQUAL, expression1, expression2);
    }

    private static ComparisonExpression lessThan(Expression expression1, Expression expression2) {
        return new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, expression1, expression2);
    }

    private static ComparisonExpression lessThanOrEqual(Expression expression1, Expression expression2) {
        return new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, expression1, expression2);
    }

    private static ComparisonExpression greaterThan(Expression expression1, Expression expression2) {
        return new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, expression1, expression2);
    }

    private static IsNullPredicate isNull(Expression expression) {
        return new IsNullPredicate(expression);
    }

    private static ResolvedFunction fakeFunction(String name) {
        BoundSignature boundSignature = new BoundSignature(GlobalFunctionCatalog.builtinFunctionName((String)name), (Type)UnknownType.UNKNOWN, (List)ImmutableList.of());
        return new ResolvedFunction(boundSignature, GlobalSystemConnector.CATALOG_HANDLE, FunctionId.toFunctionId((String)name, (Signature)boundSignature.toSignature()), FunctionKind.SCALAR, true, new FunctionNullability(false, (List)ImmutableList.of()), (Map)ImmutableMap.of(), (Set)ImmutableSet.of());
    }

    private Set<Expression> normalizeConjuncts(Expression ... conjuncts) {
        return this.normalizeConjuncts(Arrays.asList(conjuncts));
    }

    private Set<Expression> normalizeConjuncts(Collection<Expression> conjuncts) {
        return this.normalizeConjuncts(IrUtils.combineConjuncts(conjuncts));
    }

    private Set<Expression> normalizeConjuncts(Expression predicate) {
        predicate = this.expressionNormalizer.normalize(predicate);
        EqualityInference inference = new EqualityInference(new Expression[]{predicate});
        Set scope = SymbolsExtractor.extractUnique((Expression)predicate);
        Set<Expression> rewrittenSet = EqualityInference.nonInferrableConjuncts((Expression)predicate).map(expression -> inference.rewrite(expression, scope)).peek(rewritten -> Preconditions.checkState((rewritten != null ? 1 : 0) != 0, (Object)"Rewrite with full symbol scope should always be possible")).collect(Collectors.toSet());
        rewrittenSet.addAll(inference.generateEqualitiesPartitionedBy(scope).getScopeEqualities());
        return rewrittenSet;
    }

    private static TableHandle makeTableHandle(TupleDomain<ColumnHandle> predicate) {
        return new TableHandle(TestingHandles.TEST_CATALOG_HANDLE, (ConnectorTableHandle)new PredicatedTableHandle(predicate), (ConnectorTransactionHandle)TestingTransactionHandle.create());
    }

    private static class ExpressionIdentityNormalizer {
        private final Map<Expression, Expression> expressionCache = new HashMap<Expression, Expression>();

        private ExpressionIdentityNormalizer() {
        }

        private Expression normalize(Expression expression) {
            Expression identityNormalizedExpression = this.expressionCache.get(expression);
            if (identityNormalizedExpression == null) {
                IrUtils.preOrder((Expression)expression).filter(e -> !e.equals((Object)expression)).forEach(this::normalize);
                identityNormalizedExpression = ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ExpressionNodeInliner(this.expressionCache), (Expression)expression);
                this.expressionCache.put(identityNormalizedExpression, identityNormalizedExpression);
            }
            return identityNormalizedExpression;
        }
    }

    private static class PredicatedTableHandle
    implements ConnectorTableHandle {
        private final TupleDomain<ColumnHandle> predicate;

        public PredicatedTableHandle(TupleDomain<ColumnHandle> predicate) {
            this.predicate = predicate;
        }

        public TupleDomain<ColumnHandle> getPredicate() {
            return this.predicate;
        }
    }
}

