/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.ir.ArithmeticBinaryExpression;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.ComparisonExpression;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.InPredicate;
import io.trino.sql.ir.IrUtils;
import io.trino.sql.ir.IsNullPredicate;
import io.trino.sql.ir.LambdaExpression;
import io.trino.sql.ir.NotExpression;
import io.trino.sql.ir.NullIfExpression;
import io.trino.sql.ir.SearchedCaseExpression;
import io.trino.sql.ir.SimpleCaseExpression;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.ir.WhenClause;
import io.trino.sql.planner.EqualityInference;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolsExtractor;
import io.trino.type.FunctionType;
import io.trino.type.UnknownType;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestEqualityInference {
    private static final TestingFunctionResolution FUNCTIONS = new TestingFunctionResolution();
    private static final ResolvedFunction ADD_BIGINT = FUNCTIONS.resolveOperator(OperatorType.ADD, (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT));
    private static final ResolvedFunction MULTIPLY_BIGINT = FUNCTIONS.resolveOperator(OperatorType.MULTIPLY, (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT));
    private final TestingFunctionResolution functionResolution = new TestingFunctionResolution();

    @Test
    public void testDoesNotInferRedundantStraddlingPredicates() {
        EqualityInference inference = new EqualityInference(new Expression[]{TestEqualityInference.equals("a1", "b1"), TestEqualityInference.equals(TestEqualityInference.add((Expression)new SymbolReference((Type)BigintType.BIGINT, "a1"), (Expression)TestEqualityInference.number(1L)), (Expression)TestEqualityInference.number(0L)), TestEqualityInference.equals((Expression)new SymbolReference((Type)BigintType.BIGINT, "a2"), TestEqualityInference.add((Expression)new SymbolReference((Type)BigintType.BIGINT, "a1"), (Expression)TestEqualityInference.number(2L))), TestEqualityInference.equals((Expression)new SymbolReference((Type)BigintType.BIGINT, "a1"), TestEqualityInference.add("a3", "b3")), TestEqualityInference.equals((Expression)new SymbolReference((Type)BigintType.BIGINT, "b2"), TestEqualityInference.add("a4", "b4"))});
        EqualityInference.EqualityPartition partition = inference.generateEqualitiesPartitionedBy(TestEqualityInference.symbols("a1", "a2", "a3", "a4"));
        Assertions.assertThat((List)partition.getScopeEqualities()).containsExactly((Object[])new Expression[]{TestEqualityInference.equals((Expression)TestEqualityInference.number(0L), TestEqualityInference.add((Expression)new SymbolReference((Type)BigintType.BIGINT, "a1"), (Expression)TestEqualityInference.number(1L))), TestEqualityInference.equals((Expression)new SymbolReference((Type)BigintType.BIGINT, "a2"), TestEqualityInference.add((Expression)new SymbolReference((Type)BigintType.BIGINT, "a1"), (Expression)TestEqualityInference.number(2L)))});
        Assertions.assertThat((List)partition.getScopeComplementEqualities()).containsExactly((Object[])new Expression[]{TestEqualityInference.equals((Expression)TestEqualityInference.number(0L), TestEqualityInference.add((Expression)new SymbolReference((Type)BigintType.BIGINT, "b1"), (Expression)TestEqualityInference.number(1L)))});
        Assertions.assertThat((List)partition.getScopeStraddlingEqualities()).containsExactly((Object[])new Expression[]{TestEqualityInference.equals("a1", "b1"), TestEqualityInference.equals((Expression)new SymbolReference((Type)BigintType.BIGINT, "a1"), TestEqualityInference.add("a3", "b3")), TestEqualityInference.equals((Expression)new SymbolReference((Type)BigintType.BIGINT, "b2"), TestEqualityInference.add("a4", "b4"))});
    }

    @Test
    public void testTransitivity() {
        EqualityInference inference = new EqualityInference(new Expression[]{TestEqualityInference.equals("a1", "b1"), TestEqualityInference.equals("b1", "c1"), TestEqualityInference.equals("d1", "c1"), TestEqualityInference.equals("a2", "b2"), TestEqualityInference.equals("b2", "a2"), TestEqualityInference.equals("b2", "c2"), TestEqualityInference.equals("d2", "b2"), TestEqualityInference.equals("c2", "d2")});
        Assertions.assertThat((Object)inference.rewrite(TestEqualityInference.someExpression("a1", "a2"), TestEqualityInference.symbols("d1", "d2"))).isEqualTo((Object)TestEqualityInference.someExpression("d1", "d2"));
        Assertions.assertThat((Object)inference.rewrite(TestEqualityInference.someExpression("a1", "c1"), TestEqualityInference.symbols("b1"))).isEqualTo((Object)TestEqualityInference.someExpression("b1", "b1"));
        Assertions.assertThat((Object)inference.rewrite(TestEqualityInference.someExpression("a1", "a2"), TestEqualityInference.symbols("b1", "d2", "c3"))).isEqualTo((Object)TestEqualityInference.someExpression("b1", "d2"));
        Assertions.assertThat((Object)inference.getScopedCanonical((Expression)new SymbolReference((Type)BigintType.BIGINT, "a2"), TestEqualityInference.matchesSymbols("c2", "d2"))).isEqualTo((Object)inference.getScopedCanonical((Expression)new SymbolReference((Type)BigintType.BIGINT, "b2"), TestEqualityInference.matchesSymbols("c2", "d2")));
        Expression canonical = inference.getScopedCanonical((Expression)new SymbolReference((Type)BigintType.BIGINT, "a2"), TestEqualityInference.matchesSymbols("c2", "d2"));
        Assertions.assertThat((Object)inference.rewrite(TestEqualityInference.someExpression("a2", "b2"), TestEqualityInference.symbols("c2", "d2"))).isEqualTo((Object)TestEqualityInference.someExpression(canonical, canonical));
    }

    @Test
    public void testTriviallyRewritable() {
        Expression expression = new EqualityInference(new Expression[0]).rewrite(TestEqualityInference.someExpression("a1", "a2"), TestEqualityInference.symbols("a1", "a2"));
        Assertions.assertThat((Object)expression).isEqualTo((Object)TestEqualityInference.someExpression("a1", "a2"));
    }

    @Test
    public void testUnrewritable() {
        EqualityInference inference = new EqualityInference(new Expression[]{TestEqualityInference.equals("a1", "b1"), TestEqualityInference.equals("a2", "b2")});
        Assertions.assertThat((Object)inference.rewrite(TestEqualityInference.someExpression("a1", "a2"), TestEqualityInference.symbols("b1", "c1"))).isNull();
        Assertions.assertThat((Object)inference.rewrite(TestEqualityInference.someExpression("c1", "c2"), TestEqualityInference.symbols("a1", "a2"))).isNull();
    }

    @Test
    public void testParseEqualityExpression() {
        EqualityInference inference = new EqualityInference(new Expression[]{TestEqualityInference.equals("a1", "b1"), TestEqualityInference.equals("a1", "c1"), TestEqualityInference.equals("c1", "a1")});
        Expression expression = inference.rewrite(TestEqualityInference.someExpression("a1", "b1"), TestEqualityInference.symbols("c1"));
        Assertions.assertThat((Object)expression).isEqualTo((Object)TestEqualityInference.someExpression("c1", "c1"));
    }

    @Test
    public void testExtractInferrableEqualities() {
        EqualityInference inference = new EqualityInference(new Expression[]{IrUtils.and((Expression[])new Expression[]{TestEqualityInference.equals("a1", "b1"), TestEqualityInference.equals("b1", "c1"), TestEqualityInference.someExpression("c1", "d1")})});
        Assertions.assertThat((Object)new SymbolReference((Type)BigintType.BIGINT, "c1")).isEqualTo((Object)inference.rewrite((Expression)new SymbolReference((Type)BigintType.BIGINT, "a1"), TestEqualityInference.symbols("c1")));
        Assertions.assertThat((Object)inference.rewrite((Expression)new SymbolReference((Type)BigintType.BIGINT, "a1"), TestEqualityInference.symbols("d1"))).isNull();
    }

    @Test
    public void testEqualityPartitionGeneration() {
        EqualityInference inference = new EqualityInference(new Expression[]{TestEqualityInference.equals((Expression)new SymbolReference((Type)BigintType.BIGINT, "a1"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "b1")), TestEqualityInference.equals(TestEqualityInference.add("a1", "a1"), TestEqualityInference.multiply((Expression)new SymbolReference((Type)BigintType.BIGINT, "a1"), (Expression)TestEqualityInference.number(2L))), TestEqualityInference.equals((Expression)new SymbolReference((Type)BigintType.BIGINT, "b1"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "c1")), TestEqualityInference.equals(TestEqualityInference.add("a1", "a1"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "c1")), TestEqualityInference.equals(TestEqualityInference.add("a1", "b1"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "c1"))});
        EqualityInference.EqualityPartition emptyScopePartition = inference.generateEqualitiesPartitionedBy((Set)ImmutableSet.of());
        Assertions.assertThat((boolean)emptyScopePartition.getScopeEqualities().isEmpty()).isTrue();
        Assertions.assertThat((boolean)emptyScopePartition.getScopeComplementEqualities().isEmpty()).isFalse();
        Assertions.assertThat((boolean)emptyScopePartition.getScopeStraddlingEqualities().isEmpty()).isTrue();
        EqualityInference.EqualityPartition equalityPartition = inference.generateEqualitiesPartitionedBy(TestEqualityInference.symbols("c1"));
        Assertions.assertThat((boolean)equalityPartition.getScopeEqualities().isEmpty()).isFalse();
        Assertions.assertThat((boolean)Iterables.all((Iterable)equalityPartition.getScopeEqualities(), TestEqualityInference.matchesSymbolScope(TestEqualityInference.matchesSymbols("c1")))).isTrue();
        Assertions.assertThat((boolean)Iterables.all((Iterable)equalityPartition.getScopeEqualities(), expression -> EqualityInference.isInferenceCandidate((Expression)expression))).isTrue();
        Assertions.assertThat((boolean)equalityPartition.getScopeComplementEqualities().isEmpty()).isFalse();
        Assertions.assertThat((boolean)Iterables.all((Iterable)equalityPartition.getScopeComplementEqualities(), TestEqualityInference.matchesSymbolScope((Predicate<Symbol>)Predicates.not(TestEqualityInference.matchesSymbols("c1"))))).isTrue();
        Assertions.assertThat((boolean)Iterables.all((Iterable)equalityPartition.getScopeComplementEqualities(), expression -> EqualityInference.isInferenceCandidate((Expression)expression))).isTrue();
        Assertions.assertThat((boolean)equalityPartition.getScopeStraddlingEqualities().isEmpty()).isFalse();
        Assertions.assertThat((boolean)Iterables.any((Iterable)equalityPartition.getScopeStraddlingEqualities(), TestEqualityInference.matchesStraddlingScope(TestEqualityInference.matchesSymbols("c1")))).isTrue();
        Assertions.assertThat((boolean)Iterables.all((Iterable)equalityPartition.getScopeStraddlingEqualities(), expression -> EqualityInference.isInferenceCandidate((Expression)expression))).isTrue();
        EqualityInference newInference = new EqualityInference((Collection)ImmutableList.builder().addAll((Iterable)equalityPartition.getScopeEqualities()).addAll((Iterable)equalityPartition.getScopeComplementEqualities()).addAll((Iterable)equalityPartition.getScopeStraddlingEqualities()).build());
        EqualityInference.EqualityPartition newEqualityPartition = newInference.generateEqualitiesPartitionedBy(TestEqualityInference.symbols("c1"));
        Assertions.assertThat(TestEqualityInference.setCopy(equalityPartition.getScopeEqualities())).isEqualTo(TestEqualityInference.setCopy(newEqualityPartition.getScopeEqualities()));
        Assertions.assertThat(TestEqualityInference.setCopy(equalityPartition.getScopeComplementEqualities())).isEqualTo(TestEqualityInference.setCopy(newEqualityPartition.getScopeComplementEqualities()));
        Assertions.assertThat(TestEqualityInference.setCopy(equalityPartition.getScopeStraddlingEqualities())).isEqualTo(TestEqualityInference.setCopy(newEqualityPartition.getScopeStraddlingEqualities()));
    }

    @Test
    public void testMultipleEqualitySetsPredicateGeneration() {
        EqualityInference inference = new EqualityInference(new Expression[]{TestEqualityInference.equals("a1", "b1"), TestEqualityInference.equals("b1", "c1"), TestEqualityInference.equals("c1", "d1"), TestEqualityInference.equals("a2", "b2"), TestEqualityInference.equals("b2", "c2"), TestEqualityInference.equals("c2", "d2")});
        EqualityInference.EqualityPartition equalityPartition = inference.generateEqualitiesPartitionedBy(TestEqualityInference.symbols("a1", "a2", "b1", "b2"));
        Assertions.assertThat((boolean)equalityPartition.getScopeEqualities().isEmpty()).isFalse();
        Assertions.assertThat((boolean)Iterables.all((Iterable)equalityPartition.getScopeEqualities(), TestEqualityInference.matchesSymbolScope(TestEqualityInference.symbolBeginsWith("a", "b")))).isTrue();
        Assertions.assertThat((boolean)Iterables.all((Iterable)equalityPartition.getScopeEqualities(), expression -> EqualityInference.isInferenceCandidate((Expression)expression))).isTrue();
        Assertions.assertThat((boolean)equalityPartition.getScopeComplementEqualities().isEmpty()).isFalse();
        Assertions.assertThat((boolean)Iterables.all((Iterable)equalityPartition.getScopeComplementEqualities(), TestEqualityInference.matchesSymbolScope((Predicate<Symbol>)Predicates.not(TestEqualityInference.symbolBeginsWith("a", "b"))))).isTrue();
        Assertions.assertThat((boolean)Iterables.all((Iterable)equalityPartition.getScopeComplementEqualities(), expression -> EqualityInference.isInferenceCandidate((Expression)expression))).isTrue();
        Assertions.assertThat((boolean)equalityPartition.getScopeStraddlingEqualities().isEmpty()).isFalse();
        Assertions.assertThat((boolean)Iterables.any((Iterable)equalityPartition.getScopeStraddlingEqualities(), TestEqualityInference.matchesStraddlingScope(TestEqualityInference.symbolBeginsWith("a", "b")))).isTrue();
        Assertions.assertThat((boolean)Iterables.all((Iterable)equalityPartition.getScopeStraddlingEqualities(), expression -> EqualityInference.isInferenceCandidate((Expression)expression))).isTrue();
        EqualityInference newInference = new EqualityInference((Collection)ImmutableList.builder().addAll((Iterable)equalityPartition.getScopeEqualities()).addAll((Iterable)equalityPartition.getScopeComplementEqualities()).addAll((Iterable)equalityPartition.getScopeStraddlingEqualities()).build());
        EqualityInference.EqualityPartition newEqualityPartition = newInference.generateEqualitiesPartitionedBy(TestEqualityInference.symbols("a1", "a2", "b1", "b2"));
        Assertions.assertThat(TestEqualityInference.setCopy(equalityPartition.getScopeEqualities())).isEqualTo(TestEqualityInference.setCopy(newEqualityPartition.getScopeEqualities()));
        Assertions.assertThat(TestEqualityInference.setCopy(equalityPartition.getScopeComplementEqualities())).isEqualTo(TestEqualityInference.setCopy(newEqualityPartition.getScopeComplementEqualities()));
        Assertions.assertThat(TestEqualityInference.setCopy(equalityPartition.getScopeStraddlingEqualities())).isEqualTo(TestEqualityInference.setCopy(newEqualityPartition.getScopeStraddlingEqualities()));
    }

    @Test
    public void testSubExpressionRewrites() {
        EqualityInference inference = new EqualityInference(new Expression[]{TestEqualityInference.equals((Expression)new SymbolReference((Type)BigintType.BIGINT, "a1"), TestEqualityInference.add("b", "c")), TestEqualityInference.equals((Expression)new SymbolReference((Type)BigintType.BIGINT, "a2"), TestEqualityInference.multiply((Expression)new SymbolReference((Type)BigintType.BIGINT, "b"), TestEqualityInference.add("b", "c"))), TestEqualityInference.equals((Expression)new SymbolReference((Type)BigintType.BIGINT, "a3"), TestEqualityInference.multiply((Expression)new SymbolReference((Type)BigintType.BIGINT, "a1"), TestEqualityInference.add("b", "c")))});
        Assertions.assertThat((Object)inference.rewrite(TestEqualityInference.add("b", "c"), TestEqualityInference.symbols("a1", "a2"))).isEqualTo((Object)new SymbolReference((Type)BigintType.BIGINT, "a1"));
        Assertions.assertThat((Object)inference.rewrite(TestEqualityInference.multiply((Expression)new SymbolReference((Type)BigintType.BIGINT, "ax"), TestEqualityInference.add("b", "c")), TestEqualityInference.symbols("ax", "a1", "a2", "a3"))).isEqualTo((Object)TestEqualityInference.multiply((Expression)new SymbolReference((Type)BigintType.BIGINT, "ax"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "a1")));
        Assertions.assertThat((Object)inference.rewrite(TestEqualityInference.multiply((Expression)new SymbolReference((Type)BigintType.BIGINT, "a1"), TestEqualityInference.add("b", "c")), TestEqualityInference.symbols("a1", "a2", "a3"))).isEqualTo((Object)new SymbolReference((Type)BigintType.BIGINT, "a3"));
    }

    @Test
    public void testConstantEqualities() {
        EqualityInference inference = new EqualityInference(new Expression[]{TestEqualityInference.equals("a1", "b1"), TestEqualityInference.equals("b1", "c1"), TestEqualityInference.equals((Expression)new SymbolReference((Type)BigintType.BIGINT, "c1"), (Expression)TestEqualityInference.number(1L))});
        Assertions.assertThat((Object)inference.rewrite((Expression)new SymbolReference((Type)BigintType.BIGINT, "a1"), TestEqualityInference.symbols("a1", "b1"))).isEqualTo((Object)TestEqualityInference.number(1L));
        EqualityInference.EqualityPartition equalityPartition = inference.generateEqualitiesPartitionedBy(TestEqualityInference.symbols("a1", "b1"));
        Assertions.assertThat(TestEqualityInference.equalitiesAsSets(equalityPartition.getScopeEqualities())).isEqualTo(TestEqualityInference.set(TestEqualityInference.set(new SymbolReference((Type)BigintType.BIGINT, "a1"), TestEqualityInference.number(1L)), TestEqualityInference.set(new SymbolReference((Type)BigintType.BIGINT, "b1"), TestEqualityInference.number(1L))));
        Assertions.assertThat(TestEqualityInference.equalitiesAsSets(equalityPartition.getScopeComplementEqualities())).isEqualTo(TestEqualityInference.set(TestEqualityInference.set(new SymbolReference((Type)BigintType.BIGINT, "c1"), TestEqualityInference.number(1L))));
        Assertions.assertThat((boolean)equalityPartition.getScopeStraddlingEqualities().isEmpty()).isTrue();
    }

    @Test
    public void testEqualityGeneration() {
        EqualityInference inference = new EqualityInference(new Expression[]{TestEqualityInference.equals((Expression)new SymbolReference((Type)BigintType.BIGINT, "a1"), TestEqualityInference.add("b", "c")), TestEqualityInference.equals((Expression)new SymbolReference((Type)BigintType.BIGINT, "e1"), TestEqualityInference.add("b", "d")), TestEqualityInference.equals("c", "d")});
        Expression scopedCanonical = inference.getScopedCanonical((Expression)new SymbolReference((Type)BigintType.BIGINT, "e1"), TestEqualityInference.symbolBeginsWith("a"));
        Assertions.assertThat((Object)scopedCanonical).isEqualTo((Object)new SymbolReference((Type)BigintType.BIGINT, "a1"));
    }

    @Test
    public void testExpressionsThatMayReturnNullOnNonNullInput() {
        ImmutableList candidates = ImmutableList.of((Object)new Cast((Expression)new SymbolReference((Type)BigintType.BIGINT, "b"), (Type)BigintType.BIGINT, true), (Object)this.functionResolution.functionCallBuilder("$internal$try").addArgument((Type)new FunctionType((List)ImmutableList.of(), (Type)VarcharType.VARCHAR), (Expression)new LambdaExpression((List)ImmutableList.of(), (Expression)new SymbolReference((Type)BigintType.BIGINT, "b"))).build(), (Object)new NullIfExpression((Expression)new SymbolReference((Type)BigintType.BIGINT, "b"), (Expression)TestEqualityInference.number(1L)), (Object)new InPredicate((Expression)new SymbolReference((Type)BigintType.BIGINT, "b"), (List)ImmutableList.of((Object)new Constant((Type)UnknownType.UNKNOWN, null))), (Object)new SearchedCaseExpression((List)ImmutableList.of((Object)new WhenClause((Expression)new NotExpression((Expression)new IsNullPredicate((Expression)new SymbolReference((Type)BigintType.BIGINT, "b"))), (Expression)new Constant((Type)UnknownType.UNKNOWN, null))), Optional.empty()), (Object)new SimpleCaseExpression((Expression)new SymbolReference((Type)BigintType.BIGINT, "b"), (List)ImmutableList.of((Object)new WhenClause((Expression)TestEqualityInference.number(1L), (Expression)new Constant((Type)UnknownType.UNKNOWN, null))), Optional.empty()));
        for (Expression candidate : candidates) {
            EqualityInference inference = new EqualityInference(new Expression[]{TestEqualityInference.equals((Expression)new SymbolReference((Type)BigintType.BIGINT, "b"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "x")), TestEqualityInference.equals((Expression)new SymbolReference((Type)BigintType.BIGINT, "a"), candidate)});
            List equalities = inference.generateEqualitiesPartitionedBy(TestEqualityInference.symbols("b")).getScopeStraddlingEqualities();
            Assertions.assertThat((int)equalities.size()).isEqualTo(1);
            Assertions.assertThat((((Expression)equalities.get(0)).equals((Object)TestEqualityInference.equals((Expression)new SymbolReference((Type)BigintType.BIGINT, "x"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "b"))) || ((Expression)equalities.get(0)).equals((Object)TestEqualityInference.equals((Expression)new SymbolReference((Type)BigintType.BIGINT, "b"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "x"))) ? 1 : 0) != 0).isTrue();
        }
    }

    private static Predicate<Expression> matchesSymbolScope(Predicate<Symbol> symbolScope) {
        return expression -> Iterables.all((Iterable)SymbolsExtractor.extractUnique((Expression)expression), (Predicate)symbolScope);
    }

    private static Predicate<Expression> matchesStraddlingScope(Predicate<Symbol> symbolScope) {
        return expression -> {
            Set symbols = SymbolsExtractor.extractUnique((Expression)expression);
            return Iterables.any((Iterable)symbols, (Predicate)symbolScope) && Iterables.any((Iterable)symbols, (Predicate)Predicates.not((Predicate)symbolScope));
        };
    }

    private static Expression someExpression(String symbol1, String symbol2) {
        return TestEqualityInference.someExpression((Expression)new SymbolReference((Type)BigintType.BIGINT, symbol1), (Expression)new SymbolReference((Type)BigintType.BIGINT, symbol2));
    }

    private static Expression someExpression(Expression expression1, Expression expression2) {
        return new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, expression1, expression2);
    }

    private static Expression add(String symbol1, String symbol2) {
        return TestEqualityInference.add((Expression)new SymbolReference((Type)BigintType.BIGINT, symbol1), (Expression)new SymbolReference((Type)BigintType.BIGINT, symbol2));
    }

    private static Expression add(Expression expression1, Expression expression2) {
        return new ArithmeticBinaryExpression(ADD_BIGINT, ArithmeticBinaryExpression.Operator.ADD, expression1, expression2);
    }

    private static Expression multiply(Expression expression1, Expression expression2) {
        return new ArithmeticBinaryExpression(MULTIPLY_BIGINT, ArithmeticBinaryExpression.Operator.MULTIPLY, expression1, expression2);
    }

    private static Expression equals(String symbol1, String symbol2) {
        return TestEqualityInference.equals((Expression)new SymbolReference((Type)BigintType.BIGINT, symbol1), (Expression)new SymbolReference((Type)BigintType.BIGINT, symbol2));
    }

    private static Expression equals(Expression expression1, Expression expression2) {
        return new ComparisonExpression(ComparisonExpression.Operator.EQUAL, expression1, expression2);
    }

    private static Constant number(long number) {
        if (number >= Integer.MIN_VALUE && number < Integer.MAX_VALUE) {
            return new Constant((Type)IntegerType.INTEGER, (Object)number);
        }
        return new Constant((Type)BigintType.BIGINT, (Object)number);
    }

    private static Set<Symbol> symbols(String ... symbols) {
        return (Set)Arrays.stream(symbols).map(name -> new Symbol((Type)UnknownType.UNKNOWN, name)).collect(ImmutableSet.toImmutableSet());
    }

    private static Predicate<Symbol> matchesSymbols(String ... symbols) {
        return TestEqualityInference.matchesSymbols(Arrays.asList(symbols));
    }

    private static Predicate<Symbol> matchesSymbols(Collection<String> symbols) {
        Set symbolSet = (Set)symbols.stream().map(name -> new Symbol((Type)UnknownType.UNKNOWN, name)).collect(ImmutableSet.toImmutableSet());
        return Predicates.in((Collection)symbolSet);
    }

    private static Predicate<Symbol> symbolBeginsWith(String ... prefixes) {
        return TestEqualityInference.symbolBeginsWith(Arrays.asList(prefixes));
    }

    private static Predicate<Symbol> symbolBeginsWith(Iterable<String> prefixes) {
        return symbol -> {
            for (String prefix : prefixes) {
                if (!symbol.getName().startsWith(prefix)) continue;
                return true;
            }
            return false;
        };
    }

    private static Set<Set<Expression>> equalitiesAsSets(Iterable<Expression> expressions) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Expression expression : expressions) {
            builder.add(TestEqualityInference.equalityAsSet(expression));
        }
        return builder.build();
    }

    private static Set<Expression> equalityAsSet(Expression expression) {
        Preconditions.checkArgument((boolean)(expression instanceof ComparisonExpression));
        ComparisonExpression comparisonExpression = (ComparisonExpression)expression;
        Preconditions.checkArgument((comparisonExpression.getOperator() == ComparisonExpression.Operator.EQUAL ? 1 : 0) != 0);
        return ImmutableSet.of((Object)comparisonExpression.getLeft(), (Object)comparisonExpression.getRight());
    }

    @SafeVarargs
    private static <E> Set<E> set(E ... elements) {
        return ImmutableSet.copyOf((Object[])elements);
    }

    private static <E> Set<E> setCopy(Iterable<E> elements) {
        return ImmutableSet.copyOf(elements);
    }
}

