/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.airlift.slice.Slices;
import io.trino.execution.querystats.PlanOptimizersStatsCollector;
import io.trino.execution.warnings.WarningCollector;
import io.trino.json.ir.IrJsonPath;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.operator.table.json.JsonTable;
import io.trino.operator.table.json.JsonTablePlanCross;
import io.trino.operator.table.json.JsonTablePlanLeaf;
import io.trino.operator.table.json.JsonTablePlanNode;
import io.trino.operator.table.json.JsonTablePlanSingle;
import io.trino.operator.table.json.JsonTablePlanUnion;
import io.trino.operator.table.json.JsonTableQueryColumn;
import io.trino.operator.table.json.JsonTableValueColumn;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.analyzer.ExpressionAnalyzer;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.ir.BooleanLiteral;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.FunctionCall;
import io.trino.sql.ir.Row;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.JsonTablePlanComparator;
import io.trino.sql.planner.LogicalPlanner;
import io.trino.sql.planner.PathNodes;
import io.trino.sql.planner.Plan;
import io.trino.sql.planner.assertions.BasePlanTest;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.assertions.TableFunctionMatcher;
import io.trino.sql.planner.optimizations.PlanNodeSearcher;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.TableFunctionNode;
import io.trino.sql.tree.JsonQuery;
import io.trino.sql.tree.JsonValue;
import io.trino.type.Json2016Type;
import io.trino.type.TestJsonPath2016TypeSerialization;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.intellij.lang.annotations.Language;
import org.junit.jupiter.api.Test;

public class TestJsonTable
extends BasePlanTest {
    private static final TestingFunctionResolution FUNCTIONS = new TestingFunctionResolution();
    private static final ResolvedFunction JSON_VALUE_FUNCTION = FUNCTIONS.resolveFunction("$json_value", TypeSignatureProvider.fromTypes((Type[])new Type[]{Json2016Type.JSON_2016, TestJsonPath2016TypeSerialization.JSON_PATH_2016, ExpressionAnalyzer.JSON_NO_PARAMETERS_ROW_TYPE, TinyintType.TINYINT, BigintType.BIGINT, TinyintType.TINYINT, BigintType.BIGINT}));
    private static final ResolvedFunction JSON_QUERY_FUNCTION = FUNCTIONS.resolveFunction("$json_query", TypeSignatureProvider.fromTypes((Type[])new Type[]{Json2016Type.JSON_2016, TestJsonPath2016TypeSerialization.JSON_PATH_2016, ExpressionAnalyzer.JSON_NO_PARAMETERS_ROW_TYPE, TinyintType.TINYINT, TinyintType.TINYINT, TinyintType.TINYINT}));
    private static final ResolvedFunction JSON_TO_VARCHAR = FUNCTIONS.resolveFunction("$json_to_varchar", TypeSignatureProvider.fromTypes((Type[])new Type[]{Json2016Type.JSON_2016, TinyintType.TINYINT, BooleanType.BOOLEAN}));
    private static final ResolvedFunction VARCHAR_TO_JSON = FUNCTIONS.resolveFunction("$varchar_to_json", TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR, BooleanType.BOOLEAN}));

    @Test
    public void testJsonTableInitialPlan() {
        this.assertPlan("SELECT *\nFROM (SELECT '[1, 2, 3]', 4) t(json_col, int_col), JSON_TABLE(\n    json_col,\n    'lax $'  AS root_path PASSING int_col AS id, '[ala]' FORMAT JSON AS name\n    COLUMNS(\n        bigint_col BIGINT DEFAULT 5 ON EMPTY DEFAULT int_col ON ERROR,\n        varchar_col VARCHAR FORMAT JSON ERROR ON ERROR)\n    EMPTY ON ERROR)\n", LogicalPlanner.Stage.CREATED, PlanMatchPattern.strictOutput((List<String>)ImmutableList.of((Object)"json_col", (Object)"int_col", (Object)"bigint_col", (Object)"formatted_varchar_col"), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"formatted_varchar_col", (Object)PlanMatchPattern.expression((Expression)new FunctionCall(JSON_TO_VARCHAR, (List)ImmutableList.of((Object)new SymbolReference((Type)VarcharType.VARCHAR, "varchar_col"), (Object)new Constant((Type)TinyintType.TINYINT, (Object)1L), (Object)BooleanLiteral.FALSE_LITERAL)))), PlanMatchPattern.tableFunction(builder -> builder.name("$json_table").addTableArgument("$input", TableFunctionMatcher.TableArgumentValue.Builder.tableArgument(0).rowSemantics().passThroughColumns().passThroughSymbols((Set<String>)ImmutableSet.of((Object)"json_col", (Object)"int_col"))).properOutputs((List<String>)ImmutableList.of((Object)"bigint_col", (Object)"varchar_col")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"context_item", (Object)PlanMatchPattern.expression((Expression)new FunctionCall(VARCHAR_TO_JSON, (List)ImmutableList.of((Object)new SymbolReference((Type)VarcharType.VARCHAR, "json_col_coerced"), (Object)BooleanLiteral.FALSE_LITERAL))), (Object)"parameters_row", (Object)PlanMatchPattern.expression((Expression)new Cast((Expression)new Row((List)ImmutableList.of((Object)new SymbolReference((Type)IntegerType.INTEGER, "int_col"), (Object)new FunctionCall(VARCHAR_TO_JSON, (List)ImmutableList.of((Object)new SymbolReference((Type)VarcharType.VARCHAR, "name_coerced"), (Object)BooleanLiteral.FALSE_LITERAL)))), (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"id", (Type)IntegerType.INTEGER), RowType.field((String)"name", (Type)Json2016Type.JSON_2016)})))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"name_coerced", (Object)PlanMatchPattern.expression((Expression)new Cast((Expression)new SymbolReference((Type)VarcharType.createVarcharType((int)5), "name"), (Type)VarcharType.VARCHAR)), (Object)"default_value_coerced", (Object)PlanMatchPattern.expression((Expression)new Cast((Expression)new SymbolReference((Type)IntegerType.INTEGER, "default_value"), (Type)BigintType.BIGINT)), (Object)"json_col_coerced", (Object)PlanMatchPattern.expression((Expression)new Cast((Expression)new SymbolReference((Type)VarcharType.createVarcharType((int)9), "json_col"), (Type)VarcharType.VARCHAR)), (Object)"int_col_coerced", (Object)PlanMatchPattern.expression((Expression)new Cast((Expression)new SymbolReference((Type)IntegerType.INTEGER, "int_col"), (Type)BigintType.BIGINT))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"name", (Object)PlanMatchPattern.expression((Expression)new Constant((Type)VarcharType.createVarcharType((int)5), (Object)Slices.utf8Slice((String)"[ala]"))), (Object)"default_value", (Object)PlanMatchPattern.expression((Expression)new Constant((Type)IntegerType.INTEGER, (Object)5L))), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"json_col", (Object)PlanMatchPattern.expression((Expression)new Constant((Type)VarcharType.createVarcharType((int)9), (Object)Slices.utf8Slice((String)"[1, 2, 3]"))), (Object)"int_col", (Object)PlanMatchPattern.expression((Expression)new Constant((Type)IntegerType.INTEGER, (Object)4L))), PlanMatchPattern.values(1)))))))))));
    }

    @Test
    public void testImplicitColumnPath() {
        this.assertJsonTablePlan("SELECT *\nFROM (SELECT 1, 2, 3), JSON_TABLE(\n    '[1, 2, 3]',\n    'lax $' AS root_path\n    COLUMNS(\n        first_col BIGINT,\n        \"Second_Col\" BIGINT,\n        \"_\"\"_'_?_\" BIGINT))\n", (JsonTablePlanNode)new JsonTablePlanLeaf(new IrJsonPath(true, PathNodes.contextVariable()), (List)ImmutableList.of((Object)TestJsonTable.valueColumn(0, new IrJsonPath(true, PathNodes.memberAccessor(PathNodes.contextVariable(), "FIRST_COL"))), (Object)TestJsonTable.valueColumn(1, new IrJsonPath(true, PathNodes.memberAccessor(PathNodes.contextVariable(), "Second_Col"))), (Object)TestJsonTable.valueColumn(2, new IrJsonPath(true, PathNodes.memberAccessor(PathNodes.contextVariable(), "_\"_'_?_"))))));
    }

    @Test
    public void testExplicitColumnPath() {
        this.assertJsonTablePlan("SELECT *\nFROM (SELECT 1, 2, 3), JSON_TABLE(\n    '[1, 2, 3]',\n    'lax $' AS root_path\n    COLUMNS(\n        first_col BIGINT PATH 'lax $.a',\n        \"Second_Col\" BIGINT PATH 'lax $.B',\n        \"_\"\"_'_?_\" BIGINT PATH 'lax false'))\n", (JsonTablePlanNode)new JsonTablePlanLeaf(new IrJsonPath(true, PathNodes.contextVariable()), (List)ImmutableList.of((Object)TestJsonTable.valueColumn(0, new IrJsonPath(true, PathNodes.memberAccessor(PathNodes.contextVariable(), "a"))), (Object)TestJsonTable.valueColumn(1, new IrJsonPath(true, PathNodes.memberAccessor(PathNodes.contextVariable(), "B"))), (Object)TestJsonTable.valueColumn(2, new IrJsonPath(true, PathNodes.literal((Type)BooleanType.BOOLEAN, false))))));
    }

    @Test
    public void testColumnOutputIndex() {
        this.assertJsonTablePlan("SELECT *\nFROM (SELECT 1, 2, 3), JSON_TABLE(\n    '[1, 2, 3]',\n    'lax $' AS root_path\n    COLUMNS(\n        a BIGINT,\n        NESTED PATH 'lax $.x' COLUMNS(\n            b BIGINT,\n            NESTED PATH 'lax $.y' COLUMNS(\n                c BIGINT)),\n        d BIGINT))\n", (JsonTablePlanNode)new JsonTablePlanSingle(new IrJsonPath(true, PathNodes.contextVariable()), (List)ImmutableList.of((Object)TestJsonTable.valueColumn(0, new IrJsonPath(true, PathNodes.memberAccessor(PathNodes.contextVariable(), "A"))), (Object)TestJsonTable.valueColumn(3, new IrJsonPath(true, PathNodes.memberAccessor(PathNodes.contextVariable(), "D")))), true, (JsonTablePlanNode)new JsonTablePlanSingle(new IrJsonPath(true, PathNodes.memberAccessor(PathNodes.contextVariable(), "x")), (List)ImmutableList.of((Object)TestJsonTable.valueColumn(1, new IrJsonPath(true, PathNodes.memberAccessor(PathNodes.contextVariable(), "B")))), true, (JsonTablePlanNode)new JsonTablePlanLeaf(new IrJsonPath(true, PathNodes.memberAccessor(PathNodes.contextVariable(), "y")), (List)ImmutableList.of((Object)TestJsonTable.valueColumn(2, new IrJsonPath(true, PathNodes.memberAccessor(PathNodes.contextVariable(), "C"))))))));
    }

    @Test
    public void testColumnBehavior() {
        this.assertJsonTablePlan("SELECT *\nFROM (SELECT 1, 2, 3), JSON_TABLE(\n    '[1, 2, 3]',\n    'lax $' AS root_path\n    COLUMNS(\n        a BIGINT,\n        b BIGINT NULL ON EMPTY ERROR ON ERROR,\n        c BIGINT DEFAULT 1 ON EMPTY DEFAULT 2 ON ERROR,\n        d VARCHAR FORMAT JSON,\n        e VARCHAR FORMAT JSON WITH CONDITIONAL ARRAY WRAPPER NULL ON EMPTY ERROR ON ERROR,\n        f VARCHAR FORMAT JSON OMIT QUOTES EMPTY ARRAY ON EMPTY EMPTY OBJECT ON ERROR))\n", (JsonTablePlanNode)new JsonTablePlanLeaf(new IrJsonPath(true, PathNodes.contextVariable()), (List)ImmutableList.of((Object)TestJsonTable.valueColumn(0, new IrJsonPath(true, PathNodes.memberAccessor(PathNodes.contextVariable(), "A")), JsonValue.EmptyOrErrorBehavior.NULL, -1, JsonValue.EmptyOrErrorBehavior.NULL, -1), (Object)TestJsonTable.valueColumn(1, new IrJsonPath(true, PathNodes.memberAccessor(PathNodes.contextVariable(), "B")), JsonValue.EmptyOrErrorBehavior.NULL, -1, JsonValue.EmptyOrErrorBehavior.ERROR, -1), (Object)TestJsonTable.valueColumn(2, new IrJsonPath(true, PathNodes.memberAccessor(PathNodes.contextVariable(), "C")), JsonValue.EmptyOrErrorBehavior.DEFAULT, 2, JsonValue.EmptyOrErrorBehavior.DEFAULT, 3), (Object)TestJsonTable.queryColumn(3, new IrJsonPath(true, PathNodes.memberAccessor(PathNodes.contextVariable(), "D")), JsonQuery.ArrayWrapperBehavior.WITHOUT, JsonQuery.EmptyOrErrorBehavior.NULL, JsonQuery.EmptyOrErrorBehavior.NULL), (Object)TestJsonTable.queryColumn(4, new IrJsonPath(true, PathNodes.memberAccessor(PathNodes.contextVariable(), "E")), JsonQuery.ArrayWrapperBehavior.CONDITIONAL, JsonQuery.EmptyOrErrorBehavior.NULL, JsonQuery.EmptyOrErrorBehavior.ERROR), (Object)TestJsonTable.queryColumn(5, new IrJsonPath(true, PathNodes.memberAccessor(PathNodes.contextVariable(), "F")), JsonQuery.ArrayWrapperBehavior.WITHOUT, JsonQuery.EmptyOrErrorBehavior.EMPTY_ARRAY, JsonQuery.EmptyOrErrorBehavior.EMPTY_OBJECT))));
    }

    @Test
    public void testInheritedErrorBehavior() {
        this.assertJsonTablePlan("SELECT *\nFROM (SELECT 1, 2, 3), JSON_TABLE(\n    '[1, 2, 3]',\n    'lax $' AS root_path\n    COLUMNS(\n        a BIGINT))\n", (JsonTablePlanNode)new JsonTablePlanLeaf(new IrJsonPath(true, PathNodes.contextVariable()), (List)ImmutableList.of((Object)TestJsonTable.valueColumn(0, new IrJsonPath(true, PathNodes.memberAccessor(PathNodes.contextVariable(), "A")), JsonValue.EmptyOrErrorBehavior.NULL, -1, JsonValue.EmptyOrErrorBehavior.NULL, -1))));
        this.assertJsonTablePlan("SELECT *\nFROM (SELECT 1, 2, 3), JSON_TABLE(\n    '[1, 2, 3]',\n    'lax $' AS root_path\n    COLUMNS(\n        a BIGINT)\n    ERROR ON ERROR)\n", (JsonTablePlanNode)new JsonTablePlanLeaf(new IrJsonPath(true, PathNodes.contextVariable()), (List)ImmutableList.of((Object)TestJsonTable.valueColumn(0, new IrJsonPath(true, PathNodes.memberAccessor(PathNodes.contextVariable(), "A")), JsonValue.EmptyOrErrorBehavior.NULL, -1, JsonValue.EmptyOrErrorBehavior.ERROR, -1))));
        this.assertJsonTablePlan("SELECT *\nFROM (SELECT 1, 2, 3), JSON_TABLE(\n    '[1, 2, 3]',\n    'lax $' AS root_path\n    COLUMNS(\n        a BIGINT)\n    EMPTY ON ERROR)\n", (JsonTablePlanNode)new JsonTablePlanLeaf(new IrJsonPath(true, PathNodes.contextVariable()), (List)ImmutableList.of((Object)TestJsonTable.valueColumn(0, new IrJsonPath(true, PathNodes.memberAccessor(PathNodes.contextVariable(), "A")), JsonValue.EmptyOrErrorBehavior.NULL, -1, JsonValue.EmptyOrErrorBehavior.NULL, -1))));
        this.assertJsonTablePlan("SELECT *\nFROM (SELECT 1, 2, 3), JSON_TABLE(\n    '[1, 2, 3]',\n    'lax $' AS root_path\n    COLUMNS(\n        a BIGINT NULL ON ERROR)\n    ERROR ON ERROR)\n", (JsonTablePlanNode)new JsonTablePlanLeaf(new IrJsonPath(true, PathNodes.contextVariable()), (List)ImmutableList.of((Object)TestJsonTable.valueColumn(0, new IrJsonPath(true, PathNodes.memberAccessor(PathNodes.contextVariable(), "A")), JsonValue.EmptyOrErrorBehavior.NULL, -1, JsonValue.EmptyOrErrorBehavior.NULL, -1))));
    }

    @Test
    public void testImplicitDefaultPlan() {
        this.assertJsonTablePlan("SELECT *\nFROM (SELECT 1, 2, 3), JSON_TABLE(\n    '[1, 2, 3]',\n    'lax $' AS root_path\n    COLUMNS(\n        NESTED PATH 'lax $.a' COLUMNS(col_1 BIGINT),\n        NESTED PATH 'lax $.b' COLUMNS(\n            NESTED PATH 'lax $.c' COLUMNS(col_2 BIGINT),\n            NESTED PATH 'lax $.d' COLUMNS(col_3 BIGINT)),\n        NESTED PATH 'lax $.e' COLUMNS(col_4 BIGINT)))\n", (JsonTablePlanNode)new JsonTablePlanSingle(new IrJsonPath(true, PathNodes.contextVariable()), (List)ImmutableList.of(), true, (JsonTablePlanNode)new JsonTablePlanUnion((List)ImmutableList.of((Object)new JsonTablePlanLeaf(new IrJsonPath(true, PathNodes.memberAccessor(PathNodes.contextVariable(), "a")), (List)ImmutableList.of((Object)TestJsonTable.valueColumn(0, new IrJsonPath(true, PathNodes.memberAccessor(PathNodes.contextVariable(), "COL_1"))))), (Object)new JsonTablePlanSingle(new IrJsonPath(true, PathNodes.memberAccessor(PathNodes.contextVariable(), "b")), (List)ImmutableList.of(), true, (JsonTablePlanNode)new JsonTablePlanUnion((List)ImmutableList.of((Object)new JsonTablePlanLeaf(new IrJsonPath(true, PathNodes.memberAccessor(PathNodes.contextVariable(), "c")), (List)ImmutableList.of((Object)TestJsonTable.valueColumn(1, new IrJsonPath(true, PathNodes.memberAccessor(PathNodes.contextVariable(), "COL_2"))))), (Object)new JsonTablePlanLeaf(new IrJsonPath(true, PathNodes.memberAccessor(PathNodes.contextVariable(), "d")), (List)ImmutableList.of((Object)TestJsonTable.valueColumn(2, new IrJsonPath(true, PathNodes.memberAccessor(PathNodes.contextVariable(), "COL_3")))))))), (Object)new JsonTablePlanLeaf(new IrJsonPath(true, PathNodes.memberAccessor(PathNodes.contextVariable(), "e")), (List)ImmutableList.of((Object)TestJsonTable.valueColumn(3, new IrJsonPath(true, PathNodes.memberAccessor(PathNodes.contextVariable(), "COL_4")))))))));
    }

    @Test
    public void testExplicitDefaultPlan() {
        this.assertJsonTablePlan("SELECT *\nFROM (SELECT 1, 2, 3), JSON_TABLE(\n    '[1, 2, 3]',\n    'lax $' AS root_path\n    COLUMNS(\n        NESTED PATH 'lax $.a' AS a COLUMNS(col_1 BIGINT),\n        NESTED PATH 'lax $.b' AS b COLUMNS(\n            NESTED PATH 'lax $.c' AS c COLUMNS(col_2 BIGINT),\n            NESTED PATH 'lax $.d' AS d COLUMNS(col_3 BIGINT)),\n        NESTED PATH 'lax $.e' AS e COLUMNS(col_4 BIGINT))\n    PLAN DEFAULT (INNER, CROSS))\n", (JsonTablePlanNode)new JsonTablePlanSingle(new IrJsonPath(true, PathNodes.contextVariable()), (List)ImmutableList.of(), false, (JsonTablePlanNode)new JsonTablePlanCross((List)ImmutableList.of((Object)new JsonTablePlanLeaf(new IrJsonPath(true, PathNodes.memberAccessor(PathNodes.contextVariable(), "a")), (List)ImmutableList.of((Object)TestJsonTable.valueColumn(0, new IrJsonPath(true, PathNodes.memberAccessor(PathNodes.contextVariable(), "COL_1"))))), (Object)new JsonTablePlanSingle(new IrJsonPath(true, PathNodes.memberAccessor(PathNodes.contextVariable(), "b")), (List)ImmutableList.of(), false, (JsonTablePlanNode)new JsonTablePlanCross((List)ImmutableList.of((Object)new JsonTablePlanLeaf(new IrJsonPath(true, PathNodes.memberAccessor(PathNodes.contextVariable(), "c")), (List)ImmutableList.of((Object)TestJsonTable.valueColumn(1, new IrJsonPath(true, PathNodes.memberAccessor(PathNodes.contextVariable(), "COL_2"))))), (Object)new JsonTablePlanLeaf(new IrJsonPath(true, PathNodes.memberAccessor(PathNodes.contextVariable(), "d")), (List)ImmutableList.of((Object)TestJsonTable.valueColumn(2, new IrJsonPath(true, PathNodes.memberAccessor(PathNodes.contextVariable(), "COL_3")))))))), (Object)new JsonTablePlanLeaf(new IrJsonPath(true, PathNodes.memberAccessor(PathNodes.contextVariable(), "e")), (List)ImmutableList.of((Object)TestJsonTable.valueColumn(3, new IrJsonPath(true, PathNodes.memberAccessor(PathNodes.contextVariable(), "COL_4")))))))));
        this.assertJsonTablePlan("SELECT *\nFROM (SELECT 1, 2, 3), JSON_TABLE(\n    '[1, 2, 3]',\n    'lax $' AS root_path\n    COLUMNS(\n        NESTED PATH 'lax $.a' AS a COLUMNS(col_1 BIGINT),\n        NESTED PATH 'lax $.b' AS b COLUMNS(\n            NESTED PATH 'lax $.c' AS c COLUMNS(col_2 BIGINT),\n            NESTED PATH 'lax $.d' AS d COLUMNS(col_3 BIGINT)),\n        NESTED PATH 'lax $.e' AS e COLUMNS(col_4 BIGINT))\n    PLAN DEFAULT (CROSS))\n", (JsonTablePlanNode)new JsonTablePlanSingle(new IrJsonPath(true, PathNodes.contextVariable()), (List)ImmutableList.of(), true, (JsonTablePlanNode)new JsonTablePlanCross((List)ImmutableList.of((Object)new JsonTablePlanLeaf(new IrJsonPath(true, PathNodes.memberAccessor(PathNodes.contextVariable(), "a")), (List)ImmutableList.of((Object)TestJsonTable.valueColumn(0, new IrJsonPath(true, PathNodes.memberAccessor(PathNodes.contextVariable(), "COL_1"))))), (Object)new JsonTablePlanSingle(new IrJsonPath(true, PathNodes.memberAccessor(PathNodes.contextVariable(), "b")), (List)ImmutableList.of(), true, (JsonTablePlanNode)new JsonTablePlanCross((List)ImmutableList.of((Object)new JsonTablePlanLeaf(new IrJsonPath(true, PathNodes.memberAccessor(PathNodes.contextVariable(), "c")), (List)ImmutableList.of((Object)TestJsonTable.valueColumn(1, new IrJsonPath(true, PathNodes.memberAccessor(PathNodes.contextVariable(), "COL_2"))))), (Object)new JsonTablePlanLeaf(new IrJsonPath(true, PathNodes.memberAccessor(PathNodes.contextVariable(), "d")), (List)ImmutableList.of((Object)TestJsonTable.valueColumn(2, new IrJsonPath(true, PathNodes.memberAccessor(PathNodes.contextVariable(), "COL_3")))))))), (Object)new JsonTablePlanLeaf(new IrJsonPath(true, PathNodes.memberAccessor(PathNodes.contextVariable(), "e")), (List)ImmutableList.of((Object)TestJsonTable.valueColumn(3, new IrJsonPath(true, PathNodes.memberAccessor(PathNodes.contextVariable(), "COL_4")))))))));
    }

    @Test
    public void testSpecificPlan() {
        this.assertJsonTablePlan("SELECT *\nFROM (SELECT 1, 2, 3), JSON_TABLE(\n    '[1, 2, 3]',\n    'lax $' AS root_path\n    COLUMNS(\n        NESTED PATH 'lax $.a' AS a COLUMNS(col_1 BIGINT),\n        NESTED PATH 'lax $.b' AS b COLUMNS(\n            NESTED PATH 'lax $.c' AS c COLUMNS(col_2 BIGINT),\n            NESTED PATH 'lax $.d' AS d COLUMNS(col_3 BIGINT)),\n        NESTED PATH 'lax $.e' AS e COLUMNS(col_4 BIGINT))\n    PLAN (ROOT_PATH INNER (((B OUTER (D CROSS C)) UNION E) CROSS A)))\n", (JsonTablePlanNode)new JsonTablePlanSingle(new IrJsonPath(true, PathNodes.contextVariable()), (List)ImmutableList.of(), false, (JsonTablePlanNode)new JsonTablePlanCross((List)ImmutableList.of((Object)new JsonTablePlanUnion((List)ImmutableList.of((Object)new JsonTablePlanSingle(new IrJsonPath(true, PathNodes.memberAccessor(PathNodes.contextVariable(), "b")), (List)ImmutableList.of(), true, (JsonTablePlanNode)new JsonTablePlanCross((List)ImmutableList.of((Object)new JsonTablePlanLeaf(new IrJsonPath(true, PathNodes.memberAccessor(PathNodes.contextVariable(), "d")), (List)ImmutableList.of((Object)TestJsonTable.valueColumn(2, new IrJsonPath(true, PathNodes.memberAccessor(PathNodes.contextVariable(), "COL_3"))))), (Object)new JsonTablePlanLeaf(new IrJsonPath(true, PathNodes.memberAccessor(PathNodes.contextVariable(), "c")), (List)ImmutableList.of((Object)TestJsonTable.valueColumn(1, new IrJsonPath(true, PathNodes.memberAccessor(PathNodes.contextVariable(), "COL_2")))))))), (Object)new JsonTablePlanLeaf(new IrJsonPath(true, PathNodes.memberAccessor(PathNodes.contextVariable(), "e")), (List)ImmutableList.of((Object)TestJsonTable.valueColumn(3, new IrJsonPath(true, PathNodes.memberAccessor(PathNodes.contextVariable(), "COL_4"))))))), (Object)new JsonTablePlanLeaf(new IrJsonPath(true, PathNodes.memberAccessor(PathNodes.contextVariable(), "a")), (List)ImmutableList.of((Object)TestJsonTable.valueColumn(0, new IrJsonPath(true, PathNodes.memberAccessor(PathNodes.contextVariable(), "COL_1")))))))));
    }

    private static JsonTableValueColumn valueColumn(int outputIndex, IrJsonPath path) {
        return TestJsonTable.valueColumn(outputIndex, path, JsonValue.EmptyOrErrorBehavior.NULL, -1, JsonValue.EmptyOrErrorBehavior.NULL, -1);
    }

    private static JsonTableValueColumn valueColumn(int outputIndex, IrJsonPath path, JsonValue.EmptyOrErrorBehavior emptyBehavior, int emptyDefaultInput, JsonValue.EmptyOrErrorBehavior errorBehavior, int errorDefaultInput) {
        return new JsonTableValueColumn(outputIndex, JSON_VALUE_FUNCTION, path, (long)emptyBehavior.ordinal(), emptyDefaultInput, (long)errorBehavior.ordinal(), errorDefaultInput);
    }

    private static JsonTableQueryColumn queryColumn(int outputIndex, IrJsonPath path, JsonQuery.ArrayWrapperBehavior wrapperBehavior, JsonQuery.EmptyOrErrorBehavior emptyBehavior, JsonQuery.EmptyOrErrorBehavior errorBehavior) {
        return new JsonTableQueryColumn(outputIndex, JSON_QUERY_FUNCTION, path, (long)wrapperBehavior.ordinal(), (long)emptyBehavior.ordinal(), (long)errorBehavior.ordinal());
    }

    private void assertJsonTablePlan(@Language(value="SQL") String sql, JsonTablePlanNode expectedPlan) {
        try {
            this.getPlanTester().inTransaction(transactionSession -> {
                Plan queryPlan = this.getPlanTester().createPlan(transactionSession, sql, (List)ImmutableList.of(), LogicalPlanner.Stage.CREATED, WarningCollector.NOOP, PlanOptimizersStatsCollector.createPlanOptimizersStatsCollector());
                TableFunctionNode tableFunctionNode = (TableFunctionNode)Iterables.getOnlyElement((Iterable)PlanNodeSearcher.searchFrom((PlanNode)queryPlan.getRoot()).where(TableFunctionNode.class::isInstance).findAll());
                JsonTablePlanNode actualPlan = ((JsonTable.JsonTableFunctionHandle)tableFunctionNode.getHandle().getFunctionHandle()).processingPlan();
                ((ObjectAssert)Assertions.assertThat((Object)actualPlan).usingComparator(JsonTablePlanComparator.planComparator())).isEqualTo((Object)expectedPlan);
                return null;
            });
        }
        catch (Throwable e) {
            e.addSuppressed(new Exception("Query: " + sql));
            throw e;
        }
    }
}

