/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.collect.ImmutableMap;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.NotExpression;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.assertions.BasePlanTest;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.JoinType;
import io.trino.sql.planner.plan.ValuesNode;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class TestQuantifiedComparison
extends BasePlanTest {
    @Test
    public void testQuantifiedComparisonEqualsAny() {
        String query = "SELECT orderkey, custkey FROM orders WHERE orderkey = ANY (VALUES ROW(CAST(5 as BIGINT)), ROW(CAST(3 as BIGINT)))";
        this.assertPlan(query, PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, builder -> builder.equiCriteria("X", "Y").left(PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"X", (Object)"orderkey")))).right(PlanMatchPattern.anyTree(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"Y", (Object)0)))))));
    }

    @Test
    public void testQuantifiedComparisonNotEqualsAll() {
        String query = "SELECT orderkey, custkey FROM orders WHERE orderkey <> ALL (VALUES ROW(CAST(5 as BIGINT)), ROW(CAST(3 as BIGINT)))";
        this.assertPlan(query, PlanMatchPattern.anyTree(PlanMatchPattern.filter((Expression)new NotExpression((Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "S")), PlanMatchPattern.semiJoin("X", "Y", "S", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"X", (Object)"orderkey")), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"Y", (Object)0))))));
    }

    @Test
    public void testQuantifiedComparisonLessAll() {
        this.assertQuantifiedComparison("SELECT orderkey, custkey FROM orders WHERE orderkey < ALL (VALUES CAST(5 as BIGINT), CAST(3 as BIGINT))");
    }

    @Test
    public void testQuantifiedComparisonGreaterEqualAll() {
        this.assertQuantifiedComparison("SELECT orderkey, custkey FROM orders WHERE orderkey >= ALL (VALUES CAST(5 as BIGINT), CAST(3 as BIGINT))");
    }

    @Test
    public void testQuantifiedComparisonLessSome() {
        this.assertQuantifiedComparison("SELECT orderkey, custkey FROM orders WHERE orderkey < SOME (VALUES CAST(5 as BIGINT), CAST(3 as BIGINT))");
    }

    @Test
    public void testQuantifiedComparisonGreaterEqualAny() {
        this.assertQuantifiedComparison("SELECT orderkey, custkey FROM orders WHERE orderkey >= ANY (VALUES CAST(5 as BIGINT), CAST(3 as BIGINT))");
    }

    @Test
    public void testQuantifiedComparisonEqualAll() {
        this.assertQuantifiedComparison("SELECT orderkey, custkey FROM orders WHERE orderkey = ALL (VALUES CAST(5 as BIGINT), CAST(3 as BIGINT))");
    }

    @Test
    public void testQuantifiedComparisonNotEqualAny() {
        this.assertQuantifiedComparison("SELECT orderkey, custkey FROM orders WHERE orderkey <> SOME (VALUES CAST(5 as BIGINT), CAST(3 as BIGINT))");
    }

    private void assertQuantifiedComparison(String query) {
        this.assertPlan(query, PlanMatchPattern.anyTree(PlanMatchPattern.node(JoinNode.class, PlanMatchPattern.tableScan("orders"), PlanMatchPattern.node(AggregationNode.class, PlanMatchPattern.node(ValuesNode.class, new PlanMatchPattern[0])))));
    }
}

