/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slices;
import io.trino.metadata.MetadataManager;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.ir.BooleanLiteral;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.ComparisonExpression;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.FunctionCall;
import io.trino.sql.ir.IrExpressions;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.LogicalPlanner;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.BasePlanTest;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.plan.FrameBoundType;
import io.trino.sql.planner.plan.WindowFrameType;
import io.trino.sql.planner.plan.WindowNode;
import io.trino.type.UnknownType;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.Test;

public class TestWindowFrameRange
extends BasePlanTest {
    private static final TestingFunctionResolution FUNCTIONS = new TestingFunctionResolution();
    private static final ResolvedFunction FAIL = FUNCTIONS.resolveFunction("fail", TypeSignatureProvider.fromTypes((Type[])new Type[]{IntegerType.INTEGER, VarcharType.VARCHAR}));
    private static final ResolvedFunction ADD_DECIMAL_10_0 = MetadataManager.createTestMetadataManager().resolveOperator(OperatorType.ADD, (List)ImmutableList.of((Object)DecimalType.createDecimalType((int)10, (int)0), (Object)DecimalType.createDecimalType((int)10, (int)0)));
    private static final ResolvedFunction SUBTRACT_DECIMAL_10_0 = MetadataManager.createTestMetadataManager().resolveOperator(OperatorType.SUBTRACT, (List)ImmutableList.of((Object)DecimalType.createDecimalType((int)10, (int)0), (Object)DecimalType.createDecimalType((int)10, (int)0)));
    private static final ResolvedFunction ADD_INTEGER = MetadataManager.createTestMetadataManager().resolveOperator(OperatorType.ADD, (List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER));
    private static final ResolvedFunction SUBTRACT_INTEGER = MetadataManager.createTestMetadataManager().resolveOperator(OperatorType.SUBTRACT, (List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER));

    @Test
    public void testFramePrecedingWithSortKeyCoercions() {
        String sql = "SELECT array_agg(key) OVER(ORDER BY key RANGE x PRECEDING) FROM (VALUES (1, 1.1), (2, 2.2)) t(key, x)";
        PlanMatchPattern pattern = PlanMatchPattern.anyTree(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"key"), (Map<String, SortOrder>)ImmutableMap.of((Object)"key", (Object)SortOrder.ASC_NULLS_LAST))).addFunction("array_agg_result", PlanMatchPattern.windowFunction("array_agg", (List<String>)ImmutableList.of((Object)"key"), new WindowNode.Frame(WindowFrameType.RANGE, FrameBoundType.PRECEDING, Optional.of(new Symbol((Type)UnknownType.UNKNOWN, "frame_start_value")), Optional.of(new Symbol((Type)UnknownType.UNKNOWN, "key_for_frame_start_comparison")), FrameBoundType.CURRENT_ROW, Optional.empty(), Optional.empty()))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"key_for_frame_start_comparison", (Object)PlanMatchPattern.expression((Expression)new Cast((Expression)new SymbolReference((Type)IntegerType.INTEGER, "key"), (Type)DecimalType.createDecimalType((int)12, (int)1)))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"frame_start_value", (Object)PlanMatchPattern.expression((Expression)new FunctionCall(SUBTRACT_DECIMAL_10_0, (List)ImmutableList.of((Object)new SymbolReference((Type)IntegerType.INTEGER, "key_for_frame_start_calculation"), (Object)new SymbolReference((Type)DoubleType.DOUBLE, "x"))))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"key_for_frame_start_calculation", (Object)PlanMatchPattern.expression((Expression)new Cast((Expression)new SymbolReference((Type)IntegerType.INTEGER, "key"), (Type)DecimalType.createDecimalType((int)10, (int)0)))), PlanMatchPattern.filter(IrExpressions.ifExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference((Type)DecimalType.createDecimalType((int)2, (int)1), "x"), (Expression)new Constant((Type)DecimalType.createDecimalType((int)2, (int)1), (Object)0L)), (Expression)BooleanLiteral.TRUE_LITERAL, (Expression)new Cast((Expression)new FunctionCall(FAIL, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)StandardErrorCode.INVALID_WINDOW_FRAME.toErrorCode().getCode()), (Object)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"Window frame offset value must not be negative or null")))), (Type)BooleanType.BOOLEAN)), PlanMatchPattern.anyTree(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"key", (Object)"x"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Object)new Constant((Type)DecimalType.createDecimalType((int)2, (int)1), (Object)Decimals.valueOfShort((BigDecimal)new BigDecimal("1.1")))), (Object)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Object)new Constant((Type)DecimalType.createDecimalType((int)2, (int)1), (Object)Decimals.valueOfShort((BigDecimal)new BigDecimal("2.2")))))))))))));
        this.assertPlan(sql, LogicalPlanner.Stage.CREATED, pattern);
    }

    @Test
    public void testFrameFollowingWithOffsetCoercion() {
        String sql = "SELECT array_agg(key) OVER(ORDER BY key RANGE BETWEEN CURRENT ROW AND x FOLLOWING) FROM (VALUES (1.1, 1), (2.2, 2)) t(key, x)";
        PlanMatchPattern pattern = PlanMatchPattern.anyTree(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"key"), (Map<String, SortOrder>)ImmutableMap.of((Object)"key", (Object)SortOrder.ASC_NULLS_LAST))).addFunction("array_agg_result", PlanMatchPattern.windowFunction("array_agg", (List<String>)ImmutableList.of((Object)"key"), new WindowNode.Frame(WindowFrameType.RANGE, FrameBoundType.CURRENT_ROW, Optional.empty(), Optional.empty(), FrameBoundType.FOLLOWING, Optional.of(new Symbol((Type)UnknownType.UNKNOWN, "frame_end_value")), Optional.of(new Symbol((Type)UnknownType.UNKNOWN, "key_for_frame_end_comparison"))))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"key_for_frame_end_comparison", (Object)PlanMatchPattern.expression((Expression)new Cast((Expression)new SymbolReference((Type)IntegerType.INTEGER, "key"), (Type)DecimalType.createDecimalType((int)12, (int)1)))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"frame_end_value", (Object)PlanMatchPattern.expression((Expression)new FunctionCall(ADD_DECIMAL_10_0, (List)ImmutableList.of((Object)new SymbolReference((Type)IntegerType.INTEGER, "key"), (Object)new SymbolReference((Type)IntegerType.INTEGER, "offset"))))), PlanMatchPattern.filter(IrExpressions.ifExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference((Type)DecimalType.createDecimalType((int)10, (int)0), "offset"), (Expression)new Constant((Type)DecimalType.createDecimalType((int)10, (int)0), (Object)0L)), (Expression)BooleanLiteral.TRUE_LITERAL, (Expression)new Cast((Expression)new FunctionCall(FAIL, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)StandardErrorCode.INVALID_WINDOW_FRAME.toErrorCode().getCode()), (Object)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"Window frame offset value must not be negative or null")))), (Type)BooleanType.BOOLEAN)), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"offset", (Object)PlanMatchPattern.expression((Expression)new Cast((Expression)new SymbolReference((Type)DoubleType.DOUBLE, "x"), (Type)DecimalType.createDecimalType((int)10, (int)0)))), PlanMatchPattern.anyTree(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"key", (Object)"x"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new Constant((Type)DecimalType.createDecimalType((int)2, (int)1), (Object)Decimals.valueOfShort((BigDecimal)new BigDecimal("1.1"))), (Object)new Constant((Type)IntegerType.INTEGER, (Object)1L)), (Object)ImmutableList.of((Object)new Constant((Type)DecimalType.createDecimalType((int)2, (int)1), (Object)Decimals.valueOfShort((BigDecimal)new BigDecimal("2.2"))), (Object)new Constant((Type)IntegerType.INTEGER, (Object)2L)))))))))));
        this.assertPlan(sql, LogicalPlanner.Stage.CREATED, pattern);
    }

    @Test
    public void testFramePrecedingFollowingNoCoercions() {
        String sql = "SELECT array_agg(key) OVER(ORDER BY key RANGE BETWEEN x PRECEDING AND y FOLLOWING) FROM (VALUES (1, 1, 1), (2, 2, 2)) t(key, x, y)";
        PlanMatchPattern pattern = PlanMatchPattern.anyTree(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"key"), (Map<String, SortOrder>)ImmutableMap.of((Object)"key", (Object)SortOrder.ASC_NULLS_LAST))).addFunction("array_agg_result", PlanMatchPattern.windowFunction("array_agg", (List<String>)ImmutableList.of((Object)"key"), new WindowNode.Frame(WindowFrameType.RANGE, FrameBoundType.PRECEDING, Optional.of(new Symbol((Type)UnknownType.UNKNOWN, "frame_start_value")), Optional.of(new Symbol((Type)UnknownType.UNKNOWN, "key")), FrameBoundType.FOLLOWING, Optional.of(new Symbol((Type)UnknownType.UNKNOWN, "frame_end_value")), Optional.of(new Symbol((Type)UnknownType.UNKNOWN, "key"))))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"frame_end_value", (Object)PlanMatchPattern.expression((Expression)new FunctionCall(ADD_INTEGER, (List)ImmutableList.of((Object)new SymbolReference((Type)IntegerType.INTEGER, "key"), (Object)new SymbolReference((Type)IntegerType.INTEGER, "y"))))), PlanMatchPattern.filter(IrExpressions.ifExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "y"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)BooleanLiteral.TRUE_LITERAL, (Expression)new Cast((Expression)new FunctionCall(FAIL, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)StandardErrorCode.INVALID_WINDOW_FRAME.toErrorCode().getCode()), (Object)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"Window frame offset value must not be negative or null")))), (Type)BooleanType.BOOLEAN)), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"frame_start_value", (Object)PlanMatchPattern.expression((Expression)new FunctionCall(SUBTRACT_INTEGER, (List)ImmutableList.of((Object)new SymbolReference((Type)IntegerType.INTEGER, "key"), (Object)new SymbolReference((Type)IntegerType.INTEGER, "x"))))), PlanMatchPattern.filter(IrExpressions.ifExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "x"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), (Expression)BooleanLiteral.TRUE_LITERAL, (Expression)new Cast((Expression)new FunctionCall(FAIL, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)StandardErrorCode.INVALID_WINDOW_FRAME.toErrorCode().getCode()), (Object)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"Window frame offset value must not be negative or null")))), (Type)BooleanType.BOOLEAN)), PlanMatchPattern.anyTree(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"key", (Object)"x", (Object)"y"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)1L)), (Object)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)2L)))))))))));
        this.assertPlan(sql, LogicalPlanner.Stage.CREATED, pattern);
    }
}

