/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.assertions;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.graph.Traverser;
import io.airlift.testing.Closeables;
import io.trino.Session;
import io.trino.client.NodeVersion;
import io.trino.cost.RuntimeInfoProvider;
import io.trino.cost.StaticRuntimeInfoProvider;
import io.trino.execution.querystats.PlanOptimizersStatsCollector;
import io.trino.execution.scheduler.faulttolerant.OutputStatsEstimator;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.FunctionManager;
import io.trino.metadata.Metadata;
import io.trino.plugin.tpch.TpchConnectorFactory;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.sql.planner.LogicalPlanner;
import io.trino.sql.planner.Plan;
import io.trino.sql.planner.PlanFragment;
import io.trino.sql.planner.PlanOptimizers;
import io.trino.sql.planner.RuleStatsRecorder;
import io.trino.sql.planner.SubPlan;
import io.trino.sql.planner.assertions.PlanAssert;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.assertions.SubPlanMatcher;
import io.trino.sql.planner.iterative.IterativeOptimizer;
import io.trino.sql.planner.iterative.rule.RemoveRedundantIdentityProjections;
import io.trino.sql.planner.optimizations.AdaptivePlanOptimizer;
import io.trino.sql.planner.optimizations.PlanOptimizer;
import io.trino.sql.planner.optimizations.UnaliasSymbolReferences;
import io.trino.sql.planner.plan.PlanFragmentId;
import io.trino.sql.planner.planprinter.PlanPrinter;
import io.trino.testing.PlanTester;
import io.trino.testing.TestingSession;
import java.io.Closeable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.intellij.lang.annotations.Language;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class BasePlanTest {
    private final Map<String, String> sessionProperties;
    private PlanTester planTester;

    public BasePlanTest() {
        this((Map<String, String>)ImmutableMap.of());
    }

    public BasePlanTest(Map<String, String> sessionProperties) {
        this.sessionProperties = Objects.requireNonNull(sessionProperties, "sessionProperties is null");
    }

    protected PlanTester createPlanTester() {
        Session.SessionBuilder sessionBuilder = TestingSession.testSessionBuilder().setCatalog("test_catalog").setSchema("tiny").setSystemProperty("task_concurrency", "1");
        this.sessionProperties.forEach((arg_0, arg_1) -> ((Session.SessionBuilder)sessionBuilder).setSystemProperty(arg_0, arg_1));
        PlanTester planTester = PlanTester.create((Session)sessionBuilder.build());
        planTester.createCatalog((String)planTester.getDefaultSession().getCatalog().get(), (ConnectorFactory)new TpchConnectorFactory(1), (Map)ImmutableMap.of());
        return planTester;
    }

    @BeforeAll
    public final void initPlanTest() {
        this.planTester = this.createPlanTester();
    }

    @AfterAll
    public final void destroyPlanTest() {
        Closeables.closeAllRuntimeException((Closeable[])new Closeable[]{this.planTester});
        this.planTester = null;
    }

    protected CatalogHandle getCurrentCatalogHandle() {
        return (CatalogHandle)((Optional)this.planTester.inTransaction(transactionSession -> this.planTester.getPlannerContext().getMetadata().getCatalogHandle(transactionSession, (String)transactionSession.getCatalog().get()))).get();
    }

    protected CatalogHandle getCatalogHandle(String catalogName) {
        return (CatalogHandle)((Optional)this.planTester.inTransaction(transactionSession -> this.planTester.getPlannerContext().getMetadata().getCatalogHandle(transactionSession, catalogName))).get();
    }

    protected PlanTester getPlanTester() {
        return this.planTester;
    }

    protected void assertPlan(@Language(value="SQL") String sql, PlanMatchPattern pattern) {
        this.assertPlan(sql, LogicalPlanner.Stage.OPTIMIZED_AND_VALIDATED, pattern);
    }

    protected void assertPlan(@Language(value="SQL") String sql, Session session, PlanMatchPattern pattern) {
        this.assertPlanWithSession(sql, session, true, pattern);
    }

    protected void assertPlan(@Language(value="SQL") String sql, LogicalPlanner.Stage stage, PlanMatchPattern pattern) {
        List optimizers = this.planTester.getPlanOptimizers(true);
        this.assertPlan(sql, stage, pattern, optimizers);
    }

    protected void assertPlan(@Language(value="SQL") String sql, PlanMatchPattern pattern, List<PlanOptimizer> optimizers) {
        this.assertPlan(sql, LogicalPlanner.Stage.OPTIMIZED, pattern, optimizers);
    }

    protected void assertPlan(@Language(value="SQL") String sql, LogicalPlanner.Stage stage, PlanMatchPattern pattern, Predicate<PlanOptimizer> optimizerPredicate) {
        List<PlanOptimizer> optimizers = this.planTester.getPlanOptimizers(true).stream().filter(optimizerPredicate).collect(Collectors.toList());
        this.assertPlan(sql, stage, pattern, optimizers);
    }

    protected void assertPlan(@Language(value="SQL") String sql, LogicalPlanner.Stage stage, PlanMatchPattern pattern, List<PlanOptimizer> optimizers) {
        try {
            this.planTester.inTransaction(transactionSession -> {
                Plan actualPlan = this.planTester.createPlan(transactionSession, sql, optimizers, stage, WarningCollector.NOOP, PlanOptimizersStatsCollector.createPlanOptimizersStatsCollector());
                PlanAssert.assertPlan(transactionSession, this.planTester.getPlannerContext().getMetadata(), this.planTester.getPlannerContext().getFunctionManager(), this.planTester.getStatsCalculator(), actualPlan, pattern);
                return null;
            });
        }
        catch (Throwable e) {
            e.addSuppressed(new Exception("Query: " + sql));
            throw e;
        }
    }

    protected void assertDistributedPlan(@Language(value="SQL") String sql, PlanMatchPattern pattern) {
        this.assertDistributedPlan(sql, this.getPlanTester().getDefaultSession(), pattern);
    }

    protected void assertDistributedPlan(@Language(value="SQL") String sql, Session session, PlanMatchPattern pattern) {
        this.assertPlanWithSession(sql, session, false, pattern);
    }

    protected void assertMinimallyOptimizedPlan(@Language(value="SQL") String sql, PlanMatchPattern pattern) {
        Metadata metadata = this.getPlanTester().getPlannerContext().getMetadata();
        ImmutableList optimizers = ImmutableList.of((Object)new UnaliasSymbolReferences(), (Object)new IterativeOptimizer(this.planTester.getPlannerContext(), new RuleStatsRecorder(), this.planTester.getStatsCalculator(), this.planTester.getCostCalculator(), (Set)ImmutableSet.builder().add((Object)new RemoveRedundantIdentityProjections()).addAll((Iterable)PlanOptimizers.columnPruningRules((Metadata)metadata)).build()));
        this.assertPlan(sql, LogicalPlanner.Stage.OPTIMIZED, pattern, (List<PlanOptimizer>)optimizers);
    }

    protected void assertPlanWithSession(@Language(value="SQL") String sql, Session session, boolean forceSingleNode, PlanMatchPattern pattern) {
        try {
            this.planTester.inTransaction(session, transactionSession -> {
                Plan actualPlan = this.planTester.createPlan(transactionSession, sql, this.planTester.getPlanOptimizers(forceSingleNode), LogicalPlanner.Stage.OPTIMIZED_AND_VALIDATED, WarningCollector.NOOP, PlanOptimizersStatsCollector.createPlanOptimizersStatsCollector());
                PlanAssert.assertPlan(transactionSession, this.planTester.getPlannerContext().getMetadata(), this.planTester.getPlannerContext().getFunctionManager(), this.planTester.getStatsCalculator(), actualPlan, pattern);
                return null;
            });
        }
        catch (Throwable e) {
            e.addSuppressed(new Exception("Query: " + sql));
            throw e;
        }
    }

    protected void assertPlanWithSession(@Language(value="SQL") String sql, Session session, boolean forceSingleNode, PlanMatchPattern pattern, Consumer<Plan> planValidator) {
        try {
            this.planTester.inTransaction(session, transactionSession -> {
                Plan actualPlan = this.planTester.createPlan(transactionSession, sql, this.planTester.getPlanOptimizers(forceSingleNode), LogicalPlanner.Stage.OPTIMIZED_AND_VALIDATED, WarningCollector.NOOP, PlanOptimizersStatsCollector.createPlanOptimizersStatsCollector());
                PlanAssert.assertPlan(transactionSession, this.planTester.getPlannerContext().getMetadata(), this.planTester.getPlannerContext().getFunctionManager(), this.planTester.getStatsCalculator(), actualPlan, pattern);
                planValidator.accept(actualPlan);
                return null;
            });
        }
        catch (Throwable e) {
            e.addSuppressed(new Exception("Query: " + sql));
            throw e;
        }
    }

    protected Plan plan(@Language(value="SQL") String sql) {
        return this.plan(sql, LogicalPlanner.Stage.OPTIMIZED_AND_VALIDATED);
    }

    protected Plan plan(@Language(value="SQL") String sql, LogicalPlanner.Stage stage) {
        return this.plan(sql, stage, true);
    }

    protected Plan plan(@Language(value="SQL") String sql, LogicalPlanner.Stage stage, boolean forceSingleNode) {
        try {
            return (Plan)this.planTester.inTransaction(this.planTester.getDefaultSession(), transactionSession -> this.planTester.createPlan(transactionSession, sql, this.planTester.getPlanOptimizers(forceSingleNode), stage, WarningCollector.NOOP, PlanOptimizersStatsCollector.createPlanOptimizersStatsCollector()));
        }
        catch (RuntimeException e) {
            throw new AssertionError("Planning failed for SQL: " + sql, e);
        }
    }

    protected SubPlan subplan(@Language(value="SQL") String sql, LogicalPlanner.Stage stage, boolean forceSingleNode) {
        return this.subplan(sql, stage, forceSingleNode, this.getPlanTester().getDefaultSession());
    }

    protected SubPlan subplan(@Language(value="SQL") String sql, LogicalPlanner.Stage stage, boolean forceSingleNode, Session session) {
        try {
            return (SubPlan)this.planTester.inTransaction(session, transactionSession -> {
                Plan plan = this.planTester.createPlan(transactionSession, sql, this.planTester.getPlanOptimizers(forceSingleNode), stage, WarningCollector.NOOP, PlanOptimizersStatsCollector.createPlanOptimizersStatsCollector());
                return this.planTester.createSubPlans(transactionSession, plan, forceSingleNode);
            });
        }
        catch (RuntimeException e) {
            throw new AssertionError("Planning failed for SQL: " + sql, e);
        }
    }

    protected void assertAdaptivePlan(@Language(value="SQL") String sql, Session session, Map<PlanFragmentId, OutputStatsEstimator.OutputStatsEstimateResult> completeStageStats, SubPlanMatcher subPlanMatcher) {
        this.assertAdaptivePlan(sql, session, this.planTester.getAdaptivePlanOptimizers(), completeStageStats, subPlanMatcher);
    }

    protected void assertAdaptivePlan(@Language(value="SQL") String sql, Session session, List<AdaptivePlanOptimizer> optimizers, Map<PlanFragmentId, OutputStatsEstimator.OutputStatsEstimateResult> completeStageStats, SubPlanMatcher subPlanMatcher) {
        try {
            this.planTester.inTransaction(session, transactionSession -> {
                Plan plan = this.planTester.createPlan(transactionSession, sql, this.planTester.getPlanOptimizers(false), LogicalPlanner.Stage.OPTIMIZED_AND_VALIDATED, WarningCollector.NOOP, PlanOptimizersStatsCollector.createPlanOptimizersStatsCollector());
                SubPlan subPlan = this.planTester.createSubPlans(transactionSession, plan, false);
                SubPlan adaptivePlan = this.planTester.createAdaptivePlan(transactionSession, subPlan, optimizers, WarningCollector.NOOP, PlanOptimizersStatsCollector.createPlanOptimizersStatsCollector(), this.createRuntimeInfoProvider(subPlan, completeStageStats));
                String formattedPlan = PlanPrinter.textDistributedPlan((SubPlan)adaptivePlan, (Metadata)this.planTester.getPlannerContext().getMetadata(), (FunctionManager)this.planTester.getPlannerContext().getFunctionManager(), (Session)transactionSession, (boolean)false, (NodeVersion)NodeVersion.UNKNOWN);
                if (!subPlanMatcher.matches(adaptivePlan, this.planTester.getStatsCalculator(), (Session)transactionSession, this.planTester.getPlannerContext().getMetadata())) {
                    throw new AssertionError((Object)String.format("Adaptive plan does not match, expected [\n\n%s\n] but found [\n\n%s\n]", subPlanMatcher, formattedPlan));
                }
                return null;
            });
        }
        catch (RuntimeException e) {
            e.addSuppressed(new Exception("Query: " + sql));
            throw e;
        }
    }

    private RuntimeInfoProvider createRuntimeInfoProvider(SubPlan subPlan, Map<PlanFragmentId, OutputStatsEstimator.OutputStatsEstimateResult> completeStageStats) {
        Map fragments = (Map)this.traverse(subPlan).map(SubPlan::getFragment).collect(ImmutableMap.toImmutableMap(PlanFragment::getId, val -> val));
        return new StaticRuntimeInfoProvider(completeStageStats, fragments);
    }

    private Stream<SubPlan> traverse(SubPlan subPlan) {
        Iterable iterable = Traverser.forTree(SubPlan::getChildren).depthFirstPreOrder((Object)subPlan);
        return StreamSupport.stream(iterable.spliterator(), false);
    }
}

