/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.assertions;

import io.trino.sql.ir.ArithmeticBinaryExpression;
import io.trino.sql.ir.ArithmeticNegation;
import io.trino.sql.ir.BetweenPredicate;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.CoalesceExpression;
import io.trino.sql.ir.ComparisonExpression;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.FunctionCall;
import io.trino.sql.ir.InPredicate;
import io.trino.sql.ir.IrVisitor;
import io.trino.sql.ir.IsNullPredicate;
import io.trino.sql.ir.LambdaExpression;
import io.trino.sql.ir.LogicalExpression;
import io.trino.sql.ir.NotExpression;
import io.trino.sql.ir.Row;
import io.trino.sql.ir.SearchedCaseExpression;
import io.trino.sql.ir.SimpleCaseExpression;
import io.trino.sql.ir.SubscriptExpression;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.ir.WhenClause;
import io.trino.sql.planner.assertions.SymbolAliases;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class ExpressionVerifier
extends IrVisitor<Boolean, Expression> {
    private final SymbolAliases symbolAliases;

    public ExpressionVerifier(SymbolAliases symbolAliases) {
        this.symbolAliases = Objects.requireNonNull(symbolAliases, "symbolAliases is null");
    }

    protected Boolean visitConstant(Constant actual, Expression expectedExpression) {
        if (!(expectedExpression instanceof Constant)) {
            return false;
        }
        Constant expected = (Constant)expectedExpression;
        return Objects.equals(actual.getValue(), expected.getValue()) && actual.getType().equals((Object)expected.getType());
    }

    protected Boolean visitSymbolReference(SymbolReference actual, Expression expectedExpression) {
        if (!(expectedExpression instanceof SymbolReference)) {
            return false;
        }
        SymbolReference expected = (SymbolReference)expectedExpression;
        return this.symbolAliases.get(expected.getName()).name().equals(actual.name());
    }

    protected Boolean visitCast(Cast actual, Expression expectedExpression) {
        if (!(expectedExpression instanceof Cast)) {
            return false;
        }
        Cast expected = (Cast)expectedExpression;
        if (!actual.getType().toString().equalsIgnoreCase(expected.getType().toString())) {
            return false;
        }
        return (Boolean)this.process(actual.getExpression(), expected.getExpression());
    }

    protected Boolean visitIsNullPredicate(IsNullPredicate actual, Expression expectedExpression) {
        if (!(expectedExpression instanceof IsNullPredicate)) {
            return false;
        }
        IsNullPredicate expected = (IsNullPredicate)expectedExpression;
        return (Boolean)this.process(actual.getValue(), expected.getValue());
    }

    protected Boolean visitInPredicate(InPredicate actual, Expression expectedExpression) {
        if (!(expectedExpression instanceof InPredicate)) {
            return false;
        }
        InPredicate expected = (InPredicate)expectedExpression;
        return (Boolean)this.process(actual.getValue(), expected.getValue()) != false && this.process(actual.getValueList(), expected.getValueList());
    }

    protected Boolean visitComparisonExpression(ComparisonExpression actual, Expression expectedExpression) {
        if (!(expectedExpression instanceof ComparisonExpression)) {
            return false;
        }
        ComparisonExpression expected = (ComparisonExpression)expectedExpression;
        if (actual.getOperator() == expected.getOperator() && ((Boolean)this.process(actual.getLeft(), expected.getLeft())).booleanValue() && ((Boolean)this.process(actual.getRight(), expected.getRight())).booleanValue()) {
            return true;
        }
        return actual.getOperator() == expected.getOperator().flip() && (Boolean)this.process(actual.getLeft(), expected.getRight()) != false && (Boolean)this.process(actual.getRight(), expected.getLeft()) != false;
    }

    protected Boolean visitBetweenPredicate(BetweenPredicate actual, Expression expectedExpression) {
        if (!(expectedExpression instanceof BetweenPredicate)) {
            return false;
        }
        BetweenPredicate expected = (BetweenPredicate)expectedExpression;
        return (Boolean)this.process(actual.getValue(), expected.getValue()) != false && (Boolean)this.process(actual.getMin(), expected.getMin()) != false && (Boolean)this.process(actual.getMax(), expected.getMax()) != false;
    }

    protected Boolean visitArithmeticNegation(ArithmeticNegation actual, Expression expectedExpression) {
        if (!(expectedExpression instanceof ArithmeticNegation)) {
            return false;
        }
        ArithmeticNegation expected = (ArithmeticNegation)expectedExpression;
        return (Boolean)this.process(actual.getValue(), expected.getValue());
    }

    protected Boolean visitArithmeticBinary(ArithmeticBinaryExpression actual, Expression expectedExpression) {
        if (!(expectedExpression instanceof ArithmeticBinaryExpression)) {
            return false;
        }
        ArithmeticBinaryExpression expected = (ArithmeticBinaryExpression)expectedExpression;
        return actual.getOperator() == expected.getOperator() && (Boolean)this.process(actual.getLeft(), expected.getLeft()) != false && (Boolean)this.process(actual.getRight(), expected.getRight()) != false;
    }

    protected Boolean visitNotExpression(NotExpression actual, Expression expectedExpression) {
        if (!(expectedExpression instanceof NotExpression)) {
            return false;
        }
        NotExpression expected = (NotExpression)expectedExpression;
        return (Boolean)this.process(actual.getValue(), expected.getValue());
    }

    protected Boolean visitLogicalExpression(LogicalExpression actual, Expression expectedExpression) {
        if (!(expectedExpression instanceof LogicalExpression)) {
            return false;
        }
        LogicalExpression expected = (LogicalExpression)expectedExpression;
        if (actual.getTerms().size() != expected.getTerms().size() || actual.getOperator() != expected.getOperator()) {
            return false;
        }
        for (int i = 0; i < actual.getTerms().size(); ++i) {
            if (((Boolean)this.process((Expression)actual.getTerms().get(i), (Expression)expected.getTerms().get(i))).booleanValue()) continue;
            return false;
        }
        return true;
    }

    protected Boolean visitCoalesceExpression(CoalesceExpression actual, Expression expectedExpression) {
        if (!(expectedExpression instanceof CoalesceExpression)) {
            return false;
        }
        CoalesceExpression expected = (CoalesceExpression)expectedExpression;
        if (actual.getOperands().size() != expected.getOperands().size()) {
            return false;
        }
        for (int i = 0; i < actual.getOperands().size(); ++i) {
            if (((Boolean)this.process((Expression)actual.getOperands().get(i), (Expression)expected.getOperands().get(i))).booleanValue()) continue;
            return false;
        }
        return true;
    }

    protected Boolean visitSimpleCaseExpression(SimpleCaseExpression actual, Expression expectedExpression) {
        if (!(expectedExpression instanceof SimpleCaseExpression)) {
            return false;
        }
        SimpleCaseExpression expected = (SimpleCaseExpression)expectedExpression;
        return (Boolean)this.process(actual.getOperand(), expected.getOperand()) != false && this.processWhenClauses(actual.getWhenClauses(), expected.getWhenClauses()) && this.process(actual.getDefaultValue(), expected.getDefaultValue());
    }

    protected Boolean visitSearchedCaseExpression(SearchedCaseExpression actual, Expression expected) {
        if (!(expected instanceof SearchedCaseExpression)) {
            return false;
        }
        SearchedCaseExpression expectedCase = (SearchedCaseExpression)expected;
        if (!this.processWhenClauses(actual.getWhenClauses(), expectedCase.getWhenClauses())) {
            return false;
        }
        if (actual.getDefaultValue().isPresent() != expectedCase.getDefaultValue().isPresent()) {
            return false;
        }
        return this.process(actual.getDefaultValue(), expectedCase.getDefaultValue());
    }

    private boolean processWhenClauses(List<WhenClause> actual, List<WhenClause> expected) {
        if (actual.size() != expected.size()) {
            return false;
        }
        for (int i = 0; i < actual.size(); ++i) {
            if (this.process(actual.get(i), expected.get(i))) continue;
            return false;
        }
        return true;
    }

    private boolean process(WhenClause actual, WhenClause expected) {
        return (Boolean)this.process(actual.getOperand(), expected.getOperand()) != false && (Boolean)this.process(actual.getResult(), expected.getResult()) != false;
    }

    protected Boolean visitFunctionCall(FunctionCall actual, Expression expectedExpression) {
        if (!(expectedExpression instanceof FunctionCall)) {
            return false;
        }
        FunctionCall expected = (FunctionCall)expectedExpression;
        return actual.getFunction().getName().equals((Object)expected.getFunction().getName()) && this.process(actual.getArguments(), expected.getArguments());
    }

    protected Boolean visitLambdaExpression(LambdaExpression actual, Expression expected) {
        if (!(expected instanceof LambdaExpression)) {
            return false;
        }
        LambdaExpression lambdaExpression = (LambdaExpression)expected;
        if (!actual.getArguments().equals(lambdaExpression.getArguments())) {
            return false;
        }
        return (Boolean)this.process(actual.getBody(), lambdaExpression.getBody());
    }

    protected Boolean visitRow(Row actual, Expression expectedExpression) {
        if (!(expectedExpression instanceof Row)) {
            return false;
        }
        Row expected = (Row)expectedExpression;
        return this.process(actual.getItems(), expected.getItems());
    }

    protected Boolean visitSubscriptExpression(SubscriptExpression actual, Expression expectedExpression) {
        if (!(expectedExpression instanceof SubscriptExpression)) {
            return false;
        }
        SubscriptExpression expected = (SubscriptExpression)expectedExpression;
        return (Boolean)this.process(actual.getBase(), expected.getBase()) != false && (Boolean)this.process(actual.getIndex(), expected.getIndex()) != false;
    }

    private <T extends Expression> boolean process(List<T> actuals, List<T> expecteds) {
        if (actuals.size() != expecteds.size()) {
            return false;
        }
        for (int i = 0; i < actuals.size(); ++i) {
            if (((Boolean)this.process((Expression)actuals.get(i), (Expression)expecteds.get(i))).booleanValue()) continue;
            return false;
        }
        return true;
    }

    private <T extends Expression> boolean process(Optional<T> actual, Optional<T> expected) {
        if (actual.isPresent() != expected.isPresent()) {
            return false;
        }
        if (actual.isPresent()) {
            return (Boolean)this.process((Expression)actual.get(), (Expression)expected.get());
        }
        return true;
    }
}

