/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.assertions;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.ir.BetweenPredicate;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.ComparisonExpression;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.LogicalExpression;
import io.trino.sql.ir.NotExpression;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.assertions.ExpressionVerifier;
import io.trino.sql.planner.assertions.SymbolAliases;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestExpressionVerifier {
    @Test
    public void test() {
        NotExpression actual = new NotExpression((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "orderkey"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L)), (Object)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "custkey"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L)), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "orderkey"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)10L)))));
        SymbolAliases symbolAliases = SymbolAliases.builder().put("X", new SymbolReference((Type)IntegerType.INTEGER, "orderkey")).put("Y", new SymbolReference((Type)IntegerType.INTEGER, "custkey")).build();
        ExpressionVerifier verifier = new ExpressionVerifier(symbolAliases);
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)actual, new NotExpression((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "X"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L)), (Object)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "Y"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L)), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "X"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)10L)))))))).isTrue();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestExpressionVerifier.lambda$test$0(verifier, (Expression)actual)).isInstanceOf(IllegalStateException.class)).hasMessage("missing expression for alias Z");
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)actual, new NotExpression((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "X"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L)), (Object)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "X"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L)), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "X"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)10L)))))))).isFalse();
    }

    @Test
    public void testCast() {
        SymbolAliases aliases = SymbolAliases.builder().put("X", new SymbolReference((Type)BigintType.BIGINT, "orderkey")).build();
        ExpressionVerifier verifier = new ExpressionVerifier(aliases);
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2")), new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2"))))).isTrue();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2")), new Cast((Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2")), (Type)BigintType.BIGINT)))).isFalse();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new Cast((Expression)new SymbolReference((Type)BigintType.BIGINT, "orderkey"), (Type)VarcharType.VARCHAR), new Cast((Expression)new SymbolReference((Type)BigintType.BIGINT, "X"), (Type)VarcharType.VARCHAR)))).isTrue();
    }

    @Test
    public void testBetween() {
        SymbolAliases symbolAliases = SymbolAliases.builder().put("X", new SymbolReference((Type)BigintType.BIGINT, "orderkey")).put("Y", new SymbolReference((Type)BigintType.BIGINT, "custkey")).build();
        ExpressionVerifier verifier = new ExpressionVerifier(symbolAliases);
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new BetweenPredicate((Expression)new SymbolReference((Type)BigintType.BIGINT, "orderkey"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L)), new BetweenPredicate((Expression)new SymbolReference((Type)IntegerType.INTEGER, "X"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L))))).isTrue();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new BetweenPredicate((Expression)new SymbolReference((Type)BigintType.BIGINT, "orderkey"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L)), new BetweenPredicate((Expression)new SymbolReference((Type)BigintType.BIGINT, "Y"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L))))).isFalse();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new BetweenPredicate((Expression)new SymbolReference((Type)BigintType.BIGINT, "custkey"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L)), new BetweenPredicate((Expression)new SymbolReference((Type)BigintType.BIGINT, "X"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L))))).isFalse();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new BetweenPredicate((Expression)new SymbolReference((Type)BigintType.BIGINT, "orderkey"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)4L)), new BetweenPredicate((Expression)new SymbolReference((Type)BigintType.BIGINT, "X"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L))))).isFalse();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new BetweenPredicate((Expression)new SymbolReference((Type)BigintType.BIGINT, "orderkey"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L)), new BetweenPredicate((Expression)new SymbolReference((Type)BigintType.BIGINT, "X"), (Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"1")), (Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2")))))).isFalse();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new BetweenPredicate((Expression)new SymbolReference((Type)BigintType.BIGINT, "orderkey"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L)), new BetweenPredicate((Expression)new SymbolReference((Type)BigintType.BIGINT, "X"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)4L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)7L))))).isFalse();
    }

    @Test
    public void testSymmetry() {
        SymbolAliases symbolAliases = SymbolAliases.builder().put("a", new SymbolReference((Type)BigintType.BIGINT, "x")).put("b", new SymbolReference((Type)BigintType.BIGINT, "y")).build();
        ExpressionVerifier verifier = new ExpressionVerifier(symbolAliases);
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)BigintType.BIGINT, "x"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "y")), new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)BigintType.BIGINT, "a"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "b"))))).isTrue();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)BigintType.BIGINT, "x"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "y")), new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference((Type)BigintType.BIGINT, "b"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "a"))))).isTrue();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference((Type)BigintType.BIGINT, "y"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "x")), new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)BigintType.BIGINT, "a"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "b"))))).isTrue();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference((Type)BigintType.BIGINT, "y"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "x")), new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference((Type)BigintType.BIGINT, "b"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "a"))))).isTrue();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference((Type)BigintType.BIGINT, "x"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "y")), new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)BigintType.BIGINT, "a"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "b"))))).isFalse();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference((Type)BigintType.BIGINT, "x"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "y")), new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference((Type)BigintType.BIGINT, "b"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "a"))))).isFalse();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)BigintType.BIGINT, "y"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "x")), new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)BigintType.BIGINT, "a"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "b"))))).isFalse();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)BigintType.BIGINT, "y"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "x")), new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference((Type)BigintType.BIGINT, "b"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "a"))))).isFalse();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference((Type)BigintType.BIGINT, "x"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "y")), new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference((Type)BigintType.BIGINT, "a"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "b"))))).isTrue();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference((Type)BigintType.BIGINT, "x"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "y")), new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference((Type)BigintType.BIGINT, "b"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "a"))))).isTrue();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference((Type)BigintType.BIGINT, "y"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "x")), new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference((Type)BigintType.BIGINT, "a"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "b"))))).isTrue();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference((Type)BigintType.BIGINT, "y"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "x")), new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference((Type)BigintType.BIGINT, "b"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "a"))))).isTrue();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference((Type)BigintType.BIGINT, "x"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "y")), new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference((Type)BigintType.BIGINT, "a"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "b"))))).isFalse();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference((Type)BigintType.BIGINT, "x"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "y")), new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference((Type)BigintType.BIGINT, "b"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "a"))))).isFalse();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference((Type)BigintType.BIGINT, "y"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "x")), new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference((Type)BigintType.BIGINT, "a"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "b"))))).isFalse();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference((Type)BigintType.BIGINT, "y"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "x")), new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference((Type)BigintType.BIGINT, "b"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "a"))))).isFalse();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference((Type)BigintType.BIGINT, "x"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "y")), new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference((Type)BigintType.BIGINT, "a"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "b"))))).isTrue();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference((Type)BigintType.BIGINT, "x"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "y")), new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference((Type)BigintType.BIGINT, "b"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "a"))))).isTrue();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference((Type)BigintType.BIGINT, "y"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "x")), new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference((Type)BigintType.BIGINT, "a"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "b"))))).isTrue();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference((Type)BigintType.BIGINT, "y"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "x")), new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference((Type)BigintType.BIGINT, "b"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "a"))))).isTrue();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, (Expression)new SymbolReference((Type)BigintType.BIGINT, "x"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "y")), new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, (Expression)new SymbolReference((Type)BigintType.BIGINT, "a"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "b"))))).isTrue();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, (Expression)new SymbolReference((Type)BigintType.BIGINT, "x"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "y")), new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, (Expression)new SymbolReference((Type)BigintType.BIGINT, "b"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "a"))))).isTrue();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, (Expression)new SymbolReference((Type)BigintType.BIGINT, "y"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "x")), new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, (Expression)new SymbolReference((Type)BigintType.BIGINT, "a"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "b"))))).isTrue();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, (Expression)new SymbolReference((Type)BigintType.BIGINT, "y"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "x")), new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, (Expression)new SymbolReference((Type)BigintType.BIGINT, "b"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "a"))))).isTrue();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)new SymbolReference((Type)BigintType.BIGINT, "x"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "y")), new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)new SymbolReference((Type)BigintType.BIGINT, "a"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "b"))))).isTrue();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)new SymbolReference((Type)BigintType.BIGINT, "x"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "y")), new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)new SymbolReference((Type)BigintType.BIGINT, "b"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "a"))))).isTrue();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)new SymbolReference((Type)BigintType.BIGINT, "y"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "x")), new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)new SymbolReference((Type)BigintType.BIGINT, "a"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "b"))))).isTrue();
        Assertions.assertThat((Boolean)((Boolean)verifier.process((Expression)new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)new SymbolReference((Type)BigintType.BIGINT, "y"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "x")), new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)new SymbolReference((Type)BigintType.BIGINT, "b"), (Expression)new SymbolReference((Type)BigintType.BIGINT, "a"))))).isTrue();
    }

    private static /* synthetic */ void lambda$test$0(ExpressionVerifier verifier, Expression actual) throws Throwable {
        verifier.process(actual, new NotExpression((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "X"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L)), (Object)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "Y"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)3L)), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference((Type)IntegerType.INTEGER, "Z"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)10L))))));
    }
}

