/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slices;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.spi.Plugin;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.ir.BooleanLiteral;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.ComparisonExpression;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.FunctionCall;
import io.trino.sql.ir.IrExpressions;
import io.trino.sql.ir.IsNullPredicate;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.assertions.RowNumberSymbolMatcher;
import io.trino.sql.planner.assertions.RvalueMatcher;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.DecorrelateUnnest;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.JoinType;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.UnnestNode;
import io.trino.sql.planner.plan.WindowNode;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.Test;

public class TestDecorrelateUnnest
extends BaseRuleTest {
    private static final TestingFunctionResolution FUNCTIONS = new TestingFunctionResolution();
    private static final ResolvedFunction FAIL = FUNCTIONS.resolveFunction("fail", TypeSignatureProvider.fromTypes((Type[])new Type[]{IntegerType.INTEGER, VarcharType.VARCHAR}));

    public TestDecorrelateUnnest() {
        super(new Plugin[0]);
    }

    @Test
    public void doesNotFireWithoutUnnest() {
        this.tester().assertThat((Rule<?>)new DecorrelateUnnest(this.tester().getMetadata())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), (PlanNode)p.limit(5L, (PlanNode)p.values(new Symbol[0])))).doesNotFire();
    }

    @Test
    public void doesNotFireOnSourceDependentUnnest() {
        this.tester().assertThat((Rule<?>)new DecorrelateUnnest(this.tester().getMetadata())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), (PlanNode)p.unnest((List<Symbol>)ImmutableList.of(), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(p.symbol("corr"), (List)ImmutableList.of((Object)p.symbol("unnested_corr"))), (Object)new UnnestNode.Mapping(p.symbol("a"), (List)ImmutableList.of((Object)p.symbol("unnested_a")))), (PlanNode)p.values(p.symbol("a"))))).doesNotFire();
    }

    @Test
    public void testLeftCorrelatedJoinWithLeftUnnest() {
        this.tester().assertThat((Rule<?>)new DecorrelateUnnest(this.tester().getMetadata())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), JoinType.LEFT, (Expression)BooleanLiteral.TRUE_LITERAL, (PlanNode)p.unnest((List<Symbol>)ImmutableList.of(), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(p.symbol("corr"), (List)ImmutableList.of((Object)p.symbol("unnested_corr")))), Optional.empty(), JoinType.LEFT, (PlanNode)p.values((List<Symbol>)ImmutableList.of(), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of()))))).matches(PlanMatchPattern.project(PlanMatchPattern.unnest((List<String>)ImmutableList.of((Object)"corr", (Object)"unique"), (List<PlanMatchPattern.UnnestMapping>)ImmutableList.of((Object)PlanMatchPattern.UnnestMapping.unnestMapping("corr", (List<String>)ImmutableList.of((Object)"unnested_corr"))), Optional.of("ordinality"), JoinType.LEFT, PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values("corr")))));
    }

    @Test
    public void testInnerCorrelatedJoinWithLeftUnnest() {
        this.tester().assertThat((Rule<?>)new DecorrelateUnnest(this.tester().getMetadata())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), JoinType.INNER, (Expression)BooleanLiteral.TRUE_LITERAL, (PlanNode)p.unnest((List<Symbol>)ImmutableList.of(), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(p.symbol("corr"), (List)ImmutableList.of((Object)p.symbol("unnested_corr")))), Optional.empty(), JoinType.LEFT, (PlanNode)p.values((List<Symbol>)ImmutableList.of(), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of()))))).matches(PlanMatchPattern.project(PlanMatchPattern.unnest((List<String>)ImmutableList.of((Object)"corr", (Object)"unique"), (List<PlanMatchPattern.UnnestMapping>)ImmutableList.of((Object)PlanMatchPattern.UnnestMapping.unnestMapping("corr", (List<String>)ImmutableList.of((Object)"unnested_corr"))), Optional.of("ordinality"), JoinType.LEFT, PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values("corr")))));
    }

    @Test
    public void testInnerCorrelatedJoinWithInnerUnnest() {
        this.tester().assertThat((Rule<?>)new DecorrelateUnnest(this.tester().getMetadata())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), JoinType.INNER, (Expression)BooleanLiteral.TRUE_LITERAL, (PlanNode)p.unnest((List<Symbol>)ImmutableList.of(), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(p.symbol("corr"), (List)ImmutableList.of((Object)p.symbol("unnested_corr")))), Optional.empty(), JoinType.INNER, (PlanNode)p.values((List<Symbol>)ImmutableList.of(), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of()))))).matches(PlanMatchPattern.project(PlanMatchPattern.unnest((List<String>)ImmutableList.of((Object)"corr", (Object)"unique"), (List<PlanMatchPattern.UnnestMapping>)ImmutableList.of((Object)PlanMatchPattern.UnnestMapping.unnestMapping("corr", (List<String>)ImmutableList.of((Object)"unnested_corr"))), Optional.of("ordinality"), JoinType.INNER, PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values("corr")))));
    }

    @Test
    public void testLeftCorrelatedJoinWithInnerUnnest() {
        this.tester().assertThat((Rule<?>)new DecorrelateUnnest(this.tester().getMetadata())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), JoinType.LEFT, (Expression)BooleanLiteral.TRUE_LITERAL, (PlanNode)p.unnest((List<Symbol>)ImmutableList.of(), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(p.symbol("corr"), (List)ImmutableList.of((Object)p.symbol("unnested_corr")))), Optional.empty(), JoinType.INNER, (PlanNode)p.values((List<Symbol>)ImmutableList.of(), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of()))))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"corr", (Object)PlanMatchPattern.expression((Expression)new SymbolReference((Type)BigintType.BIGINT, "corr")), (Object)"unnested_corr", (Object)PlanMatchPattern.expression(IrExpressions.ifExpression((Expression)new IsNullPredicate((Expression)new SymbolReference((Type)BigintType.BIGINT, "ordinality")), (Expression)new Constant((Type)BigintType.BIGINT, null), (Expression)new SymbolReference((Type)BigintType.BIGINT, "unnested_corr")))), PlanMatchPattern.unnest((List<String>)ImmutableList.of((Object)"corr", (Object)"unique"), (List<PlanMatchPattern.UnnestMapping>)ImmutableList.of((Object)PlanMatchPattern.UnnestMapping.unnestMapping("corr", (List<String>)ImmutableList.of((Object)"unnested_corr"))), Optional.of("ordinality"), JoinType.LEFT, PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values("corr")))));
    }

    @Test
    public void testEnforceSingleRow() {
        this.tester().assertThat((Rule<?>)new DecorrelateUnnest(this.tester().getMetadata())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), JoinType.INNER, (Expression)BooleanLiteral.TRUE_LITERAL, (PlanNode)p.enforceSingleRow((PlanNode)p.unnest((List<Symbol>)ImmutableList.of(), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(p.symbol("corr"), (List)ImmutableList.of((Object)p.symbol("unnested_corr")))), Optional.empty(), JoinType.INNER, (PlanNode)p.values((List<Symbol>)ImmutableList.of(), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of())))))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"corr", (Object)PlanMatchPattern.expression((Expression)new SymbolReference((Type)BigintType.BIGINT, "corr")), (Object)"unnested_corr", (Object)PlanMatchPattern.expression(IrExpressions.ifExpression((Expression)new IsNullPredicate((Expression)new SymbolReference((Type)BigintType.BIGINT, "ordinality")), (Expression)new Constant((Type)BigintType.BIGINT, null), (Expression)new SymbolReference((Type)BigintType.BIGINT, "unnested_corr")))), PlanMatchPattern.filter(IrExpressions.ifExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)BigintType.BIGINT, "row_number"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L)), (Expression)new Cast((Expression)new FunctionCall(FAIL, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)28L), (Object)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"Scalar sub-query has returned multiple rows")))), (Type)BooleanType.BOOLEAN), (Expression)BooleanLiteral.TRUE_LITERAL), PlanMatchPattern.rowNumber(builder -> builder.partitionBy((List<String>)ImmutableList.of((Object)"unique")).maxRowCountPerPartition(Optional.of(2)), PlanMatchPattern.unnest((List<String>)ImmutableList.of((Object)"corr", (Object)"unique"), (List<PlanMatchPattern.UnnestMapping>)ImmutableList.of((Object)PlanMatchPattern.UnnestMapping.unnestMapping("corr", (List<String>)ImmutableList.of((Object)"unnested_corr"))), Optional.of("ordinality"), JoinType.LEFT, PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values("corr")))).withAlias("row_number", (RvalueMatcher)new RowNumberSymbolMatcher()))));
    }

    @Test
    public void testLimit() {
        this.tester().assertThat((Rule<?>)new DecorrelateUnnest(this.tester().getMetadata())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), JoinType.LEFT, (Expression)BooleanLiteral.TRUE_LITERAL, (PlanNode)p.limit(5L, (PlanNode)p.unnest((List<Symbol>)ImmutableList.of(), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(p.symbol("corr"), (List)ImmutableList.of((Object)p.symbol("unnested_corr")))), Optional.empty(), JoinType.LEFT, (PlanNode)p.values((List<Symbol>)ImmutableList.of(), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of())))))).matches(PlanMatchPattern.project(PlanMatchPattern.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference((Type)BigintType.BIGINT, "row_number"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)5L)), PlanMatchPattern.rowNumber(builder -> builder.partitionBy((List<String>)ImmutableList.of((Object)"unique")).maxRowCountPerPartition(Optional.empty()), PlanMatchPattern.unnest((List<String>)ImmutableList.of((Object)"corr", (Object)"unique"), (List<PlanMatchPattern.UnnestMapping>)ImmutableList.of((Object)PlanMatchPattern.UnnestMapping.unnestMapping("corr", (List<String>)ImmutableList.of((Object)"unnested_corr"))), Optional.of("ordinality"), JoinType.LEFT, PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values("corr")))).withAlias("row_number", (RvalueMatcher)new RowNumberSymbolMatcher()))));
    }

    @Test
    public void testLimitWithTies() {
        this.tester().assertThat((Rule<?>)new DecorrelateUnnest(this.tester().getMetadata())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), JoinType.LEFT, (Expression)BooleanLiteral.TRUE_LITERAL, (PlanNode)p.limit(5L, (List<Symbol>)ImmutableList.of((Object)p.symbol("unnested_corr")), (PlanNode)p.unnest((List<Symbol>)ImmutableList.of(), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(p.symbol("corr"), (List)ImmutableList.of((Object)p.symbol("unnested_corr")))), Optional.empty(), JoinType.LEFT, (PlanNode)p.values((List<Symbol>)ImmutableList.of(), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of())))))).matches(PlanMatchPattern.project(PlanMatchPattern.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference((Type)BigintType.BIGINT, "rank_number"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)5L)), PlanMatchPattern.window(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"unique"), (List<String>)ImmutableList.of((Object)"unnested_corr"), (Map<String, SortOrder>)ImmutableMap.of((Object)"unnested_corr", (Object)SortOrder.ASC_NULLS_FIRST))).addFunction("rank_number", PlanMatchPattern.windowFunction("rank", (List<String>)ImmutableList.of(), WindowNode.Frame.DEFAULT_FRAME)), PlanMatchPattern.unnest((List<String>)ImmutableList.of((Object)"corr", (Object)"unique"), (List<PlanMatchPattern.UnnestMapping>)ImmutableList.of((Object)PlanMatchPattern.UnnestMapping.unnestMapping("corr", (List<String>)ImmutableList.of((Object)"unnested_corr"))), Optional.of("ordinality"), JoinType.LEFT, PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values("corr")))))));
    }

    @Test
    public void testTopN() {
        this.tester().assertThat((Rule<?>)new DecorrelateUnnest(this.tester().getMetadata())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), JoinType.LEFT, (Expression)BooleanLiteral.TRUE_LITERAL, (PlanNode)p.topN(5L, (List<Symbol>)ImmutableList.of((Object)p.symbol("unnested_corr")), (PlanNode)p.unnest((List<Symbol>)ImmutableList.of(), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(p.symbol("corr"), (List)ImmutableList.of((Object)p.symbol("unnested_corr")))), Optional.empty(), JoinType.LEFT, (PlanNode)p.values((List<Symbol>)ImmutableList.of(), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of())))))).matches(PlanMatchPattern.project(PlanMatchPattern.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference((Type)BigintType.BIGINT, "row_number"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)5L)), PlanMatchPattern.window(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"unique"), (List<String>)ImmutableList.of((Object)"unnested_corr"), (Map<String, SortOrder>)ImmutableMap.of((Object)"unnested_corr", (Object)SortOrder.ASC_NULLS_FIRST))).addFunction("row_number", PlanMatchPattern.windowFunction("row_number", (List<String>)ImmutableList.of(), WindowNode.Frame.DEFAULT_FRAME)), PlanMatchPattern.unnest((List<String>)ImmutableList.of((Object)"corr", (Object)"unique"), (List<PlanMatchPattern.UnnestMapping>)ImmutableList.of((Object)PlanMatchPattern.UnnestMapping.unnestMapping("corr", (List<String>)ImmutableList.of((Object)"unnested_corr"))), Optional.of("ordinality"), JoinType.LEFT, PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values("corr")))))));
    }

    @Test
    public void testProject() {
        this.tester().assertThat((Rule<?>)new DecorrelateUnnest(this.tester().getMetadata())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), JoinType.LEFT, (Expression)BooleanLiteral.TRUE_LITERAL, (PlanNode)p.project(Assignments.of((Symbol)p.symbol("boolean_result"), (Expression)new IsNullPredicate((Expression)new SymbolReference((Type)BigintType.BIGINT, "unnested_corr"))), (PlanNode)p.unnest((List<Symbol>)ImmutableList.of(), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(p.symbol("corr"), (List)ImmutableList.of((Object)p.symbol("unnested_corr")))), Optional.empty(), JoinType.LEFT, (PlanNode)p.values((List<Symbol>)ImmutableList.of(), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of())))))).matches(PlanMatchPattern.project(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"corr", (Object)PlanMatchPattern.expression((Expression)new SymbolReference((Type)BigintType.BIGINT, "corr")), (Object)"unique", (Object)PlanMatchPattern.expression((Expression)new SymbolReference((Type)BigintType.BIGINT, "unique")), (Object)"ordinality", (Object)PlanMatchPattern.expression((Expression)new SymbolReference((Type)BigintType.BIGINT, "ordinality")), (Object)"boolean_result", (Object)PlanMatchPattern.expression((Expression)new IsNullPredicate((Expression)new SymbolReference((Type)BigintType.BIGINT, "unnested_corr")))), PlanMatchPattern.unnest((List<String>)ImmutableList.of((Object)"corr", (Object)"unique"), (List<PlanMatchPattern.UnnestMapping>)ImmutableList.of((Object)PlanMatchPattern.UnnestMapping.unnestMapping("corr", (List<String>)ImmutableList.of((Object)"unnested_corr"))), Optional.of("ordinality"), JoinType.LEFT, PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values("corr"))))));
        this.tester().assertThat((Rule<?>)new DecorrelateUnnest(this.tester().getMetadata())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), JoinType.LEFT, (Expression)BooleanLiteral.TRUE_LITERAL, (PlanNode)p.project(Assignments.of((Symbol)p.symbol("boolean_result"), (Expression)new IsNullPredicate((Expression)new SymbolReference((Type)BigintType.BIGINT, "unnested_corr"))), (PlanNode)p.unnest((List<Symbol>)ImmutableList.of(), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(p.symbol("corr"), (List)ImmutableList.of((Object)p.symbol("unnested_corr")))), Optional.empty(), JoinType.INNER, (PlanNode)p.values((List<Symbol>)ImmutableList.of(), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of())))))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"corr", (Object)PlanMatchPattern.expression((Expression)new SymbolReference((Type)BigintType.BIGINT, "corr")), (Object)"boolean_result", (Object)PlanMatchPattern.expression(IrExpressions.ifExpression((Expression)new IsNullPredicate((Expression)new SymbolReference((Type)BigintType.BIGINT, "ordinality")), (Expression)new Constant((Type)BigintType.BIGINT, null), (Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "boolean_result")))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"corr", (Object)PlanMatchPattern.expression((Expression)new SymbolReference((Type)BigintType.BIGINT, "corr")), (Object)"unique", (Object)PlanMatchPattern.expression((Expression)new SymbolReference((Type)BigintType.BIGINT, "unique")), (Object)"ordinality", (Object)PlanMatchPattern.expression((Expression)new SymbolReference((Type)BigintType.BIGINT, "ordinality")), (Object)"boolean_result", (Object)PlanMatchPattern.expression((Expression)new IsNullPredicate((Expression)new SymbolReference((Type)BigintType.BIGINT, "unnested_corr")))), PlanMatchPattern.unnest((List<String>)ImmutableList.of((Object)"corr", (Object)"unique"), (List<PlanMatchPattern.UnnestMapping>)ImmutableList.of((Object)PlanMatchPattern.UnnestMapping.unnestMapping("corr", (List<String>)ImmutableList.of((Object)"unnested_corr"))), Optional.of("ordinality"), JoinType.LEFT, PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values("corr"))))));
    }

    @Test
    public void testDifferentNodesInSubquery() {
        this.tester().assertThat((Rule<?>)new DecorrelateUnnest(this.tester().getMetadata())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), JoinType.LEFT, (Expression)BooleanLiteral.TRUE_LITERAL, (PlanNode)p.enforceSingleRow((PlanNode)p.project(Assignments.of((Symbol)p.symbol("integer_result"), (Expression)IrExpressions.ifExpression((Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "boolean_result"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L))), (PlanNode)p.limit(5L, (PlanNode)p.project(Assignments.of((Symbol)p.symbol("boolean_result"), (Expression)new IsNullPredicate((Expression)new SymbolReference((Type)BigintType.BIGINT, "unnested_corr"))), (PlanNode)p.topN(10L, (List<Symbol>)ImmutableList.of((Object)p.symbol("unnested_corr")), (PlanNode)p.unnest((List<Symbol>)ImmutableList.of(), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(p.symbol("corr"), (List)ImmutableList.of((Object)p.symbol("unnested_corr")))), Optional.empty(), JoinType.LEFT, (PlanNode)p.values((List<Symbol>)ImmutableList.of(), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of())))))))))).matches(PlanMatchPattern.project(PlanMatchPattern.filter(IrExpressions.ifExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference((Type)BigintType.BIGINT, "row_number"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L)), (Expression)new Cast((Expression)new FunctionCall(FAIL, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)28L), (Object)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"Scalar sub-query has returned multiple rows")))), (Type)BooleanType.BOOLEAN), (Expression)BooleanLiteral.TRUE_LITERAL), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"corr", (Object)PlanMatchPattern.expression((Expression)new SymbolReference((Type)BigintType.BIGINT, "corr")), (Object)"unique", (Object)PlanMatchPattern.expression((Expression)new SymbolReference((Type)BigintType.BIGINT, "unique")), (Object)"ordinality", (Object)PlanMatchPattern.expression((Expression)new SymbolReference((Type)BigintType.BIGINT, "ordinality")), (Object)"row_number", (Object)PlanMatchPattern.expression((Expression)new SymbolReference((Type)BigintType.BIGINT, "row_number")), (Object)"integer_result", (Object)PlanMatchPattern.expression(IrExpressions.ifExpression((Expression)new SymbolReference((Type)BooleanType.BOOLEAN, "boolean_result"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)))), PlanMatchPattern.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference((Type)BigintType.BIGINT, "row_number"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)5L)), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"corr", (Object)PlanMatchPattern.expression((Expression)new SymbolReference((Type)BigintType.BIGINT, "corr")), (Object)"unique", (Object)PlanMatchPattern.expression((Expression)new SymbolReference((Type)BigintType.BIGINT, "unique")), (Object)"ordinality", (Object)PlanMatchPattern.expression((Expression)new SymbolReference((Type)BigintType.BIGINT, "ordinality")), (Object)"row_number", (Object)PlanMatchPattern.expression((Expression)new SymbolReference((Type)BigintType.BIGINT, "row_number")), (Object)"boolean_result", (Object)PlanMatchPattern.expression((Expression)new IsNullPredicate((Expression)new SymbolReference((Type)BigintType.BIGINT, "unnested_corr")))), PlanMatchPattern.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference((Type)BigintType.BIGINT, "row_number"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)10L)), PlanMatchPattern.window(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"unique"), (List<String>)ImmutableList.of((Object)"unnested_corr"), (Map<String, SortOrder>)ImmutableMap.of((Object)"unnested_corr", (Object)SortOrder.ASC_NULLS_FIRST))).addFunction("row_number", PlanMatchPattern.windowFunction("row_number", (List<String>)ImmutableList.of(), WindowNode.Frame.DEFAULT_FRAME)), PlanMatchPattern.unnest((List<String>)ImmutableList.of((Object)"corr", (Object)"unique"), (List<PlanMatchPattern.UnnestMapping>)ImmutableList.of((Object)PlanMatchPattern.UnnestMapping.unnestMapping("corr", (List<String>)ImmutableList.of((Object)"unnested_corr"))), Optional.of("ordinality"), JoinType.LEFT, PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values("corr")))))))))));
    }

    @Test
    public void testWithPreexistingOrdinality() {
        this.tester().assertThat((Rule<?>)new DecorrelateUnnest(this.tester().getMetadata())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), JoinType.LEFT, (Expression)BooleanLiteral.TRUE_LITERAL, (PlanNode)p.unnest((List<Symbol>)ImmutableList.of(), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(p.symbol("corr"), (List)ImmutableList.of((Object)p.symbol("unnested_corr")))), Optional.of(p.symbol("ordinality")), JoinType.INNER, (PlanNode)p.values((List<Symbol>)ImmutableList.of(), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of()))))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"corr", (Object)PlanMatchPattern.expression((Expression)new SymbolReference((Type)BigintType.BIGINT, "corr")), (Object)"unnested_corr", (Object)PlanMatchPattern.expression(IrExpressions.ifExpression((Expression)new IsNullPredicate((Expression)new SymbolReference((Type)BigintType.BIGINT, "ordinality")), (Expression)new Constant((Type)BigintType.BIGINT, null), (Expression)new SymbolReference((Type)BigintType.BIGINT, "unnested_corr")))), PlanMatchPattern.unnest((List<String>)ImmutableList.of((Object)"corr", (Object)"unique"), (List<PlanMatchPattern.UnnestMapping>)ImmutableList.of((Object)PlanMatchPattern.UnnestMapping.unnestMapping("corr", (List<String>)ImmutableList.of((Object)"unnested_corr"))), Optional.of("ordinality"), JoinType.LEFT, PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values("corr")))));
    }

    @Test
    public void testPreprojectUnnestSymbol() {
        this.tester().assertThat((Rule<?>)new DecorrelateUnnest(this.tester().getMetadata())).on(p -> {
            Symbol corr = p.symbol("corr", (Type)VarcharType.VARCHAR);
            FunctionCall regexpExtractAll = new FunctionCall(this.tester().getMetadata().resolveBuiltinFunction("regexp_extract_all", TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR})), (List)ImmutableList.of((Object)corr.toSymbolReference(), (Object)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"."))));
            return p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)corr), (PlanNode)p.values(corr), JoinType.LEFT, (Expression)BooleanLiteral.TRUE_LITERAL, (PlanNode)p.unnest((List<Symbol>)ImmutableList.of(), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(p.symbol("char_array"), (List)ImmutableList.of((Object)p.symbol("unnested_char")))), Optional.empty(), JoinType.LEFT, (PlanNode)p.project(Assignments.of((Symbol)p.symbol("char_array"), (Expression)regexpExtractAll), (PlanNode)p.values((List<Symbol>)ImmutableList.of(), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of())))));
        }).matches(PlanMatchPattern.project(PlanMatchPattern.unnest((List<String>)ImmutableList.of((Object)"corr", (Object)"unique", (Object)"char_array"), (List<PlanMatchPattern.UnnestMapping>)ImmutableList.of((Object)PlanMatchPattern.UnnestMapping.unnestMapping("char_array", (List<String>)ImmutableList.of((Object)"unnested_char"))), Optional.of("ordinality"), JoinType.LEFT, PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"char_array", (Object)PlanMatchPattern.expression((Expression)new FunctionCall(this.tester().getMetadata().resolveBuiltinFunction("regexp_extract_all", TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR})), (List)ImmutableList.of((Object)new SymbolReference((Type)BigintType.BIGINT, "corr"), (Object)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)".")))))), PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values("corr"))))));
    }
}

